/*  
	Copyright (C) 2006 Salvatore Scarciglia <laas.mono@gmail.com>
	http://laas.altervista.org

    This code is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This code is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

using System;
using System.IO;
using System.Net;
using Gtk;
/*
	This is the class used to translate text 
*/

public class yTService {
	private yTProvider	_ServiceProvider;
	private	string		_language1="";
	private	string		_language2="";
	private Gtk.Entry	_text1;
	private Gtk.Entry	_text2;
	private string		_messageError="";
	private bool		_fromLargeWindow;
	private Gtk.TextView 	_txtLarge;
	
	
	// Constructor
	public yTService(yTProvider mainProvider,Gtk.Entry txt1,Gtk.Entry txt2){
		_ServiceProvider = mainProvider;
		_text1 = txt1;
		_text2 = txt2;
		_messageError = "There was an error during translation process. This is probably due to:\n"+
						"1) Internet connection not available\n"+
						"2) Service provider not available (choose another one)\n"+
						"3) Connection timeout\n"+
						"4) Bad string to translate\n"+
						"5) Other";
	}
	
	/*
		This is the most important method of the applciations;
	*/
	public void goTranslate(string text, int comingFrom, bool frmLarg){
		string lFrom;
		string lTo;
		string translationResult="";
		// what's the source language and the destination language ? 
		if(comingFrom==1){lFrom=_language1;lTo=_language2;}
		else {lFrom=_language2;lTo=_language1;}
		// check if the current provider support the requested translation 
		if(_ServiceProvider.serviceIsAvailable(lFrom,lTo)) {
			try {
				string strUrl = _ServiceProvider.getUrlTranslator(lFrom,lTo,text);
				string tmpRes = "";
				Uri providerUrl = new Uri(strUrl);
				WebRequest req = WebRequest.Create(providerUrl);
				WebResponse res = req.GetResponse();
				using (StreamReader reader = new StreamReader(res.GetResponseStream())) {
					tmpRes = reader.ReadToEnd();
				}
				translationResult = extractFromStream(tmpRes);
			}
			catch(UriFormatException e){
				new yTMessageBox("Warning!!","Error during translation",_messageError,false,false);
			}
			catch(Exception x){
				new yTMessageBox("Warning!!","Error during translation",_messageError,false,false);
			}
		}
		else {
			translationResult = "-- NOT AVAILABLE --";
		}
		// write the result inside the entry
		writeTranslationResult(translationResult,comingFrom,frmLarg);
	}
	
	
	public void goTranslate(string text, int comingFrom){
		goTranslate(text,comingFrom,false);
	}
	
	// service method to clean the result of the web response
	private string extractFromStream(string text) {
		string res="";
		int pos1 = text.IndexOf(_ServiceProvider.OpenTag1);
		string r1 = text.Substring(pos1);
		int pos2 = r1.IndexOf(_ServiceProvider.OpenTag2);
		string r2 = r1.Substring(pos2);
		int pos3 = r2.IndexOf(_ServiceProvider.CloseTag);
		res = r2.Substring(_ServiceProvider.OpenTag2.Length,pos3-_ServiceProvider.OpenTag2.Length);
		return res;
	}
	
	// render the result
	private void writeTranslationResult(string result, int where, bool frmLarg){
		if(frmLarg) {
			_txtLarge.Buffer.SetText(result);
		}
		else {
			if(where==1) _text2.Text = result;
			else _text1.Text = result;
		}
	}
	
	private void writeTranslationResult(string result, int where){
		writeTranslationResult(result,where,false);
	}	
	
	// Public Properties :: start
	public string Language1 {
		get {return _language1;}
		set {_language1 = value;}		
	}	
	public string Language2 {
		get {return _language2;}
		set {_language2 = value;}		
	}		
	public Gtk.TextView txtLarge {
		get {return _txtLarge;}
		set {_txtLarge = value;}		
	}	
	// Public Properties :: end
	
	
	
}