//
// C++ Implementation: listdialog
//
// Description:
//
//
// Author: Oleksandr Shneyder <o.shneyder@phoca-gmbh.de>, (C) 2006-2018
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "listdialog.h"
#include <QListWidget>
#include <QGridLayout>
#include <QPushButton>

ListDialog::ListDialog(QStringList lst,QWidget *parent)
        : QMessageBox(parent)
{
    setWindowModality(Qt::WindowModal);
    box=new QListWidget(this);
    lst.sort();
    box->insertItems(0,lst);
    box->setSelectionMode(QAbstractItemView::ExtendedSelection);
    ((QGridLayout*)layout())->addWidget(box,0,0);
    QPushButton *del=new QPushButton(tr("remove"),this);
    ((QGridLayout*)layout())->addWidget(del,0,1,Qt::AlignTop);
    ((QGridLayout*)layout())->setVerticalSpacing(5);
    setStandardButtons(Ok|Cancel);
    connect(del,SIGNAL(clicked()),this,SLOT(slotDel()));
}


ListDialog::~ListDialog()
{
}

void ListDialog::slotDel()
{
    for (int i=box->count()-1;i>=0;--i)
    {
        QListWidgetItem* it=box->item(i);
        if (it->isSelected())
        {
            box->takeItem(i);
            delete it;
        }
    }
}

QStringList ListDialog::getList()
{
    QStringList lst;
    for (int i=box->count()-1;i>=0;--i)
    {
        lst<<box->item(i)->text();
    }
    return lst;

}
