# - Try to find Minizip
# Once done this will define
#  
#  MINIZIP_FOUND        - system has MINIZIP
#  MINIZIP_INCLUDE_DIR  - the MINIZIP include directory
#  MINIZIP_LIBRARY_DIR  - where the libraries are
#  MINIZIP_LIBRARY      - Link these to use MINIZIP
#   

IF (MINIZIP_INCLUDE_DIR)
  # Already in cache, be silent
  SET(MINIZIP_FIND_QUIETLY TRUE)
ENDIF (MINIZIP_INCLUDE_DIR)

FIND_PATH( MINIZIP_INCLUDE_DIR 
	  NAMES zip.h unzip.h ioapi.h
	  PATHS /usr/local/include /usr/include
	  PATH_SUFFIXES minizip/ )
SET( MINIZIP_NAMES minizip MINIZIP )
FIND_LIBRARY( MINIZIP_LIBRARY
	      NAMES ${MINIZIP_NAMES}
	      PATHS /usr/lib /usr/local/lib )

GET_FILENAME_COMPONENT( MINIZIP_LIBRARY_DIR ${MINIZIP_LIBRARY} PATH )

IF (MINIZIP_INCLUDE_DIR AND MINIZIP_LIBRARY)
   SET(MINIZIP_FOUND TRUE)
   SET(MINIZIP_LIBRARY_DIR ${MINIZIP_LIBRARY} )
   IF (NOT MINIZIP_FIND_QUIETLY)
     MESSAGE (STATUS "Found Minizip: ${MINIZIP_LIBRARY} ${MINIZIP_INCLUDE_DIR}")
   ENDIF (NOT MINIZIP_FIND_QUIETLY)
ELSE (MINIZIP_INCLUDE_DIR AND MINIZIP_LIBRARY)
   SET( MINIZIP_FOUND FALSE )
   SET( MINIZIP_LIBRARY_DIR )
   SET( MINIZIP_EXTRA_DEFINITIONS )
ENDIF (MINIZIP_INCLUDE_DIR AND MINIZIP_LIBRARY)

