/* valacompiler.c generated by valac, the Vala compiler
 * generated from valacompiler.vala, do not modify */

/* valacompiler.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <valacodegen.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>
#include <config.h>
#include <gobject/gvaluecollector.h>

#define VALA_TYPE_COMPILER (vala_compiler_get_type ())
#define VALA_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMPILER, ValaCompiler))
#define VALA_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMPILER, ValaCompilerClass))
#define VALA_IS_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMPILER))
#define VALA_IS_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMPILER))
#define VALA_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMPILER, ValaCompilerClass))

typedef struct _ValaCompiler ValaCompiler;
typedef struct _ValaCompilerClass ValaCompilerClass;
typedef struct _ValaCompilerPrivate ValaCompilerPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_compiler_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_compiler_unref0(var) ((var == NULL) ? NULL : (var = (vala_compiler_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ValaParamSpecCompiler ValaParamSpecCompiler;

struct _ValaCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCompilerPrivate * priv;
};

struct _ValaCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCompiler *self);
};

struct _ValaCompilerPrivate {
	ValaCodeContext* context;
};

struct _Block1Data {
	int _ref_count_;
	GMainLoop* loop;
	gint child_status;
};

struct _ValaParamSpecCompiler {
	GParamSpec parent_instance;
};

static gint ValaCompiler_private_offset;
static gpointer vala_compiler_parent_class = NULL;
static gchar** vala_compiler_vapi_directories;
static gchar** vala_compiler_gir_directories;
static gchar** vala_compiler_metadata_directories;
static gchar** vala_compiler_packages;
static gchar* vala_compiler_vapi_filename;
static gchar* vala_compiler_library;
static gchar* vala_compiler_shared_library;
static gchar* vala_compiler_gir;
static gchar* vala_compiler_basedir;
static gchar* vala_compiler_directory;
static gboolean vala_compiler_version;
static gboolean vala_compiler_api_version;
static gboolean vala_compiler_ccode_only;
static gchar* vala_compiler_header_filename;
static gboolean vala_compiler_use_header;
static gchar* vala_compiler_includedir;
static gchar* vala_compiler_internal_header_filename;
static gchar* vala_compiler_internal_vapi_filename;
static gchar* vala_compiler_fast_vapi_filename;
static gchar** vala_compiler_fast_vapis;
static gboolean vala_compiler_vapi_comments;
static gchar* vala_compiler_dependencies;
static gchar* vala_compiler_depfile;
static gboolean vala_compiler_list_sources;
static gchar* vala_compiler_symbols_filename;
static gboolean vala_compiler_compile_only;
static gchar* vala_compiler_output;
static gboolean vala_compiler_debug;
static gboolean vala_compiler_mem_profiler;
static gchar** vala_compiler_defines;
static gchar* vala_compiler_entry_point;
static gboolean vala_compiler_nostdpkg;
static gboolean vala_compiler_disable_assert;
static gboolean vala_compiler_enable_checking;
static gboolean vala_compiler_deprecated;
static gboolean vala_compiler_hide_internal;
static gboolean vala_compiler_experimental;
static gboolean vala_compiler_disable_warnings;
static gboolean vala_compiler_fatal_warnings;
static gboolean vala_compiler_disable_since_check;
static gboolean vala_compiler_keep_going;
static gboolean vala_compiler_experimental_non_null;
static gboolean vala_compiler_gobject_tracing;
static gchar* vala_compiler_cc_command;
static gchar** vala_compiler_cc_options;
static gchar* vala_compiler_pkg_config_command;
static gchar* vala_compiler_dump_tree;
static gboolean vala_compiler_save_temps;
static gchar* vala_compiler_profile;
static gboolean vala_compiler_quiet_mode;
static gboolean vala_compiler_verbose_mode;
static gboolean vala_compiler_disable_colored_output;
static gchar* vala_compiler_target_glib;
static gchar** vala_compiler_gresources;
static gchar** vala_compiler_gresources_directories;
static gboolean vala_compiler_enable_version_header;
static gboolean vala_compiler_disable_version_header;
static gchar* vala_compiler_run_args;
static gboolean vala_compiler_abi_stability;
static gchar** vala_compiler_sources;
static gchar* vala_compiler_basedir = NULL;
static gchar* vala_compiler_directory = NULL;
static gboolean vala_compiler_version = FALSE;
static gboolean vala_compiler_api_version = FALSE;
static gchar** vala_compiler_sources = NULL;
static gchar** vala_compiler_vapi_directories = NULL;
static gchar** vala_compiler_gir_directories = NULL;
static gchar** vala_compiler_metadata_directories = NULL;
static gchar* vala_compiler_vapi_filename = NULL;
static gchar* vala_compiler_library = NULL;
static gchar* vala_compiler_shared_library = NULL;
static gchar* vala_compiler_gir = NULL;
static gchar** vala_compiler_packages = NULL;
static gchar** vala_compiler_fast_vapis = NULL;
static gchar* vala_compiler_target_glib = NULL;
static gchar** vala_compiler_gresources = NULL;
static gchar** vala_compiler_gresources_directories = NULL;
static gboolean vala_compiler_ccode_only = FALSE;
static gboolean vala_compiler_abi_stability = FALSE;
static gchar* vala_compiler_header_filename = NULL;
static gboolean vala_compiler_use_header = FALSE;
static gchar* vala_compiler_internal_header_filename = NULL;
static gchar* vala_compiler_internal_vapi_filename = NULL;
static gchar* vala_compiler_fast_vapi_filename = NULL;
static gboolean vala_compiler_vapi_comments = FALSE;
static gchar* vala_compiler_symbols_filename = NULL;
static gchar* vala_compiler_includedir = NULL;
static gboolean vala_compiler_compile_only = FALSE;
static gchar* vala_compiler_output = NULL;
static gboolean vala_compiler_debug = FALSE;
static gboolean vala_compiler_mem_profiler = FALSE;
static gboolean vala_compiler_disable_assert = FALSE;
static gboolean vala_compiler_enable_checking = FALSE;
static gboolean vala_compiler_deprecated = FALSE;
static gboolean vala_compiler_hide_internal = FALSE;
static gboolean vala_compiler_experimental = FALSE;
static gboolean vala_compiler_experimental_non_null = FALSE;
static gboolean vala_compiler_gobject_tracing = FALSE;
static gboolean vala_compiler_disable_since_check = FALSE;
static gboolean vala_compiler_disable_warnings = FALSE;
static gboolean vala_compiler_keep_going = FALSE;
static gboolean vala_compiler_list_sources = FALSE;
static gchar* vala_compiler_cc_command = NULL;
static gchar** vala_compiler_cc_options = NULL;
static gchar* vala_compiler_pkg_config_command = NULL;
static gchar* vala_compiler_dump_tree = NULL;
static gboolean vala_compiler_save_temps = FALSE;
static gchar** vala_compiler_defines = NULL;
static gboolean vala_compiler_quiet_mode = FALSE;
static gboolean vala_compiler_verbose_mode = FALSE;
static gchar* vala_compiler_profile = NULL;
static gboolean vala_compiler_nostdpkg = FALSE;
static gboolean vala_compiler_enable_version_header = FALSE;
static gboolean vala_compiler_disable_version_header = FALSE;
static gboolean vala_compiler_fatal_warnings = FALSE;
static gboolean vala_compiler_disable_colored_output = FALSE;
static ValaReportColored vala_compiler_colored_output;
static ValaReportColored vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
static gchar* vala_compiler_dependencies = NULL;
static gchar* vala_compiler_depfile = NULL;
static gchar* vala_compiler_entry_point = NULL;
static gboolean vala_compiler_run_output;
static gboolean vala_compiler_run_output = FALSE;
static gchar* vala_compiler_run_args = NULL;

G_GNUC_INTERNAL gpointer vala_compiler_ref (gpointer instance);
G_GNUC_INTERNAL void vala_compiler_unref (gpointer instance);
G_GNUC_INTERNAL GParamSpec* vala_param_spec_compiler (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
G_GNUC_INTERNAL void vala_value_set_compiler (GValue* value,
                              gpointer v_object) G_GNUC_UNUSED;
G_GNUC_INTERNAL void vala_value_take_compiler (GValue* value,
                               gpointer v_object);
G_GNUC_INTERNAL gpointer vala_value_get_compiler (const GValue* value) G_GNUC_UNUSED;
G_GNUC_INTERNAL GType vala_compiler_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ValaCompiler, vala_compiler_unref)
#define VALA_COMPILER_DEFAULT_COLORS "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
static gboolean vala_compiler_option_deprecated (const gchar* option_name,
                                          const gchar* val,
                                          void* data,
                                          GError** error);
static gboolean vala_compiler_option_parse_color (const gchar* option_name,
                                           const gchar* val,
                                           void* data,
                                           GError** error);
static gint vala_compiler_quit (ValaCompiler* self);
static gint vala_compiler_run (ValaCompiler* self);
static gint vala_compiler_run_source (gchar** args,
                               gint args_length1);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_new (void);
G_GNUC_INTERNAL ValaCompiler* vala_compiler_construct (GType object_type);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ___lambda4_ (Block1Data* _data1_,
                  GPid pid,
                  gint status);
static void ____lambda4__gchild_watch_func (GPid pid,
                                     gint status,
                                     gpointer self);
static gint vala_compiler_main (gchar** args,
                         gint args_length1);
static void vala_compiler_finalize (ValaCompiler * obj);
static GType vala_compiler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry VALA_COMPILER_options[63] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_library, "Library name", "NAME"}, {"shared-library", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_shared_library, "Shared library name used in generated gir", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &vala_compiler_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &vala_compiler_directory, "Change output directory from current working directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &vala_compiler_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &vala_compiler_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"vapi-comments", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_vapi_comments, "Include comments in generated vapi", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_dependencies, "Write make-style dependency information to this file", NULL}, {"depfile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_depfile, "Write make-style external dependency information for build systems to " \
"this file", NULL}, {"list-sources", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_list_sources, "Output a list of all source and binding files which are used", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &vala_compiler_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &vala_compiler_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &vala_compiler_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, (gint) (G_OPTION_FLAG_OPTIONAL_ARG | G_OPTION_FLAG_NO_ARG), G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_deprecated, "Enable multithreading support (DEPRECATED AND IGNORED)", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_deprecated, "Enable deprecated features", NULL}, {"hide-internal", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_hide_internal, "Hide symbols marked as internal", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_fatal_warnings, "Treat warnings as fatal", NULL}, {"disable-since-check", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_since_check, "Do not check whether used symbols exist in local packages", NULL}, {"keep-going", 'k', 0, G_OPTION_ARG_NONE, &vala_compiler_keep_going, "Continue as much as possible after an error", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &vala_compiler_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"pkg-config", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_pkg_config_command, "Use COMMAND as pkg-config command", "COMMAND"}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &vala_compiler_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &vala_compiler_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &vala_compiler_verbose_mode, "Print additional messages to the console", NULL}, {"no-color", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_colored_output, "Disable colored output, alias for --color=never", NULL}, {"color", (gchar) 0, (gint) G_OPTION_FLAG_OPTIONAL_ARG, G_OPTION_ARG_CALLBACK, (void*) vala_compiler_option_parse_color, "Enable color output, options are 'always', 'never', or 'auto'", "WHEN"}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_target_glib, "Target version of glib for code generation", "'MAJOR.MINOR', or 'auto'"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources, "XML of gresources", "FILE..."}, {"gresourcesdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_gresources_directories, "Look for resources in DIRECTORY", "DIRECTORY..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_disable_version_header, "Do not write vala build version in generated files", NULL}, {"run-args", (gchar) 0, 0, G_OPTION_ARG_STRING, &vala_compiler_run_args, "Arguments passed to directly compiled executable", NULL}, {"abi-stability", (gchar) 0, 0, G_OPTION_ARG_NONE, &vala_compiler_abi_stability, "Enable support for ABI stability", NULL}, {G_OPTION_REMAINING, (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &vala_compiler_sources, NULL, "FILE..."}, {NULL}};

static inline gpointer
vala_compiler_get_instance_private (ValaCompiler* self)
{
	return G_STRUCT_MEMBER_P (self, ValaCompiler_private_offset);
}

static gboolean
vala_compiler_option_parse_color (const gchar* option_name,
                                  const gchar* val,
                                  void* data,
                                  GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = val;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("auto")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_AUTO;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("never")))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
				break;
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (NULL)))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("always"))))) {
		switch (0) {
			default:
			{
				vala_compiler_colored_output = VALA_REPORT_COLORED_ALWAYS;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GError* _tmp3_;
				_tmp3_ = g_error_new (G_OPTION_ERROR, G_OPTION_ERROR_FAILED, "Invalid --color argument '%s'", val);
				_inner_error0_ = _tmp3_;
				if (_inner_error0_->domain == G_OPTION_ERROR) {
					gboolean _tmp4_ = FALSE;
					g_propagate_error (error, _inner_error0_);
					return _tmp4_;
				} else {
					gboolean _tmp5_ = FALSE;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp5_;
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static gboolean
vala_compiler_option_deprecated (const gchar* option_name,
                                 const gchar* val,
                                 void* data,
                                 GError** error)
{
	FILE* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (option_name != NULL, FALSE);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "Command-line option `%s` is deprecated and will be ignored\n", option_name);
	result = TRUE;
	return result;
}

static gint
vala_compiler_quit (ValaCompiler* self)
{
	gboolean _tmp0_ = FALSE;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_;
	ValaReport* _tmp9_;
	ValaReport* _tmp10_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->context;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	if (vala_report_get_errors (_tmp3_) == 0) {
		ValaCodeContext* _tmp4_;
		ValaReport* _tmp5_;
		ValaReport* _tmp6_;
		_tmp4_ = self->priv->context;
		_tmp5_ = vala_code_context_get_report (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = vala_report_get_warnings (_tmp6_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_code_context_pop ();
		result = 0;
		return result;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_report (_tmp8_);
	_tmp10_ = _tmp9_;
	if (vala_report_get_errors (_tmp10_) == 0) {
		gboolean _tmp11_ = FALSE;
		if (!vala_compiler_fatal_warnings) {
			_tmp11_ = TRUE;
		} else {
			ValaCodeContext* _tmp12_;
			ValaReport* _tmp13_;
			ValaReport* _tmp14_;
			_tmp12_ = self->priv->context;
			_tmp13_ = vala_code_context_get_report (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp11_ = vala_report_get_warnings (_tmp14_) == 0;
		}
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp15_;
			ValaCodeContext* _tmp16_;
			ValaReport* _tmp17_;
			ValaReport* _tmp18_;
			_tmp15_ = stdout;
			_tmp16_ = self->priv->context;
			_tmp17_ = vala_code_context_get_report (_tmp16_);
			_tmp18_ = _tmp17_;
			fprintf (_tmp15_, "Compilation succeeded - %d warning(s)\n", vala_report_get_warnings (_tmp18_));
		}
		vala_code_context_pop ();
		result = 0;
		return result;
	} else {
		if (!vala_compiler_quiet_mode) {
			FILE* _tmp19_;
			ValaCodeContext* _tmp20_;
			ValaReport* _tmp21_;
			ValaReport* _tmp22_;
			ValaCodeContext* _tmp23_;
			ValaReport* _tmp24_;
			ValaReport* _tmp25_;
			_tmp19_ = stdout;
			_tmp20_ = self->priv->context;
			_tmp21_ = vala_code_context_get_report (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = self->priv->context;
			_tmp24_ = vala_code_context_get_report (_tmp23_);
			_tmp25_ = _tmp24_;
			fprintf (_tmp19_, "Compilation failed: %d error(s), %d warning(s)\n", vala_report_get_errors (_tmp22_), vala_report_get_warnings (_tmp25_));
		}
		vala_code_context_pop ();
		result = 1;
		return result;
	}
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
vala_compiler_run (ValaCompiler* self)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReportColored _tmp2_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	ValaCodeContext* _tmp26_;
	ValaCodeContext* _tmp27_;
	ValaCodeContext* _tmp28_;
	ValaCodeContext* _tmp29_;
	ValaCodeContext* _tmp30_;
	ValaCodeContext* _tmp31_;
	ValaCodeContext* _tmp32_;
	ValaCodeContext* _tmp33_;
	ValaCodeContext* _tmp34_;
	ValaCodeContext* _tmp35_;
	ValaReport* _tmp36_;
	ValaReport* _tmp37_;
	ValaCodeContext* _tmp38_;
	ValaReport* _tmp39_;
	ValaReport* _tmp40_;
	ValaCodeContext* _tmp41_;
	ValaCodeContext* _tmp42_;
	ValaCodeContext* _tmp43_;
	gboolean _tmp44_ = FALSE;
	ValaCodeContext* _tmp46_;
	ValaCodeContext* _tmp47_;
	ValaCodeContext* _tmp48_;
	const gchar* _tmp49_;
	gboolean _tmp50_ = FALSE;
	const gchar* _tmp51_;
	ValaCodeContext* _tmp52_;
	ValaCodeContext* _tmp53_;
	const gchar* _tmp54_;
	ValaCodeContext* _tmp55_;
	const gchar* _tmp56_;
	ValaCodeContext* _tmp57_;
	const gchar* _tmp58_;
	ValaCodeContext* _tmp59_;
	const gchar* _tmp60_;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp71_;
	ValaCodeContext* _tmp80_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	ValaCodeContext* _tmp82_;
	ValaCodeContext* _tmp83_;
	gchar** _tmp84_;
	gint _tmp84__length1;
	ValaCodeContext* _tmp85_;
	gchar** _tmp86_;
	gint _tmp86__length1;
	ValaCodeContext* _tmp87_;
	ValaCodeContext* _tmp88_;
	ValaCodeContext* _tmp89_;
	gboolean _tmp90_ = FALSE;
	const gchar* _tmp91_;
	const gchar* _tmp104_;
	ValaCodeContext* _tmp105_;
	ValaCodeContext* _tmp106_;
	const gchar* _tmp107_;
	ValaCodeContext* _tmp108_;
	const gchar* _tmp109_;
	ValaCodeContext* _tmp113_;
	const gchar* _tmp114_;
	gchar** _tmp115_;
	gint _tmp115__length1;
	ValaCodeContext* _tmp120_;
	ValaProfile _tmp121_;
	ValaProfile _tmp122_;
	gchar** _tmp132_;
	gint _tmp132__length1;
	gchar** _tmp137_;
	gint _tmp137__length1;
	ValaCodeContext* _tmp148_;
	gchar** _tmp149_;
	gint _tmp149__length1;
	ValaCodeContext* _tmp150_;
	gchar** _tmp151_;
	gint _tmp151__length1;
	gboolean _tmp152_ = FALSE;
	ValaCodeContext* _tmp153_;
	ValaReport* _tmp154_;
	ValaReport* _tmp155_;
	ValaCodeContext* _tmp160_;
	ValaProfile _tmp161_;
	ValaProfile _tmp162_;
	gboolean has_c_files = FALSE;
	gboolean has_h_files = FALSE;
	gchar** _tmp169_;
	gint _tmp169__length1;
	gboolean _tmp175_ = FALSE;
	gboolean _tmp177_ = FALSE;
	ValaCodeContext* _tmp178_;
	ValaReport* _tmp179_;
	ValaReport* _tmp180_;
	ValaParser* parser = NULL;
	ValaParser* _tmp205_;
	ValaParser* _tmp206_;
	ValaCodeContext* _tmp207_;
	ValaGenieParser* genie_parser = NULL;
	ValaGenieParser* _tmp208_;
	ValaGenieParser* _tmp209_;
	ValaCodeContext* _tmp210_;
	ValaGirParser* gir_parser = NULL;
	ValaGirParser* _tmp211_;
	ValaGirParser* _tmp212_;
	ValaCodeContext* _tmp213_;
	gboolean _tmp214_ = FALSE;
	ValaCodeContext* _tmp215_;
	ValaReport* _tmp216_;
	ValaReport* _tmp217_;
	const gchar* _tmp222_;
	ValaCodeContext* _tmp227_;
	gboolean _tmp228_ = FALSE;
	ValaCodeContext* _tmp229_;
	ValaReport* _tmp230_;
	ValaReport* _tmp231_;
	gboolean _tmp236_ = FALSE;
	gboolean _tmp237_ = FALSE;
	const gchar* _tmp243_;
	gboolean _tmp248_ = FALSE;
	ValaCodeContext* _tmp249_;
	ValaReport* _tmp250_;
	ValaReport* _tmp251_;
	ValaCodeContext* _tmp256_;
	ValaCodeGenerator* _tmp257_;
	ValaCodeGenerator* _tmp258_;
	ValaCodeContext* _tmp259_;
	gboolean _tmp260_ = FALSE;
	ValaCodeContext* _tmp261_;
	ValaReport* _tmp262_;
	ValaReport* _tmp263_;
	gboolean _tmp268_ = FALSE;
	const gchar* _tmp269_;
	const gchar* _tmp273_;
	const gchar* _tmp320_;
	const gchar* _tmp333_;
	const gchar* _tmp376_;
	const gchar* _tmp379_;
	gboolean _tmp382_ = FALSE;
	ValaCodeContext* _tmp383_;
	ValaReport* _tmp384_;
	ValaReport* _tmp385_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_code_context_new ();
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = self->priv->context;
	vala_code_context_push (_tmp1_);
	if (vala_compiler_disable_colored_output) {
		vala_compiler_colored_output = VALA_REPORT_COLORED_NEVER;
	}
	_tmp2_ = vala_compiler_colored_output;
	if (_tmp2_ != VALA_REPORT_COLORED_NEVER) {
		const gchar* env_colors = NULL;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = g_getenv ("VALA_COLORS");
		env_colors = _tmp3_;
		_tmp4_ = env_colors;
		if (_tmp4_ != NULL) {
			ValaCodeContext* _tmp5_;
			ValaReport* _tmp6_;
			ValaReport* _tmp7_;
			const gchar* _tmp8_;
			ValaReportColored _tmp9_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_report (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = env_colors;
			_tmp9_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp7_, _tmp8_, _tmp9_);
		} else {
			ValaCodeContext* _tmp10_;
			ValaReport* _tmp11_;
			ValaReport* _tmp12_;
			ValaReportColored _tmp13_;
			_tmp10_ = self->priv->context;
			_tmp11_ = vala_code_context_get_report (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_compiler_colored_output;
			vala_report_set_colors (_tmp12_, VALA_COMPILER_DEFAULT_COLORS, _tmp13_);
		}
	}
	if (!vala_compiler_ccode_only) {
		_tmp15_ = !vala_compiler_compile_only;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = vala_compiler_output;
		_tmp14_ = _tmp16_ == NULL;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar** _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp18_;
		_tmp17_ = vala_compiler_sources;
		_tmp17__length1 = _vala_array_length (vala_compiler_sources);
		_tmp18_ = _tmp17_[0];
		if (string_last_index_of_char (_tmp18_, (gunichar) '.', 0) != -1) {
			gint dot = 0;
			gchar** _tmp19_;
			gint _tmp19__length1;
			const gchar* _tmp20_;
			gchar** _tmp21_;
			gint _tmp21__length1;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp19_ = vala_compiler_sources;
			_tmp19__length1 = _vala_array_length (vala_compiler_sources);
			_tmp20_ = _tmp19_[0];
			dot = string_last_index_of_char (_tmp20_, (gunichar) '.', 0);
			_tmp21_ = vala_compiler_sources;
			_tmp21__length1 = _vala_array_length (vala_compiler_sources);
			_tmp22_ = _tmp21_[0];
			_tmp23_ = string_substring (_tmp22_, (glong) 0, (glong) dot);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_path_get_basename (_tmp24_);
			_g_free0 (vala_compiler_output);
			vala_compiler_output = _tmp25_;
			_g_free0 (_tmp24_);
		}
	}
	_tmp26_ = self->priv->context;
	vala_code_context_set_assert (_tmp26_, !vala_compiler_disable_assert);
	_tmp27_ = self->priv->context;
	vala_code_context_set_checking (_tmp27_, vala_compiler_enable_checking);
	_tmp28_ = self->priv->context;
	vala_code_context_set_deprecated (_tmp28_, vala_compiler_deprecated);
	_tmp29_ = self->priv->context;
	vala_code_context_set_since_check (_tmp29_, !vala_compiler_disable_since_check);
	_tmp30_ = self->priv->context;
	vala_code_context_set_hide_internal (_tmp30_, vala_compiler_hide_internal);
	_tmp31_ = self->priv->context;
	vala_code_context_set_experimental (_tmp31_, vala_compiler_experimental);
	_tmp32_ = self->priv->context;
	vala_code_context_set_experimental_non_null (_tmp32_, vala_compiler_experimental_non_null);
	_tmp33_ = self->priv->context;
	vala_code_context_set_gobject_tracing (_tmp33_, vala_compiler_gobject_tracing);
	_tmp34_ = self->priv->context;
	vala_code_context_set_keep_going (_tmp34_, vala_compiler_keep_going);
	_tmp35_ = self->priv->context;
	_tmp36_ = vala_code_context_get_report (_tmp35_);
	_tmp37_ = _tmp36_;
	vala_report_set_enable_warnings (_tmp37_, !vala_compiler_disable_warnings);
	_tmp38_ = self->priv->context;
	_tmp39_ = vala_code_context_get_report (_tmp38_);
	_tmp40_ = _tmp39_;
	vala_report_set_verbose_errors (_tmp40_, !vala_compiler_quiet_mode);
	_tmp41_ = self->priv->context;
	vala_code_context_set_verbose_mode (_tmp41_, vala_compiler_verbose_mode);
	_tmp42_ = self->priv->context;
	vala_code_context_set_version_header (_tmp42_, !vala_compiler_disable_version_header);
	_tmp43_ = self->priv->context;
	vala_code_context_set_ccode_only (_tmp43_, vala_compiler_ccode_only);
	if (vala_compiler_ccode_only) {
		gchar** _tmp45_;
		gint _tmp45__length1;
		_tmp45_ = vala_compiler_cc_options;
		_tmp45__length1 = _vala_array_length (vala_compiler_cc_options);
		_tmp44_ = _tmp45_ != NULL;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		vala_report_warning (NULL, "-X has no effect when -C or --ccode is set");
	}
	_tmp46_ = self->priv->context;
	vala_code_context_set_abi_stability (_tmp46_, vala_compiler_abi_stability);
	_tmp47_ = self->priv->context;
	vala_code_context_set_compile_only (_tmp47_, vala_compiler_compile_only);
	_tmp48_ = self->priv->context;
	_tmp49_ = vala_compiler_header_filename;
	vala_code_context_set_header_filename (_tmp48_, _tmp49_);
	_tmp51_ = vala_compiler_header_filename;
	if (_tmp51_ == NULL) {
		_tmp50_ = vala_compiler_use_header;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp52_ = self->priv->context;
	vala_code_context_set_use_header (_tmp52_, vala_compiler_use_header);
	_tmp53_ = self->priv->context;
	_tmp54_ = vala_compiler_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp53_, _tmp54_);
	_tmp55_ = self->priv->context;
	_tmp56_ = vala_compiler_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->context;
	_tmp58_ = vala_compiler_includedir;
	vala_code_context_set_includedir (_tmp57_, _tmp58_);
	_tmp59_ = self->priv->context;
	_tmp60_ = vala_compiler_output;
	vala_code_context_set_output (_tmp59_, _tmp60_);
	_tmp62_ = vala_compiler_output;
	if (_tmp62_ != NULL) {
		_tmp61_ = vala_compiler_ccode_only;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		vala_report_warning (NULL, "--output and -o have no effect when -C or --ccode is set");
	}
	_tmp63_ = vala_compiler_basedir;
	if (_tmp63_ == NULL) {
		ValaCodeContext* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		_tmp64_ = self->priv->context;
		_tmp65_ = vala_code_context_realpath (".");
		_tmp66_ = _tmp65_;
		vala_code_context_set_basedir (_tmp64_, _tmp66_);
		_g_free0 (_tmp66_);
	} else {
		ValaCodeContext* _tmp67_;
		const gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp67_ = self->priv->context;
		_tmp68_ = vala_compiler_basedir;
		_tmp69_ = vala_code_context_realpath (_tmp68_);
		_tmp70_ = _tmp69_;
		vala_code_context_set_basedir (_tmp67_, _tmp70_);
		_g_free0 (_tmp70_);
	}
	_tmp71_ = vala_compiler_directory;
	if (_tmp71_ != NULL) {
		ValaCodeContext* _tmp72_;
		const gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		_tmp72_ = self->priv->context;
		_tmp73_ = vala_compiler_directory;
		_tmp74_ = vala_code_context_realpath (_tmp73_);
		_tmp75_ = _tmp74_;
		vala_code_context_set_directory (_tmp72_, _tmp75_);
		_g_free0 (_tmp75_);
	} else {
		ValaCodeContext* _tmp76_;
		ValaCodeContext* _tmp77_;
		const gchar* _tmp78_;
		const gchar* _tmp79_;
		_tmp76_ = self->priv->context;
		_tmp77_ = self->priv->context;
		_tmp78_ = vala_code_context_get_basedir (_tmp77_);
		_tmp79_ = _tmp78_;
		vala_code_context_set_directory (_tmp76_, _tmp79_);
	}
	_tmp80_ = self->priv->context;
	_tmp81_ = vala_compiler_vapi_directories;
	_tmp81__length1 = _vala_array_length (vala_compiler_vapi_directories);
	vala_code_context_set_vapi_directories (_tmp80_, _tmp81_, _tmp81__length1);
	_tmp82_ = self->priv->context;
	vala_code_context_set_vapi_comments (_tmp82_, vala_compiler_vapi_comments);
	_tmp83_ = self->priv->context;
	_tmp84_ = vala_compiler_gir_directories;
	_tmp84__length1 = _vala_array_length (vala_compiler_gir_directories);
	vala_code_context_set_gir_directories (_tmp83_, _tmp84_, _tmp84__length1);
	_tmp85_ = self->priv->context;
	_tmp86_ = vala_compiler_metadata_directories;
	_tmp86__length1 = _vala_array_length (vala_compiler_metadata_directories);
	vala_code_context_set_metadata_directories (_tmp85_, _tmp86_, _tmp86__length1);
	_tmp87_ = self->priv->context;
	vala_code_context_set_debug (_tmp87_, vala_compiler_debug);
	_tmp88_ = self->priv->context;
	vala_code_context_set_mem_profiler (_tmp88_, vala_compiler_mem_profiler);
	_tmp89_ = self->priv->context;
	vala_code_context_set_save_temps (_tmp89_, vala_compiler_save_temps);
	if (vala_compiler_ccode_only) {
		_tmp90_ = vala_compiler_save_temps;
	} else {
		_tmp90_ = FALSE;
	}
	if (_tmp90_) {
		vala_report_warning (NULL, "--save-temps has no effect when -C or --ccode is set");
	}
	_tmp91_ = vala_compiler_profile;
	if (g_strcmp0 (_tmp91_, "posix") == 0) {
		ValaCodeContext* _tmp92_;
		ValaCodeContext* _tmp93_;
		_tmp92_ = self->priv->context;
		vala_code_context_set_profile (_tmp92_, VALA_PROFILE_POSIX);
		_tmp93_ = self->priv->context;
		vala_code_context_add_define (_tmp93_, "POSIX");
	} else {
		gboolean _tmp94_ = FALSE;
		gboolean _tmp95_ = FALSE;
		const gchar* _tmp96_;
		_tmp96_ = vala_compiler_profile;
		if (g_strcmp0 (_tmp96_, "gobject-2.0") == 0) {
			_tmp95_ = TRUE;
		} else {
			const gchar* _tmp97_;
			_tmp97_ = vala_compiler_profile;
			_tmp95_ = g_strcmp0 (_tmp97_, "gobject") == 0;
		}
		if (_tmp95_) {
			_tmp94_ = TRUE;
		} else {
			const gchar* _tmp98_;
			_tmp98_ = vala_compiler_profile;
			_tmp94_ = _tmp98_ == NULL;
		}
		if (_tmp94_) {
			ValaCodeContext* _tmp99_;
			ValaCodeContext* _tmp100_;
			_tmp99_ = self->priv->context;
			vala_code_context_set_profile (_tmp99_, VALA_PROFILE_GOBJECT);
			_tmp100_ = self->priv->context;
			vala_code_context_add_define (_tmp100_, "GOBJECT");
		} else {
			const gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			_tmp101_ = vala_compiler_profile;
			_tmp102_ = g_strdup_printf ("Unknown profile %s", _tmp101_);
			_tmp103_ = _tmp102_;
			vala_report_error (NULL, _tmp103_);
			_g_free0 (_tmp103_);
		}
	}
	_tmp104_ = vala_compiler_fast_vapi_filename;
	vala_compiler_nostdpkg = vala_compiler_nostdpkg | (_tmp104_ != NULL);
	_tmp105_ = self->priv->context;
	vala_code_context_set_nostdpkg (_tmp105_, vala_compiler_nostdpkg);
	_tmp106_ = self->priv->context;
	_tmp107_ = vala_compiler_entry_point;
	vala_code_context_set_entry_point_name (_tmp106_, _tmp107_);
	_tmp108_ = self->priv->context;
	vala_code_context_set_run_output (_tmp108_, vala_compiler_run_output);
	_tmp109_ = vala_compiler_pkg_config_command;
	if (_tmp109_ == NULL) {
		const gchar* _tmp110_ = NULL;
		const gchar* _tmp111_;
		gchar* _tmp112_;
		_tmp111_ = g_getenv ("PKG_CONFIG");
		_tmp110_ = _tmp111_;
		if (_tmp110_ == NULL) {
			_tmp110_ = "pkg-config";
		}
		_tmp112_ = g_strdup (_tmp110_);
		_g_free0 (vala_compiler_pkg_config_command);
		vala_compiler_pkg_config_command = _tmp112_;
	}
	_tmp113_ = self->priv->context;
	_tmp114_ = vala_compiler_pkg_config_command;
	vala_code_context_set_pkg_config_command (_tmp113_, _tmp114_);
	_tmp115_ = vala_compiler_defines;
	_tmp115__length1 = _vala_array_length (vala_compiler_defines);
	if (_tmp115_ != NULL) {
		gchar** _tmp116_;
		gint _tmp116__length1;
		_tmp116_ = vala_compiler_defines;
		_tmp116__length1 = _vala_array_length (vala_compiler_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp116_;
			define_collection_length1 = _tmp116__length1;
			for (define_it = 0; define_it < define_collection_length1; define_it = define_it + 1) {
				gchar* _tmp117_;
				gchar* define = NULL;
				_tmp117_ = g_strdup (define_collection[define_it]);
				define = _tmp117_;
				{
					ValaCodeContext* _tmp118_;
					const gchar* _tmp119_;
					_tmp118_ = self->priv->context;
					_tmp119_ = define;
					vala_code_context_add_define (_tmp118_, _tmp119_);
					_g_free0 (define);
				}
			}
		}
	}
	_tmp120_ = self->priv->context;
	_tmp121_ = vala_code_context_get_profile (_tmp120_);
	_tmp122_ = _tmp121_;
	if (_tmp122_ == VALA_PROFILE_POSIX) {
		if (!vala_compiler_nostdpkg) {
			ValaCodeContext* _tmp123_;
			_tmp123_ = self->priv->context;
			vala_code_context_add_external_package (_tmp123_, "posix");
		}
	} else {
		ValaCodeContext* _tmp124_;
		ValaProfile _tmp125_;
		ValaProfile _tmp126_;
		_tmp124_ = self->priv->context;
		_tmp125_ = vala_code_context_get_profile (_tmp124_);
		_tmp126_ = _tmp125_;
		if (_tmp126_ == VALA_PROFILE_GOBJECT) {
			const gchar* _tmp127_;
			_tmp127_ = vala_compiler_target_glib;
			if (_tmp127_ != NULL) {
				ValaCodeContext* _tmp128_;
				const gchar* _tmp129_;
				_tmp128_ = self->priv->context;
				_tmp129_ = vala_compiler_target_glib;
				vala_code_context_set_target_glib_version (_tmp128_, _tmp129_);
			}
			if (!vala_compiler_nostdpkg) {
				ValaCodeContext* _tmp130_;
				ValaCodeContext* _tmp131_;
				_tmp130_ = self->priv->context;
				vala_code_context_add_external_package (_tmp130_, "glib-2.0");
				_tmp131_ = self->priv->context;
				vala_code_context_add_external_package (_tmp131_, "gobject-2.0");
			}
		}
	}
	_tmp132_ = vala_compiler_packages;
	_tmp132__length1 = _vala_array_length (vala_compiler_packages);
	if (_tmp132_ != NULL) {
		gchar** _tmp133_;
		gint _tmp133__length1;
		_tmp133_ = vala_compiler_packages;
		_tmp133__length1 = _vala_array_length (vala_compiler_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp133_;
			package_collection_length1 = _tmp133__length1;
			for (package_it = 0; package_it < package_collection_length1; package_it = package_it + 1) {
				gchar* _tmp134_;
				gchar* package = NULL;
				_tmp134_ = g_strdup (package_collection[package_it]);
				package = _tmp134_;
				{
					ValaCodeContext* _tmp135_;
					const gchar* _tmp136_;
					_tmp135_ = self->priv->context;
					_tmp136_ = package;
					vala_code_context_add_external_package (_tmp135_, _tmp136_);
					_g_free0 (package);
				}
			}
		}
		vala_compiler_packages = (_vala_array_free (vala_compiler_packages, _vala_array_length (vala_compiler_packages), (GDestroyNotify) g_free), NULL);
		vala_compiler_packages = NULL;
	}
	_tmp137_ = vala_compiler_fast_vapis;
	_tmp137__length1 = _vala_array_length (vala_compiler_fast_vapis);
	if (_tmp137_ != NULL) {
		gchar** _tmp138_;
		gint _tmp138__length1;
		ValaCodeContext* _tmp147_;
		_tmp138_ = vala_compiler_fast_vapis;
		_tmp138__length1 = _vala_array_length (vala_compiler_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp138_;
			vapi_collection_length1 = _tmp138__length1;
			for (vapi_it = 0; vapi_it < vapi_collection_length1; vapi_it = vapi_it + 1) {
				gchar* _tmp139_;
				gchar* vapi = NULL;
				_tmp139_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp139_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp140_;
					gchar* _tmp141_;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp142_;
					const gchar* _tmp143_;
					ValaSourceFile* _tmp144_;
					ValaCodeContext* _tmp145_;
					ValaSourceFile* _tmp146_;
					_tmp140_ = vapi;
					_tmp141_ = vala_code_context_realpath (_tmp140_);
					rpath = _tmp141_;
					_tmp142_ = self->priv->context;
					_tmp143_ = rpath;
					_tmp144_ = vala_source_file_new (_tmp142_, VALA_SOURCE_FILE_TYPE_FAST, _tmp143_, NULL, FALSE);
					source_file = _tmp144_;
					_tmp145_ = self->priv->context;
					_tmp146_ = source_file;
					vala_code_context_add_source_file (_tmp145_, _tmp146_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp147_ = self->priv->context;
		vala_code_context_set_use_fast_vapi (_tmp147_, TRUE);
	}
	_tmp148_ = self->priv->context;
	_tmp149_ = vala_compiler_gresources;
	_tmp149__length1 = _vala_array_length (vala_compiler_gresources);
	vala_code_context_set_gresources (_tmp148_, _tmp149_, _tmp149__length1);
	_tmp150_ = self->priv->context;
	_tmp151_ = vala_compiler_gresources_directories;
	_tmp151__length1 = _vala_array_length (vala_compiler_gresources_directories);
	vala_code_context_set_gresources_directories (_tmp150_, _tmp151_, _tmp151__length1);
	_tmp153_ = self->priv->context;
	_tmp154_ = vala_code_context_get_report (_tmp153_);
	_tmp155_ = _tmp154_;
	if (vala_report_get_errors (_tmp155_) > 0) {
		_tmp152_ = TRUE;
	} else {
		gboolean _tmp156_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp157_;
			ValaReport* _tmp158_;
			ValaReport* _tmp159_;
			_tmp157_ = self->priv->context;
			_tmp158_ = vala_code_context_get_report (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp156_ = vala_report_get_warnings (_tmp159_) > 0;
		} else {
			_tmp156_ = FALSE;
		}
		_tmp152_ = _tmp156_;
	}
	if (_tmp152_) {
		result = vala_compiler_quit (self);
		return result;
	}
	_tmp160_ = self->priv->context;
	_tmp161_ = vala_code_context_get_profile (_tmp160_);
	_tmp162_ = _tmp161_;
	if (_tmp162_ == VALA_PROFILE_GOBJECT) {
		ValaCodeContext* _tmp163_;
		ValaGDBusServerModule* _tmp164_;
		ValaGDBusServerModule* _tmp165_;
		_tmp163_ = self->priv->context;
		_tmp164_ = vala_gd_bus_server_module_new ();
		_tmp165_ = _tmp164_;
		vala_code_context_set_codegen (_tmp163_, (ValaCodeGenerator*) _tmp165_);
		_vala_code_visitor_unref0 (_tmp165_);
	} else {
		ValaCodeContext* _tmp166_;
		ValaCCodeDelegateModule* _tmp167_;
		ValaCCodeDelegateModule* _tmp168_;
		_tmp166_ = self->priv->context;
		_tmp167_ = vala_ccode_delegate_module_new ();
		_tmp168_ = _tmp167_;
		vala_code_context_set_codegen (_tmp166_, (ValaCodeGenerator*) _tmp168_);
		_vala_code_visitor_unref0 (_tmp168_);
	}
	has_c_files = FALSE;
	has_h_files = FALSE;
	_tmp169_ = vala_compiler_sources;
	_tmp169__length1 = _vala_array_length (vala_compiler_sources);
	{
		gchar** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp169_;
		source_collection_length1 = _tmp169__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			gchar* _tmp170_;
			gchar* source = NULL;
			_tmp170_ = g_strdup (source_collection[source_it]);
			source = _tmp170_;
			{
				ValaCodeContext* _tmp171_;
				const gchar* _tmp172_;
				_tmp171_ = self->priv->context;
				_tmp172_ = source;
				if (vala_code_context_add_source_filename (_tmp171_, _tmp172_, vala_compiler_run_output, TRUE)) {
					const gchar* _tmp173_;
					_tmp173_ = source;
					if (g_str_has_suffix (_tmp173_, ".c")) {
						has_c_files = TRUE;
					} else {
						const gchar* _tmp174_;
						_tmp174_ = source;
						if (g_str_has_suffix (_tmp174_, ".h")) {
							has_h_files = TRUE;
						}
					}
				}
				_g_free0 (source);
			}
		}
	}
	vala_compiler_sources = (_vala_array_free (vala_compiler_sources, _vala_array_length (vala_compiler_sources), (GDestroyNotify) g_free), NULL);
	vala_compiler_sources = NULL;
	if (vala_compiler_ccode_only) {
		gboolean _tmp176_ = FALSE;
		if (has_c_files) {
			_tmp176_ = TRUE;
		} else {
			_tmp176_ = has_h_files;
		}
		_tmp175_ = _tmp176_;
	} else {
		_tmp175_ = FALSE;
	}
	if (_tmp175_) {
		vala_report_warning (NULL, "C header and source files are ignored when -C or --ccode is set");
	}
	_tmp178_ = self->priv->context;
	_tmp179_ = vala_code_context_get_report (_tmp178_);
	_tmp180_ = _tmp179_;
	if (vala_report_get_errors (_tmp180_) > 0) {
		_tmp177_ = TRUE;
	} else {
		gboolean _tmp181_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp182_;
			ValaReport* _tmp183_;
			ValaReport* _tmp184_;
			_tmp182_ = self->priv->context;
			_tmp183_ = vala_code_context_get_report (_tmp182_);
			_tmp184_ = _tmp183_;
			_tmp181_ = vala_report_get_warnings (_tmp184_) > 0;
		} else {
			_tmp181_ = FALSE;
		}
		_tmp177_ = _tmp181_;
	}
	if (_tmp177_) {
		result = vala_compiler_quit (self);
		return result;
	}
	if (vala_compiler_list_sources) {
		{
			ValaList* _file_list = NULL;
			ValaCodeContext* _tmp185_;
			ValaList* _tmp186_;
			ValaList* _tmp187_;
			gint _file_size = 0;
			ValaList* _tmp188_;
			gint _tmp189_;
			gint _tmp190_;
			gint _file_index = 0;
			_tmp185_ = self->priv->context;
			_tmp186_ = vala_code_context_get_source_files (_tmp185_);
			_tmp187_ = _vala_iterable_ref0 (_tmp186_);
			_file_list = _tmp187_;
			_tmp188_ = _file_list;
			_tmp189_ = vala_collection_get_size ((ValaCollection*) _tmp188_);
			_tmp190_ = _tmp189_;
			_file_size = _tmp190_;
			_file_index = -1;
			while (TRUE) {
				ValaSourceFile* file = NULL;
				ValaList* _tmp191_;
				gpointer _tmp192_;
				ValaSourceFile* _tmp193_;
				const gchar* _tmp194_;
				const gchar* _tmp195_;
				_file_index = _file_index + 1;
				if (!(_file_index < _file_size)) {
					break;
				}
				_tmp191_ = _file_list;
				_tmp192_ = vala_list_get (_tmp191_, _file_index);
				file = (ValaSourceFile*) _tmp192_;
				_tmp193_ = file;
				_tmp194_ = vala_source_file_get_filename (_tmp193_);
				_tmp195_ = _tmp194_;
				g_print ("%s\n", _tmp195_);
				_vala_source_file_unref0 (file);
			}
			_vala_iterable_unref0 (_file_list);
		}
		if (!vala_compiler_ccode_only) {
			{
				ValaList* _filename_list = NULL;
				ValaCodeContext* _tmp196_;
				ValaList* _tmp197_;
				ValaList* _tmp198_;
				gint _filename_size = 0;
				ValaList* _tmp199_;
				gint _tmp200_;
				gint _tmp201_;
				gint _filename_index = 0;
				_tmp196_ = self->priv->context;
				_tmp197_ = vala_code_context_get_c_source_files (_tmp196_);
				_tmp198_ = _vala_iterable_ref0 (_tmp197_);
				_filename_list = _tmp198_;
				_tmp199_ = _filename_list;
				_tmp200_ = vala_collection_get_size ((ValaCollection*) _tmp199_);
				_tmp201_ = _tmp200_;
				_filename_size = _tmp201_;
				_filename_index = -1;
				while (TRUE) {
					gchar* filename = NULL;
					ValaList* _tmp202_;
					gpointer _tmp203_;
					const gchar* _tmp204_;
					_filename_index = _filename_index + 1;
					if (!(_filename_index < _filename_size)) {
						break;
					}
					_tmp202_ = _filename_list;
					_tmp203_ = vala_list_get (_tmp202_, _filename_index);
					filename = (gchar*) _tmp203_;
					_tmp204_ = filename;
					g_print ("%s\n", _tmp204_);
					_g_free0 (filename);
				}
				_vala_iterable_unref0 (_filename_list);
			}
		}
		result = 0;
		return result;
	}
	_tmp205_ = vala_parser_new ();
	parser = _tmp205_;
	_tmp206_ = parser;
	_tmp207_ = self->priv->context;
	vala_parser_parse (_tmp206_, _tmp207_);
	_tmp208_ = vala_genie_parser_new ();
	genie_parser = _tmp208_;
	_tmp209_ = genie_parser;
	_tmp210_ = self->priv->context;
	vala_genie_parser_parse (_tmp209_, _tmp210_);
	_tmp211_ = vala_gir_parser_new ();
	gir_parser = _tmp211_;
	_tmp212_ = gir_parser;
	_tmp213_ = self->priv->context;
	vala_gir_parser_parse (_tmp212_, _tmp213_);
	_tmp215_ = self->priv->context;
	_tmp216_ = vala_code_context_get_report (_tmp215_);
	_tmp217_ = _tmp216_;
	if (vala_report_get_errors (_tmp217_) > 0) {
		_tmp214_ = TRUE;
	} else {
		gboolean _tmp218_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp219_;
			ValaReport* _tmp220_;
			ValaReport* _tmp221_;
			_tmp219_ = self->priv->context;
			_tmp220_ = vala_code_context_get_report (_tmp219_);
			_tmp221_ = _tmp220_;
			_tmp218_ = vala_report_get_warnings (_tmp221_) > 0;
		} else {
			_tmp218_ = FALSE;
		}
		_tmp214_ = _tmp218_;
	}
	if (_tmp214_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp222_ = vala_compiler_fast_vapi_filename;
	if (_tmp222_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp223_;
		ValaCodeWriter* _tmp224_;
		ValaCodeContext* _tmp225_;
		const gchar* _tmp226_;
		_tmp223_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_FAST);
		interface_writer = _tmp223_;
		_tmp224_ = interface_writer;
		_tmp225_ = self->priv->context;
		_tmp226_ = vala_compiler_fast_vapi_filename;
		vala_code_writer_write_file (_tmp224_, _tmp225_, _tmp226_);
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (interface_writer);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp227_ = self->priv->context;
	vala_code_context_check (_tmp227_);
	_tmp229_ = self->priv->context;
	_tmp230_ = vala_code_context_get_report (_tmp229_);
	_tmp231_ = _tmp230_;
	if (vala_report_get_errors (_tmp231_) > 0) {
		_tmp228_ = TRUE;
	} else {
		gboolean _tmp232_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp233_;
			ValaReport* _tmp234_;
			ValaReport* _tmp235_;
			_tmp233_ = self->priv->context;
			_tmp234_ = vala_code_context_get_report (_tmp233_);
			_tmp235_ = _tmp234_;
			_tmp232_ = vala_report_get_warnings (_tmp235_) > 0;
		} else {
			_tmp232_ = FALSE;
		}
		_tmp228_ = _tmp232_;
	}
	if (_tmp228_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		_tmp237_ = !vala_compiler_compile_only;
	} else {
		_tmp237_ = FALSE;
	}
	if (_tmp237_) {
		const gchar* _tmp238_;
		_tmp238_ = vala_compiler_library;
		_tmp236_ = _tmp238_ == NULL;
	} else {
		_tmp236_ = FALSE;
	}
	if (_tmp236_) {
		gboolean _tmp239_ = FALSE;
		if (!has_c_files) {
			ValaCodeContext* _tmp240_;
			ValaMethod* _tmp241_;
			ValaMethod* _tmp242_;
			_tmp240_ = self->priv->context;
			_tmp241_ = vala_code_context_get_entry_point (_tmp240_);
			_tmp242_ = _tmp241_;
			_tmp239_ = _tmp242_ == NULL;
		} else {
			_tmp239_ = FALSE;
		}
		if (_tmp239_) {
			vala_report_error (NULL, "program does not contain a static `main' method");
		}
	}
	_tmp243_ = vala_compiler_dump_tree;
	if (_tmp243_ != NULL) {
		ValaCodeWriter* code_writer = NULL;
		ValaCodeWriter* _tmp244_;
		ValaCodeWriter* _tmp245_;
		ValaCodeContext* _tmp246_;
		const gchar* _tmp247_;
		_tmp244_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_DUMP);
		code_writer = _tmp244_;
		_tmp245_ = code_writer;
		_tmp246_ = self->priv->context;
		_tmp247_ = vala_compiler_dump_tree;
		vala_code_writer_write_file (_tmp245_, _tmp246_, _tmp247_);
		_vala_code_visitor_unref0 (code_writer);
	}
	_tmp249_ = self->priv->context;
	_tmp250_ = vala_code_context_get_report (_tmp249_);
	_tmp251_ = _tmp250_;
	if (vala_report_get_errors (_tmp251_) > 0) {
		_tmp248_ = TRUE;
	} else {
		gboolean _tmp252_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp253_;
			ValaReport* _tmp254_;
			ValaReport* _tmp255_;
			_tmp253_ = self->priv->context;
			_tmp254_ = vala_code_context_get_report (_tmp253_);
			_tmp255_ = _tmp254_;
			_tmp252_ = vala_report_get_warnings (_tmp255_) > 0;
		} else {
			_tmp252_ = FALSE;
		}
		_tmp248_ = _tmp252_;
	}
	if (_tmp248_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp256_ = self->priv->context;
	_tmp257_ = vala_code_context_get_codegen (_tmp256_);
	_tmp258_ = _tmp257_;
	_tmp259_ = self->priv->context;
	vala_code_generator_emit (_tmp258_, _tmp259_);
	_tmp261_ = self->priv->context;
	_tmp262_ = vala_code_context_get_report (_tmp261_);
	_tmp263_ = _tmp262_;
	if (vala_report_get_errors (_tmp263_) > 0) {
		_tmp260_ = TRUE;
	} else {
		gboolean _tmp264_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp265_;
			ValaReport* _tmp266_;
			ValaReport* _tmp267_;
			_tmp265_ = self->priv->context;
			_tmp266_ = vala_code_context_get_report (_tmp265_);
			_tmp267_ = _tmp266_;
			_tmp264_ = vala_report_get_warnings (_tmp267_) > 0;
		} else {
			_tmp264_ = FALSE;
		}
		_tmp260_ = _tmp264_;
	}
	if (_tmp260_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	_tmp269_ = vala_compiler_vapi_filename;
	if (_tmp269_ == NULL) {
		const gchar* _tmp270_;
		_tmp270_ = vala_compiler_library;
		_tmp268_ = _tmp270_ != NULL;
	} else {
		_tmp268_ = FALSE;
	}
	if (_tmp268_) {
		const gchar* _tmp271_;
		gchar* _tmp272_;
		_tmp271_ = vala_compiler_library;
		_tmp272_ = g_strdup_printf ("%s.vapi", _tmp271_);
		_g_free0 (vala_compiler_vapi_filename);
		vala_compiler_vapi_filename = _tmp272_;
	}
	_tmp273_ = vala_compiler_library;
	if (_tmp273_ != NULL) {
		const gchar* _tmp274_;
		_tmp274_ = vala_compiler_gir;
		if (_tmp274_ != NULL) {
			ValaCodeContext* _tmp275_;
			ValaProfile _tmp276_;
			ValaProfile _tmp277_;
			_tmp275_ = self->priv->context;
			_tmp276_ = vala_code_context_get_profile (_tmp275_);
			_tmp277_ = _tmp276_;
			if (_tmp277_ == VALA_PROFILE_GOBJECT) {
				gchar* gir_base = NULL;
				const gchar* _tmp278_;
				gchar* _tmp279_;
				glong gir_len = 0L;
				const gchar* _tmp280_;
				gint _tmp281_;
				gint _tmp282_;
				gint last_hyphen = 0;
				const gchar* _tmp283_;
				gboolean _tmp284_ = FALSE;
				_tmp278_ = vala_compiler_gir;
				_tmp279_ = g_path_get_basename (_tmp278_);
				gir_base = _tmp279_;
				_tmp280_ = gir_base;
				_tmp281_ = strlen (_tmp280_);
				_tmp282_ = _tmp281_;
				gir_len = (glong) _tmp282_;
				_tmp283_ = gir_base;
				last_hyphen = string_last_index_of_char (_tmp283_, (gunichar) '-', 0);
				if (last_hyphen == -1) {
					_tmp284_ = TRUE;
				} else {
					const gchar* _tmp285_;
					_tmp285_ = gir_base;
					_tmp284_ = !g_str_has_suffix (_tmp285_, ".gir");
				}
				if (_tmp284_) {
					const gchar* _tmp286_;
					gchar* _tmp287_;
					gchar* _tmp288_;
					_tmp286_ = vala_compiler_gir;
					_tmp287_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp286_);
					_tmp288_ = _tmp287_;
					vala_report_error (NULL, _tmp288_);
					_g_free0 (_tmp288_);
				} else {
					gchar* gir_namespace = NULL;
					const gchar* _tmp289_;
					gchar* _tmp290_;
					gchar* gir_version = NULL;
					const gchar* _tmp291_;
					gchar* _tmp292_;
					const gchar* _tmp293_;
					gboolean _tmp294_ = FALSE;
					gboolean _tmp295_ = FALSE;
					gboolean _tmp296_ = FALSE;
					const gchar* _tmp297_;
					_tmp289_ = gir_base;
					_tmp290_ = string_substring (_tmp289_, (glong) 0, (glong) last_hyphen);
					gir_namespace = _tmp290_;
					_tmp291_ = gir_base;
					_tmp292_ = string_substring (_tmp291_, (glong) (last_hyphen + 1), (gir_len - last_hyphen) - 5);
					gir_version = _tmp292_;
					_tmp293_ = gir_version;
					g_strcanon (_tmp293_, "0123456789.", '?');
					_tmp297_ = gir_namespace;
					if (g_strcmp0 (_tmp297_, "") == 0) {
						_tmp296_ = TRUE;
					} else {
						const gchar* _tmp298_;
						_tmp298_ = gir_version;
						_tmp296_ = g_strcmp0 (_tmp298_, "") == 0;
					}
					if (_tmp296_) {
						_tmp295_ = TRUE;
					} else {
						const gchar* _tmp299_;
						_tmp299_ = gir_version;
						_tmp295_ = !g_ascii_isdigit (string_get (_tmp299_, (glong) 0));
					}
					if (_tmp295_) {
						_tmp294_ = TRUE;
					} else {
						const gchar* _tmp300_;
						_tmp300_ = gir_version;
						_tmp294_ = string_contains (_tmp300_, "?");
					}
					if (_tmp294_) {
						const gchar* _tmp301_;
						gchar* _tmp302_;
						gchar* _tmp303_;
						_tmp301_ = vala_compiler_gir;
						_tmp302_ = g_strdup_printf ("GIR file name `%s' is not well-formed, expected NAME-VERSION.gir", _tmp301_);
						_tmp303_ = _tmp302_;
						vala_report_error (NULL, _tmp303_);
						_g_free0 (_tmp303_);
					} else {
						ValaGIRWriter* gir_writer = NULL;
						ValaGIRWriter* _tmp304_;
						gchar* gir_directory = NULL;
						gchar* _tmp305_;
						const gchar* _tmp306_;
						ValaGIRWriter* _tmp311_;
						ValaCodeContext* _tmp312_;
						const gchar* _tmp313_;
						const gchar* _tmp314_;
						const gchar* _tmp315_;
						const gchar* _tmp316_;
						const gchar* _tmp317_;
						const gchar* _tmp318_;
						_tmp304_ = vala_gir_writer_new ();
						gir_writer = _tmp304_;
						_tmp305_ = g_strdup (".");
						gir_directory = _tmp305_;
						_tmp306_ = vala_compiler_directory;
						if (_tmp306_ != NULL) {
							ValaCodeContext* _tmp307_;
							const gchar* _tmp308_;
							const gchar* _tmp309_;
							gchar* _tmp310_;
							_tmp307_ = self->priv->context;
							_tmp308_ = vala_code_context_get_directory (_tmp307_);
							_tmp309_ = _tmp308_;
							_tmp310_ = g_strdup (_tmp309_);
							_g_free0 (gir_directory);
							gir_directory = _tmp310_;
						}
						_tmp311_ = gir_writer;
						_tmp312_ = self->priv->context;
						_tmp313_ = gir_directory;
						_tmp314_ = vala_compiler_gir;
						_tmp315_ = gir_namespace;
						_tmp316_ = gir_version;
						_tmp317_ = vala_compiler_library;
						_tmp318_ = vala_compiler_shared_library;
						vala_gir_writer_write_file (_tmp311_, _tmp312_, _tmp313_, _tmp314_, _tmp315_, _tmp316_, _tmp317_, _tmp318_);
						_g_free0 (gir_directory);
						_vala_code_visitor_unref0 (gir_writer);
					}
					_g_free0 (gir_version);
					_g_free0 (gir_namespace);
				}
				_g_free0 (gir_base);
			}
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
		_g_free0 (vala_compiler_library);
		vala_compiler_library = NULL;
	} else {
		const gchar* _tmp319_;
		_tmp319_ = vala_compiler_gir;
		if (_tmp319_ != NULL) {
			vala_report_warning (NULL, "--gir has no effect without --library");
			_g_free0 (vala_compiler_gir);
			vala_compiler_gir = NULL;
		}
	}
	_tmp320_ = vala_compiler_vapi_filename;
	if (_tmp320_ != NULL) {
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp321_;
		gboolean _tmp322_ = FALSE;
		const gchar* _tmp323_;
		ValaCodeWriter* _tmp330_;
		ValaCodeContext* _tmp331_;
		const gchar* _tmp332_;
		_tmp321_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_EXTERNAL);
		interface_writer = _tmp321_;
		_tmp323_ = vala_compiler_directory;
		if (_tmp323_ != NULL) {
			const gchar* _tmp324_;
			_tmp324_ = vala_compiler_vapi_filename;
			_tmp322_ = !g_path_is_absolute (_tmp324_);
		} else {
			_tmp322_ = FALSE;
		}
		if (_tmp322_) {
			ValaCodeContext* _tmp325_;
			const gchar* _tmp326_;
			const gchar* _tmp327_;
			const gchar* _tmp328_;
			gchar* _tmp329_;
			_tmp325_ = self->priv->context;
			_tmp326_ = vala_code_context_get_directory (_tmp325_);
			_tmp327_ = _tmp326_;
			_tmp328_ = vala_compiler_vapi_filename;
			_tmp329_ = g_strdup_printf ("%s%c%s", _tmp327_, (gint) G_DIR_SEPARATOR, _tmp328_);
			_g_free0 (vala_compiler_vapi_filename);
			vala_compiler_vapi_filename = _tmp329_;
		}
		_tmp330_ = interface_writer;
		_tmp331_ = self->priv->context;
		_tmp332_ = vala_compiler_vapi_filename;
		vala_code_writer_write_file (_tmp330_, _tmp331_, _tmp332_);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp333_ = vala_compiler_internal_vapi_filename;
	if (_tmp333_ != NULL) {
		gboolean _tmp334_ = FALSE;
		const gchar* _tmp335_;
		ValaCodeWriter* interface_writer = NULL;
		ValaCodeWriter* _tmp337_;
		ValaCodeContext* _tmp338_;
		const gchar* _tmp339_;
		const gchar* _tmp340_;
		gchar* vapi_filename = NULL;
		const gchar* _tmp363_;
		gchar* _tmp364_;
		gboolean _tmp365_ = FALSE;
		const gchar* _tmp366_;
		ValaCodeWriter* _tmp373_;
		ValaCodeContext* _tmp374_;
		const gchar* _tmp375_;
		_tmp335_ = vala_compiler_internal_header_filename;
		if (_tmp335_ == NULL) {
			_tmp334_ = TRUE;
		} else {
			const gchar* _tmp336_;
			_tmp336_ = vala_compiler_header_filename;
			_tmp334_ = _tmp336_ == NULL;
		}
		if (_tmp334_) {
			vala_report_error (NULL, "--internal-vapi may only be used in combination with --header and --in" \
"ternal-header");
			result = vala_compiler_quit (self);
			_vala_code_visitor_unref0 (gir_parser);
			_vala_code_visitor_unref0 (genie_parser);
			_vala_code_visitor_unref0 (parser);
			return result;
		}
		_tmp337_ = vala_code_writer_new (VALA_CODE_WRITER_TYPE_INTERNAL);
		interface_writer = _tmp337_;
		_tmp338_ = self->priv->context;
		_tmp339_ = vala_code_context_get_includedir (_tmp338_);
		_tmp340_ = _tmp339_;
		if (_tmp340_ != NULL) {
			gchar* prefixed_header_filename = NULL;
			ValaCodeContext* _tmp341_;
			const gchar* _tmp342_;
			const gchar* _tmp343_;
			const gchar* _tmp344_;
			gchar* _tmp345_;
			gchar* _tmp346_;
			gchar* _tmp347_;
			gchar* _tmp348_;
			gchar* prefixed_internal_header_filename = NULL;
			ValaCodeContext* _tmp349_;
			const gchar* _tmp350_;
			const gchar* _tmp351_;
			const gchar* _tmp352_;
			gchar* _tmp353_;
			gchar* _tmp354_;
			gchar* _tmp355_;
			gchar* _tmp356_;
			ValaCodeWriter* _tmp357_;
			const gchar* _tmp358_;
			const gchar* _tmp359_;
			_tmp341_ = self->priv->context;
			_tmp342_ = vala_code_context_get_includedir (_tmp341_);
			_tmp343_ = _tmp342_;
			_tmp344_ = vala_compiler_header_filename;
			_tmp345_ = g_path_get_basename (_tmp344_);
			_tmp346_ = _tmp345_;
			_tmp347_ = g_build_path ("/", _tmp343_, _tmp346_, NULL);
			_tmp348_ = _tmp347_;
			_g_free0 (_tmp346_);
			prefixed_header_filename = _tmp348_;
			_tmp349_ = self->priv->context;
			_tmp350_ = vala_code_context_get_includedir (_tmp349_);
			_tmp351_ = _tmp350_;
			_tmp352_ = vala_compiler_internal_header_filename;
			_tmp353_ = g_path_get_basename (_tmp352_);
			_tmp354_ = _tmp353_;
			_tmp355_ = g_build_path ("/", _tmp351_, _tmp354_, NULL);
			_tmp356_ = _tmp355_;
			_g_free0 (_tmp354_);
			prefixed_internal_header_filename = _tmp356_;
			_tmp357_ = interface_writer;
			_tmp358_ = prefixed_header_filename;
			_tmp359_ = prefixed_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp357_, _tmp358_, _tmp359_);
			_g_free0 (prefixed_internal_header_filename);
			_g_free0 (prefixed_header_filename);
		} else {
			ValaCodeWriter* _tmp360_;
			const gchar* _tmp361_;
			const gchar* _tmp362_;
			_tmp360_ = interface_writer;
			_tmp361_ = vala_compiler_header_filename;
			_tmp362_ = vala_compiler_internal_header_filename;
			vala_code_writer_set_cheader_override (_tmp360_, _tmp361_, _tmp362_);
		}
		_tmp363_ = vala_compiler_internal_vapi_filename;
		_tmp364_ = g_strdup (_tmp363_);
		vapi_filename = _tmp364_;
		_tmp366_ = vala_compiler_directory;
		if (_tmp366_ != NULL) {
			const gchar* _tmp367_;
			_tmp367_ = vapi_filename;
			_tmp365_ = !g_path_is_absolute (_tmp367_);
		} else {
			_tmp365_ = FALSE;
		}
		if (_tmp365_) {
			ValaCodeContext* _tmp368_;
			const gchar* _tmp369_;
			const gchar* _tmp370_;
			const gchar* _tmp371_;
			gchar* _tmp372_;
			_tmp368_ = self->priv->context;
			_tmp369_ = vala_code_context_get_directory (_tmp368_);
			_tmp370_ = _tmp369_;
			_tmp371_ = vapi_filename;
			_tmp372_ = g_strdup_printf ("%s%c%s", _tmp370_, (gint) G_DIR_SEPARATOR, _tmp371_);
			_g_free0 (vapi_filename);
			vapi_filename = _tmp372_;
		}
		_tmp373_ = interface_writer;
		_tmp374_ = self->priv->context;
		_tmp375_ = vapi_filename;
		vala_code_writer_write_file (_tmp373_, _tmp374_, _tmp375_);
		_g_free0 (vala_compiler_internal_vapi_filename);
		vala_compiler_internal_vapi_filename = NULL;
		_g_free0 (vapi_filename);
		_vala_code_visitor_unref0 (interface_writer);
	}
	_tmp376_ = vala_compiler_dependencies;
	if (_tmp376_ != NULL) {
		ValaCodeContext* _tmp377_;
		const gchar* _tmp378_;
		_tmp377_ = self->priv->context;
		_tmp378_ = vala_compiler_dependencies;
		vala_code_context_write_dependencies (_tmp377_, _tmp378_);
	}
	_tmp379_ = vala_compiler_depfile;
	if (_tmp379_ != NULL) {
		ValaCodeContext* _tmp380_;
		const gchar* _tmp381_;
		_tmp380_ = self->priv->context;
		_tmp381_ = vala_compiler_depfile;
		vala_code_context_write_external_dependencies (_tmp380_, _tmp381_);
	}
	_tmp383_ = self->priv->context;
	_tmp384_ = vala_code_context_get_report (_tmp383_);
	_tmp385_ = _tmp384_;
	if (vala_report_get_errors (_tmp385_) > 0) {
		_tmp382_ = TRUE;
	} else {
		gboolean _tmp386_ = FALSE;
		if (vala_compiler_fatal_warnings) {
			ValaCodeContext* _tmp387_;
			ValaReport* _tmp388_;
			ValaReport* _tmp389_;
			_tmp387_ = self->priv->context;
			_tmp388_ = vala_code_context_get_report (_tmp387_);
			_tmp389_ = _tmp388_;
			_tmp386_ = vala_report_get_warnings (_tmp389_) > 0;
		} else {
			_tmp386_ = FALSE;
		}
		_tmp382_ = _tmp386_;
	}
	if (_tmp382_) {
		result = vala_compiler_quit (self);
		_vala_code_visitor_unref0 (gir_parser);
		_vala_code_visitor_unref0 (genie_parser);
		_vala_code_visitor_unref0 (parser);
		return result;
	}
	if (!vala_compiler_ccode_only) {
		ValaCCodeCompiler* ccompiler = NULL;
		ValaCCodeCompiler* _tmp390_;
		gboolean _tmp391_ = FALSE;
		const gchar* _tmp392_;
		gchar** _tmp396_;
		gint _tmp396__length1;
		_tmp390_ = vala_ccode_compiler_new ();
		ccompiler = _tmp390_;
		_tmp392_ = vala_compiler_cc_command;
		if (_tmp392_ == NULL) {
			const gchar* _tmp393_;
			_tmp393_ = g_getenv ("CC");
			_tmp391_ = _tmp393_ != NULL;
		} else {
			_tmp391_ = FALSE;
		}
		if (_tmp391_) {
			const gchar* _tmp394_;
			gchar* _tmp395_;
			_tmp394_ = g_getenv ("CC");
			_tmp395_ = g_strdup (_tmp394_);
			_g_free0 (vala_compiler_cc_command);
			vala_compiler_cc_command = _tmp395_;
		}
		_tmp396_ = vala_compiler_cc_options;
		_tmp396__length1 = _vala_array_length (vala_compiler_cc_options);
		if (_tmp396_ == NULL) {
			ValaCCodeCompiler* _tmp397_;
			ValaCodeContext* _tmp398_;
			const gchar* _tmp399_;
			gchar** _tmp400_;
			gchar** _tmp401_;
			gint _tmp401__length1;
			_tmp397_ = ccompiler;
			_tmp398_ = self->priv->context;
			_tmp399_ = vala_compiler_cc_command;
			_tmp400_ = g_new0 (gchar*, 0 + 1);
			_tmp401_ = _tmp400_;
			_tmp401__length1 = 0;
			vala_ccode_compiler_compile (_tmp397_, _tmp398_, _tmp399_, _tmp401_, (gint) 0);
			_tmp401_ = (_vala_array_free (_tmp401_, _tmp401__length1, (GDestroyNotify) g_free), NULL);
		} else {
			ValaCCodeCompiler* _tmp402_;
			ValaCodeContext* _tmp403_;
			const gchar* _tmp404_;
			gchar** _tmp405_;
			gint _tmp405__length1;
			_tmp402_ = ccompiler;
			_tmp403_ = self->priv->context;
			_tmp404_ = vala_compiler_cc_command;
			_tmp405_ = vala_compiler_cc_options;
			_tmp405__length1 = _vala_array_length (vala_compiler_cc_options);
			vala_ccode_compiler_compile (_tmp402_, _tmp403_, _tmp404_, _tmp405_, (gint) _tmp405__length1);
		}
		_vala_ccode_compiler_unref0 (ccompiler);
	}
	result = vala_compiler_quit (self);
	_vala_code_visitor_unref0 (gir_parser);
	_vala_code_visitor_unref0 (genie_parser);
	_vala_code_visitor_unref0 (parser);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->loop);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
___lambda4_ (Block1Data* _data1_,
             GPid pid,
             gint status)
{
	GMainLoop* _tmp0_;
	_data1_->child_status = (status & 0xff00) >> 8;
	_tmp0_ = _data1_->loop;
	g_main_loop_quit (_tmp0_);
}

static void
____lambda4__gchild_watch_func (GPid pid,
                                gint status,
                                gpointer self)
{
	___lambda4_ (self, pid, status);
}

static gint
vala_compiler_run_source (gchar** args,
                          gint args_length1)
{
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint outputfd = 0;
	const gchar* _tmp21_;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp22_;
	gint ret = 0;
	ValaCompiler* _tmp23_;
	const gchar* _tmp24_;
	gchar** target_args = NULL;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar** _tmp28_;
	gint target_args_length1;
	gint _target_args_size_;
	const gchar* _tmp29_;
	gint _tmp46_ = -1;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new ("- Vala Interpreter");
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, VALA_COMPILER_options, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		FILE* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stdout;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		_tmp8_ = stdout;
		_tmp9_ = args[0];
		fprintf (_tmp8_, "Run '%s --help' to see a full list of available command line options.\n", _tmp9_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp10_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	if (vala_compiler_version) {
		FILE* _tmp11_;
		_tmp11_ = stdout;
		fprintf (_tmp11_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp12_;
			_tmp12_ = stdout;
			fprintf (_tmp12_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp13_ = vala_compiler_sources;
	_tmp13__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp13_ == NULL) {
		FILE* _tmp14_;
		_tmp14_ = stderr;
		fprintf (_tmp14_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp15_ = g_get_tmp_dir ();
	_tmp16_ = vala_compiler_sources;
	_tmp16__length1 = _vala_array_length (vala_compiler_sources);
	_tmp17_ = _tmp16_[0];
	_tmp18_ = g_path_get_basename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s/%s.XXXXXX", _tmp15_, _tmp19_);
	_g_free0 (vala_compiler_output);
	vala_compiler_output = _tmp20_;
	_g_free0 (_tmp19_);
	_tmp21_ = vala_compiler_output;
	outputfd = g_mkstemp (_tmp21_);
	if (outputfd < 0) {
		result = 1;
		return result;
	}
	vala_compiler_ccode_only = FALSE;
	vala_compiler_compile_only = FALSE;
	vala_compiler_run_output = TRUE;
	vala_compiler_disable_warnings = TRUE;
	vala_compiler_quiet_mode = TRUE;
	_g_free0 (vala_compiler_library);
	vala_compiler_library = NULL;
	_g_free0 (vala_compiler_shared_library);
	vala_compiler_shared_library = NULL;
	_tmp22_ = vala_compiler_new ();
	compiler = _tmp22_;
	_tmp23_ = compiler;
	ret = vala_compiler_run (_tmp23_);
	if (ret != 0) {
		result = ret;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	close (outputfd);
	_tmp24_ = vala_compiler_output;
	if (g_chmod (_tmp24_, 0700) != 0) {
		const gchar* _tmp25_;
		_tmp25_ = vala_compiler_output;
		g_unlink (_tmp25_);
		result = 1;
		_vala_compiler_unref0 (compiler);
		return result;
	}
	_tmp26_ = vala_compiler_output;
	_tmp27_ = g_strdup (_tmp26_);
	_tmp28_ = g_new0 (gchar*, 1 + 1);
	_tmp28_[0] = _tmp27_;
	target_args = _tmp28_;
	target_args_length1 = 1;
	_target_args_size_ = target_args_length1;
	_tmp29_ = vala_compiler_run_args;
	if (_tmp29_ != NULL) {
		gchar** target_run_args = NULL;
		const gchar* _tmp30_;
		gchar** _tmp31_;
		gchar** _tmp32_;
		gint target_run_args_length1;
		gint _target_run_args_size_;
		gchar** _tmp33_;
		gint _tmp33__length1;
		_tmp30_ = vala_compiler_run_args;
		_tmp32_ = _tmp31_ = g_strsplit (_tmp30_, " ", 0);
		target_run_args = _tmp32_;
		target_run_args_length1 = _vala_array_length (_tmp31_);
		_target_run_args_size_ = target_run_args_length1;
		_tmp33_ = target_run_args;
		_tmp33__length1 = target_run_args_length1;
		{
			gchar** arg_collection = NULL;
			gint arg_collection_length1 = 0;
			gint _arg_collection_size_ = 0;
			gint arg_it = 0;
			arg_collection = _tmp33_;
			arg_collection_length1 = _tmp33__length1;
			for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
				gchar* _tmp34_;
				gchar* arg = NULL;
				_tmp34_ = g_strdup (arg_collection[arg_it]);
				arg = _tmp34_;
				{
					const gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp35_ = arg;
					_tmp36_ = g_strdup (_tmp35_);
					_vala_array_add1 (&target_args, &target_args_length1, &_target_args_size_, _tmp36_);
					_g_free0 (arg);
				}
			}
		}
		target_run_args = (_vala_array_free (target_run_args, target_run_args_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		Block1Data* _data1_;
		GPid pid = 0;
		GMainLoop* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		GPid _tmp39_ = 0;
		const gchar* _tmp41_;
		GMainLoop* _tmp42_;
		_data1_ = g_slice_new0 (Block1Data);
		_data1_->_ref_count_ = 1;
		_tmp37_ = g_main_loop_new (NULL, FALSE);
		_data1_->loop = _tmp37_;
		_data1_->child_status = 0;
		_tmp38_ = target_args;
		_tmp38__length1 = target_args_length1;
		g_spawn_async (NULL, _tmp38_, NULL, G_SPAWN_CHILD_INHERITS_STDIN | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp39_, &_inner_error0_);
		pid = _tmp39_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp40_ = -1;
			block1_data_unref (_data1_);
			_data1_ = NULL;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
			_vala_compiler_unref0 (compiler);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp40_;
		}
		_tmp41_ = vala_compiler_output;
		g_unlink (_tmp41_);
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, pid, ____lambda4__gchild_watch_func, block1_data_ref (_data1_), block1_data_unref);
		_tmp42_ = _data1_->loop;
		g_main_loop_run (_tmp42_);
		result = _data1_->child_status;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp43_;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = stdout;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		fprintf (_tmp43_, "%s\n", _tmp45_);
		result = 1;
		_g_error_free0 (e);
		target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
		_vala_compiler_unref0 (compiler);
		return result;
	}
	__finally1:
	target_args = (_vala_array_free (target_args, target_args_length1, (GDestroyNotify) g_free), NULL);
	_vala_compiler_unref0 (compiler);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp46_;
}

static gint
vala_compiler_main (gchar** args,
                    gint args_length1)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp21_ = FALSE;
	gchar** _tmp22_;
	gint _tmp22__length1;
	ValaCompiler* compiler = NULL;
	ValaCompiler* _tmp25_;
	ValaCompiler* _tmp26_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	setlocale (LC_ALL, "");
	_tmp1_ = args[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "vala") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = args[0];
		_tmp6_ = g_path_get_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = g_strcmp0 (_tmp7_, "vala" PACKAGE_SUFFIX) == 0;
		_g_free0 (_tmp7_);
	}
	if (_tmp0_) {
		result = vala_compiler_run_source (args, (gint) args_length1);
		return result;
	}
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp8_;
		GOptionContext* _tmp9_;
		GOptionContext* _tmp10_;
		GOptionContext* _tmp11_;
		_tmp8_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp8_;
		_tmp9_ = opt_context;
		g_option_context_set_help_enabled (_tmp9_, TRUE);
		_tmp10_ = opt_context;
		g_option_context_add_main_entries (_tmp10_, VALA_COMPILER_options, NULL);
		_tmp11_ = opt_context;
		g_option_context_parse (_tmp11_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp12_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp12_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		FILE* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = stdout;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		fprintf (_tmp13_, "%s\n", _tmp15_);
		_tmp16_ = stdout;
		_tmp17_ = args[0];
		fprintf (_tmp16_, "Run '%s --help' to see a full list of available command line options.\n", _tmp17_);
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp18_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp18_;
	}
	if (vala_compiler_version) {
		FILE* _tmp19_;
		_tmp19_ = stdout;
		fprintf (_tmp19_, "Vala %s\n", VALA_BUILD_VERSION);
		result = 0;
		return result;
	} else {
		if (vala_compiler_api_version) {
			FILE* _tmp20_;
			_tmp20_ = stdout;
			fprintf (_tmp20_, "%s\n", VALA_API_VERSION);
			result = 0;
			return result;
		}
	}
	_tmp22_ = vala_compiler_sources;
	_tmp22__length1 = _vala_array_length (vala_compiler_sources);
	if (_tmp22_ == NULL) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		_tmp23_ = vala_compiler_fast_vapis;
		_tmp23__length1 = _vala_array_length (vala_compiler_fast_vapis);
		_tmp21_ = _tmp23_ == NULL;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		FILE* _tmp24_;
		_tmp24_ = stderr;
		fprintf (_tmp24_, "No source file specified.\n");
		result = 1;
		return result;
	}
	_tmp25_ = vala_compiler_new ();
	compiler = _tmp25_;
	_tmp26_ = compiler;
	result = vala_compiler_run (_tmp26_);
	_vala_compiler_unref0 (compiler);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return vala_compiler_main (argv, argc);
}

G_GNUC_INTERNAL ValaCompiler*
vala_compiler_construct (GType object_type)
{
	ValaCompiler* self = NULL;
	self = (ValaCompiler*) g_type_create_instance (object_type);
	return self;
}

G_GNUC_INTERNAL ValaCompiler*
vala_compiler_new (void)
{
	return vala_compiler_construct (VALA_TYPE_COMPILER);
}

static void
vala_value_compiler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_value_compiler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_compiler_unref (value->data[0].v_pointer);
	}
}

static void
vala_value_compiler_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_compiler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_value_compiler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_value_compiler_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaCompiler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_compiler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_value_compiler_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	ValaCompiler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_compiler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

G_GNUC_INTERNAL GParamSpec*
vala_param_spec_compiler (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ValaParamSpecCompiler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_COMPILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

G_GNUC_INTERNAL gpointer
vala_value_get_compiler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER), NULL);
	return value->data[0].v_pointer;
}

G_GNUC_INTERNAL void
vala_value_set_compiler (GValue* value,
                         gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_compiler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

G_GNUC_INTERNAL void
vala_value_take_compiler (GValue* value,
                          gpointer v_object)
{
	ValaCompiler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_COMPILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_COMPILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_compiler_unref (old);
	}
}

static void
vala_compiler_class_init (ValaCompilerClass * klass,
                          gpointer klass_data)
{
	vala_compiler_parent_class = g_type_class_peek_parent (klass);
	((ValaCompilerClass *) klass)->finalize = vala_compiler_finalize;
	g_type_class_adjust_private_offset (klass, &ValaCompiler_private_offset);
}

static void
vala_compiler_instance_init (ValaCompiler * self,
                             gpointer klass)
{
	self->priv = vala_compiler_get_instance_private (self);
	self->ref_count = 1;
}

static void
vala_compiler_finalize (ValaCompiler * obj)
{
	ValaCompiler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_COMPILER, ValaCompiler);
	g_signal_handlers_destroy (self);
	_vala_code_context_unref0 (self->priv->context);
}

static GType
vala_compiler_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_value_compiler_init, vala_value_compiler_free_value, vala_value_compiler_copy_value, vala_value_compiler_peek_pointer, "p", vala_value_compiler_collect_value, "p", vala_value_compiler_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaCompilerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_compiler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCompiler), 0, (GInstanceInitFunc) vala_compiler_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_compiler_type_id;
	vala_compiler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCompiler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaCompiler_private_offset = g_type_add_instance_private (vala_compiler_type_id, sizeof (ValaCompilerPrivate));
	return vala_compiler_type_id;
}

G_GNUC_INTERNAL GType
vala_compiler_get_type (void)
{
	static volatile gsize vala_compiler_type_id__volatile = 0;
	if (g_once_init_enter (&vala_compiler_type_id__volatile)) {
		GType vala_compiler_type_id;
		vala_compiler_type_id = vala_compiler_get_type_once ();
		g_once_init_leave (&vala_compiler_type_id__volatile, vala_compiler_type_id);
	}
	return vala_compiler_type_id__volatile;
}

G_GNUC_INTERNAL gpointer
vala_compiler_ref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

G_GNUC_INTERNAL void
vala_compiler_unref (gpointer instance)
{
	ValaCompiler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_COMPILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

