/* valaelementaccess.c generated by valac, the Vala compiler
 * generated from valaelementaccess.vala, do not modify */

/* valaelementaccess.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaElementAccessPrivate {
	ValaList* indices;
	ValaExpression* _container;
};


static gpointer vala_element_access_parent_class = NULL;

#define VALA_ELEMENT_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessPrivate))
static void vala_element_access_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_element_access_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static gchar* vala_element_access_real_to_string (ValaCodeNode* base);
static void vala_element_access_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static gboolean vala_element_access_real_is_pure (ValaExpression* base);
static gboolean vala_element_access_real_is_accessible (ValaExpression* base,
                                                 ValaSymbol* sym);
static gboolean vala_element_access_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_element_access_real_emit (ValaCodeNode* base,
                                    ValaCodeGenerator* codegen);
static void vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_element_access_finalize (ValaCodeNode * obj);


void
vala_element_access_append_index (ValaElementAccess* self,
                                  ValaExpression* index)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (index != NULL);
	_tmp0_ = self->priv->indices;
	vala_collection_add ((ValaCollection*) _tmp0_, index);
	vala_code_node_set_parent_node ((ValaCodeNode*) index, (ValaCodeNode*) self);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_element_access_get_indices (ValaElementAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indices;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaElementAccess*
vala_element_access_construct (GType object_type,
                               ValaExpression* container,
                               ValaSourceReference* source_reference)
{
	ValaElementAccess* self = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaElementAccess*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_element_access_set_container (self, container);
	return self;
}


ValaElementAccess*
vala_element_access_new (ValaExpression* container,
                         ValaSourceReference* source_reference)
{
	return vala_element_access_construct (VALA_TYPE_ELEMENT_ACCESS, container, source_reference);
}


static void
vala_element_access_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_element_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_element_access_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* e = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _e_index;
			_e_index = _tmp7_ + 1;
			_tmp8_ = _e_index;
			_tmp9_ = _e_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _e_list;
			_tmp11_ = _e_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			e = (ValaExpression*) _tmp12_;
			_tmp13_ = e;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
}


static gchar*
vala_element_access_real_to_string (ValaCodeNode* base)
{
	ValaElementAccess * self;
	gchar* result = NULL;
	gchar* s = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean first = FALSE;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	self = (ValaElementAccess*) base;
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%s[", _tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	s = _tmp5_;
	first = TRUE;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _index_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _index_index = 0;
		_tmp6_ = self->priv->indices;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_index_list = _tmp7_;
		_tmp8_ = _index_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_index_size = _tmp10_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* index = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			gboolean _tmp17_;
			_tmp11_ = _index_index;
			_index_index = _tmp11_ + 1;
			_tmp12_ = _index_index;
			_tmp13_ = _index_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _index_list;
			_tmp15_ = _index_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			index = (ValaExpression*) _tmp16_;
			_tmp17_ = first;
			if (_tmp17_) {
				const gchar* _tmp18_;
				ValaExpression* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp18_ = s;
				_tmp19_ = index;
				_tmp20_ = vala_code_node_to_string ((ValaCodeNode*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
				_g_free0 (s);
				s = _tmp22_;
				_g_free0 (_tmp21_);
				first = FALSE;
			} else {
				const gchar* _tmp23_;
				ValaExpression* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp23_ = s;
				_tmp24_ = index;
				_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strdup_printf (", %s", _tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp23_, _tmp28_, NULL);
				_g_free0 (s);
				s = _tmp29_;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp30_ = s;
	_tmp31_ = g_strconcat (_tmp30_, "]", NULL);
	result = _tmp31_;
	_g_free0 (s);
	return result;
}


static void
vala_element_access_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	gint _tmp3_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_element_access_set_container (self, new_node);
	}
	_tmp2_ = self->priv->indices;
	index = vala_list_index_of (_tmp2_, old_node);
	_tmp3_ = index;
	if (_tmp3_ >= 0) {
		ValaList* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->indices;
		_tmp5_ = index;
		vala_list_set (_tmp4_, _tmp5_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean
vala_element_access_real_is_pure (ValaExpression* base)
{
	ValaElementAccess * self;
	gboolean result = FALSE;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	self = (ValaElementAccess*) base;
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _index_index;
			_index_index = _tmp5_ + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = _index_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			index = (ValaExpression*) _tmp10_;
			_tmp11_ = index;
			if (!vala_expression_is_pure (_tmp11_)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp12_ = vala_element_access_get_container (self);
	_tmp13_ = _tmp12_;
	result = vala_expression_is_pure (_tmp13_);
	return result;
}


static gboolean
vala_element_access_real_is_accessible (ValaExpression* base,
                                        ValaSymbol* sym)
{
	ValaElementAccess * self;
	gboolean result = FALSE;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _index_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _index_index = 0;
		_tmp0_ = self->priv->indices;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_index_list = _tmp1_;
		_tmp2_ = _index_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_index_size = _tmp4_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* index = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _index_index;
			_index_index = _tmp5_ + 1;
			_tmp6_ = _index_index;
			_tmp7_ = _index_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _index_list;
			_tmp9_ = _index_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			index = (ValaExpression*) _tmp10_;
			_tmp11_ = index;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (index);
				_vala_iterable_unref0 (_index_list);
				return result;
			}
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	_tmp12_ = vala_element_access_get_container (self);
	_tmp13_ = _tmp12_;
	result = vala_expression_is_accessible (_tmp13_, sym);
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_element_access_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaElementAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	gboolean _tmp14_ = FALSE;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	gboolean index_int_type_check = FALSE;
	ValaPointerType* pointer_type = NULL;
	ValaExpression* _tmp48_;
	ValaExpression* _tmp49_;
	ValaDataType* _tmp50_;
	ValaDataType* _tmp51_;
	ValaPointerType* _tmp52_;
	ValaExpression* _tmp53_;
	ValaExpression* _tmp54_;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	gboolean _tmp248_;
	gboolean _tmp272_;
	gboolean _tmp273_;
	self = (ValaElementAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_element_access_get_container (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp6_ = vala_element_access_get_container (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSourceReference* _tmp13_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp10_ = vala_element_access_get_container (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp13_, "Invalid container expression");
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_element_access_get_container (self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp17_ = vala_element_access_get_container (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_expression_get_symbol_reference (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp14_ = VALA_IS_SIGNAL (_tmp20_);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaList* _tmp21_;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gboolean _tmp25_;
		ValaList* _tmp28_;
		ValaList* _tmp29_;
		gpointer _tmp30_;
		ValaExpression* _tmp31_;
		ValaSemanticAnalyzer* _tmp32_;
		ValaSemanticAnalyzer* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		_tmp21_ = vala_element_access_get_indices (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_ != 1;
		_vala_iterable_unref0 (_tmp22_);
		if (_tmp25_) {
			ValaSourceReference* _tmp26_;
			ValaSourceReference* _tmp27_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp27_ = _tmp26_;
			vala_report_error (_tmp27_, "Element access with more than one dimension is not supported for signa" \
"ls");
			result = FALSE;
			return result;
		}
		_tmp28_ = vala_element_access_get_indices (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_list_get (_tmp29_, 0);
		_tmp31_ = (ValaExpression*) _tmp30_;
		_tmp32_ = vala_code_context_get_analyzer (context);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_->string_type;
		_tmp35_ = vala_data_type_copy (_tmp34_);
		_tmp36_ = _tmp35_;
		vala_expression_set_target_type (_tmp31_, _tmp36_);
		_vala_code_node_unref0 (_tmp36_);
		_vala_code_node_unref0 (_tmp31_);
		_vala_iterable_unref0 (_tmp29_);
	}
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp37_;
		gint _index_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _index_index = 0;
		_tmp37_ = vala_element_access_get_indices (self);
		_index_list = _tmp37_;
		_tmp38_ = _index_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_index_size = _tmp40_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			ValaExpression* index = NULL;
			ValaList* _tmp44_;
			gint _tmp45_;
			gpointer _tmp46_;
			ValaExpression* _tmp47_;
			_tmp41_ = _index_index;
			_index_index = _tmp41_ + 1;
			_tmp42_ = _index_index;
			_tmp43_ = _index_size;
			if (!(_tmp42_ < _tmp43_)) {
				break;
			}
			_tmp44_ = _index_list;
			_tmp45_ = _index_index;
			_tmp46_ = vala_list_get (_tmp44_, _tmp45_);
			index = (ValaExpression*) _tmp46_;
			_tmp47_ = index;
			vala_code_node_check ((ValaCodeNode*) _tmp47_, context);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
	index_int_type_check = TRUE;
	_tmp48_ = vala_element_access_get_container (self);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_expression_get_value_type (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp51_) ? ((ValaPointerType*) _tmp51_) : NULL);
	pointer_type = _tmp52_;
	_tmp53_ = vala_element_access_get_container (self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_expression_get_value_type (_tmp54_);
	_tmp56_ = _tmp55_;
	if (VALA_IS_ARRAY_TYPE (_tmp56_)) {
		ValaArrayType* array_type = NULL;
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaDataType* _tmp59_;
		ValaDataType* _tmp60_;
		ValaArrayType* _tmp61_;
		ValaArrayType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		gboolean _tmp67_;
		gboolean _tmp68_;
		ValaArrayType* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		ValaList* _tmp119_;
		ValaList* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		gboolean _tmp123_;
		_tmp57_ = vala_element_access_get_container (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_expression_get_value_type (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp61_;
		_tmp62_ = array_type;
		_tmp63_ = vala_array_type_get_element_type (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_data_type_copy (_tmp64_);
		_tmp66_ = _tmp65_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp66_);
		_vala_code_node_unref0 (_tmp66_);
		_tmp67_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp68_ = _tmp67_;
		if (!_tmp68_) {
			ValaDataType* _tmp69_;
			ValaDataType* _tmp70_;
			_tmp69_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp70_ = _tmp69_;
			vala_data_type_set_value_owned (_tmp70_, FALSE);
		} else {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp71_;
			ValaExpression* _tmp72_;
			ValaMemberAccess* _tmp73_;
			gboolean _tmp74_ = FALSE;
			ValaMemberAccess* _tmp75_;
			_tmp71_ = vala_element_access_get_container (self);
			_tmp72_ = _tmp71_;
			_tmp73_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp72_) ? ((ValaMemberAccess*) _tmp72_) : NULL);
			ma = _tmp73_;
			_tmp75_ = ma;
			if (_tmp75_ != NULL) {
				ValaMemberAccess* _tmp76_;
				ValaSymbol* _tmp77_;
				ValaSymbol* _tmp78_;
				_tmp76_ = ma;
				_tmp77_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp76_);
				_tmp78_ = _tmp77_;
				_tmp74_ = VALA_IS_ARRAY_LENGTH_FIELD (_tmp78_);
			} else {
				_tmp74_ = FALSE;
			}
			if (_tmp74_) {
				ValaMemberAccess* _tmp79_;
				ValaExpression* _tmp80_;
				ValaExpression* _tmp81_;
				ValaMemberAccess* _tmp82_;
				ValaExpression* _tmp83_;
				ValaExpression* _tmp84_;
				_tmp79_ = ma;
				_tmp80_ = vala_member_access_get_inner (_tmp79_);
				_tmp81_ = _tmp80_;
				vala_expression_set_lvalue (_tmp81_, TRUE);
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_inner (_tmp82_);
				_tmp84_ = _tmp83_;
				vala_member_access_check_lvalue_access (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			} else {
				gboolean _tmp85_ = FALSE;
				gboolean _tmp86_ = FALSE;
				gboolean _tmp87_ = FALSE;
				gboolean _tmp88_ = FALSE;
				gboolean _tmp89_ = FALSE;
				ValaMemberAccess* _tmp90_;
				_tmp90_ = ma;
				if (_tmp90_ != NULL) {
					ValaMemberAccess* _tmp91_;
					ValaSymbol* _tmp92_;
					ValaSymbol* _tmp93_;
					_tmp91_ = ma;
					_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp91_);
					_tmp93_ = _tmp92_;
					_tmp89_ = VALA_IS_FIELD (_tmp93_);
				} else {
					_tmp89_ = FALSE;
				}
				if (_tmp89_) {
					ValaMemberAccess* _tmp94_;
					ValaExpression* _tmp95_;
					ValaExpression* _tmp96_;
					_tmp94_ = ma;
					_tmp95_ = vala_member_access_get_inner (_tmp94_);
					_tmp96_ = _tmp95_;
					_tmp88_ = _tmp96_ != NULL;
				} else {
					_tmp88_ = FALSE;
				}
				if (_tmp88_) {
					ValaMemberAccess* _tmp97_;
					ValaExpression* _tmp98_;
					ValaExpression* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					_tmp97_ = ma;
					_tmp98_ = vala_member_access_get_inner (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = vala_expression_get_symbol_reference (_tmp99_);
					_tmp101_ = _tmp100_;
					_tmp87_ = VALA_IS_VARIABLE (_tmp101_);
				} else {
					_tmp87_ = FALSE;
				}
				if (_tmp87_) {
					ValaMemberAccess* _tmp102_;
					ValaExpression* _tmp103_;
					ValaExpression* _tmp104_;
					ValaDataType* _tmp105_;
					ValaDataType* _tmp106_;
					_tmp102_ = ma;
					_tmp103_ = vala_member_access_get_inner (_tmp102_);
					_tmp104_ = _tmp103_;
					_tmp105_ = vala_expression_get_value_type (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp86_ = VALA_IS_STRUCT_VALUE_TYPE (_tmp106_);
				} else {
					_tmp86_ = FALSE;
				}
				if (_tmp86_) {
					ValaMemberAccess* _tmp107_;
					ValaExpression* _tmp108_;
					ValaExpression* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					gboolean _tmp112_;
					gboolean _tmp113_;
					_tmp107_ = ma;
					_tmp108_ = vala_member_access_get_inner (_tmp107_);
					_tmp109_ = _tmp108_;
					_tmp110_ = vala_expression_get_value_type (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = vala_data_type_get_nullable (_tmp111_);
					_tmp113_ = _tmp112_;
					_tmp85_ = !_tmp113_;
				} else {
					_tmp85_ = FALSE;
				}
				if (_tmp85_) {
					ValaMemberAccess* _tmp114_;
					ValaMemberAccess* _tmp115_;
					_tmp114_ = ma;
					vala_expression_set_lvalue ((ValaExpression*) _tmp114_, TRUE);
					_tmp115_ = ma;
					vala_member_access_check_lvalue_access (_tmp115_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp116_ = array_type;
		_tmp117_ = vala_array_type_get_rank (_tmp116_);
		_tmp118_ = _tmp117_;
		_tmp119_ = vala_element_access_get_indices (self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = _tmp118_ < _tmp122_;
		_vala_iterable_unref0 (_tmp120_);
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			ValaList* _tmp126_;
			ValaList* _tmp127_;
			gint _tmp128_;
			gint _tmp129_;
			ValaArrayType* _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_element_access_get_indices (self);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = array_type;
			_tmp131_ = vala_array_type_get_rank (_tmp130_);
			_tmp132_ = _tmp131_;
			_tmp133_ = g_strdup_printf ("%d extra indices for element access", _tmp129_ - _tmp132_);
			_tmp134_ = _tmp133_;
			vala_report_error (_tmp125_, _tmp134_);
			_g_free0 (_tmp134_);
			_vala_iterable_unref0 (_tmp127_);
		} else {
			ValaArrayType* _tmp135_;
			gint _tmp136_;
			gint _tmp137_;
			ValaList* _tmp138_;
			ValaList* _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			gboolean _tmp142_;
			_tmp135_ = array_type;
			_tmp136_ = vala_array_type_get_rank (_tmp135_);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_element_access_get_indices (self);
			_tmp139_ = _tmp138_;
			_tmp140_ = vala_collection_get_size ((ValaCollection*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = _tmp137_ > _tmp141_;
			_vala_iterable_unref0 (_tmp139_);
			if (_tmp142_) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaArrayType* _tmp145_;
				gint _tmp146_;
				gint _tmp147_;
				ValaList* _tmp148_;
				ValaList* _tmp149_;
				gint _tmp150_;
				gint _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = array_type;
				_tmp146_ = vala_array_type_get_rank (_tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = vala_element_access_get_indices (self);
				_tmp149_ = _tmp148_;
				_tmp150_ = vala_collection_get_size ((ValaCollection*) _tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = g_strdup_printf ("%d missing indices for element access", _tmp147_ - _tmp151_);
				_tmp153_ = _tmp152_;
				vala_report_error (_tmp144_, _tmp153_);
				_g_free0 (_tmp153_);
				_vala_iterable_unref0 (_tmp149_);
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp154_ = FALSE;
		ValaPointerType* _tmp155_;
		_tmp155_ = pointer_type;
		if (_tmp155_ != NULL) {
			ValaPointerType* _tmp156_;
			ValaDataType* _tmp157_;
			ValaDataType* _tmp158_;
			_tmp156_ = pointer_type;
			_tmp157_ = vala_pointer_type_get_base_type (_tmp156_);
			_tmp158_ = _tmp157_;
			_tmp154_ = !vala_data_type_is_reference_type_or_type_parameter (_tmp158_);
		} else {
			_tmp154_ = FALSE;
		}
		if (_tmp154_) {
			ValaPointerType* _tmp159_;
			ValaDataType* _tmp160_;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			_tmp159_ = pointer_type;
			_tmp160_ = vala_pointer_type_get_base_type (_tmp159_);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_data_type_copy (_tmp161_);
			_tmp163_ = _tmp162_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp163_);
			_vala_code_node_unref0 (_tmp163_);
		} else {
			gboolean _tmp164_ = FALSE;
			ValaExpression* _tmp165_;
			ValaExpression* _tmp166_;
			_tmp165_ = vala_element_access_get_container (self);
			_tmp166_ = _tmp165_;
			if (VALA_IS_MEMBER_ACCESS (_tmp166_)) {
				ValaExpression* _tmp167_;
				ValaExpression* _tmp168_;
				ValaSymbol* _tmp169_;
				ValaSymbol* _tmp170_;
				_tmp167_ = vala_element_access_get_container (self);
				_tmp168_ = _tmp167_;
				_tmp169_ = vala_expression_get_symbol_reference (_tmp168_);
				_tmp170_ = _tmp169_;
				_tmp164_ = VALA_IS_SIGNAL (_tmp170_);
			} else {
				_tmp164_ = FALSE;
			}
			if (_tmp164_) {
				ValaExpression* _tmp171_;
				ValaExpression* _tmp172_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaExpression* _tmp175_;
				ValaExpression* _tmp176_;
				ValaDataType* _tmp177_;
				ValaDataType* _tmp178_;
				index_int_type_check = FALSE;
				_tmp171_ = vala_element_access_get_container (self);
				_tmp172_ = _tmp171_;
				_tmp173_ = vala_expression_get_symbol_reference (_tmp172_);
				_tmp174_ = _tmp173_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp174_);
				_tmp175_ = vala_element_access_get_container (self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_expression_get_value_type (_tmp176_);
				_tmp178_ = _tmp177_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp178_);
			} else {
				gboolean _tmp179_;
				gboolean _tmp180_;
				ValaSourceReference* _tmp238_;
				ValaSourceReference* _tmp239_;
				ValaExpression* _tmp240_;
				ValaExpression* _tmp241_;
				ValaDataType* _tmp242_;
				ValaDataType* _tmp243_;
				gchar* _tmp244_;
				gchar* _tmp245_;
				gchar* _tmp246_;
				gchar* _tmp247_;
				_tmp179_ = vala_expression_get_lvalue ((ValaExpression*) self);
				_tmp180_ = _tmp179_;
				if (_tmp180_) {
					ValaMethod* set_method = NULL;
					ValaExpression* _tmp181_;
					ValaExpression* _tmp182_;
					ValaDataType* _tmp183_;
					ValaDataType* _tmp184_;
					ValaSymbol* _tmp185_;
					ValaMethod* _tmp186_;
					ValaAssignment* assignment = NULL;
					ValaCodeNode* _tmp187_;
					ValaCodeNode* _tmp188_;
					ValaAssignment* _tmp189_;
					gboolean _tmp190_ = FALSE;
					gboolean _tmp191_ = FALSE;
					ValaMethod* _tmp192_;
					_tmp181_ = vala_element_access_get_container (self);
					_tmp182_ = _tmp181_;
					_tmp183_ = vala_expression_get_value_type (_tmp182_);
					_tmp184_ = _tmp183_;
					_tmp185_ = vala_data_type_get_member (_tmp184_, "set");
					_tmp186_ = VALA_IS_METHOD (_tmp185_) ? ((ValaMethod*) _tmp185_) : NULL;
					if (_tmp186_ == NULL) {
						_vala_code_node_unref0 (_tmp185_);
					}
					set_method = _tmp186_;
					_tmp187_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp188_ = _tmp187_;
					_tmp189_ = _vala_code_node_ref0 (VALA_IS_ASSIGNMENT (_tmp188_) ? ((ValaAssignment*) _tmp188_) : NULL);
					assignment = _tmp189_;
					_tmp192_ = set_method;
					if (_tmp192_ != NULL) {
						ValaMethod* _tmp193_;
						ValaDataType* _tmp194_;
						ValaDataType* _tmp195_;
						_tmp193_ = set_method;
						_tmp194_ = vala_callable_get_return_type ((ValaCallable*) _tmp193_);
						_tmp195_ = _tmp194_;
						_tmp191_ = VALA_IS_VOID_TYPE (_tmp195_);
					} else {
						_tmp191_ = FALSE;
					}
					if (_tmp191_) {
						ValaAssignment* _tmp196_;
						_tmp196_ = assignment;
						_tmp190_ = _tmp196_ != NULL;
					} else {
						_tmp190_ = FALSE;
					}
					if (_tmp190_) {
						gboolean _tmp197_;
						gboolean _tmp198_;
						_tmp197_ = vala_code_node_get_error ((ValaCodeNode*) self);
						_tmp198_ = _tmp197_;
						result = !_tmp198_;
						_vala_code_node_unref0 (assignment);
						_vala_code_node_unref0 (set_method);
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_vala_code_node_unref0 (assignment);
					_vala_code_node_unref0 (set_method);
				} else {
					ValaMethod* get_method = NULL;
					ValaExpression* _tmp199_;
					ValaExpression* _tmp200_;
					ValaDataType* _tmp201_;
					ValaDataType* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaMethod* _tmp204_;
					ValaMethod* _tmp205_;
					_tmp199_ = vala_element_access_get_container (self);
					_tmp200_ = _tmp199_;
					_tmp201_ = vala_expression_get_value_type (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_data_type_get_member (_tmp202_, "get");
					_tmp204_ = VALA_IS_METHOD (_tmp203_) ? ((ValaMethod*) _tmp203_) : NULL;
					if (_tmp204_ == NULL) {
						_vala_code_node_unref0 (_tmp203_);
					}
					get_method = _tmp204_;
					_tmp205_ = get_method;
					if (_tmp205_ != NULL) {
						ValaMethodCall* get_call = NULL;
						ValaExpression* _tmp206_;
						ValaExpression* _tmp207_;
						ValaSourceReference* _tmp208_;
						ValaSourceReference* _tmp209_;
						ValaMemberAccess* _tmp210_;
						ValaMemberAccess* _tmp211_;
						ValaSourceReference* _tmp212_;
						ValaSourceReference* _tmp213_;
						ValaMethodCall* _tmp214_;
						ValaMethodCall* _tmp215_;
						ValaMethodCall* _tmp228_;
						ValaDataType* _tmp229_;
						ValaDataType* _tmp230_;
						ValaMethodCall* _tmp231_;
						ValaDataType* _tmp232_;
						ValaDataType* _tmp233_;
						ValaCodeNode* _tmp234_;
						ValaCodeNode* _tmp235_;
						ValaMethodCall* _tmp236_;
						ValaMethodCall* _tmp237_;
						_tmp206_ = vala_element_access_get_container (self);
						_tmp207_ = _tmp206_;
						_tmp208_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp209_ = _tmp208_;
						_tmp210_ = vala_member_access_new (_tmp207_, "get", _tmp209_);
						_tmp211_ = _tmp210_;
						_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp213_ = _tmp212_;
						_tmp214_ = vala_method_call_new ((ValaExpression*) _tmp211_, _tmp213_);
						_tmp215_ = _tmp214_;
						_vala_code_node_unref0 (_tmp211_);
						get_call = _tmp215_;
						{
							ValaList* _e_list = NULL;
							ValaList* _tmp216_;
							gint _e_size = 0;
							ValaList* _tmp217_;
							gint _tmp218_;
							gint _tmp219_;
							gint _e_index = 0;
							_tmp216_ = vala_element_access_get_indices (self);
							_e_list = _tmp216_;
							_tmp217_ = _e_list;
							_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
							_tmp219_ = _tmp218_;
							_e_size = _tmp219_;
							_e_index = -1;
							while (TRUE) {
								gint _tmp220_;
								gint _tmp221_;
								gint _tmp222_;
								ValaExpression* e = NULL;
								ValaList* _tmp223_;
								gint _tmp224_;
								gpointer _tmp225_;
								ValaMethodCall* _tmp226_;
								ValaExpression* _tmp227_;
								_tmp220_ = _e_index;
								_e_index = _tmp220_ + 1;
								_tmp221_ = _e_index;
								_tmp222_ = _e_size;
								if (!(_tmp221_ < _tmp222_)) {
									break;
								}
								_tmp223_ = _e_list;
								_tmp224_ = _e_index;
								_tmp225_ = vala_list_get (_tmp223_, _tmp224_);
								e = (ValaExpression*) _tmp225_;
								_tmp226_ = get_call;
								_tmp227_ = e;
								vala_method_call_add_argument (_tmp226_, _tmp227_);
								_vala_code_node_unref0 (e);
							}
							_vala_iterable_unref0 (_e_list);
						}
						_tmp228_ = get_call;
						_tmp229_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
						_tmp230_ = _tmp229_;
						vala_expression_set_formal_target_type ((ValaExpression*) _tmp228_, _tmp230_);
						_tmp231_ = get_call;
						_tmp232_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp233_ = _tmp232_;
						vala_expression_set_target_type ((ValaExpression*) _tmp231_, _tmp233_);
						_tmp234_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp235_ = _tmp234_;
						_tmp236_ = get_call;
						vala_code_node_replace_expression (_tmp235_, (ValaExpression*) self, (ValaExpression*) _tmp236_);
						_tmp237_ = get_call;
						result = vala_code_node_check ((ValaCodeNode*) _tmp237_, context);
						_vala_code_node_unref0 (get_call);
						_vala_code_node_unref0 (get_method);
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_vala_code_node_unref0 (get_method);
				}
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_element_access_get_container (self);
				_tmp241_ = _tmp240_;
				_tmp242_ = vala_expression_get_value_type (_tmp241_);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_code_node_to_string ((ValaCodeNode*) _tmp243_);
				_tmp245_ = _tmp244_;
				_tmp246_ = g_strdup_printf ("The expression `%s' does not denote an array", _tmp245_);
				_tmp247_ = _tmp246_;
				vala_report_error (_tmp239_, _tmp247_);
				_g_free0 (_tmp247_);
				_g_free0 (_tmp245_);
				result = FALSE;
				_vala_code_node_unref0 (pointer_type);
				return result;
			}
		}
	}
	_tmp248_ = index_int_type_check;
	if (_tmp248_) {
		{
			ValaList* _e_list = NULL;
			ValaList* _tmp249_;
			gint _e_size = 0;
			ValaList* _tmp250_;
			gint _tmp251_;
			gint _tmp252_;
			gint _e_index = 0;
			_tmp249_ = vala_element_access_get_indices (self);
			_e_list = _tmp249_;
			_tmp250_ = _e_list;
			_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
			_tmp252_ = _tmp251_;
			_e_size = _tmp252_;
			_e_index = -1;
			while (TRUE) {
				gint _tmp253_;
				gint _tmp254_;
				gint _tmp255_;
				ValaExpression* e = NULL;
				ValaList* _tmp256_;
				gint _tmp257_;
				gpointer _tmp258_;
				ValaExpression* _tmp259_;
				ValaDataType* _tmp260_;
				ValaDataType* _tmp261_;
				gboolean _tmp262_ = FALSE;
				ValaExpression* _tmp263_;
				ValaDataType* _tmp264_;
				ValaDataType* _tmp265_;
				_tmp253_ = _e_index;
				_e_index = _tmp253_ + 1;
				_tmp254_ = _e_index;
				_tmp255_ = _e_size;
				if (!(_tmp254_ < _tmp255_)) {
					break;
				}
				_tmp256_ = _e_list;
				_tmp257_ = _e_index;
				_tmp258_ = vala_list_get (_tmp256_, _tmp257_);
				e = (ValaExpression*) _tmp258_;
				_tmp259_ = e;
				_tmp260_ = vala_expression_get_value_type (_tmp259_);
				_tmp261_ = _tmp260_;
				if (_tmp261_ == NULL) {
					result = FALSE;
					_vala_code_node_unref0 (e);
					_vala_iterable_unref0 (_e_list);
					_vala_code_node_unref0 (pointer_type);
					return result;
				}
				_tmp263_ = e;
				_tmp264_ = vala_expression_get_value_type (_tmp263_);
				_tmp265_ = _tmp264_;
				if (VALA_IS_INTEGER_TYPE (_tmp265_)) {
					_tmp262_ = TRUE;
				} else {
					ValaExpression* _tmp266_;
					ValaDataType* _tmp267_;
					ValaDataType* _tmp268_;
					_tmp266_ = e;
					_tmp267_ = vala_expression_get_value_type (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp262_ = VALA_IS_ENUM_VALUE_TYPE (_tmp268_);
				}
				if (!_tmp262_) {
					ValaExpression* _tmp269_;
					ValaSourceReference* _tmp270_;
					ValaSourceReference* _tmp271_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp269_ = e;
					_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp269_);
					_tmp271_ = _tmp270_;
					vala_report_error (_tmp271_, "Expression of integer type expected");
				}
				_vala_code_node_unref0 (e);
			}
			_vala_iterable_unref0 (_e_list);
		}
	}
	_tmp272_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp273_ = _tmp272_;
	result = !_tmp273_;
	_vala_code_node_unref0 (pointer_type);
	return result;
}


static void
vala_element_access_real_emit (ValaCodeNode* base,
                               ValaCodeGenerator* codegen)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _e_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _e_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_e_list = _tmp3_;
		_tmp4_ = _e_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_e_size = _tmp6_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* e = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _e_index;
			_e_index = _tmp7_ + 1;
			_tmp8_ = _e_index;
			_tmp9_ = _e_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _e_list;
			_tmp11_ = _e_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			e = (ValaExpression*) _tmp12_;
			_tmp13_ = e;
			vala_code_node_emit ((ValaCodeNode*) _tmp13_, codegen);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	vala_code_visitor_visit_element_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_element_access_real_get_defined_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _index_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_index_list = _tmp3_;
		_tmp4_ = _index_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_index_size = _tmp6_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* index = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _index_index;
			_index_index = _tmp7_ + 1;
			_tmp8_ = _index_index;
			_tmp9_ = _index_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _index_list;
			_tmp11_ = _index_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			index = (ValaExpression*) _tmp12_;
			_tmp13_ = index;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}


static void
vala_element_access_real_get_used_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaElementAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaElementAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_element_access_get_container (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _index_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _index_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _index_index = 0;
		_tmp2_ = self->priv->indices;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_index_list = _tmp3_;
		_tmp4_ = _index_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_index_size = _tmp6_;
		_index_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* index = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _index_index;
			_index_index = _tmp7_ + 1;
			_tmp8_ = _index_index;
			_tmp9_ = _index_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _index_list;
			_tmp11_ = _index_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			index = (ValaExpression*) _tmp12_;
			_tmp13_ = index;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (index);
		}
		_vala_iterable_unref0 (_index_list);
	}
}


ValaExpression*
vala_element_access_get_container (ValaElementAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_container;
	result = _tmp0_;
	return result;
}


void
vala_element_access_set_container (ValaElementAccess* self,
                                   ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_container);
	self->priv->_container = _tmp0_;
	_tmp1_ = self->priv->_container;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_element_access_class_init (ValaElementAccessClass * klass)
{
	vala_element_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_element_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaElementAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_element_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_element_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_element_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_element_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_element_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_element_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_element_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_element_access_real_get_used_variables;
}


static void
vala_element_access_instance_init (ValaElementAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_ELEMENT_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->indices = (ValaList*) _tmp1_;
}


static void
vala_element_access_finalize (ValaCodeNode * obj)
{
	ValaElementAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess);
	_vala_iterable_unref0 (self->priv->indices);
	_vala_code_node_unref0 (self->priv->_container);
	VALA_CODE_NODE_CLASS (vala_element_access_parent_class)->finalize (obj);
}


/**
 * Represents an array access expression e.g. "a[1,2]".
 */
GType
vala_element_access_get_type (void)
{
	static volatile gsize vala_element_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_element_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaElementAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_element_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaElementAccess), 0, (GInstanceInitFunc) vala_element_access_instance_init, NULL };
		GType vala_element_access_type_id;
		vala_element_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaElementAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_element_access_type_id__volatile, vala_element_access_type_id);
	}
	return vala_element_access_type_id__volatile;
}



