/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef TOUCHPAD_H
#define TOUCHPAD_H

#include <QObject>
#include <QtPlugin>

#include "shell/interface.h"
#include "touchpadui.h"

class Touchpad : public QObject, CommonInterface
{
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.ukcc.CommonInterface")
    Q_INTERFACES(CommonInterface)

public:
    explicit Touchpad();
    ~Touchpad();

    QString plugini18nName() Q_DECL_OVERRIDE;
    int pluginTypes() Q_DECL_OVERRIDE;
    QWidget *pluginUi() Q_DECL_OVERRIDE;
    const QString name() const  Q_DECL_OVERRIDE;
    bool isShowOnHomePage() const Q_DECL_OVERRIDE;
    QIcon icon() const Q_DECL_OVERRIDE;
    bool isEnable() const Q_DECL_OVERRIDE;

    bool findSynaptics() const;
    bool _supportsXinputDevices() const;
    XDevice* _deviceIsTouchpad (XDeviceInfo * deviceinfo) const;
    bool _deviceHasProperty (XDevice * device, const char * property_name) const;

private:
    QString pluginName;
    int pluginType;
    TouchpadUI * pluginWidget;

private:
    bool mFirstLoad;

};

#endif // TOUCHPAD_H
