C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MATCLI,SSI=0
C
                     SUBROUTINE MATCLI
C                    ******************
C
C     ------------------------------------------------------
     * (NCOUPS,VCOUPS,NECHS,VECHS,
     * NRESCS,VRESCS,
     * NRAYTS,VRAYTS,NBRAYS,
     * NRAYIS,VRAYIS,NBRAIS,
     * TMPSA,NODEUS,COORDS,SURFUS,
     * NPOINS,NELEMS,NDIM,NELEUS,NDMASS,
     * NBCOUS,NBECHS,NBRESS, 
     * TRAV1,TRAV4,DIAG,WCT)
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DE LA CONTRIBUTION DES TERMES ECHANGE      *
C                    DU A L'IMPLICITATION DES TERMES D'ECHANGE         *
C                                                                      *
C      On calcule les termes suivants                                  *
C            Termes de couplage avec le fluide                         *
C            Termes de coefficient d'echange avec l'exterieure         *
C            Terme de resistance de contact                            *
C            Terme de rayonnement                                      *
C                                                                      *
C     Ces termes seront mass-lumpe pour etre coherent                  *
C     La diagonale correspondante (non nul sur les termes de bord)     *
C     sera stokee dans le vecteur TRAV4                                *
C                                                                      *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEUS,OV
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : DIFSOL
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "rayonn.h"
C    
C***********************************************************************
C
C..Variables externes
      INTEGER NPOINS,NELEMS,NDIM,NELEUS,NDMASS
      INTEGER NBCOUS,NBECHS,NBRESS,NBRAYS,NBRAIS
      INTEGER NCOUPS(NBCOUS),NECHS(NBECHS)
      INTEGER NODEUS(NELEUS,NDMASS)
      INTEGER NRESCS(NBRESS,2),NRAYTS(NBRAYS),NRAYIS(NBRAIS)
C
      DOUBLE PRECISION VCOUPS(NBCOUS,2),VECHS(NBECHS,2)
      DOUBLE PRECISION VRESCS(NBRESS,2)
      DOUBLE PRECISION VRAYTS(NBRAYS,2),VRAYIS(NBRAIS,2)
      DOUBLE PRECISION TRAV1(NPOINS),TRAV4(NPOINS),DIAG(NPOINS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM),TMPSA(NPOINS)
      DOUBLE PRECISION WCT(NELEMS,NDMASS)
      DOUBLE PRECISION SURFUS(NELEUS)   
C
C..Variables internes
      DOUBLE PRECISION ZERO
      LOGICAL LVERIF
      DOUBLE PRECISION R1,R2
      DOUBLE PRECISION CL1,CL2,CL3,CL4,CL5,CL6
      INTEGER I,INODE,NCA
      INTEGER N1,N2,N3,N4,N5,N6
      DOUBLE PRECISION S48,SV48,S12,SV12
      DOUBLE PRECISION HRAYI,HRAYT
C    
C***********************************************************************
C
C     1- INITIALISATION
C     =================
C
      LVERIF = .FALSE.
      ZERO   = 0.D0
      IF (IAXISY.EQ.1) THEN
         NCA=2
      ELSE
         NCA=1
      ENDIF
C
      S48 = 1.D0 / 48.D0
      S12  = 1.D0 / 12.D0
C
C
      CALL OV ('X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )         
      CALL OV ('X=C     ',TRAV4,TRAV4,TRAV4,ZERO,NPOINS )         
      CALL OV ('X=C     ',DIAG,DIAG,DIAG,ZERO,NPOINS )         
C
C      
C     2- PRISE EN COMPTE DES "COEFFICIENTS D'ECHANGE"
C     ==============================================
C 
          DO 210 I=1,NBCOUS
            INODE = NCOUPS(I)
            TRAV1(INODE) = TRAV1(INODE) + VCOUPS(I,2)
  210     CONTINUE
C        
          DO 220 I=1,NBECHS
            INODE = NECHS(I)
            TRAV1(INODE) = TRAV1(INODE) + VECHS(I,2)
  220     CONTINUE
C              
          DO 230 I=1,NBRESS
            INODE = NRESCS(I,1)
            TRAV1(INODE) = TRAV1(INODE) + VRESCS(I,2)
  230     CONTINUE
C                      
C               
C     3- CALCUL DE LA MATRICE ELEMENTAIRE (echange)
C     ===========================================
C
C         3.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             3.1.1- Cas cartesien
C             --------------------
              IF (IAXISY.EQ.0) THEN
C
                   DO 311 I=1,NELEUS
C
                     N1 = NODEUS(I,1)
                     N2 = NODEUS(I,2)
                     N3 = NODEUS(I,3)
C
                     SV12 = S12 * SURFUS(I)      
C
                     CL1  = TRAV1(N1) * SV12
                     CL2  = TRAV1(N2) * SV12
                     CL3  = TRAV1(N3) * SV12
C                  
C !                  Expression du vecteur
C                    ATTENTION  Le point 3 est au milieu du segment           
                     WCT(I,1) = 2*CL1 + CL3
                     WCT(I,2) = 2*CL2 + CL3
                     WCT(I,3) = CL1 + CL2 + 4*CL3       
  311              CONTINUE
C
C             3.1.2- Cas axisymetrique
C             ------------------------
              ELSE
              
                   DO 312 I=1,NELEUS
C
                     N1 = NODEUS(I,1)
                     N2 = NODEUS(I,2)
                     N3 = NODEUS(I,3)
C
                     SV48 = S48 * SURFUS(I)
C
                     R1 = ABS (COORDS(N1,NCA))
                     R2 = ABS (COORDS(N2,NCA))         
C
                     CL1  = TRAV1(N1) * SV48
                     CL2  = TRAV1(N2) * SV48
                     CL3  = TRAV1(N3) * SV48
C                  
                     WCT(I,1) = R2*CL3+R2*CL1+3*R1*CL3+7*R1*CL1 
                     WCT(I,2) = 3*R2*CL3+7*R2*CL2+R1*CL3+R1*CL2 
                     WCT(I,3) = 8*R2*CL3+R2*CL1+8*R1*CL3+3*R1*CL1
     &                       +3*R2*CL2+R1*CL2 
C   
  312              CONTINUE
C              
              ENDIF
C                         
C         3.2- Cas 3D
C         -----------          
          ELSE
                   DO 320 I=1,NELEUS
C
                   N1 = NODEUS(I,1)
                   N2 = NODEUS(I,2)
                   N3 = NODEUS(I,3)
                   N4 = NODEUS(I,4)
                   N5 = NODEUS(I,5)
                   N6 = NODEUS(I,6)
C
                   SV48 = S48 * SURFUS(I)                      
C            
                   CL1  = TRAV1(N1) * SV48
                   CL2  = TRAV1(N2) * SV48
                   CL3  = TRAV1(N3) * SV48
                   CL4  = TRAV1(N4) * SV48
                   CL5  = TRAV1(N5) * SV48
                   CL6  = TRAV1(N6) * SV48
C
C
                   WCT(I,1) =  2*CL1 + CL4 + CL6
                   WCT(I,2) =  2*CL2 + CL4 + CL5
                   WCT(I,3) =  2*CL3 + CL5 + CL6
                   WCT(I,4) =  CL1 + CL2 + 6*CL4 + 2*(CL5+CL6)
                   WCT(I,5) =  CL2 + CL3 + 6*CL5 + 2*(CL4+CL6)
                   WCT(I,6) =  CL1 + CL3 + 6*CL6 + 2*(CL4+CL5)
C
  320 CONTINUE
C
          ENDIF
C
          CALL OV ('X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )         
          CALL ASSEUS ( TRAV1,NODEUS,NELEMS,NELEUS,NPOINS,NDMASS,
     &                  NDIM,WCT)
C
C         3.3 Elimination des contributions parasites sur le bord 
C         --------------------------------------------------------
C
          DO 331 I=1,NBCOUS
            INODE = NCOUPS(I)
            TRAV4(INODE) = TRAV1(INODE)
  331     CONTINUE
C        
          DO 332 I=1,NBECHS
            INODE = NECHS(I)
            TRAV4(INODE) = TRAV1(INODE)
  332     CONTINUE
C              
          DO 333 I=1,NBRESS
            INODE = NRESCS(I,1)
            TRAV4(INODE) = TRAV1(INODE)
  333     CONTINUE
C                      
C
C     4-TRAITEMENT DU RAYONNEMENT
C     ===========================================
      CALL OV ('X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )         
C
          DO 410 I=1,NBRAIS
            INODE = NRAYIS(I)
            HRAYI = VRAYIS(I,2)*SIGMA*
     &              (TMPSA(INODE)+VRAYIS(I,1)+2*TKEL)*
     &              ((TMPSA(INODE)+TKEL) * (TMPSA(INODE)+TKEL) +
     &               (VRAYIS(I,1)+TKEL)  * (VRAYIS(I,1)+TKEL) )
            TRAV1(INODE) = TRAV1(INODE) + HRAYI
  410     CONTINUE
C        
          DO 420 I=1,NBRAYS
            INODE = NRAYTS(I)
            HRAYT = VRAYTS(I,2)*SIGMA*
     &               (TMPSA(INODE)+VRAYTS(I,1)+2*TKEL)*
     &               ((TMPSA(INODE)+TKEL) * (TMPSA(INODE)+TKEL) + 
     &                (VRAYTS(I,1) +TKEL) * (VRAYTS(I,1)+TKEL) )
            TRAV1(INODE) = TRAV1(INODE) + HRAYT
  420     CONTINUE
C        
C     5- CALCUL DE LA MATRICE ELEMENTAIRE pour le rayonnemnt
C     =====================================================
      IF ( NBRAYS .GT. 0 .OR. NBRAIS.GT.0 ) THEN
C
C         5.1- Cas 2D
C         -----------
          IF ( NDIM .EQ. 2 ) THEN
C
C             5.1.1- Cas cartesien
C             --------------------
              IF (IAXISY.EQ.0) THEN
C
                   DO 511 I=1,NELEUS
C
                     N1 = NODEUS(I,1)
                     N2 = NODEUS(I,2)
                     N3 = NODEUS(I,3)
C
                     SV12 = S12 * SURFUS(I)      
C
                     CL1  = TRAV1(N1) * SV12
                     CL2  = TRAV1(N2) * SV12
                     CL3  = TRAV1(N3) * SV12
C                  
C                    ATTENTION  Le point 3 est au milieu du segment           
                     WCT(I,1) = 2*CL1 + CL3
                     WCT(I,2) = 2*CL2 + CL3
                     WCT(I,3) = CL1 + CL2 + 4*CL3       
  511              CONTINUE
C
C             5.1.2- Cas axisymetrique
C             ------------------------
              ELSE
              
                   DO 512 I=1,NELEUS
C
                     N1 = NODEUS(I,1)
                     N2 = NODEUS(I,2)
                     N3 = NODEUS(I,3)
C
                     SV48 = S48 * SURFUS(I)
C
                     R1 = ABS (COORDS(N1,NCA))
                     R2 = ABS (COORDS(N2,NCA))         
C
                     CL1  = TRAV1(N1) * SV48
                     CL2  = TRAV1(N2) * SV48
                     CL3  = TRAV1(N3) * SV48
C                  
                     WCT(I,1) = R2*CL3+R2*CL1+3*R1*CL3+7*R1*CL1 
                     WCT(I,2) = 3*R2*CL3+7*R2*CL2+R1*CL3+R1*CL2 
                     WCT(I,3) = 8*R2*CL3+R2*CL1+8*R1*CL3+3*R1*CL1
     &                       +3*R2*CL2+R1*CL2 
C   
  512              CONTINUE
C              
C             Fin du cas axisymetrique              
              ENDIF
C                         
C         5.2- Cas 3D
C         -----------          
          ELSE
                   DO 520 I=1,NELEUS
C
                   N1 = NODEUS(I,1)
                   N2 = NODEUS(I,2)
                   N3 = NODEUS(I,3)
                   N4 = NODEUS(I,4)
                   N5 = NODEUS(I,5)
                   N6 = NODEUS(I,6)
C
                   SV48 = S48 * SURFUS(I)                      
C            
                   CL1  = TRAV1(N1) * SV48
                   CL2  = TRAV1(N2) * SV48
                   CL3  = TRAV1(N3) * SV48
                   CL4  = TRAV1(N4) * SV48
                   CL5  = TRAV1(N5) * SV48
                   CL6  = TRAV1(N6) * SV48
C
C
                   WCT(I,1) =  2*CL1 + CL4 + CL6
                   WCT(I,2) =  2*CL2 + CL4 + CL5
                   WCT(I,3) =  2*CL3 + CL5 + CL6
                   WCT(I,4) =  CL1 + CL2 + 6*CL4 + 2*(CL5+CL6)
                   WCT(I,5) =  CL2 + CL3 + 6*CL5 + 2*(CL4+CL6)
                   WCT(I,6) =  CL1 + CL3 + 6*CL6 + 2*(CL4+CL5)
C
  520 CONTINUE
C
          ENDIF
C
          CALL OV ('X=C     ',TRAV1,TRAV1,TRAV1,ZERO,NPOINS )         
          CALL ASSEUS ( TRAV1,NODEUS,NELEMS,NELEUS,NPOINS,NDMASS,
     &                  NDIM,WCT)
C
C         5.3 Elimination des contributions parasites sur le bord 
C         --------------------------------------------------------
C
          DO 534 I=1,NBRAIS
            INODE = NRAYIS(I)
            DIAG(INODE) = TRAV1(INODE)
  534     CONTINUE
C        
          DO 535 I=1,NBRAYS
            INODE = NRAYTS(I)
            DIAG(INODE) = TRAV1(INODE)
  535     CONTINUE
C  
      ENDIF      
C
C     6- IMPRESSIONS POUR CONTROLE
C     ============================
C
      IF ( LVERIF ) THEN
        WRITE(NFECRA,6000)
        DO 600 I=1,NPOINS
          WRITE(NFECRA,6010) I,TRAV4(I),DIAG(I)
  600   CONTINUE
      ENDIF
C
C--------
C FORMATS
C--------
 6000 FORMAT(/,' *** MATCLI : 1ER MEMBRE (PARTIE ECHANGE IMPLICITE)',/,
     &         '     NOEUD     MAT ML ECH      MAT ML RAYONNEMENT')
 6010 FORMAT(7X,I6,5X,G10.4,5X,G10.4)
C                             
      END
