/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _STRINGUTILS_HH
#define _STRINGUTILS_HH

#include <string>
#include <list>

using namespace std;

namespace StringUtils {
	int to_int(string const input);
	float to_float(string const input);
	string to_string(int const input);
	string to_string(float const input);
	string strip_slashes(string const str);
	void split(const std::string str, const char separator, std::list<std::string> &result);
	string chomp(string const inString);
	string upper(string const str);
	string lower(string const str);
}

#endif
