/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROJECTSORTER_H
#define _SC_PROJECTSORTER_H

// sc
#include "ProjectTypes.h"

/**
 * Helper class for handling project and project item sort order changes.
 */
class ProjectSorter
{
public:
  ProjectSorter( const Projects& projects );

  /**
   * move sort position \a src to position \a dst.
   */
  void move( long src, long dst );

  /**
   * make sure the sort positions are properly sequenced.
   */
  void cleanupSortPositions();


  const Projects& getProjects() const;

private:
  Projects _projects;
};

#endif // _SC_PROJECTSORTER_H
