/* ====================================================================
 * Copyright (c) 2003-2008, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COMMITDIALOG_H
#define _SC_COMMITDIALOG_H

// sc
#include "svn/ClientTypes.h"
#include "svn/CommitItemTypes.h"
class WcViewModel;
class CommitParam;
class CommitLogHistory;
namespace sc {
  class Condition;
}

// qt
#include <QtGui/QDialog>
class QComboBox;
class QCheckBox;
class QPushButton;
class QTextEdit;
class QTreeWidget;
class QTreeWidgetItem;
class QLabel;


/**
 * closing the commit dialog will set the results through this
 * interface.
 */
class CommitResult
{
public:
  virtual ~CommitResult() {};

  virtual void setCommit( bool ) = 0;
  virtual void setLog( const sc::String& log ) = 0;
};


class CommitDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  CommitDialog( bool direct, bool bookmark, WcViewModel* model,
    CommitLogHistory*, const QFont& font, QWidget *parent );
  virtual ~CommitDialog();

  void setCommitItems( const svn::CommitItems& items );
  void setCondition( sc::Condition* cond );
  void setResult( CommitResult* res );
  
public slots:
  void doubleClicked(QTreeWidgetItem*,int);
  void cursorChanged();
  void logChanged();
  void logHistory(int);
  
  void list();
  void commit();
  void cancel();

  void confirmCommit( CommitParam* param, bool& proceed );

private:
  void finish( bool commit );

  bool              _direct;
  bool              _bookmark;
  WcViewModel*      _model;        // may be NULL! (implict commit)
  CommitLogHistory* _logHistory;

  QComboBox*        _log;
  QCheckBox*        _recurse;
  QCheckBox*        _keepLocks;
  QTextEdit*        _edit;
  QLabel*           _pos;
  QLabel*           _url;
  QLabel*           _path;
  QTreeWidget*      _list;

  bool              _commitTriggered;

  QPushButton*      _ls;
  QPushButton*      _ok;
  QPushButton*      _ca;

  sc::Condition*    _cond;
  CommitResult*     _result;
};

#endif // _SC_COMMITDIALOG_H
