/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BLAMEDIALOG_H
#define _SC_BLAMEDIALOG_H

// sc
#include "sublib/TargetId.h"
#include "util/String.h"
#include "svn/BlameLineTypes.h"
class RevisionWidget;
class BlameViewModel;

namespace svn
{
  class Error;
}

// qt
#include <QtGui/QWidget>
class QPushButton;
class Q3ListView;

// sys
#include <vector>

/**
 * Dialog class for displaying blame information.
 */
class BlameDialog : public QWidget, public TargetId
{
  typedef QWidget super;
  Q_OBJECT 

public:
  BlameDialog( BlameViewModel* model, const QFont& font, QWidget *parent = 0 );
  virtual ~BlameDialog();

public slots:
  void run();

  // model slots
  void add( svn::BlameLinePtr );
  void done();

private:
  BlameViewModel*  _model;

  RevisionWidget*  _rwStart;
  RevisionWidget*  _rwStop;

  Q3ListView*      _blame;

  QPushButton*     _run;
  QPushButton*     _done;
};

#endif // _SC_BLAMEDIALOG_H
