/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.htm.core.test;

import edu.jhu.htm.core.Convex;
import edu.jhu.htm.core.Domain;
import edu.jhu.htm.core.HTMindexImp;
import edu.jhu.htm.core.HTMrange;
import edu.jhu.htm.core.HTMrangeIterator;
import edu.jhu.htm.core.Vector3d;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;

public class TestHTMindexImp
extends TestCase {
    static /* synthetic */ Class class$edu$jhu$htm$core$test$TestHTMindexImp;

    public TestHTMindexImp(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$edu$jhu$htm$core$test$TestHTMindexImp == null ? (class$edu$jhu$htm$core$test$TestHTMindexImp = TestHTMindexImp.class$("edu.jhu.htm.core.test.TestHTMindexImp")) : class$edu$jhu$htm$core$test$TestHTMindexImp);
    }

    public void testBarcelona() throws Exception {
        HTMindexImp hTMindexImp = new HTMindexImp(12, 6);
        Vector3d[] vector3dArray = new Vector3d[]{new Vector3d(40.0, 65.0), new Vector3d(40.0, 66.0), new Vector3d(41.0, 65.0), new Vector3d(41.0, 66.0)};
        Convex convex = new Convex(vector3dArray[0], vector3dArray[1], vector3dArray[2], vector3dArray[3]);
        convex.simplify();
        Domain domain = new Domain();
        domain.add(convex);
        domain.setOlevel(12);
        HTMrange hTMrange = new HTMrange();
        domain.intersect(hTMindexImp, hTMrange, false);
        hTMrange.reset();
        long[] lArray = hTMrange.getNext();
        while (lArray != null && lArray[0] > 0L) {
            System.err.println("Range: " + lArray[0] + " to " + lArray[1]);
            lArray = hTMrange.getNext();
        }
        HTMrangeIterator hTMrangeIterator = new HTMrangeIterator(hTMrange, true);
        Assert.assertTrue((boolean)hTMrangeIterator.hasNext());
    }

    public void testResolutionConstruc() throws Exception {
        HTMindexImp hTMindexImp = new HTMindexImp(1.0);
        Assert.assertEquals((String)"Resolution is incorrect", (int)7, (int)hTMindexImp.maxlevel_);
    }

    public void testIdByPoint10() throws Exception {
        double d = 10.0;
        double d2 = 10.0;
        Vector3d vector3d = new Vector3d(d, d2);
        long l = 0L;
        HTMindexImp hTMindexImp = new HTMindexImp(10);
        l = hTMindexImp.lookupId(vector3d);
        Assert.assertEquals((String)"Incorrect Id returned", (long)16305926L, (long)l);
    }

    public void testIdByPoint20() throws Exception {
        double d = 10.0;
        double d2 = 10.0;
        Vector3d vector3d = new Vector3d(d, d2);
        long l = 0L;
        HTMindexImp hTMindexImp = new HTMindexImp(20);
        l = hTMindexImp.lookupId(vector3d);
        Assert.assertEquals((String)"Incorrect Id returned", (long)17098002819647L, (long)l);
    }

    public void testnameById10() throws Exception {
        HTMindexImp hTMindexImp = new HTMindexImp(10);
        long l = 16305926L;
        String string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N32030330012", (Object)string);
    }

    public void testnameById20() throws Exception {
        HTMindexImp hTMindexImp = new HTMindexImp(20);
        long l = 17098002819647L;
        String string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N320303300120212220333", (Object)string);
    }

    public void testLookup10() throws Exception {
        double d = 10.0;
        double d2 = 10.0;
        Vector3d vector3d = new Vector3d(d, d2);
        long l = 0L;
        long l2 = System.currentTimeMillis();
        HTMindexImp hTMindexImp = new HTMindexImp(10);
        l = hTMindexImp.lookupId(vector3d);
        String string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N32030330012", (Object)string);
        vector3d.set(45.0, 45.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N33313333303", (Object)string);
        vector3d.set(90.0, -45.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"S01100000000", (Object)string);
        vector3d.set(180.0, 85.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N21000200100", (Object)string);
        vector3d.set(275.0, -85.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"S31000200223", (Object)string);
        float f = System.currentTimeMillis() - l2;
        System.err.println("Test took " + f + " miliseconds");
    }

    public void testLookup14() throws Exception {
        double d = 10.0;
        double d2 = 10.0;
        Vector3d vector3d = new Vector3d(d, d2);
        long l = 0L;
        long l2 = System.currentTimeMillis();
        HTMindexImp hTMindexImp = new HTMindexImp(14);
        l = hTMindexImp.lookupId(vector3d);
        String string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N320303300120212", (Object)string);
        vector3d.set(45.0, 45.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N333133333033333", (Object)string);
        vector3d.set(90.0, -45.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"S011000000000000", (Object)string);
        vector3d.set(180.0, 85.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"N210002001002001", (Object)string);
        vector3d.set(275.0, -85.0);
        l = hTMindexImp.lookupId(vector3d);
        string = hTMindexImp.idToName(l);
        Assert.assertEquals((String)"Incorrect Id returned", (Object)"S310002002230232", (Object)string);
        float f = System.currentTimeMillis() - l2;
        System.err.println("Test took " + f + " miliseconds");
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{(class$edu$jhu$htm$core$test$TestHTMindexImp == null ? (class$edu$jhu$htm$core$test$TestHTMindexImp = TestHTMindexImp.class$("edu.jhu.htm.core.test.TestHTMindexImp")) : class$edu$jhu$htm$core$test$TestHTMindexImp).getName()};
        TestRunner.main((String[])stringArray2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

