/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.BaseHash;
import cds.healpix.CompassPoint;
import java.util.EnumMap;
import java.util.EnumSet;

final class BaseHashSouthPolarCap
extends BaseHash {
    private static final EnumSet<CompassPoint.MainWind> noNeighbour = EnumSet.of(CompassPoint.MainWind.E, CompassPoint.MainWind.W);
    private static final EnumMap<CompassPoint.MainWind, CompassPoint.MainWind> dirFromNeighbour = new EnumMap(CompassPoint.MainWind.class);

    protected BaseHashSouthPolarCap(int baseHash) {
        super(baseHash);
    }

    @Override
    CompassPoint.MainWind getDirectionFromNeighbour(CompassPoint.MainWind neighbourMainWind) {
        if (noNeighbour.contains((Object)neighbourMainWind)) {
            throw new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourMainWind));
        }
        return dirFromNeighbour.get((Object)neighbourMainWind);
    }

    @Override
    CompassPoint.MainWind getEdgeCellDirectionFromNeighbour(CompassPoint.MainWind innerDirection, CompassPoint.MainWind neighbourDirection) {
        switch (neighbourDirection) {
            case C: {
                new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourDirection));
            }
            case E: {
                switch (innerDirection) {
                    case S: 
                    case SE: {
                        return CompassPoint.MainWind.S;
                    }
                    case E: {
                        new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourDirection));
                    }
                    case N: 
                    case NE: {
                        return neighbourDirection.getOppositeDirection();
                    }
                }
                assert (false);
            }
            case W: {
                switch (innerDirection) {
                    case S: 
                    case SW: {
                        return CompassPoint.MainWind.S;
                    }
                    case W: {
                        new IllegalArgumentException("No neighbour in direction " + (Object)((Object)neighbourDirection));
                    }
                    case N: 
                    case NW: {
                        return neighbourDirection.getOppositeDirection();
                    }
                }
                assert (false);
            }
            case SE: {
                return CompassPoint.MainWind.SW;
            }
            case SW: {
                return CompassPoint.MainWind.SE;
            }
            case S: {
                switch (innerDirection) {
                    case S: {
                        return CompassPoint.MainWind.S;
                    }
                    case SE: 
                    case E: {
                        return CompassPoint.MainWind.W;
                    }
                    case SW: 
                    case W: {
                        return CompassPoint.MainWind.E;
                    }
                }
                assert (false);
                break;
            }
        }
        return neighbourDirection.getOppositeDirection();
    }

    @Override
    protected void fillNeighbours(int d0h, int[] neighbours) {
        assert (8 <= d0h && d0h < 12);
        int hModulo4 = d0h & 3;
        int hp1Modulo4 = hModulo4 + 1 & 3;
        neighbours[CompassPoint.MainWind.SE.getIndex()] = hp1Modulo4 + 8;
        neighbours[CompassPoint.MainWind.E.getIndex()] = -1;
        neighbours[CompassPoint.MainWind.NE.getIndex()] = hp1Modulo4 + 4;
        int hp2Modulo4 = hModulo4 + 2 & 3;
        neighbours[CompassPoint.MainWind.S.getIndex()] = 8 + hp2Modulo4;
        neighbours[CompassPoint.MainWind.C.getIndex()] = d0h;
        neighbours[CompassPoint.MainWind.N.getIndex()] = hModulo4;
        int hm1Modulo4 = hModulo4 - 1 & 3;
        neighbours[CompassPoint.MainWind.NW.getIndex()] = hModulo4 + 4;
        neighbours[CompassPoint.MainWind.W.getIndex()] = -1;
        neighbours[CompassPoint.MainWind.SW.getIndex()] = hm1Modulo4 + 8;
    }

    @Override
    int pickRightIndexOnNeighbourSouthToEastAxis(CompassPoint.MainWind neighbourDirection, int iAxisSE, int jAxisSW, int nsideMinus1) {
        return neighbourDirection.pickRightIntValue(iAxisSE, 0, 0, -1, iAxisSE, -1, jAxisSW, 0, 0);
    }

    @Override
    long pickRightIndexBitsOnNeighbourSouthToEastAxis(CompassPoint.MainWind neighbourDirection, long iAxisSEBits, long jAxisSWBits, long nsideMinus1Bits) {
        return neighbourDirection.pickRightLongValue(iAxisSEBits, 0L, 0L, -1L, iAxisSEBits, -1L, jAxisSWBits, 0L, 0L);
    }

    @Override
    int pickRightIndexOnNeighbourSouthToWestAxis(CompassPoint.MainWind neighbourDirection, int iAxisSE, int jAxisSW, int nsideMinus1) {
        return neighbourDirection.pickRightIntValue(0, 0, jAxisSW, -1, jAxisSW, -1, 0, 0, iAxisSE);
    }

    @Override
    long pickRightIndexSWBits(CompassPoint.MainWind neighbourDirection, long iAxisSEBits, long jAxisSWBits, long nsideMinus1Bits) {
        return neighbourDirection.pickRightLongValue(0L, 0L, jAxisSWBits, -1L, jAxisSWBits, -1L, 0L, 0L, iAxisSEBits);
    }

    static {
        dirFromNeighbour.put(CompassPoint.MainWind.NE, CompassPoint.MainWind.NE.getOppositeDirection());
        dirFromNeighbour.put(CompassPoint.MainWind.N, CompassPoint.MainWind.N.getOppositeDirection());
        dirFromNeighbour.put(CompassPoint.MainWind.NW, CompassPoint.MainWind.NW.getOppositeDirection());
        dirFromNeighbour.put(CompassPoint.MainWind.C, CompassPoint.MainWind.C.getOppositeDirection());
        dirFromNeighbour.put(CompassPoint.MainWind.SE, CompassPoint.MainWind.SW);
        dirFromNeighbour.put(CompassPoint.MainWind.S, CompassPoint.MainWind.S);
        dirFromNeighbour.put(CompassPoint.MainWind.SW, CompassPoint.MainWind.SE);
    }
}

