#!/bin/sh

set -e

save() {
    if [ -f root/$1 ]; then
	    cp -va root/$1 root/$1.clonesave
    fi
}

restore() {
    if [ -f root/$1.clonesave ]; then
	    mv root/$1.clonesave root/$1
    fi
}

echo 
echo "Runing $0 script"
echo
BASEPATH=$(dirname $0)
echo $BASEPATH

# copy over /etc (but preserve fstab)
save /etc/fstab
save /etc/network/interfaces

cp -ra /etc root/

restore /etc/fstab
restore /etc/network/interfaces

# copy the FS
for d in /bin /boot /initrd /lib /lib32 /lib64 /opt /root \
         /sbin /srv /usr /var; do
    if [ -d $d ]; then
        echo "copying $d -> root/"
	(cd root/ ; tar cf - $d | tar xf - )
    fi
done

# kill copied menu.lst and let the system generate a new one
rm root/boot/grub/menu.lst

# copy custom xorg.conf - the orignial one
# will most likely not work
# FIXME: instead of overwritting, just remove/rewrite
#        the device section?
if [ -e root/etc/X11/xorg.conf ]; then
    cp -v $BASEPATH/xorg.conf root/etc/X11/
fi

# create homedirs of the users
# FIXME: copy dot-files
for d in $(find /home/ -maxdepth 1 -type d ); do 
    (cd root/ ; tar --no-recursion -c -f - $d | tar xvf -)
done


