% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-that.R
\name{fail}
\alias{fail}
\alias{succeed}
\title{Default expectations that always succeed or fail.}
\usage{
fail(
  message = "Failure has been forced",
  info = NULL,
  trace_env = caller_env()
)

succeed(message = "Success has been forced", info = NULL)
}
\arguments{
\item{message}{a string to display.}

\item{info}{Character vector continuing additional information. Included
for backward compatibility only and new expectations should not use it.}

\item{trace_env}{If \code{is.null(trace)}, this is used to automatically
generate a traceback running from \code{test_code()}/\code{test_file()} to
\code{trace_env}. You'll generally only need to set this if you're wrapping
an expectation inside another function.}
}
\description{
These allow you to manually trigger success or failure. Failure is
particularly useful to a pre-condition or mark a test as not yet
implemented.
}
\examples{
\dontrun{
test_that("this test fails", fail())
test_that("this test succeeds", succeed())
}
}
