% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_windows_nice_values}
\alias{ps_windows_nice_values}
\alias{ps_get_nice}
\alias{ps_set_nice}
\title{Get or set the priority of a process}
\usage{
ps_windows_nice_values()

ps_get_nice(p = ps_handle())

ps_set_nice(p = ps_handle(), value)
}
\arguments{
\item{p}{Process handle.}

\item{value}{On Windows it must be a string, one of the values of
\code{ps_windows_nice_values()}. On Unix it is a priority value that is
smaller than or equal to 20.}
}
\value{
\code{ps_windows_nice_values()} return a character vector of possible
priority values on Windows.

\code{ps_get_nice()} returns a string from
\code{ps_windows_nice_values()} on Windows. On Unix it returns an integer
smaller than or equal to 20.

\code{ps_set_nice()} return \code{NULL} invisibly.
}
\description{
\code{ps_get_nice()} returns the current priority, \code{ps_set_nice()} sets a
new priority, \code{ps_windows_nice_values()} list the possible priority
values on Windows.
}
\details{
Priority values are different on Windows and Unix.

On Unix, priority is an integer, which is maximum 20. 20 is the lowest
priority.
\subsection{Rules:}{
\itemize{
\item On Windows you can only set the priority of the processes the current
user has \code{PROCESS_SET_INFORMATION} access rights to. This typically
means your own processes.
\item On Unix you can only set the priority of the your own processes.
The superuser can set the priority of any process.
\item On Unix you cannot set a higher priority, unless you are the superuser.
(I.e. you cannot set a lower number.)
\item On Unix the default priority of a process is zero.
}
}
}
