% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_layout_helper.R
\name{layout_default}
\alias{layout_default}
\title{Default layout for new slides}
\usage{
layout_default(x, layout = NULL, master = NULL, as_list = FALSE)
}
\arguments{
\item{x}{An \code{rpptx} object.}

\item{layout}{Layout name. If \code{NULL} (default), removes the default layout.}

\item{master}{Name of master. Only required if layout name is not unique across masters.}

\item{as_list}{If \code{TRUE}, return a list with layout and master instead of the \code{rpptx} object.}
}
\value{
The \code{rpptx} object.
}
\description{
Set or remove the default layout used when calling \code{add_slide()}.
}
\examples{
# set and remove the default layout
x <- read_pptx()
layout_default(x) # no defaults
x <- layout_default(x, "Title and Content") # set default
layout_default(x)
x <- add_slide(x) # new slide with default layout
x <- layout_default(x, NULL) # remove default
layout_default(x) # no defaults

# use when repeatedly adding slides with same layout
x <- read_pptx()
x <- layout_default(x, "Title and Content")
x <- add_slide(x, title = "1. Slide", body = "Some content")
x <- add_slide(x, title = "2. Slide", body = "Some more content")
x <- add_slide(x, title = "3. Slide", body = "Even more content")
}
\seealso{
\code{\link[=add_slide]{add_slide()}}
}
