% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFilterValues.R
\name{plotFilterValues}
\alias{plotFilterValues}
\title{Plot filter values using ggplot2.}
\usage{
plotFilterValues(
  fvalues,
  sort = "dec",
  n.show = nrow(fvalues$data),
  filter = NULL,
  feat.type.cols = FALSE
)
}
\arguments{
\item{fvalues}{(\link{FilterValues})\cr
Filter values.}

\item{sort}{(\code{character(1)})\cr
Available options are:
\itemize{
\item \code{"dec"}-> descending
\item \code{"inc"} -> increasing
\item \code{"none"} -> no sorting
}

Default is decreasing.}

\item{n.show}{(\code{integer(1)})\cr
Number of features (maximal) to show.
Default is to plot all features.}

\item{filter}{(\code{character(1)})
In case \code{fvalues} contains multiple filter methods, which method should be
plotted?}

\item{feat.type.cols}{(\code{logical(1)})\cr
Whether to color different feature types (e.g. numeric | factor).
Default is to use no colors (\code{feat.type.cols = FALSE}).}
}
\value{
ggplot2 plot object.
}
\description{
Plot filter values using ggplot2.
}
\examples{
fv = generateFilterValuesData(iris.task, method = "variance")
plotFilterValues(fv)
}
\seealso{
Other filter: 
\code{\link{filterFeatures}()},
\code{\link{generateFilterValuesData}()},
\code{\link{getFilteredFeatures}()},
\code{\link{listFilterEnsembleMethods}()},
\code{\link{listFilterMethods}()},
\code{\link{makeFilterEnsemble}()},
\code{\link{makeFilterWrapper}()},
\code{\link{makeFilter}()}

Other generate_plot_data: 
\code{\link{generateCalibrationData}()},
\code{\link{generateCritDifferencesData}()},
\code{\link{generateFeatureImportanceData}()},
\code{\link{generateFilterValuesData}()},
\code{\link{generateLearningCurveData}()},
\code{\link{generatePartialDependenceData}()},
\code{\link{generateThreshVsPerfData}()}
}
\concept{filter}
\concept{generate_plot_data}
