% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configurations.R
\name{removeConfigurationsMetaData}
\alias{removeConfigurationsMetaData}
\title{removeConfigurationsMetaData}
\usage{
removeConfigurationsMetaData(configurations)
}
\arguments{
\item{configurations}{\code{data.frame}\cr Parameter configurations of the
target algorithm (one per row).}
}
\value{
The same data frame without "metadata".
}
\description{
Remove the columns with "metadata" of a data frame containing
configurations. Currently, metadata corresponds to column names starting
with a period.  This function should be used before printing the
configurations to output only the values for the parameters of the
configuration without metadata possibly useless to the user.
}
\seealso{
\code{\link[=configurations_print_command]{configurations_print_command()}} to print the configurations as command lines.
\code{\link[=configurations_print]{configurations_print()}} to print the configurations as a data frame.
}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
