% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-colorsteps.R
\name{guide_coloursteps}
\alias{guide_coloursteps}
\alias{guide_colorsteps}
\title{Discretized colourbar guide}
\usage{
guide_coloursteps(even.steps = TRUE, show.limits = NULL, ticks = FALSE, ...)

guide_colorsteps(even.steps = TRUE, show.limits = NULL, ticks = FALSE, ...)
}
\arguments{
\item{even.steps}{Should the rendered size of the bins be equal, or should
they be proportional to their length in the data space? Defaults to \code{TRUE}}

\item{show.limits}{Logical. Should the limits of the scale be shown with
labels and ticks. Default is \code{NULL} meaning it will take the value from the
scale. This argument is ignored if \code{labels} is given as a vector of
values. If one or both of the limits is also given in \code{breaks} it will be
shown irrespective of the value of \code{show.limits}.}

\item{ticks}{A logical specifying if tick marks on the colourbar should be
visible.}

\item{...}{
  Arguments passed on to \code{\link[=guide_colourbar]{guide_colourbar}}
  \describe{
    \item{\code{barwidth}}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the width of the colourbar. Default value is \code{legend.key.width} or
\code{legend.key.size} in \code{\link[=theme]{theme()}} or theme.}
    \item{\code{barheight}}{A numeric or a \code{\link[grid:unit]{grid::unit()}} object specifying
the height of the colourbar. Default value is \code{legend.key.height} or
\code{legend.key.size} in \code{\link[=theme]{theme()}} or theme.}
    \item{\code{frame.colour}}{A string specifying the colour of the frame
drawn around the bar. If \code{NULL} (the default), no frame is drawn.}
    \item{\code{frame.linewidth}}{A numeric specifying the width of the frame
drawn around the bar in millimetres.}
    \item{\code{frame.linetype}}{A numeric specifying the linetype of the frame
drawn around the bar.}
    \item{\code{ticks.colour}}{A string specifying the colour of the tick marks.}
    \item{\code{ticks.linewidth}}{A numeric specifying the width of the tick marks in
millimetres.}
    \item{\code{draw.ulim}}{A logical specifying if the upper limit tick marks should
be visible.}
    \item{\code{draw.llim}}{A logical specifying if the lower limit tick marks should
be visible.}
    \item{\code{direction}}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}
    \item{\code{default.unit}}{A character string indicating \code{\link[grid:unit]{grid::unit()}}
for \code{barwidth} and \code{barheight}.}
    \item{\code{reverse}}{logical. If \code{TRUE} the colourbar is reversed. By default,
the highest value is on the top and the lowest value is on the bottom}
    \item{\code{title}}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}
    \item{\code{title.position}}{A character string indicating the position of a
title. One of "top" (default for a vertical guide), "bottom", "left"
(default for a horizontal guide), or "right."}
    \item{\code{title.theme}}{A theme object for rendering the title text. Usually the
object of \code{\link[=element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.title} in \code{\link[=theme]{theme()}} or theme.}
    \item{\code{title.hjust}}{A number specifying horizontal justification of the
title text.}
    \item{\code{title.vjust}}{A number specifying vertical justification of the title
text.}
    \item{\code{label}}{logical. If \code{TRUE} then the labels are drawn. If
\code{FALSE} then the labels are invisible.}
    \item{\code{label.position}}{A character string indicating the position of a
label. One of "top", "bottom" (default for horizontal guide), "left", or
"right" (default for vertical guide).}
    \item{\code{label.theme}}{A theme object for rendering the label text. Usually the
object of \code{\link[=element_text]{element_text()}} is expected. By default, the theme is
specified by \code{legend.text} in \code{\link[=theme]{theme()}}.}
    \item{\code{label.hjust}}{A numeric specifying horizontal justification of the
label text. The default for standard text is 0 (left-aligned) and 1
(right-aligned) for expressions.}
    \item{\code{label.vjust}}{A numeric specifying vertical justification of the label
text.}
    \item{\code{order}}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}
  }}
}
\value{
A guide object
}
\description{
This guide is version of \code{\link[=guide_colourbar]{guide_colourbar()}} for binned colour and fill
scales. It shows areas between breaks as a single constant colour instead of
the gradient known from the colourbar counterpart.
}
\section{Use with discrete scale}{

This guide is intended to show binned data and work together with ggplot2's
binning scales. However, it is sometimes desirable to perform the binning in
a separate step, either as part of a stat (e.g. \code{\link[=stat_contour_filled]{stat_contour_filled()}}) or
prior to the visualisation. If you want to use this guide for discrete data
the levels must follow the naming scheme implemented by \code{\link[base:cut]{base::cut()}}. This
means that a bin must be encoded as \code{"(<lower>, <upper>]"} with \verb{<lower>}
giving the lower bound of the bin and \verb{<upper>} giving the upper bound
(\code{"[<lower>, <upper>)"} is also accepted). If you use \code{\link[base:cut]{base::cut()}} to
perform the binning everything should work as expected, if not, some recoding
may be needed.
}

\examples{
df <- expand.grid(X1 = 1:10, X2 = 1:10)
df$value <- df$X1 * df$X2

p <- ggplot(df, aes(X1, X2)) + geom_tile(aes(fill = value))

# Coloursteps guide is the default for binned colour scales
p + scale_fill_binned()

# By default each bin in the guide is the same size irrespectively of how
# their sizes relate in data space
p + scale_fill_binned(breaks = c(10, 25, 50))

# This can be changed with the `even.steps` argument
p + scale_fill_binned(
  breaks = c(10, 25, 50),
  guide = guide_coloursteps(even.steps = FALSE)
)

# By default the limits is not shown, but this can be changed
p + scale_fill_binned(guide = guide_coloursteps(show.limits = TRUE))

# (can also be set in the scale)
p + scale_fill_binned(show.limits = TRUE)

}
\seealso{
Other guides: 
\code{\link{guide_bins}()},
\code{\link{guide_colourbar}()},
\code{\link{guide_legend}()},
\code{\link{guides}()}
}
\concept{guides}
