% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer.r
\name{layer}
\alias{layer}
\title{Create a new layer}
\usage{
layer(geom = NULL, stat = NULL, data = NULL, mapping = NULL,
  position = NULL, params = list(), inherit.aes = TRUE, subset = NULL,
  show.legend = NA)
}
\arguments{
\item{geom, stat, position}{Geom, stat and position adjustment to use in
this layer. Can either be the name of a ggproto object, or the object
itself.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{params}{Additional parameters to the \code{geom} and \code{stat}.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{subset}{DEPRECATED. An older way of subsetting the dataset used in a
layer.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}
}
\description{
Create a new layer
}
\examples{
# geom calls are just a short cut for layer
ggplot(mpg, aes(displ, hwy)) + geom_point()
# shortcut for
ggplot(mpg, aes(displ, hwy)) +
  layer(geom = "point", stat = "identity", position = "identity",
    params = list(na.rm = FALSE)
  )
}

