% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_flextable.R
\name{merge_at}
\alias{merge_at}
\title{Merge flextable cells into a single one}
\usage{
merge_at(x, i = NULL, j = NULL, part = "body")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{j}{column selector, see section \emph{Column selection with the \code{j} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}
}
\description{
Merge flextable cells into a single one. All
rows and columns must be consecutive.
}
\examples{
ft_merge <- flextable(head(mtcars), cwidth = .5)
ft_merge <- merge_at(ft_merge, i = 1:2, j = 1:2)
ft_merge
}
\seealso{
Other flextable merging function: 
\code{\link{merge_h}()},
\code{\link{merge_h_range}()},
\code{\link{merge_none}()},
\code{\link{merge_v}()}
}
\concept{flextable merging function}
