% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmd_args.R
\name{cmd_list_to_flags}
\alias{cmd_list_to_flags}
\title{Convert flag list to vector of command flags}
\usage{
cmd_list_to_flags(flagList, prefix = "-", sep = ",")
}
\arguments{
\item{flagList}{output from cmd_list_interp(). A named list where names
correspond to flags and members correspond to the value for the flag.}

\item{prefix}{flag prefix, usually "-" or "--".}

\item{sep}{separator to use if flag has a vector of values (default: NULL).}
}
\value{
character vector of parsed commandline flags followed by their values
}
\description{
Convert flag list to vector of command flags
}
\examples{
theFunction <- function(...){cmd_args_all()}
theArgs <- theFunction(arg1 = "value", arg2 = TRUE)
flagList <- cmd_list_interp(theArgs)
flags <- cmd_list_to_flags(flagList)
}
