# From the kernel sources, arch/powerpc/kernel/syscalls/syscall.tbl

SYSCALL_NAMES = {
    0: "restart_syscall",
    1: "exit",
    2: "fork",
    3: "read",
    4: "write",
    5: "open",
    6: "close",
    7: "waitpid",
    8: "creat",
    9: "link",
    10: "unlink",
    11: "execve",
    12: "chdir",
    13: "time",
    14: "mknod",
    15: "chmod",
    16: "lchown",
    17: "break",
    18: "oldstat",
    19: "lseek",
    20: "getpid",
    21: "mount",
    22: "umount",
    23: "setuid",
    24: "getuid",
    25: "stime",
    26: "ptrace",
    27: "alarm",
    28: "oldfstat",
    29: "pause",
    30: "utime",
    31: "stty",
    32: "gtty",
    33: "access",
    34: "nice",
    35: "ftime",
    36: "sync",
    37: "kill",
    38: "rename",
    39: "mkdir",
    40: "rmdir",
    41: "dup",
    42: "pipe",
    43: "times",
    44: "prof",
    45: "brk",
    46: "setgid",
    47: "getgid",
    48: "signal",
    49: "geteuid",
    50: "getegid",
    51: "acct",
    52: "umount2",
    53: "lock",
    54: "ioctl",
    55: "fcntl",
    56: "mpx",
    57: "setpgid",
    58: "ulimit",
    59: "oldolduname",
    60: "umask",
    61: "chroot",
    62: "ustat",
    63: "dup2",
    64: "getppid",
    65: "getpgrp",
    66: "setsid",
    67: "sigaction",
    68: "sgetmask",
    69: "ssetmask",
    70: "setreuid",
    71: "setregid",
    72: "sigsuspend",
    73: "sigpending",
    74: "sethostname",
    75: "setrlimit",
    76: "getrlimit",
    77: "getrusage",
    78: "gettimeofday",
    79: "settimeofday",
    80: "getgroups",
    81: "setgroups",
    82: "select",
    83: "symlink",
    84: "oldlstat",
    85: "readlink",
    86: "uselib",
    87: "swapon",
    88: "reboot",
    89: "readdir",
    90: "mmap",
    91: "munmap",
    92: "truncate",
    93: "ftruncate",
    94: "fchmod",
    95: "fchown",
    96: "getpriority",
    97: "setpriority",
    98: "profil",
    99: "statfs",
    100: "fstatfs",
    101: "ioperm",
    102: "socketcall",
    103: "syslog",
    104: "setitimer",
    105: "getitimer",
    106: "stat",
    107: "lstat",
    108: "fstat",
    109: "olduname",
    110: "iopl",
    111: "vhangup",
    112: "idle",
    113: "vm86",
    114: "wait4",
    115: "swapoff",
    116: "sysinfo",
    117: "ipc",
    118: "fsync",
    119: "sigreturn",
    120: "clone",
    121: "setdomainname",
    122: "uname",
    123: "modify_ldt",
    124: "adjtimex",
    125: "mprotect",
    126: "sigprocmask",
    127: "create_module",
    128: "init_module",
    129: "delete_module",
    130: "get_kernel_syms",
    131: "quotactl",
    132: "getpgid",
    133: "fchdir",
    134: "bdflush",
    135: "sysfs",
    136: "personality",
    137: "afs_syscall",
    138: "setfsuid",
    139: "setfsgid",
    140: "_llseek",
    141: "getdents",
    142: "_newselect",
    143: "flock",
    144: "msync",
    145: "readv",
    146: "writev",
    147: "getsid",
    148: "fdatasync",
    149: "_sysctl",
    150: "mlock",
    151: "munlock",
    152: "mlockall",
    153: "munlockall",
    154: "sched_setparam",
    155: "sched_getparam",
    156: "sched_setscheduler",
    157: "sched_getscheduler",
    158: "sched_yield",
    159: "sched_get_priority_max",
    160: "sched_get_priority_min",
    161: "sched_rr_get_interval",
    162: "nanosleep",
    163: "mremap",
    164: "setresuid",
    165: "getresuid",
    166: "query_module",
    167: "poll",
    168: "nfsservctl",
    169: "setresgid",
    170: "getresgid",
    171: "prctl",
    172: "rt_sigreturn",
    173: "rt_sigaction",
    174: "rt_sigprocmask",
    175: "rt_sigpending",
    176: "rt_sigtimedwait",
    177: "",
    178: "",
    179: "pread64",
    180: "pwrite64",
    181: "chown",
    182: "getcwd",
    183: "capget",
    184: "capset",
    185: "sigaltstack",
    186: "sendfile",
    187: "getpmsg",
    188: "",
    189: "vfork",
    190: "ugetrlimit",
    191: "readahead",
    192: "mmap2",
    193: "truncate64",
    194: "ftruncate64",
    195: "stat64",
    196: "lstat64",
    197: "fstat64",
    198: "",
    199: "",
    200: "",
    201: "",
    202: "getdents64",
    203: "pivot_root",
    204: "fcntl64",
    205: "madvise",
    206: "mincore",
    207: "gettid",
    208: "tkill",
    209: "setxattr",
    210: "lsetxattr",
    211: "fsetxattr",
    212: "getxattr",
    213: "lgetxattr",
    214: "fgetxattr",
    215: "listxattr",
    216: "llistxattr",
    217: "flistxattr",
    218: "removexattr",
    219: "lremovexattr",
    220: "fremovexattr",
    221: "futex",
    222: "sched_setaffinity",
    223: "sched_getaffinity",
    225: "tuxcall",
    226: "sendfile64",
    227: "io_setup",
    228: "io_destroy",
    229: "io_getevents",
    230: "io_submit",
    231: "io_cancel",
    232: "set_tid_address",
    233: "fadvise64",
    234: "exit_group",
    235: "lookup_dcookie",
    236: "epoll_create",
    237: "epoll_ctl",
    238: "epoll_wait",
    239: "remap_file_pages",
    240: "timer_create",
    241: "timer_settime",
    242: "timer_gettime",
    243: "timer_getoverrun",
    244: "timer_delete",
    245: "clock_settime",
    246: "clock_gettime",
    247: "clock_getres",
    248: "clock_nanosleep",
    249: "swapcontext",
    250: "tgkill",
    251: "utimes",
    252: "statfs64",
    253: "fstatfs64",
    254: "fadvise64_64",
    255: "rtas",
    256: "sys_debug_setcontext",
    258: "migrate_pages",
    259: "mbind",
    260: "get_mempolicy",
    261: "set_mempolicy",
    262: "mq_open",
    263: "mq_unlink",
    264: "mq_timedsend",
    265: "mq_timedreceive",
    266: "mq_notify",
    267: "mq_getsetattr",
    268: "kexec_load",
    269: "add_key",
    270: "request_key",
    271: "keyctl",
    272: "waitid",
    273: "ioprio_set",
    274: "ioprio_get",
    275: "inotify_init",
    276: "inotify_add_watch",
    277: "inotify_rm_watch",
    280: "pselect6",
    281: "ppoll",
    282: "unshare",
    283: "splice",
    284: "tee",
    285: "vmsplice",
    286: "openat",
    287: "mkdirat",
    288: "mknodat",
    289: "fchownat",
    290: "futimesat",
    291: "fstatat64",
    292: "unlinkat",
    293: "renameat",
    294: "linkat",
    295: "symlinkat",
    296: "readlinkat",
    297: "fchmodat",
    298: "faccessat",
    299: "get_robust_list",
    300: "set_robust_list",
    301: "move_pages",
    302: "getcpu",
    303: "epoll_pwait",
    304: "utimensat",
    305: "signalfd",
    306: "timerfd_create",
    307: "eventfd",
    308: "sync_file_range2",
    309: "fallocate",
    310: "subpage_prot",
    311: "timerfd_settime",
    312: "timerfd_gettime",
    313: "signalfd4",
    314: "eventfd2",
    315: "epoll_create1",
    316: "dup3",
    317: "pipe2",
    318: "inotify_init1",
    319: "perf_event_open",
    320: "preadv",
    321: "pwritev",
    322: "rt_tgsigqueueinfo",
    323: "fanotify_init",
    324: "fanotify_mark",
    325: "prlimit64",
    326: "socket",
    327: "bind",
    328: "connect",
    329: "listen",
    330: "accept",
    331: "getsockname",
    332: "getpeername",
    333: "socketpair",
    334: "send",
    335: "sendto",
    336: "recv",
    337: "recvfrom",
    338: "shutdown",
    339: "setsockopt",
    340: "getsockopt",
    341: "sendmsg",
    342: "recvmsg",
    343: "recvmmsg",
    344: "accept4",
    345: "name_to_handle_at",
    346: "open_by_handle_at",
    347: "clock_adjtime",
    348: "syncfs",
    349: "sendmmsg",
    350: "setns",
    351: "process_vm_readv",
    352: "process_vm_writev",
    353: "finit_module",
    354: "kcmp",
    355: "sched_setattr",
    356: "sched_getattr",
    357: "renameat2",
    358: "seccomp",
    359: "getrandom",
    360: "memfd_create",
    361: "bpf",
    362: "execveat",
    363: "switch_endian",
    364: "userfaultfd",
    365: "membarrier",
    378: "mlock2",
    379: "copy_file_range",
    380: "preadv2",
    381: "pwritev2",
    382: "kexec_file_load",
    383: "statx",
    384: "pkey_alloc",
    385: "pkey_free",
    386: "pkey_mprotect",
    387: "rseq",
    388: "io_pgetevents",
    393: "semget",
    394: "semctl",
    395: "shmget",
    396: "shmctl",
    397: "shmat",
    398: "shmdt",
    399: "msgget",
    400: "msgsnd",
    401: "msgrcv",
    402: "msgctl",
    403: "clock_gettime64",
    404: "clock_settime64",
    405: "clock_adjtime64",
    406: "clock_getres_time64",
    407: "clock_nanosleep_time64",
    408: "timer_gettime64",
    409: "timer_settime64",
    410: "timerfd_gettime64",
    411: "timerfd_settime64",
    412: "utimensat_time64",
    413: "pselect6_time64",
    414: "ppoll_time64",
    416: "io_pgetevents_time64",
    417: "recvmmsg_time64",
    418: "mq_timedsend_time64",
    419: "mq_timedreceive_time64",
    420: "semtimedop_time64",
    421: "rt_sigtimedwait_time64",
    422: "futex_time64",
    423: "sched_rr_get_interval_time64",
    424: "pidfd_send_signal",
    425: "io_uring_setup",
    426: "io_uring_enter",
    427: "io_uring_register",
    428: "open_tree",
    429: "move_mount",
    430: "fsopen",
    431: "fsconfig",
    432: "fsmount",
    433: "fspick",
    434: "pidfd_open",
    435: "clone3",
    437: "openat2",
    438: "pidfd_getfd"
}

SOCKET_SYSCALL_NAMES = set((
    "socket",
    "socketpair",
    "connect",
    "sendto",
    "recvfrom",
    "sendmsg",
    "recvmsg",
    "bind",
    "listen",
    "accept",
    "getsockname",
    "getpeername",
    "getsockopt",
    "setsockopt",
    "shutdown",
))
