# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class TaskIdentifier(_serialization.Model):
    """Base task object.

    :ivar task_name:
    :vartype task_name: str
    """

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        """
        super().__init__(**kwargs)
        self.task_name = task_name


class TaskState(_serialization.Model):
    """TaskState.

    All required parameters must be populated in order to send to Azure.

    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        **kwargs
    ):
        """
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        """
        super().__init__(**kwargs)
        self.last_update_date_time = last_update_date_time
        self.status = status


class AnalyzeTextLROResult(TaskState, TaskIdentifier):
    """AnalyzeTextLROResult.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AbstractiveSummarizationLROResult, CustomEntityRecognitionLROResult,
    CustomMultiLabelClassificationLROResult, CustomSingleLabelClassificationLROResult,
    EntityLinkingLROResult, EntityRecognitionLROResult, ExtractiveSummarizationLROResult,
    HealthcareLROResult, KeyPhraseExtractionLROResult, PiiEntityRecognitionLROResult,
    SentimentLROResult

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        'kind': {'AbstractiveSummarizationLROResults': 'AbstractiveSummarizationLROResult', 'CustomEntityRecognitionLROResults': 'CustomEntityRecognitionLROResult', 'CustomMultiLabelClassificationLROResults': 'CustomMultiLabelClassificationLROResult', 'CustomSingleLabelClassificationLROResults': 'CustomSingleLabelClassificationLROResult', 'EntityLinkingLROResults': 'EntityLinkingLROResult', 'EntityRecognitionLROResults': 'EntityRecognitionLROResult', 'ExtractiveSummarizationLROResults': 'ExtractiveSummarizationLROResult', 'HealthcareLROResults': 'HealthcareLROResult', 'KeyPhraseExtractionLROResults': 'KeyPhraseExtractionLROResult', 'PiiEntityRecognitionLROResults': 'PiiEntityRecognitionLROResult', 'SentimentAnalysisLROResults': 'SentimentLROResult'}
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        """
        super().__init__(last_update_date_time=last_update_date_time, status=status, task_name=task_name, **kwargs)
        self.task_name = task_name
        self.kind = None  # type: Optional[str]
        self.last_update_date_time = last_update_date_time
        self.status = status


class AbstractiveSummarizationLROResult(AnalyzeTextLROResult):
    """An object representing the results for an Abstractive Summarization task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: An object representing the pre-build summarization results of each document.
     Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummarizationResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "AbstractiveSummarizationResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.AbstractiveSummarizationResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: An object representing the pre-build summarization results of each document.
         Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummarizationResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'AbstractiveSummarizationLROResults'  # type: str
        self.results = results


class AnalyzeTextLROTask(TaskIdentifier):
    """AnalyzeTextLROTask.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AbstractiveSummarizationLROTask, CustomEntitiesLROTask, CustomMultiLabelClassificationLROTask,
    CustomSingleLabelClassificationLROTask, EntityLinkingLROTask, EntitiesLROTask,
    ExtractiveSummarizationLROTask, HealthcareLROTask, KeyPhraseLROTask, PiiLROTask,
    SentimentAnalysisLROTask

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        'kind': {'AbstractiveSummarization': 'AbstractiveSummarizationLROTask', 'CustomEntityRecognition': 'CustomEntitiesLROTask', 'CustomMultiLabelClassification': 'CustomMultiLabelClassificationLROTask', 'CustomSingleLabelClassification': 'CustomSingleLabelClassificationLROTask', 'EntityLinking': 'EntityLinkingLROTask', 'EntityRecognition': 'EntitiesLROTask', 'ExtractiveSummarization': 'ExtractiveSummarizationLROTask', 'Healthcare': 'HealthcareLROTask', 'KeyPhraseExtraction': 'KeyPhraseLROTask', 'PiiEntityRecognition': 'PiiLROTask', 'SentimentAnalysis': 'SentimentAnalysisLROTask'}
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = None  # type: Optional[str]


class AbstractiveSummarizationLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for an Abstractive Summarization task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for the pre-build Abstractive Summarization task.
     Required.
    :vartype parameters:
     ~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummarizationTaskParameters
    """

    _validation = {
        'kind': {'required': True},
        'parameters': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "AbstractiveSummarizationTaskParameters"},
    }

    def __init__(
        self,
        *,
        parameters: "_models.AbstractiveSummarizationTaskParameters",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for the pre-build Abstractive Summarization task.
         Required.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummarizationTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'AbstractiveSummarization'  # type: str
        self.parameters = parameters


class PreBuiltResult(_serialization.Model):
    """PreBuiltResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        """
        super().__init__(**kwargs)
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version


class AbstractiveSummarizationResultBase(_serialization.Model):
    """An object representing the summarization results of each document.

    All required parameters must be populated in order to send to Azure.

    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummaryDocumentResult]
    """

    _validation = {
        'documents': {'required': True},
    }

    _attribute_map = {
        "documents": {"key": "documents", "type": "[AbstractiveSummaryDocumentResult]"},
    }

    def __init__(
        self,
        *,
        documents: List["_models.AbstractiveSummaryDocumentResult"],
        **kwargs
    ):
        """
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummaryDocumentResult]
        """
        super().__init__(**kwargs)
        self.documents = documents


class AbstractiveSummarizationResult(AbstractiveSummarizationResultBase, PreBuiltResult):
    """An object representing the pre-build summarization results of each document.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummaryDocumentResult]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[AbstractiveSummaryDocumentResult]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.AbstractiveSummaryDocumentResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummaryDocumentResult]
        """
        super().__init__(documents=documents, errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.errors = errors
        self.statistics = statistics
        self.model_version = model_version
        self.documents = documents


class TaskParameters(_serialization.Model):
    """Base parameters object for a text analysis task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        """
        super().__init__(**kwargs)
        self.logging_opt_out = logging_opt_out


class PreBuiltTaskParameters(TaskParameters):
    """Parameters object for a text analysis task using pre-built models.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        """
        super().__init__(logging_opt_out=logging_opt_out, **kwargs)
        self.model_version = model_version


class AbstractiveSummarizationTaskParametersBase(_serialization.Model):
    """Supported parameters for an Abstractive Summarization task.

    :ivar sentence_count: It controls the approximate number of sentences in the output summaries.
    :vartype sentence_count: int
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _attribute_map = {
        "sentence_count": {"key": "sentenceCount", "type": "int"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        sentence_count: Optional[int] = None,
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword sentence_count: It controls the approximate number of sentences in the output
         summaries.
        :paramtype sentence_count: int
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(**kwargs)
        self.sentence_count = sentence_count
        self.string_index_type = string_index_type


class AbstractiveSummarizationTaskParameters(AbstractiveSummarizationTaskParametersBase, PreBuiltTaskParameters):
    """Supported parameters for the pre-build Abstractive Summarization task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar sentence_count: It controls the approximate number of sentences in the output summaries.
    :vartype sentence_count: int
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "sentence_count": {"key": "sentenceCount", "type": "int"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        sentence_count: Optional[int] = None,
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword sentence_count: It controls the approximate number of sentences in the output
         summaries.
        :paramtype sentence_count: int
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(sentence_count=sentence_count, string_index_type=string_index_type, logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.logging_opt_out = logging_opt_out
        self.model_version = model_version
        self.sentence_count = sentence_count
        self.string_index_type = string_index_type


class AbstractiveSummary(_serialization.Model):
    """An object representing a single summary with context for given document.

    All required parameters must be populated in order to send to Azure.

    :ivar text: The text of the summary. Required.
    :vartype text: str
    :ivar contexts: The context list of the summary.
    :vartype contexts: list[~azure.ai.textanalytics.v2023_04_01.models.SummaryContext]
    """

    _validation = {
        'text': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "contexts": {"key": "contexts", "type": "[SummaryContext]"},
    }

    def __init__(
        self,
        *,
        text: str,
        contexts: Optional[List["_models.SummaryContext"]] = None,
        **kwargs
    ):
        """
        :keyword text: The text of the summary. Required.
        :paramtype text: str
        :keyword contexts: The context list of the summary.
        :paramtype contexts: list[~azure.ai.textanalytics.v2023_04_01.models.SummaryContext]
        """
        super().__init__(**kwargs)
        self.text = text
        self.contexts = contexts


class DocumentResult(_serialization.Model):
    """DocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        """
        super().__init__(**kwargs)
        self.id = id
        self.warnings = warnings
        self.statistics = statistics


class AbstractiveSummaryDocumentResult(DocumentResult):
    """An object representing the summarization result of a single document.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar summaries: A list of abstractive summaries. Required.
    :vartype summaries: list[~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummary]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'summaries': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "summaries": {"key": "summaries", "type": "[AbstractiveSummary]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        summaries: List["_models.AbstractiveSummary"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword summaries: A list of abstractive summaries. Required.
        :paramtype summaries: list[~azure.ai.textanalytics.v2023_04_01.models.AbstractiveSummary]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.summaries = summaries


class AnalyzeTextTask(_serialization.Model):
    """AnalyzeTextTask.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AnalyzeTextEntityLinkingInput, AnalyzeTextEntityRecognitionInput,
    AnalyzeTextKeyPhraseExtractionInput, AnalyzeTextLanguageDetectionInput,
    AnalyzeTextPiiEntitiesRecognitionInput, AnalyzeTextSentimentAnalysisInput

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis tasks. Required. Known values are:
     "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "LanguageDetection", and "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        'kind': {'EntityLinking': 'AnalyzeTextEntityLinkingInput', 'EntityRecognition': 'AnalyzeTextEntityRecognitionInput', 'KeyPhraseExtraction': 'AnalyzeTextKeyPhraseExtractionInput', 'LanguageDetection': 'AnalyzeTextLanguageDetectionInput', 'PiiEntityRecognition': 'AnalyzeTextPiiEntitiesRecognitionInput', 'SentimentAnalysis': 'AnalyzeTextSentimentAnalysisInput'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class AnalyzeTextEntityLinkingInput(AnalyzeTextTask):
    """AnalyzeTextEntityLinkingInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis tasks. Required. Known values are:
     "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "LanguageDetection", and "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for an Entity Linking task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageAnalysisInput"},
        "parameters": {"key": "parameters", "type": "EntityLinkingTaskParameters"},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.EntityLinkingTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for an Entity Linking task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingTaskParameters
        """
        super().__init__(**kwargs)
        self.kind = 'EntityLinking'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextEntityRecognitionInput(AnalyzeTextTask):
    """AnalyzeTextEntityRecognitionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis tasks. Required. Known values are:
     "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "LanguageDetection", and "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for an Entity Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageAnalysisInput"},
        "parameters": {"key": "parameters", "type": "EntitiesTaskParameters"},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.EntitiesTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for an Entity Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesTaskParameters
        """
        super().__init__(**kwargs)
        self.kind = 'EntityRecognition'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextJobsInput(_serialization.Model):
    """AnalyzeTextJobsInput.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: Optional display name for the analysis job.
    :vartype display_name: str
    :ivar analysis_input: Required.
    :vartype analysis_input: ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
    :ivar tasks: The set of tasks to execute on the input documents. Required.
    :vartype tasks: list[~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTask]
    """

    _validation = {
        'analysis_input': {'required': True},
        'tasks': {'required': True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageAnalysisInput"},
        "tasks": {"key": "tasks", "type": "[AnalyzeTextLROTask]"},
    }

    def __init__(
        self,
        *,
        analysis_input: "_models.MultiLanguageAnalysisInput",
        tasks: List["_models.AnalyzeTextLROTask"],
        display_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: Optional display name for the analysis job.
        :paramtype display_name: str
        :keyword analysis_input: Required.
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
        :keyword tasks: The set of tasks to execute on the input documents. Required.
        :paramtype tasks: list[~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTask]
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.analysis_input = analysis_input
        self.tasks = tasks


class AnalyzeTextJobStatistics(_serialization.Model):
    """AnalyzeTextJobStatistics.

    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    """

    _attribute_map = {
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
    }

    def __init__(
        self,
        *,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        """
        super().__init__(**kwargs)
        self.statistics = statistics


class TasksState(_serialization.Model):
    """TasksState.

    All required parameters must be populated in order to send to Azure.

    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v2023_04_01.models.TasksStateTasks
    """

    _validation = {
        'tasks': {'required': True},
    }

    _attribute_map = {
        "tasks": {"key": "tasks", "type": "TasksStateTasks"},
    }

    def __init__(
        self,
        *,
        tasks: "_models.TasksStateTasks",
        **kwargs
    ):
        """
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v2023_04_01.models.TasksStateTasks
        """
        super().__init__(**kwargs)
        self.tasks = tasks


class JobState(_serialization.Model):
    """JobState.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "expiration_date_time": {"key": "expirationDateTime", "type": "iso-8601"},
        "job_id": {"key": "jobId", "type": "str"},
        "last_update_date_time": {"key": "lastUpdatedDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "errors", "type": "[Error]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[List["_models.Error"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.errors = errors
        self.next_link = next_link


class AnalyzeTextJobState(JobState, TasksState, AnalyzeTextJobStatistics):
    """AnalyzeTextJobState.

    All required parameters must be populated in order to send to Azure.

    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar tasks: Required.
    :vartype tasks: ~azure.ai.textanalytics.v2023_04_01.models.TasksStateTasks
    :ivar display_name:
    :vartype display_name: str
    :ivar created_date_time: Required.
    :vartype created_date_time: ~datetime.datetime
    :ivar expiration_date_time:
    :vartype expiration_date_time: ~datetime.datetime
    :ivar job_id: Required.
    :vartype job_id: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'tasks': {'required': True},
        'created_date_time': {'required': True},
        'job_id': {'required': True},
        'last_update_date_time': {'required': True},
        'status': {'required': True},
    }

    _attribute_map = {
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "tasks": {"key": "tasks", "type": "TasksStateTasks"},
        "display_name": {"key": "displayName", "type": "str"},
        "created_date_time": {"key": "createdDateTime", "type": "iso-8601"},
        "expiration_date_time": {"key": "expirationDateTime", "type": "iso-8601"},
        "job_id": {"key": "jobId", "type": "str"},
        "last_update_date_time": {"key": "lastUpdatedDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "errors": {"key": "errors", "type": "[Error]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks: "_models.TasksStateTasks",
        created_date_time: datetime.datetime,
        job_id: str,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        statistics: Optional["_models.RequestStatistics"] = None,
        display_name: Optional[str] = None,
        expiration_date_time: Optional[datetime.datetime] = None,
        errors: Optional[List["_models.Error"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword tasks: Required.
        :paramtype tasks: ~azure.ai.textanalytics.v2023_04_01.models.TasksStateTasks
        :keyword display_name:
        :paramtype display_name: str
        :keyword created_date_time: Required.
        :paramtype created_date_time: ~datetime.datetime
        :keyword expiration_date_time:
        :paramtype expiration_date_time: ~datetime.datetime
        :keyword job_id: Required.
        :paramtype job_id: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(display_name=display_name, created_date_time=created_date_time, expiration_date_time=expiration_date_time, job_id=job_id, last_update_date_time=last_update_date_time, status=status, errors=errors, next_link=next_link, tasks=tasks, statistics=statistics, **kwargs)
        self.statistics = statistics
        self.tasks = tasks
        self.display_name = display_name
        self.created_date_time = created_date_time
        self.expiration_date_time = expiration_date_time
        self.job_id = job_id
        self.last_update_date_time = last_update_date_time
        self.status = status
        self.errors = errors
        self.next_link = next_link


class AnalyzeTextKeyPhraseExtractionInput(AnalyzeTextTask):
    """AnalyzeTextKeyPhraseExtractionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis tasks. Required. Known values are:
     "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "LanguageDetection", and "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for a Key Phrase Extraction task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageAnalysisInput"},
        "parameters": {"key": "parameters", "type": "KeyPhraseTaskParameters"},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.KeyPhraseTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for a Key Phrase Extraction task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseTaskParameters
        """
        super().__init__(**kwargs)
        self.kind = 'KeyPhraseExtraction'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextLanguageDetectionInput(AnalyzeTextTask):
    """AnalyzeTextLanguageDetectionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis tasks. Required. Known values are:
     "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "LanguageDetection", and "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input:
     ~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionAnalysisInput
    :ivar parameters: Supported parameters for a Language Detection task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "analysis_input": {"key": "analysisInput", "type": "LanguageDetectionAnalysisInput"},
        "parameters": {"key": "parameters", "type": "LanguageDetectionTaskParameters"},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.LanguageDetectionAnalysisInput"] = None,
        parameters: Optional["_models.LanguageDetectionTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionAnalysisInput
        :keyword parameters: Supported parameters for a Language Detection task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionTaskParameters
        """
        super().__init__(**kwargs)
        self.kind = 'LanguageDetection'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextPiiEntitiesRecognitionInput(AnalyzeTextTask):
    """AnalyzeTextPiiEntitiesRecognitionInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis tasks. Required. Known values are:
     "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "LanguageDetection", and "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for a PII Entities Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.PiiTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageAnalysisInput"},
        "parameters": {"key": "parameters", "type": "PiiTaskParameters"},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.PiiTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for a PII Entities Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.PiiTaskParameters
        """
        super().__init__(**kwargs)
        self.kind = 'PiiEntityRecognition'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextSentimentAnalysisInput(AnalyzeTextTask):
    """AnalyzeTextSentimentAnalysisInput.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis tasks. Required. Known values are:
     "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "LanguageDetection", and "EntityLinking".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskKind
    :ivar analysis_input:
    :vartype analysis_input: ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
    :ivar parameters: Supported parameters for a Sentiment Analysis task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.SentimentAnalysisTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "analysis_input": {"key": "analysisInput", "type": "MultiLanguageAnalysisInput"},
        "parameters": {"key": "parameters", "type": "SentimentAnalysisTaskParameters"},
    }

    def __init__(
        self,
        *,
        analysis_input: Optional["_models.MultiLanguageAnalysisInput"] = None,
        parameters: Optional["_models.SentimentAnalysisTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword analysis_input:
        :paramtype analysis_input:
         ~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageAnalysisInput
        :keyword parameters: Supported parameters for a Sentiment Analysis task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2023_04_01.models.SentimentAnalysisTaskParameters
        """
        super().__init__(**kwargs)
        self.kind = 'SentimentAnalysis'  # type: str
        self.analysis_input = analysis_input
        self.parameters = parameters


class AnalyzeTextTaskResult(_serialization.Model):
    """AnalyzeTextTaskResult.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EntityLinkingTaskResult, EntitiesTaskResult, KeyPhraseTaskResult, LanguageDetectionTaskResult,
    PiiTaskResult, SentimentTaskResult

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis task results. Required. Known values are:
     "SentimentAnalysisResults", "EntityRecognitionResults", "PiiEntityRecognitionResults",
     "KeyPhraseExtractionResults", "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskResultsKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        'kind': {'EntityLinkingResults': 'EntityLinkingTaskResult', 'EntityRecognitionResults': 'EntitiesTaskResult', 'KeyPhraseExtractionResults': 'KeyPhraseTaskResult', 'LanguageDetectionResults': 'LanguageDetectionTaskResult', 'PiiEntityRecognitionResults': 'PiiTaskResult', 'SentimentAnalysisResults': 'SentimentTaskResult'}
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ClassificationDocumentResult(DocumentResult):
    """ClassificationDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar class_property: Required.
    :vartype class_property: list[~azure.ai.textanalytics.v2023_04_01.models.ClassificationResult]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'class_property': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "class_property": {"key": "class", "type": "[ClassificationResult]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        class_property: List["_models.ClassificationResult"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword class_property: Required.
        :paramtype class_property:
         list[~azure.ai.textanalytics.v2023_04_01.models.ClassificationResult]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.class_property = class_property


class ClassificationResult(_serialization.Model):
    """ClassificationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar category: Classification type. Required.
    :vartype category: str
    :ivar confidence_score: Confidence score between 0 and 1 of the recognized class. Required.
    :vartype confidence_score: float
    """

    _validation = {
        'category': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "category": {"key": "category", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
    }

    def __init__(
        self,
        *,
        category: str,
        confidence_score: float,
        **kwargs
    ):
        """
        :keyword category: Classification type. Required.
        :paramtype category: str
        :keyword confidence_score: Confidence score between 0 and 1 of the recognized class. Required.
        :paramtype confidence_score: float
        """
        super().__init__(**kwargs)
        self.category = category
        self.confidence_score = confidence_score


class CustomEntitiesLROTask(AnalyzeTextLROTask):
    """Use custom models to ease the process of information extraction from unstructured documents like contracts or financial documents.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Custom Entities task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.CustomEntitiesTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "CustomEntitiesTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.CustomEntitiesTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Custom Entities task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.CustomEntitiesTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'CustomEntityRecognition'  # type: str
        self.parameters = parameters


class CustomResult(_serialization.Model):
    """CustomResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    """

    _validation = {
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "project_name": {"key": "projectName", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword project_name: This field indicates the project name for the model. Required.
        :paramtype project_name: str
        :keyword deployment_name: This field indicates the deployment name for the model. Required.
        :paramtype deployment_name: str
        """
        super().__init__(**kwargs)
        self.errors = errors
        self.statistics = statistics
        self.project_name = project_name
        self.deployment_name = deployment_name


class CustomEntitiesResult(CustomResult):
    """CustomEntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.CustomEntitiesResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "project_name": {"key": "projectName", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
        "documents": {"key": "documents", "type": "[CustomEntitiesResultDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        documents: List["_models.CustomEntitiesResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword project_name: This field indicates the project name for the model. Required.
        :paramtype project_name: str
        :keyword deployment_name: This field indicates the deployment name for the model. Required.
        :paramtype deployment_name: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.CustomEntitiesResultDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, project_name=project_name, deployment_name=deployment_name, **kwargs)
        self.documents = documents


class EntitiesDocumentResult(DocumentResult):
    """EntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "entities": {"key": "entities", "type": "[Entity]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword entities: Recognized entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.entities = entities


class CustomEntitiesResultDocumentsItem(EntitiesDocumentResult):
    """CustomEntitiesResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "entities": {"key": "entities", "type": "[Entity]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword entities: Recognized entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, **kwargs)


class CustomTaskParameters(TaskParameters):
    """Parameters object for a text analysis task using custom models.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "project_name": {"key": "projectName", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: bool = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: This field indicates the project name for the model. Required.
        :paramtype project_name: str
        :keyword deployment_name: This field indicates the deployment name for the model. Required.
        :paramtype deployment_name: str
        """
        super().__init__(logging_opt_out=logging_opt_out, **kwargs)
        self.project_name = project_name
        self.deployment_name = deployment_name


class CustomEntitiesTaskParameters(CustomTaskParameters):
    """Supported parameters for a Custom Entities task.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "project_name": {"key": "projectName", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: bool = False,
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: This field indicates the project name for the model. Required.
        :paramtype project_name: str
        :keyword deployment_name: This field indicates the deployment name for the model. Required.
        :paramtype deployment_name: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(logging_opt_out=logging_opt_out, project_name=project_name, deployment_name=deployment_name, **kwargs)
        self.string_index_type = string_index_type


class CustomEntityRecognitionLROResult(AnalyzeTextLROResult):
    """CustomEntityRecognitionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.CustomEntitiesResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "CustomEntitiesResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.CustomEntitiesResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.CustomEntitiesResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'CustomEntityRecognitionLROResults'  # type: str
        self.results = results


class CustomLabelClassificationResult(CustomResult):
    """CustomLabelClassificationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.CustomLabelClassificationResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'project_name': {'required': True},
        'deployment_name': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "project_name": {"key": "projectName", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
        "documents": {"key": "documents", "type": "[CustomLabelClassificationResultDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        project_name: str,
        deployment_name: str,
        documents: List["_models.CustomLabelClassificationResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword project_name: This field indicates the project name for the model. Required.
        :paramtype project_name: str
        :keyword deployment_name: This field indicates the deployment name for the model. Required.
        :paramtype deployment_name: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.CustomLabelClassificationResultDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, project_name=project_name, deployment_name=deployment_name, **kwargs)
        self.documents = documents


class CustomLabelClassificationResultDocumentsItem(ClassificationDocumentResult):
    """CustomLabelClassificationResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar class_property: Required.
    :vartype class_property: list[~azure.ai.textanalytics.v2023_04_01.models.ClassificationResult]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'class_property': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "class_property": {"key": "class", "type": "[ClassificationResult]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        class_property: List["_models.ClassificationResult"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword class_property: Required.
        :paramtype class_property:
         list[~azure.ai.textanalytics.v2023_04_01.models.ClassificationResult]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, class_property=class_property, **kwargs)


class CustomMultiLabelClassificationLROResult(AnalyzeTextLROResult):
    """CustomMultiLabelClassificationLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.CustomLabelClassificationResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "CustomLabelClassificationResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.CustomLabelClassificationResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.CustomLabelClassificationResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'CustomMultiLabelClassificationLROResults'  # type: str
        self.results = results


class CustomMultiLabelClassificationLROTask(AnalyzeTextLROTask):
    """Use custom models to classify text into multi label taxonomy.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Custom Multi Classification task.
    :vartype parameters:
     ~azure.ai.textanalytics.v2023_04_01.models.CustomMultiLabelClassificationTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "CustomMultiLabelClassificationTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.CustomMultiLabelClassificationTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Custom Multi Classification task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2023_04_01.models.CustomMultiLabelClassificationTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'CustomMultiLabelClassification'  # type: str
        self.parameters = parameters


class CustomMultiLabelClassificationTaskParameters(CustomTaskParameters):
    """Supported parameters for a Custom Multi Classification task.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "project_name": {"key": "projectName", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: bool = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: This field indicates the project name for the model. Required.
        :paramtype project_name: str
        :keyword deployment_name: This field indicates the deployment name for the model. Required.
        :paramtype deployment_name: str
        """
        super().__init__(logging_opt_out=logging_opt_out, project_name=project_name, deployment_name=deployment_name, **kwargs)


class CustomSingleLabelClassificationLROResult(AnalyzeTextLROResult):
    """CustomSingleLabelClassificationLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.CustomLabelClassificationResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "CustomLabelClassificationResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.CustomLabelClassificationResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.CustomLabelClassificationResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'CustomSingleLabelClassificationLROResults'  # type: str
        self.results = results


class CustomSingleLabelClassificationLROTask(AnalyzeTextLROTask):
    """Use custom models to classify text into single label taxonomy.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Custom Single Classification task.
    :vartype parameters:
     ~azure.ai.textanalytics.v2023_04_01.models.CustomSingleLabelClassificationTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "CustomSingleLabelClassificationTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.CustomSingleLabelClassificationTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Custom Single Classification task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2023_04_01.models.CustomSingleLabelClassificationTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'CustomSingleLabelClassification'  # type: str
        self.parameters = parameters


class CustomSingleLabelClassificationTaskParameters(CustomTaskParameters):
    """Supported parameters for a Custom Single Classification task.

    All required parameters must be populated in order to send to Azure.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar project_name: This field indicates the project name for the model. Required.
    :vartype project_name: str
    :ivar deployment_name: This field indicates the deployment name for the model. Required.
    :vartype deployment_name: str
    """

    _validation = {
        'project_name': {'required': True},
        'deployment_name': {'required': True},
    }

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "project_name": {"key": "projectName", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        project_name: str,
        deployment_name: str,
        logging_opt_out: bool = False,
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword project_name: This field indicates the project name for the model. Required.
        :paramtype project_name: str
        :keyword deployment_name: This field indicates the deployment name for the model. Required.
        :paramtype deployment_name: str
        """
        super().__init__(logging_opt_out=logging_opt_out, project_name=project_name, deployment_name=deployment_name, **kwargs)


class DetectedLanguage(_serialization.Model):
    """DetectedLanguage.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Long name of a detected language (e.g. English, French). Required.
    :vartype name: str
    :ivar iso6391_name: A two letter representation of the detected language according to the ISO
     639-1 standard (e.g. en, fr). Required.
    :vartype iso6391_name: str
    :ivar confidence_score: A confidence score between 0 and 1. Scores close to 1 indicate 100%
     certainty that the identified language is true. Required.
    :vartype confidence_score: float
    """

    _validation = {
        'name': {'required': True},
        'iso6391_name': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "iso6391_name": {"key": "iso6391Name", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
    }

    def __init__(
        self,
        *,
        name: str,
        iso6391_name: str,
        confidence_score: float,
        **kwargs
    ):
        """
        :keyword name: Long name of a detected language (e.g. English, French). Required.
        :paramtype name: str
        :keyword iso6391_name: A two letter representation of the detected language according to the
         ISO 639-1 standard (e.g. en, fr). Required.
        :paramtype iso6391_name: str
        :keyword confidence_score: A confidence score between 0 and 1. Scores close to 1 indicate 100%
         certainty that the identified language is true. Required.
        :paramtype confidence_score: float
        """
        super().__init__(**kwargs)
        self.name = name
        self.iso6391_name = iso6391_name
        self.confidence_score = confidence_score


class DocumentError(_serialization.Model):
    """Contains details of errors encountered during a job execution.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The ID of the input document. Required.
    :vartype id: str
    :ivar error: Error encountered. Required.
    :vartype error: ~azure.ai.textanalytics.v2023_04_01.models.Error
    """

    _validation = {
        'id': {'required': True},
        'error': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        error: "_models.Error",
        **kwargs
    ):
        """
        :keyword id: The ID of the input document. Required.
        :paramtype id: str
        :keyword error: Error encountered. Required.
        :paramtype error: ~azure.ai.textanalytics.v2023_04_01.models.Error
        """
        super().__init__(**kwargs)
        self.id = id
        self.error = error


class DocumentStatistics(_serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the document payload.

    All required parameters must be populated in order to send to Azure.

    :ivar characters_count: Number of text elements recognized in the document. Required.
    :vartype characters_count: int
    :ivar transactions_count: Number of transactions for the document. Required.
    :vartype transactions_count: int
    """

    _validation = {
        'characters_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        "characters_count": {"key": "charactersCount", "type": "int"},
        "transactions_count": {"key": "transactionsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        characters_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword characters_count: Number of text elements recognized in the document. Required.
        :paramtype characters_count: int
        :keyword transactions_count: Number of transactions for the document. Required.
        :paramtype transactions_count: int
        """
        super().__init__(**kwargs)
        self.characters_count = characters_count
        self.transactions_count = transactions_count


class DocumentWarning(_serialization.Model):
    """DocumentWarning.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Error code. Required. Known values are: "LongWordsInDocument" and
     "DocumentTruncated".
    :vartype code: str or ~azure.ai.textanalytics.v2023_04_01.models.WarningCodeValue
    :ivar message: Warning message. Required.
    :vartype message: str
    :ivar target_ref: A JSON pointer reference indicating the target object.
    :vartype target_ref: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target_ref": {"key": "targetRef", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.WarningCodeValue"],
        message: str,
        target_ref: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Error code. Required. Known values are: "LongWordsInDocument" and
         "DocumentTruncated".
        :paramtype code: str or ~azure.ai.textanalytics.v2023_04_01.models.WarningCodeValue
        :keyword message: Warning message. Required.
        :paramtype message: str
        :keyword target_ref: A JSON pointer reference indicating the target object.
        :paramtype target_ref: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target_ref = target_ref


class EntitiesLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for an Entities Recognition task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for an Entity Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "EntitiesTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.EntitiesTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for an Entity Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'EntityRecognition'  # type: str
        self.parameters = parameters


class EntitiesResult(PreBuiltResult):
    """EntitiesResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.EntitiesResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[EntitiesResultDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.EntitiesResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.EntitiesResultDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class EntitiesResultDocumentsItem(EntitiesDocumentResult):
    """EntitiesResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "entities": {"key": "entities", "type": "[Entity]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword entities: Recognized entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, **kwargs)


class EntitiesTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for an Entity Recognition task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.string_index_type = string_index_type


class EntitiesTaskResult(AnalyzeTextTaskResult):
    """EntitiesTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis task results. Required. Known values are:
     "SentimentAnalysisResults", "EntityRecognitionResults", "PiiEntityRecognitionResults",
     "KeyPhraseExtractionResults", "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "EntitiesResult"},
    }

    def __init__(
        self,
        *,
        results: "_models.EntitiesResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesResult
        """
        super().__init__(**kwargs)
        self.kind = 'EntityRecognitionResults'  # type: str
        self.results = results


class Entity(_serialization.Model):
    """Entity.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Entity type. Required.
    :vartype category: str
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "subcategory": {"key": "subcategory", "type": "str"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
    }

    def __init__(
        self,
        *,
        text: str,
        category: str,
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword text: Entity text as appears in the request. Required.
        :paramtype text: str
        :keyword category: Entity type. Required.
        :paramtype category: str
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Start position for the entity text. Use of different 'stringIndexType' values
         can affect the offset returned. Required.
        :paramtype offset: int
        :keyword length: Length for the entity text. Use of different 'stringIndexType' values can
         affect the length returned. Required.
        :paramtype length: int
        :keyword confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
        :paramtype confidence_score: float
        """
        super().__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score


class EntityLinkingLROResult(AnalyzeTextLROResult):
    """EntityLinkingLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "EntityLinkingResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.EntityLinkingResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'EntityLinkingLROResults'  # type: str
        self.results = results


class EntityLinkingLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for an Entity Linking task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for an Entity Linking task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "EntityLinkingTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.EntityLinkingTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for an Entity Linking task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'EntityLinking'  # type: str
        self.parameters = parameters


class EntityLinkingResult(PreBuiltResult):
    """EntityLinkingResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[EntityLinkingResultDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.EntityLinkingResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingResultDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class LinkedEntitiesDocumentResult(DocumentResult):
    """LinkedEntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar entities: Recognized well known entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.LinkedEntity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "entities": {"key": "entities", "type": "[LinkedEntity]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.LinkedEntity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword entities: Recognized well known entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.LinkedEntity]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.entities = entities


class EntityLinkingResultDocumentsItem(LinkedEntitiesDocumentResult):
    """EntityLinkingResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar entities: Recognized well known entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.LinkedEntity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "entities": {"key": "entities", "type": "[LinkedEntity]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.LinkedEntity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword entities: Recognized well known entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.LinkedEntity]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, **kwargs)


class EntityLinkingTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for an Entity Linking task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.string_index_type = string_index_type


class EntityLinkingTaskResult(AnalyzeTextTaskResult):
    """EntityLinkingTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis task results. Required. Known values are:
     "SentimentAnalysisResults", "EntityRecognitionResults", "PiiEntityRecognitionResults",
     "KeyPhraseExtractionResults", "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "EntityLinkingResult"},
    }

    def __init__(
        self,
        *,
        results: "_models.EntityLinkingResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.EntityLinkingResult
        """
        super().__init__(**kwargs)
        self.kind = 'EntityLinkingResults'  # type: str
        self.results = results


class EntityRecognitionLROResult(AnalyzeTextLROResult):
    """EntityRecognitionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "EntitiesResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.EntitiesResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.EntitiesResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'EntityRecognitionLROResults'  # type: str
        self.results = results


class Error(_serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
     "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
     "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
     "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
     "Timeout", "QuotaExceeded", "Conflict", and "Warning".
    :vartype code: str or ~azure.ai.textanalytics.v2023_04_01.models.ErrorCode
    :ivar message: A human-readable representation of the error. Required.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.textanalytics.v2023_04_01.models.InnerErrorModel
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.ErrorCode"],
        message: str,
        additional_properties: Optional[Dict[str, Any]] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.Error"]] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword code: One of a server-defined set of error codes. Required. Known values are:
         "InvalidRequest", "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
         "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
         "AzureCognitiveSearchIndexNotFound", "TooManyRequests", "AzureCognitiveSearchThrottling",
         "AzureCognitiveSearchIndexLimitReached", "InternalServerError", "ServiceUnavailable",
         "Timeout", "QuotaExceeded", "Conflict", and "Warning".
        :paramtype code: str or ~azure.ai.textanalytics.v2023_04_01.models.ErrorCode
        :keyword message: A human-readable representation of the error. Required.
        :paramtype message: str
        :keyword target: The target of the error.
        :paramtype target: str
        :keyword details: An array of details about specific errors that led to this reported error.
        :paramtype details: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.textanalytics.v2023_04_01.models.InnerErrorModel
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class ErrorResponse(_serialization.Model):
    """Error response.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The error object. Required.
    :vartype error: ~azure.ai.textanalytics.v2023_04_01.models.Error
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        error: "_models.Error",
        **kwargs
    ):
        """
        :keyword error: The error object. Required.
        :paramtype error: ~azure.ai.textanalytics.v2023_04_01.models.Error
        """
        super().__init__(**kwargs)
        self.error = error


class ExtractedSummaryDocumentResult(DocumentResult):
    """ExtractedSummaryDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar sentences: A ranked list of sentences representing the extracted summary. Required.
    :vartype sentences: list[~azure.ai.textanalytics.v2023_04_01.models.ExtractedSummarySentence]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'sentences': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "sentences": {"key": "sentences", "type": "[ExtractedSummarySentence]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        sentences: List["_models.ExtractedSummarySentence"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword sentences: A ranked list of sentences representing the extracted summary. Required.
        :paramtype sentences: list[~azure.ai.textanalytics.v2023_04_01.models.ExtractedSummarySentence]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.sentences = sentences


class ExtractedSummarySentence(_serialization.Model):
    """ExtractedSummarySentence.

    All required parameters must be populated in order to send to Azure.

    :ivar text: The extracted sentence text. Required.
    :vartype text: str
    :ivar rank_score: A double value representing the relevance of the sentence within the summary.
     Higher values indicate higher importance. Required.
    :vartype rank_score: float
    :ivar offset: The sentence offset from the start of the document, based on the value of the
     parameter StringIndexType. Required.
    :vartype offset: int
    :ivar length: The length of the sentence. Required.
    :vartype length: int
    """

    _validation = {
        'text': {'required': True},
        'rank_score': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "rank_score": {"key": "rankScore", "type": "float"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        text: str,
        rank_score: float,
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword text: The extracted sentence text. Required.
        :paramtype text: str
        :keyword rank_score: A double value representing the relevance of the sentence within the
         summary. Higher values indicate higher importance. Required.
        :paramtype rank_score: float
        :keyword offset: The sentence offset from the start of the document, based on the value of the
         parameter StringIndexType. Required.
        :paramtype offset: int
        :keyword length: The length of the sentence. Required.
        :paramtype length: int
        """
        super().__init__(**kwargs)
        self.text = text
        self.rank_score = rank_score
        self.offset = offset
        self.length = length


class ExtractiveSummarizationLROResult(AnalyzeTextLROResult):
    """ExtractiveSummarizationLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.ExtractiveSummarizationResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "ExtractiveSummarizationResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.ExtractiveSummarizationResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.ExtractiveSummarizationResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'ExtractiveSummarizationLROResults'  # type: str
        self.results = results


class ExtractiveSummarizationLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for an Extractive Summarization task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for an Extractive Summarization task.
    :vartype parameters:
     ~azure.ai.textanalytics.v2023_04_01.models.ExtractiveSummarizationTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "ExtractiveSummarizationTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.ExtractiveSummarizationTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for an Extractive Summarization task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2023_04_01.models.ExtractiveSummarizationTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'ExtractiveSummarization'  # type: str
        self.parameters = parameters


class ExtractiveSummarizationResult(PreBuiltResult):
    """ExtractiveSummarizationResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.ExtractedSummaryDocumentResult]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[ExtractedSummaryDocumentResult]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.ExtractedSummaryDocumentResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.ExtractedSummaryDocumentResult]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class ExtractiveSummarizationTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for an Extractive Summarization task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar sentence_count:
    :vartype sentence_count: int
    :ivar sort_by: The sorting criteria to use for the results of Extractive Summarization. Known
     values are: "Offset" and "Rank".
    :vartype sort_by: str or
     ~azure.ai.textanalytics.v2023_04_01.models.ExtractiveSummarizationSortingCriteria
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "sentence_count": {"key": "sentenceCount", "type": "int"},
        "sort_by": {"key": "sortBy", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        sentence_count: int = 3,
        sort_by: Union[str, "_models.ExtractiveSummarizationSortingCriteria"] = "Offset",
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword sentence_count:
        :paramtype sentence_count: int
        :keyword sort_by: The sorting criteria to use for the results of Extractive Summarization.
         Known values are: "Offset" and "Rank".
        :paramtype sort_by: str or
         ~azure.ai.textanalytics.v2023_04_01.models.ExtractiveSummarizationSortingCriteria
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.sentence_count = sentence_count
        self.sort_by = sort_by
        self.string_index_type = string_index_type


class HealthcareAssertion(_serialization.Model):
    """HealthcareAssertion.

    :ivar conditionality: Describes any conditionality on the entity. Known values are:
     "hypothetical" and "conditional".
    :vartype conditionality: str or ~azure.ai.textanalytics.v2023_04_01.models.EntityConditionality
    :ivar certainty: Describes the entities certainty and polarity. Known values are: "positive",
     "positivePossible", "neutralPossible", "negativePossible", and "negative".
    :vartype certainty: str or ~azure.ai.textanalytics.v2023_04_01.models.EntityCertainty
    :ivar association: Describes if the entity is the subject of the text or if it describes
     someone else. Known values are: "subject" and "other".
    :vartype association: str or ~azure.ai.textanalytics.v2023_04_01.models.EntityAssociation
    """

    _attribute_map = {
        "conditionality": {"key": "conditionality", "type": "str"},
        "certainty": {"key": "certainty", "type": "str"},
        "association": {"key": "association", "type": "str"},
    }

    def __init__(
        self,
        *,
        conditionality: Optional[Union[str, "_models.EntityConditionality"]] = None,
        certainty: Optional[Union[str, "_models.EntityCertainty"]] = None,
        association: Optional[Union[str, "_models.EntityAssociation"]] = None,
        **kwargs
    ):
        """
        :keyword conditionality: Describes any conditionality on the entity. Known values are:
         "hypothetical" and "conditional".
        :paramtype conditionality: str or
         ~azure.ai.textanalytics.v2023_04_01.models.EntityConditionality
        :keyword certainty: Describes the entities certainty and polarity. Known values are:
         "positive", "positivePossible", "neutralPossible", "negativePossible", and "negative".
        :paramtype certainty: str or ~azure.ai.textanalytics.v2023_04_01.models.EntityCertainty
        :keyword association: Describes if the entity is the subject of the text or if it describes
         someone else. Known values are: "subject" and "other".
        :paramtype association: str or ~azure.ai.textanalytics.v2023_04_01.models.EntityAssociation
        """
        super().__init__(**kwargs)
        self.conditionality = conditionality
        self.certainty = certainty
        self.association = association


class HealthcareEntitiesDocumentResult(DocumentResult):
    """HealthcareEntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar entities: Healthcare entities. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntity]
    :ivar relations: Healthcare entity relations. Required.
    :vartype relations: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareRelation]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "entities": {"key": "entities", "type": "[HealthcareEntity]"},
        "relations": {"key": "relations", "type": "[HealthcareRelation]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.HealthcareEntity"],
        relations: List["_models.HealthcareRelation"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword entities: Healthcare entities. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntity]
        :keyword relations: Healthcare entity relations. Required.
        :paramtype relations: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareRelation]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.entities = entities
        self.relations = relations


class HealthcareEntity(_serialization.Model):
    """HealthcareEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar category: Healthcare Entity Category. Required. Known values are: "BodyStructure", "Age",
     "Gender", "Ethnicity", "ExaminationName", "Date", "Direction", "Frequency", "MeasurementValue",
     "MeasurementUnit", "RelationalOperator", "Time", "Course", "GeneOrProtein", "Variant",
     "Expression", "MutationType", "AdministrativeEvent", "CareEnvironment", "HealthcareProfession",
     "Diagnosis", "SymptomOrSign", "ConditionQualifier", "ConditionScale", "MedicationClass",
     "MedicationName", "Dosage", "MedicationForm", "MedicationRoute", "FamilyRelation",
     "TreatmentName", "Allergen", "Employment", "LivingStatus", "SubstanceUse", and
     "SubstanceUseAmount".
    :vartype category: str or ~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntityCategory
    :ivar subcategory: (Optional) Entity sub type.
    :vartype subcategory: str
    :ivar offset: Start position for the entity text. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: Length for the entity text. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
    :vartype confidence_score: float
    :ivar assertion:
    :vartype assertion: ~azure.ai.textanalytics.v2023_04_01.models.HealthcareAssertion
    :ivar name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
     'histologic'.
    :vartype name: str
    :ivar links: Entity references in known data sources.
    :vartype links: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntityLink]
    """

    _validation = {
        'text': {'required': True},
        'category': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'confidence_score': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "subcategory": {"key": "subcategory", "type": "str"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "assertion": {"key": "assertion", "type": "HealthcareAssertion"},
        "name": {"key": "name", "type": "str"},
        "links": {"key": "links", "type": "[HealthcareEntityLink]"},
    }

    def __init__(
        self,
        *,
        text: str,
        category: Union[str, "_models.HealthcareEntityCategory"],
        offset: int,
        length: int,
        confidence_score: float,
        subcategory: Optional[str] = None,
        assertion: Optional["_models.HealthcareAssertion"] = None,
        name: Optional[str] = None,
        links: Optional[List["_models.HealthcareEntityLink"]] = None,
        **kwargs
    ):
        """
        :keyword text: Entity text as appears in the request. Required.
        :paramtype text: str
        :keyword category: Healthcare Entity Category. Required. Known values are: "BodyStructure",
         "Age", "Gender", "Ethnicity", "ExaminationName", "Date", "Direction", "Frequency",
         "MeasurementValue", "MeasurementUnit", "RelationalOperator", "Time", "Course", "GeneOrProtein",
         "Variant", "Expression", "MutationType", "AdministrativeEvent", "CareEnvironment",
         "HealthcareProfession", "Diagnosis", "SymptomOrSign", "ConditionQualifier", "ConditionScale",
         "MedicationClass", "MedicationName", "Dosage", "MedicationForm", "MedicationRoute",
         "FamilyRelation", "TreatmentName", "Allergen", "Employment", "LivingStatus", "SubstanceUse",
         and "SubstanceUseAmount".
        :paramtype category: str or ~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntityCategory
        :keyword subcategory: (Optional) Entity sub type.
        :paramtype subcategory: str
        :keyword offset: Start position for the entity text. Use of different 'stringIndexType' values
         can affect the offset returned. Required.
        :paramtype offset: int
        :keyword length: Length for the entity text. Use of different 'stringIndexType' values can
         affect the length returned. Required.
        :paramtype length: int
        :keyword confidence_score: Confidence score between 0 and 1 of the extracted entity. Required.
        :paramtype confidence_score: float
        :keyword assertion:
        :paramtype assertion: ~azure.ai.textanalytics.v2023_04_01.models.HealthcareAssertion
        :keyword name: Preferred name for the entity. Example: 'histologically' would have a 'name' of
         'histologic'.
        :paramtype name: str
        :keyword links: Entity references in known data sources.
        :paramtype links: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntityLink]
        """
        super().__init__(**kwargs)
        self.text = text
        self.category = category
        self.subcategory = subcategory
        self.offset = offset
        self.length = length
        self.confidence_score = confidence_score
        self.assertion = assertion
        self.name = name
        self.links = links


class HealthcareEntityLink(_serialization.Model):
    """HealthcareEntityLink.

    All required parameters must be populated in order to send to Azure.

    :ivar data_source: Entity Catalog. Examples include: UMLS, CHV, MSH, etc. Required.
    :vartype data_source: str
    :ivar id: Entity id in the given source catalog. Required.
    :vartype id: str
    """

    _validation = {
        'data_source': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        "data_source": {"key": "dataSource", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_source: str,
        id: str,  # pylint: disable=redefined-builtin
        **kwargs
    ):
        """
        :keyword data_source: Entity Catalog. Examples include: UMLS, CHV, MSH, etc. Required.
        :paramtype data_source: str
        :keyword id: Entity id in the given source catalog. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.data_source = data_source
        self.id = id


class HealthcareLROResult(AnalyzeTextLROResult):
    """HealthcareLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.HealthcareResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "HealthcareResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.HealthcareResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.HealthcareResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'HealthcareLROResults'  # type: str
        self.results = results


class HealthcareLROTask(AnalyzeTextLROTask):
    """HealthcareLROTask.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Healthcare task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.HealthcareTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "HealthcareTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.HealthcareTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Healthcare task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.HealthcareTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'Healthcare'  # type: str
        self.parameters = parameters


class HealthcareRelation(_serialization.Model):
    """Every relation is an entity graph of a certain relationType, where all entities are connected and have specific roles within the relation context.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: Type of relation. Examples include: ``DosageOfMedication`` or
     'FrequencyOfMedication', etc. Required. Known values are: "Abbreviation",
     "BodySiteOfCondition", "BodySiteOfTreatment", "CourseOfCondition", "CourseOfExamination",
     "CourseOfMedication", "CourseOfTreatment", "DirectionOfBodyStructure", "DirectionOfCondition",
     "DirectionOfExamination", "DirectionOfTreatment", "DosageOfMedication",
     "ExaminationFindsCondition", "ExpressionOfGene", "ExpressionOfVariant", "FormOfMedication",
     "FrequencyOfCondition", "FrequencyOfMedication", "FrequencyOfTreatment", "MutationTypeOfGene",
     "MutationTypeOfVariant", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
     "ScaleOfCondition", "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication",
     "TimeOfTreatment", "UnitOfCondition", "UnitOfExamination", "ValueOfCondition",
     "ValueOfExamination", and "VariantOfGene".
    :vartype relation_type: str or
     ~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntityRelation
    :ivar confidence_score: Confidence score between 0 and 1 of the extracted relation.
    :vartype confidence_score: float
    :ivar entities: The entities in the relation. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareRelationEntity]
    """

    _validation = {
        'relation_type': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "relation_type": {"key": "relationType", "type": "str"},
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "entities": {"key": "entities", "type": "[HealthcareRelationEntity]"},
    }

    def __init__(
        self,
        *,
        relation_type: Union[str, "_models.HealthcareEntityRelation"],
        entities: List["_models.HealthcareRelationEntity"],
        confidence_score: Optional[float] = None,
        **kwargs
    ):
        """
        :keyword relation_type: Type of relation. Examples include: ``DosageOfMedication`` or
         'FrequencyOfMedication', etc. Required. Known values are: "Abbreviation",
         "BodySiteOfCondition", "BodySiteOfTreatment", "CourseOfCondition", "CourseOfExamination",
         "CourseOfMedication", "CourseOfTreatment", "DirectionOfBodyStructure", "DirectionOfCondition",
         "DirectionOfExamination", "DirectionOfTreatment", "DosageOfMedication",
         "ExaminationFindsCondition", "ExpressionOfGene", "ExpressionOfVariant", "FormOfMedication",
         "FrequencyOfCondition", "FrequencyOfMedication", "FrequencyOfTreatment", "MutationTypeOfGene",
         "MutationTypeOfVariant", "QualifierOfCondition", "RelationOfExamination", "RouteOfMedication",
         "ScaleOfCondition", "TimeOfCondition", "TimeOfEvent", "TimeOfExamination", "TimeOfMedication",
         "TimeOfTreatment", "UnitOfCondition", "UnitOfExamination", "ValueOfCondition",
         "ValueOfExamination", and "VariantOfGene".
        :paramtype relation_type: str or
         ~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntityRelation
        :keyword confidence_score: Confidence score between 0 and 1 of the extracted relation.
        :paramtype confidence_score: float
        :keyword entities: The entities in the relation. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareRelationEntity]
        """
        super().__init__(**kwargs)
        self.relation_type = relation_type
        self.confidence_score = confidence_score
        self.entities = entities


class HealthcareRelationEntity(_serialization.Model):
    """HealthcareRelationEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar ref: Reference link object, using a JSON pointer RFC 6901 (URI Fragment Identifier
     Representation), pointing to the entity . Required.
    :vartype ref: str
    :ivar role: Role of entity in the relationship. For example: 'CD20-positive diffuse large
     B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
     (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis). Required.
    :vartype role: str
    """

    _validation = {
        'ref': {'required': True},
        'role': {'required': True},
    }

    _attribute_map = {
        "ref": {"key": "ref", "type": "str"},
        "role": {"key": "role", "type": "str"},
    }

    def __init__(
        self,
        *,
        ref: str,
        role: str,
        **kwargs
    ):
        """
        :keyword ref: Reference link object, using a JSON pointer RFC 6901 (URI Fragment Identifier
         Representation), pointing to the entity . Required.
        :paramtype ref: str
        :keyword role: Role of entity in the relationship. For example: 'CD20-positive diffuse large
         B-cell lymphoma' has the following entities with their roles in parenthesis:  CD20
         (GeneOrProtein), Positive (Expression), diffuse large B-cell lymphoma (Diagnosis). Required.
        :paramtype role: str
        """
        super().__init__(**kwargs)
        self.ref = ref
        self.role = role


class HealthcareResult(PreBuiltResult):
    """HealthcareResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[HealthcareResultDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.HealthcareResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareResultDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class HealthcareResultDocumentsItem(HealthcareEntitiesDocumentResult):
    """HealthcareResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar entities: Healthcare entities. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntity]
    :ivar relations: Healthcare entity relations. Required.
    :vartype relations: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareRelation]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'entities': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "entities": {"key": "entities", "type": "[HealthcareEntity]"},
        "relations": {"key": "relations", "type": "[HealthcareRelation]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        entities: List["_models.HealthcareEntity"],
        relations: List["_models.HealthcareRelation"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword entities: Healthcare entities. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareEntity]
        :keyword relations: Healthcare entity relations. Required.
        :paramtype relations: list[~azure.ai.textanalytics.v2023_04_01.models.HealthcareRelation]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, entities=entities, relations=relations, **kwargs)


class HealthcareTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Healthcare task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.string_index_type = string_index_type


class InnerErrorModel(_serialization.Model):
    """An object containing more specific information about the error. As per Microsoft One API guidelines - https://github.com/Microsoft/api-guidelines/blob/vNext/Guidelines.md#7102-error-condition-responses.

    All required parameters must be populated in order to send to Azure.

    :ivar code: One of a server-defined set of error codes. Required. Known values are:
     "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
     "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
     "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
     "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
     "InvalidCountryHint".
    :vartype code: str or ~azure.ai.textanalytics.v2023_04_01.models.InnerErrorCode
    :ivar message: Error message. Required.
    :vartype message: str
    :ivar details: Error details.
    :vartype details: dict[str, str]
    :ivar target: Error target.
    :vartype target: str
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.ai.textanalytics.v2023_04_01.models.InnerErrorModel
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "{str}"},
        "target": {"key": "target", "type": "str"},
        "innererror": {"key": "innererror", "type": "InnerErrorModel"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.InnerErrorCode"],
        message: str,
        details: Optional[Dict[str, str]] = None,
        target: Optional[str] = None,
        innererror: Optional["_models.InnerErrorModel"] = None,
        **kwargs
    ):
        """
        :keyword code: One of a server-defined set of error codes. Required. Known values are:
         "InvalidRequest", "InvalidParameterValue", "KnowledgeBaseNotFound",
         "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling", "ExtractionFailure",
         "InvalidRequestBodyFormat", "EmptyRequest", "MissingInputDocuments", "InvalidDocument",
         "ModelVersionIncorrect", "InvalidDocumentBatch", "UnsupportedLanguageCode", and
         "InvalidCountryHint".
        :paramtype code: str or ~azure.ai.textanalytics.v2023_04_01.models.InnerErrorCode
        :keyword message: Error message. Required.
        :paramtype message: str
        :keyword details: Error details.
        :paramtype details: dict[str, str]
        :keyword target: Error target.
        :paramtype target: str
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror: ~azure.ai.textanalytics.v2023_04_01.models.InnerErrorModel
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target
        self.innererror = innererror


class JobErrors(_serialization.Model):
    """JobErrors.

    :ivar errors:
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
    """

    _attribute_map = {
        "errors": {"key": "errors", "type": "[Error]"},
    }

    def __init__(
        self,
        *,
        errors: Optional[List["_models.Error"]] = None,
        **kwargs
    ):
        """
        :keyword errors:
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.Error]
        """
        super().__init__(**kwargs)
        self.errors = errors


class KeyPhraseExtractionLROResult(AnalyzeTextLROResult):
    """KeyPhraseExtractionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "KeyPhraseResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.KeyPhraseResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'KeyPhraseExtractionLROResults'  # type: str
        self.results = results


class KeyPhraseLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for a Key Phrase Extraction task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Key Phrase Extraction task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "KeyPhraseTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.KeyPhraseTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Key Phrase Extraction task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'KeyPhraseExtraction'  # type: str
        self.parameters = parameters


class KeyPhraseResult(PreBuiltResult):
    """KeyPhraseResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[KeyPhraseResultDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.KeyPhraseResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseResultDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class KeyPhrasesDocumentResult(DocumentResult):
    """KeyPhrasesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar key_phrases: A list of representative words or phrases. The number of key phrases
     returned is proportional to the number of words in the input document. Required.
    :vartype key_phrases: list[str]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'key_phrases': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "key_phrases": {"key": "keyPhrases", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        key_phrases: List[str],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword key_phrases: A list of representative words or phrases. The number of key phrases
         returned is proportional to the number of words in the input document. Required.
        :paramtype key_phrases: list[str]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.key_phrases = key_phrases


class KeyPhraseResultDocumentsItem(KeyPhrasesDocumentResult):
    """KeyPhraseResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar key_phrases: A list of representative words or phrases. The number of key phrases
     returned is proportional to the number of words in the input document. Required.
    :vartype key_phrases: list[str]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'key_phrases': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "key_phrases": {"key": "keyPhrases", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        key_phrases: List[str],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword key_phrases: A list of representative words or phrases. The number of key phrases
         returned is proportional to the number of words in the input document. Required.
        :paramtype key_phrases: list[str]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, key_phrases=key_phrases, **kwargs)


class KeyPhraseTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Key Phrase Extraction task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)


class KeyPhraseTaskResult(AnalyzeTextTaskResult):
    """KeyPhraseTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis task results. Required. Known values are:
     "SentimentAnalysisResults", "EntityRecognitionResults", "PiiEntityRecognitionResults",
     "KeyPhraseExtractionResults", "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "KeyPhraseResult"},
    }

    def __init__(
        self,
        *,
        results: "_models.KeyPhraseResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.KeyPhraseResult
        """
        super().__init__(**kwargs)
        self.kind = 'KeyPhraseExtractionResults'  # type: str
        self.results = results


class LanguageDetectionAnalysisInput(_serialization.Model):
    """LanguageDetectionAnalysisInput.

    :ivar documents:
    :vartype documents: list[~azure.ai.textanalytics.v2023_04_01.models.LanguageInput]
    """

    _attribute_map = {
        "documents": {"key": "documents", "type": "[LanguageInput]"},
    }

    def __init__(
        self,
        *,
        documents: Optional[List["_models.LanguageInput"]] = None,
        **kwargs
    ):
        """
        :keyword documents:
        :paramtype documents: list[~azure.ai.textanalytics.v2023_04_01.models.LanguageInput]
        """
        super().__init__(**kwargs)
        self.documents = documents


class LanguageDetectionDocumentResult(DocumentResult):
    """LanguageDetectionDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar detected_language: Detected Language. Required.
    :vartype detected_language: ~azure.ai.textanalytics.v2023_04_01.models.DetectedLanguage
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'detected_language': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "detected_language": {"key": "detectedLanguage", "type": "DetectedLanguage"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        detected_language: "_models.DetectedLanguage",
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword detected_language: Detected Language. Required.
        :paramtype detected_language: ~azure.ai.textanalytics.v2023_04_01.models.DetectedLanguage
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.detected_language = detected_language


class LanguageDetectionResult(PreBuiltResult):
    """LanguageDetectionResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionDocumentResult]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[LanguageDetectionDocumentResult]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.LanguageDetectionDocumentResult"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Response by document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionDocumentResult]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class LanguageDetectionTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Language Detection task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)


class LanguageDetectionTaskResult(AnalyzeTextTaskResult):
    """LanguageDetectionTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis task results. Required. Known values are:
     "SentimentAnalysisResults", "EntityRecognitionResults", "PiiEntityRecognitionResults",
     "KeyPhraseExtractionResults", "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "LanguageDetectionResult"},
    }

    def __init__(
        self,
        *,
        results: "_models.LanguageDetectionResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.LanguageDetectionResult
        """
        super().__init__(**kwargs)
        self.kind = 'LanguageDetectionResults'  # type: str
        self.results = results


class LanguageInput(_serialization.Model):
    """LanguageInput.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar text: Required.
    :vartype text: str
    :ivar country_hint:
    :vartype country_hint: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
        "country_hint": {"key": "countryHint", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        text: str,
        country_hint: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword text: Required.
        :paramtype text: str
        :keyword country_hint:
        :paramtype country_hint: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.text = text
        self.country_hint = country_hint


class LinkedEntity(_serialization.Model):
    """LinkedEntity.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Entity Linking formal name. Required.
    :vartype name: str
    :ivar matches: List of instances this entity appears in the text. Required.
    :vartype matches: list[~azure.ai.textanalytics.v2023_04_01.models.Match]
    :ivar language: Language used in the data source. Required.
    :vartype language: str
    :ivar id: Unique identifier of the recognized entity from the data source.
    :vartype id: str
    :ivar url: URL for the entity's page from the data source. Required.
    :vartype url: str
    :ivar data_source: Data source used to extract entity linking, such as Wiki/Bing etc. Required.
    :vartype data_source: str
    :ivar bing_id: Bing Entity Search API unique identifier of the recognized entity.
    :vartype bing_id: str
    """

    _validation = {
        'name': {'required': True},
        'matches': {'required': True},
        'language': {'required': True},
        'url': {'required': True},
        'data_source': {'required': True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "matches": {"key": "matches", "type": "[Match]"},
        "language": {"key": "language", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "data_source": {"key": "dataSource", "type": "str"},
        "bing_id": {"key": "bingId", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        matches: List["_models.Match"],
        language: str,
        url: str,
        data_source: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        bing_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Entity Linking formal name. Required.
        :paramtype name: str
        :keyword matches: List of instances this entity appears in the text. Required.
        :paramtype matches: list[~azure.ai.textanalytics.v2023_04_01.models.Match]
        :keyword language: Language used in the data source. Required.
        :paramtype language: str
        :keyword id: Unique identifier of the recognized entity from the data source.
        :paramtype id: str
        :keyword url: URL for the entity's page from the data source. Required.
        :paramtype url: str
        :keyword data_source: Data source used to extract entity linking, such as Wiki/Bing etc.
         Required.
        :paramtype data_source: str
        :keyword bing_id: Bing Entity Search API unique identifier of the recognized entity.
        :paramtype bing_id: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.matches = matches
        self.language = language
        self.id = id
        self.url = url
        self.data_source = data_source
        self.bing_id = bing_id


class Match(_serialization.Model):
    """Match.

    All required parameters must be populated in order to send to Azure.

    :ivar confidence_score: If a well known item is recognized, a decimal number denoting the
     confidence level between 0 and 1 will be returned. Required.
    :vartype confidence_score: float
    :ivar text: Entity text as appears in the request. Required.
    :vartype text: str
    :ivar offset: Start position for the entity match text. Required.
    :vartype offset: int
    :ivar length: Length for the entity match text. Required.
    :vartype length: int
    """

    _validation = {
        'confidence_score': {'required': True},
        'text': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        "confidence_score": {"key": "confidenceScore", "type": "float"},
        "text": {"key": "text", "type": "str"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        confidence_score: float,
        text: str,
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword confidence_score: If a well known item is recognized, a decimal number denoting the
         confidence level between 0 and 1 will be returned. Required.
        :paramtype confidence_score: float
        :keyword text: Entity text as appears in the request. Required.
        :paramtype text: str
        :keyword offset: Start position for the entity match text. Required.
        :paramtype offset: int
        :keyword length: Length for the entity match text. Required.
        :paramtype length: int
        """
        super().__init__(**kwargs)
        self.confidence_score = confidence_score
        self.text = text
        self.offset = offset
        self.length = length


class MultiLanguageAnalysisInput(_serialization.Model):
    """MultiLanguageAnalysisInput.

    :ivar documents:
    :vartype documents: list[~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageInput]
    """

    _attribute_map = {
        "documents": {"key": "documents", "type": "[MultiLanguageInput]"},
    }

    def __init__(
        self,
        *,
        documents: Optional[List["_models.MultiLanguageInput"]] = None,
        **kwargs
    ):
        """
        :keyword documents:
        :paramtype documents: list[~azure.ai.textanalytics.v2023_04_01.models.MultiLanguageInput]
        """
        super().__init__(**kwargs)
        self.documents = documents


class MultiLanguageInput(_serialization.Model):
    """Contains an input document to be analyzed by the service.

    All required parameters must be populated in order to send to Azure.

    :ivar id: A unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar text: The input text to process. Required.
    :vartype text: str
    :ivar language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
     example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
     default.
    :vartype language: str
    """

    _validation = {
        'id': {'required': True},
        'text': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "text": {"key": "text", "type": "str"},
        "language": {"key": "language", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        text: str,
        language: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: A unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword text: The input text to process. Required.
        :paramtype text: str
        :keyword language: (Optional) This is the 2 letter ISO 639-1 representation of a language. For
         example, use "en" for English; "es" for Spanish etc. If not set, use "en" for English as
         default.
        :paramtype language: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.text = text
        self.language = language


class Pagination(_serialization.Model):
    """Pagination.

    :ivar next_link:
    :vartype next_link: str
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword next_link:
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link


class PiiEntitiesDocumentResult(DocumentResult):
    """PiiEntitiesDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar redacted_text: Returns redacted text. Required.
    :vartype redacted_text: str
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "redacted_text": {"key": "redactedText", "type": "str"},
        "entities": {"key": "entities", "type": "[Entity]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        redacted_text: str,
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword redacted_text: Returns redacted text. Required.
        :paramtype redacted_text: str
        :keyword entities: Recognized entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.redacted_text = redacted_text
        self.entities = entities


class PiiEntityRecognitionLROResult(AnalyzeTextLROResult):
    """PiiEntityRecognitionLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.PiiResult
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "PiiResult"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.PiiResult",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.PiiResult
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'PiiEntityRecognitionLROResults'  # type: str
        self.results = results


class PiiLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for a PII Entities Recognition task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a PII Entities Recognition task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.PiiTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "PiiTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.PiiTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a PII Entities Recognition task.
        :paramtype parameters: ~azure.ai.textanalytics.v2023_04_01.models.PiiTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'PiiEntityRecognition'  # type: str
        self.parameters = parameters


class PiiResult(PreBuiltResult):
    """PiiResult.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Response by document. Required.
    :vartype documents: list[~azure.ai.textanalytics.v2023_04_01.models.PiiResultDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[PiiResultDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.PiiResultDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Response by document. Required.
        :paramtype documents: list[~azure.ai.textanalytics.v2023_04_01.models.PiiResultDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class PiiResultDocumentsItem(PiiEntitiesDocumentResult):
    """PiiResultDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar redacted_text: Returns redacted text. Required.
    :vartype redacted_text: str
    :ivar entities: Recognized entities in the document. Required.
    :vartype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'redacted_text': {'required': True},
        'entities': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "redacted_text": {"key": "redactedText", "type": "str"},
        "entities": {"key": "entities", "type": "[Entity]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        redacted_text: str,
        entities: List["_models.Entity"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword redacted_text: Returns redacted text. Required.
        :paramtype redacted_text: str
        :keyword entities: Recognized entities in the document. Required.
        :paramtype entities: list[~azure.ai.textanalytics.v2023_04_01.models.Entity]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, redacted_text=redacted_text, entities=entities, **kwargs)


class PiiTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a PII Entities Recognition task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar domain: The PII domain used for PII Entity Recognition. Known values are: "phi" and
     "none".
    :vartype domain: str or ~azure.ai.textanalytics.v2023_04_01.models.PiiDomain
    :ivar pii_categories: (Optional) describes the PII categories to return.
    :vartype pii_categories: list[str or
     ~azure.ai.textanalytics.v2023_04_01.models.PiiEntityCategory]
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _validation = {
        'pii_categories': {'unique': True},
    }

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "domain": {"key": "domain", "type": "str"},
        "pii_categories": {"key": "piiCategories", "type": "[str]"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        domain: Union[str, "_models.PiiDomain"] = "none",
        pii_categories: Optional[List[Union[str, "_models.PiiEntityCategory"]]] = None,
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword domain: The PII domain used for PII Entity Recognition. Known values are: "phi" and
         "none".
        :paramtype domain: str or ~azure.ai.textanalytics.v2023_04_01.models.PiiDomain
        :keyword pii_categories: (Optional) describes the PII categories to return.
        :paramtype pii_categories: list[str or
         ~azure.ai.textanalytics.v2023_04_01.models.PiiEntityCategory]
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.domain = domain
        self.pii_categories = pii_categories
        self.string_index_type = string_index_type


class PiiTaskResult(AnalyzeTextTaskResult):
    """PiiTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis task results. Required. Known values are:
     "SentimentAnalysisResults", "EntityRecognitionResults", "PiiEntityRecognitionResults",
     "KeyPhraseExtractionResults", "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.PiiResult
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "PiiResult"},
    }

    def __init__(
        self,
        *,
        results: "_models.PiiResult",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.PiiResult
        """
        super().__init__(**kwargs)
        self.kind = 'PiiEntityRecognitionResults'  # type: str
        self.results = results


class RequestStatistics(_serialization.Model):
    """if showStats=true was specified in the request this field will contain information about the request payload.

    All required parameters must be populated in order to send to Azure.

    :ivar documents_count: Number of documents submitted in the request. Required.
    :vartype documents_count: int
    :ivar valid_documents_count: Number of valid documents. This excludes empty, over-size limit or
     non-supported languages documents. Required.
    :vartype valid_documents_count: int
    :ivar erroneous_documents_count: Number of invalid documents. This includes empty, over-size
     limit or non-supported languages documents. Required.
    :vartype erroneous_documents_count: int
    :ivar transactions_count: Number of transactions for the request. Required.
    :vartype transactions_count: int
    """

    _validation = {
        'documents_count': {'required': True},
        'valid_documents_count': {'required': True},
        'erroneous_documents_count': {'required': True},
        'transactions_count': {'required': True},
    }

    _attribute_map = {
        "documents_count": {"key": "documentsCount", "type": "int"},
        "valid_documents_count": {"key": "validDocumentsCount", "type": "int"},
        "erroneous_documents_count": {"key": "erroneousDocumentsCount", "type": "int"},
        "transactions_count": {"key": "transactionsCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        documents_count: int,
        valid_documents_count: int,
        erroneous_documents_count: int,
        transactions_count: int,
        **kwargs
    ):
        """
        :keyword documents_count: Number of documents submitted in the request. Required.
        :paramtype documents_count: int
        :keyword valid_documents_count: Number of valid documents. This excludes empty, over-size limit
         or non-supported languages documents. Required.
        :paramtype valid_documents_count: int
        :keyword erroneous_documents_count: Number of invalid documents. This includes empty, over-size
         limit or non-supported languages documents. Required.
        :paramtype erroneous_documents_count: int
        :keyword transactions_count: Number of transactions for the request. Required.
        :paramtype transactions_count: int
        """
        super().__init__(**kwargs)
        self.documents_count = documents_count
        self.valid_documents_count = valid_documents_count
        self.erroneous_documents_count = erroneous_documents_count
        self.transactions_count = transactions_count


class SentenceAssessment(_serialization.Model):
    """SentenceAssessment.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Assessment sentiment in the sentence. Required. Known values are: "positive",
     "mixed", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.TokenSentimentValue
    :ivar confidence_scores: Assessment sentiment confidence scores in the sentence. Required.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2023_04_01.models.TargetConfidenceScoreLabel
    :ivar offset: The assessment offset from the start of the sentence. Required.
    :vartype offset: int
    :ivar length: The length of the assessment. Required.
    :vartype length: int
    :ivar text: The assessment text detected. Required.
    :vartype text: str
    :ivar is_negated: The indicator representing if the assessment is negated. Required.
    :vartype is_negated: bool
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'is_negated': {'required': True},
    }

    _attribute_map = {
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "TargetConfidenceScoreLabel"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "text": {"key": "text", "type": "str"},
        "is_negated": {"key": "isNegated", "type": "bool"},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentimentValue"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        is_negated: bool,
        **kwargs
    ):
        """
        :keyword sentiment: Assessment sentiment in the sentence. Required. Known values are:
         "positive", "mixed", and "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.TokenSentimentValue
        :keyword confidence_scores: Assessment sentiment confidence scores in the sentence. Required.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2023_04_01.models.TargetConfidenceScoreLabel
        :keyword offset: The assessment offset from the start of the sentence. Required.
        :paramtype offset: int
        :keyword length: The length of the assessment. Required.
        :paramtype length: int
        :keyword text: The assessment text detected. Required.
        :paramtype text: str
        :keyword is_negated: The indicator representing if the assessment is negated. Required.
        :paramtype is_negated: bool
        """
        super().__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.is_negated = is_negated


class SentenceSentiment(_serialization.Model):
    """SentenceSentiment.

    All required parameters must be populated in order to send to Azure.

    :ivar text: The sentence text. Required.
    :vartype text: str
    :ivar sentiment: The predicted Sentiment for the sentence. Required. Known values are:
     "positive", "neutral", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.SentenceSentimentValue
    :ivar confidence_scores: The sentiment confidence score between 0 and 1 for the sentence for
     all classes. Required.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2023_04_01.models.SentimentConfidenceScorePerLabel
    :ivar offset: The sentence offset from the start of the document. Required.
    :vartype offset: int
    :ivar length: The length of the sentence. Required.
    :vartype length: int
    :ivar targets: The array of sentence targets for the sentence.
    :vartype targets: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceTarget]
    :ivar assessments: The array of assessments for the sentence.
    :vartype assessments: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceAssessment]
    """

    _validation = {
        'text': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        "text": {"key": "text", "type": "str"},
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "SentimentConfidenceScorePerLabel"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "targets": {"key": "targets", "type": "[SentenceTarget]"},
        "assessments": {"key": "assessments", "type": "[SentenceAssessment]"},
    }

    def __init__(
        self,
        *,
        text: str,
        sentiment: Union[str, "_models.SentenceSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        offset: int,
        length: int,
        targets: Optional[List["_models.SentenceTarget"]] = None,
        assessments: Optional[List["_models.SentenceAssessment"]] = None,
        **kwargs
    ):
        """
        :keyword text: The sentence text. Required.
        :paramtype text: str
        :keyword sentiment: The predicted Sentiment for the sentence. Required. Known values are:
         "positive", "neutral", and "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.SentenceSentimentValue
        :keyword confidence_scores: The sentiment confidence score between 0 and 1 for the sentence for
         all classes. Required.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2023_04_01.models.SentimentConfidenceScorePerLabel
        :keyword offset: The sentence offset from the start of the document. Required.
        :paramtype offset: int
        :keyword length: The length of the sentence. Required.
        :paramtype length: int
        :keyword targets: The array of sentence targets for the sentence.
        :paramtype targets: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceTarget]
        :keyword assessments: The array of assessments for the sentence.
        :paramtype assessments: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceAssessment]
        """
        super().__init__(**kwargs)
        self.text = text
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.targets = targets
        self.assessments = assessments


class SentenceTarget(_serialization.Model):
    """SentenceTarget.

    All required parameters must be populated in order to send to Azure.

    :ivar sentiment: Targeted sentiment in the sentence. Required. Known values are: "positive",
     "mixed", and "negative".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.TokenSentimentValue
    :ivar confidence_scores: Target sentiment confidence scores for the target in the sentence.
     Required.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2023_04_01.models.TargetConfidenceScoreLabel
    :ivar offset: The target offset from the start of the sentence. Required.
    :vartype offset: int
    :ivar length: The length of the target. Required.
    :vartype length: int
    :ivar text: The target text detected. Required.
    :vartype text: str
    :ivar relations: The array of either assessment or target objects which is related to the
     target. Required.
    :vartype relations: list[~azure.ai.textanalytics.v2023_04_01.models.TargetRelation]
    """

    _validation = {
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'offset': {'required': True},
        'length': {'required': True},
        'text': {'required': True},
        'relations': {'required': True},
    }

    _attribute_map = {
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "TargetConfidenceScoreLabel"},
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
        "text": {"key": "text", "type": "str"},
        "relations": {"key": "relations", "type": "[TargetRelation]"},
    }

    def __init__(
        self,
        *,
        sentiment: Union[str, "_models.TokenSentimentValue"],
        confidence_scores: "_models.TargetConfidenceScoreLabel",
        offset: int,
        length: int,
        text: str,
        relations: List["_models.TargetRelation"],
        **kwargs
    ):
        """
        :keyword sentiment: Targeted sentiment in the sentence. Required. Known values are: "positive",
         "mixed", and "negative".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.TokenSentimentValue
        :keyword confidence_scores: Target sentiment confidence scores for the target in the sentence.
         Required.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2023_04_01.models.TargetConfidenceScoreLabel
        :keyword offset: The target offset from the start of the sentence. Required.
        :paramtype offset: int
        :keyword length: The length of the target. Required.
        :paramtype length: int
        :keyword text: The target text detected. Required.
        :paramtype text: str
        :keyword relations: The array of either assessment or target objects which is related to the
         target. Required.
        :paramtype relations: list[~azure.ai.textanalytics.v2023_04_01.models.TargetRelation]
        """
        super().__init__(**kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.offset = offset
        self.length = length
        self.text = text
        self.relations = relations


class SentimentAnalysisLROTask(AnalyzeTextLROTask):
    """An object representing the task definition for a Sentiment Analysis task.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar kind: Enumeration of supported long-running Text Analysis tasks. Required. Known values
     are: "SentimentAnalysis", "EntityRecognition", "PiiEntityRecognition", "KeyPhraseExtraction",
     "EntityLinking", "Healthcare", "ExtractiveSummarization", "CustomEntityRecognition",
     "CustomSingleLabelClassification", "CustomMultiLabelClassification", and
     "AbstractiveSummarization".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROTaskKind
    :ivar parameters: Supported parameters for a Sentiment Analysis task.
    :vartype parameters: ~azure.ai.textanalytics.v2023_04_01.models.SentimentAnalysisTaskParameters
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "parameters": {"key": "parameters", "type": "SentimentAnalysisTaskParameters"},
    }

    def __init__(
        self,
        *,
        task_name: Optional[str] = None,
        parameters: Optional["_models.SentimentAnalysisTaskParameters"] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword parameters: Supported parameters for a Sentiment Analysis task.
        :paramtype parameters:
         ~azure.ai.textanalytics.v2023_04_01.models.SentimentAnalysisTaskParameters
        """
        super().__init__(task_name=task_name, **kwargs)
        self.kind = 'SentimentAnalysis'  # type: str
        self.parameters = parameters


class SentimentAnalysisTaskParameters(PreBuiltTaskParameters):
    """Supported parameters for a Sentiment Analysis task.

    :ivar logging_opt_out:
    :vartype logging_opt_out: bool
    :ivar model_version:
    :vartype model_version: str
    :ivar opinion_mining:
    :vartype opinion_mining: bool
    :ivar string_index_type: Specifies the method used to interpret string offsets.  Defaults to
     Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
     and "Utf16CodeUnit".
    :vartype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
    """

    _attribute_map = {
        "logging_opt_out": {"key": "loggingOptOut", "type": "bool"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "opinion_mining": {"key": "opinionMining", "type": "bool"},
        "string_index_type": {"key": "stringIndexType", "type": "str"},
    }

    def __init__(
        self,
        *,
        logging_opt_out: bool = False,
        model_version: str = "latest",
        opinion_mining: bool = False,
        string_index_type: Union[str, "_models.StringIndexType"] = "TextElements_v8",
        **kwargs
    ):
        """
        :keyword logging_opt_out:
        :paramtype logging_opt_out: bool
        :keyword model_version:
        :paramtype model_version: str
        :keyword opinion_mining:
        :paramtype opinion_mining: bool
        :keyword string_index_type: Specifies the method used to interpret string offsets.  Defaults to
         Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see
         https://aka.ms/text-analytics-offsets. Known values are: "TextElements_v8", "UnicodeCodePoint",
         and "Utf16CodeUnit".
        :paramtype string_index_type: str or ~azure.ai.textanalytics.v2023_04_01.models.StringIndexType
        """
        super().__init__(logging_opt_out=logging_opt_out, model_version=model_version, **kwargs)
        self.opinion_mining = opinion_mining
        self.string_index_type = string_index_type


class SentimentConfidenceScorePerLabel(_serialization.Model):
    """Represents the confidence scores between 0 and 1 across all sentiment classes: positive, neutral, negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Confidence score for positive sentiment. Required.
    :vartype positive: float
    :ivar neutral: Confidence score for neutral sentiment. Required.
    :vartype neutral: float
    :ivar negative: Confidence score for negative sentiment. Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'neutral': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        "positive": {"key": "positive", "type": "float"},
        "neutral": {"key": "neutral", "type": "float"},
        "negative": {"key": "negative", "type": "float"},
    }

    def __init__(
        self,
        *,
        positive: float,
        neutral: float,
        negative: float,
        **kwargs
    ):
        """
        :keyword positive: Confidence score for positive sentiment. Required.
        :paramtype positive: float
        :keyword neutral: Confidence score for neutral sentiment. Required.
        :paramtype neutral: float
        :keyword negative: Confidence score for negative sentiment. Required.
        :paramtype negative: float
        """
        super().__init__(**kwargs)
        self.positive = positive
        self.neutral = neutral
        self.negative = negative


class SentimentDocumentResult(DocumentResult):
    """SentimentDocumentResult.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar sentiment: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     Required. Known values are: "positive", "neutral", "negative", and "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.DocumentSentimentValue
    :ivar confidence_scores: Document level sentiment confidence scores between 0 and 1 for each
     sentiment class. Required.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2023_04_01.models.SentimentConfidenceScorePerLabel
    :ivar sentences: Sentence level sentiment analysis. Required.
    :vartype sentences: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceSentiment]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "SentimentConfidenceScorePerLabel"},
        "sentences": {"key": "sentences", "type": "[SentenceSentiment]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        sentiment: Union[str, "_models.DocumentSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        sentences: List["_models.SentenceSentiment"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword sentiment: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
         Required. Known values are: "positive", "neutral", "negative", and "mixed".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.DocumentSentimentValue
        :keyword confidence_scores: Document level sentiment confidence scores between 0 and 1 for each
         sentiment class. Required.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2023_04_01.models.SentimentConfidenceScorePerLabel
        :keyword sentences: Sentence level sentiment analysis. Required.
        :paramtype sentences: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceSentiment]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, **kwargs)
        self.sentiment = sentiment
        self.confidence_scores = confidence_scores
        self.sentences = sentences


class SentimentLROResult(AnalyzeTextLROResult):
    """SentimentLROResult.

    All required parameters must be populated in order to send to Azure.

    :ivar task_name:
    :vartype task_name: str
    :ivar last_update_date_time: Required.
    :vartype last_update_date_time: ~datetime.datetime
    :ivar status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
     "cancelled", "cancelling", and "partiallyCompleted".
    :vartype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
    :ivar kind: Enumeration of supported Text Analysis long-running operation task results.
     Required. Known values are: "SentimentAnalysisLROResults", "EntityRecognitionLROResults",
     "PiiEntityRecognitionLROResults", "KeyPhraseExtractionLROResults", "EntityLinkingLROResults",
     "HealthcareLROResults", "ExtractiveSummarizationLROResults",
     "CustomEntityRecognitionLROResults", "CustomSingleLabelClassificationLROResults",
     "CustomMultiLabelClassificationLROResults", and "AbstractiveSummarizationLROResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.SentimentResponse
    """

    _validation = {
        'last_update_date_time': {'required': True},
        'status': {'required': True},
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "task_name": {"key": "taskName", "type": "str"},
        "last_update_date_time": {"key": "lastUpdateDateTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "SentimentResponse"},
    }

    def __init__(
        self,
        *,
        last_update_date_time: datetime.datetime,
        status: Union[str, "_models.State"],
        results: "_models.SentimentResponse",
        task_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword task_name:
        :paramtype task_name: str
        :keyword last_update_date_time: Required.
        :paramtype last_update_date_time: ~datetime.datetime
        :keyword status: Required. Known values are: "notStarted", "running", "succeeded", "failed",
         "cancelled", "cancelling", and "partiallyCompleted".
        :paramtype status: str or ~azure.ai.textanalytics.v2023_04_01.models.State
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.SentimentResponse
        """
        super().__init__(task_name=task_name, last_update_date_time=last_update_date_time, status=status, **kwargs)
        self.kind = 'SentimentAnalysisLROResults'  # type: str
        self.results = results


class SentimentResponse(PreBuiltResult):
    """SentimentResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar errors: Errors by document id. Required.
    :vartype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the request payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
    :ivar model_version: This field indicates which model is used for scoring. Required.
    :vartype model_version: str
    :ivar documents: Sentiment analysis per document. Required.
    :vartype documents:
     list[~azure.ai.textanalytics.v2023_04_01.models.SentimentResponseDocumentsItem]
    """

    _validation = {
        'errors': {'required': True},
        'model_version': {'required': True},
        'documents': {'required': True},
    }

    _attribute_map = {
        "errors": {"key": "errors", "type": "[DocumentError]"},
        "statistics": {"key": "statistics", "type": "RequestStatistics"},
        "model_version": {"key": "modelVersion", "type": "str"},
        "documents": {"key": "documents", "type": "[SentimentResponseDocumentsItem]"},
    }

    def __init__(
        self,
        *,
        errors: List["_models.DocumentError"],
        model_version: str,
        documents: List["_models.SentimentResponseDocumentsItem"],
        statistics: Optional["_models.RequestStatistics"] = None,
        **kwargs
    ):
        """
        :keyword errors: Errors by document id. Required.
        :paramtype errors: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentError]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the request payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.RequestStatistics
        :keyword model_version: This field indicates which model is used for scoring. Required.
        :paramtype model_version: str
        :keyword documents: Sentiment analysis per document. Required.
        :paramtype documents:
         list[~azure.ai.textanalytics.v2023_04_01.models.SentimentResponseDocumentsItem]
        """
        super().__init__(errors=errors, statistics=statistics, model_version=model_version, **kwargs)
        self.documents = documents


class SentimentResponseDocumentsItem(SentimentDocumentResult):
    """SentimentResponseDocumentsItem.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Unique, non-empty document identifier. Required.
    :vartype id: str
    :ivar warnings: Warnings encountered while processing document. Required.
    :vartype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
    :ivar statistics: if showStats=true was specified in the request this field will contain
     information about the document payload.
    :vartype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
    :ivar sentiment: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
     Required. Known values are: "positive", "neutral", "negative", and "mixed".
    :vartype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.DocumentSentimentValue
    :ivar confidence_scores: Document level sentiment confidence scores between 0 and 1 for each
     sentiment class. Required.
    :vartype confidence_scores:
     ~azure.ai.textanalytics.v2023_04_01.models.SentimentConfidenceScorePerLabel
    :ivar sentences: Sentence level sentiment analysis. Required.
    :vartype sentences: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceSentiment]
    """

    _validation = {
        'id': {'required': True},
        'warnings': {'required': True},
        'sentiment': {'required': True},
        'confidence_scores': {'required': True},
        'sentences': {'required': True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "warnings": {"key": "warnings", "type": "[DocumentWarning]"},
        "statistics": {"key": "statistics", "type": "DocumentStatistics"},
        "sentiment": {"key": "sentiment", "type": "str"},
        "confidence_scores": {"key": "confidenceScores", "type": "SentimentConfidenceScorePerLabel"},
        "sentences": {"key": "sentences", "type": "[SentenceSentiment]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        warnings: List["_models.DocumentWarning"],
        sentiment: Union[str, "_models.DocumentSentimentValue"],
        confidence_scores: "_models.SentimentConfidenceScorePerLabel",
        sentences: List["_models.SentenceSentiment"],
        statistics: Optional["_models.DocumentStatistics"] = None,
        **kwargs
    ):
        """
        :keyword id: Unique, non-empty document identifier. Required.
        :paramtype id: str
        :keyword warnings: Warnings encountered while processing document. Required.
        :paramtype warnings: list[~azure.ai.textanalytics.v2023_04_01.models.DocumentWarning]
        :keyword statistics: if showStats=true was specified in the request this field will contain
         information about the document payload.
        :paramtype statistics: ~azure.ai.textanalytics.v2023_04_01.models.DocumentStatistics
        :keyword sentiment: Predicted sentiment for document (Negative, Neutral, Positive, or Mixed).
         Required. Known values are: "positive", "neutral", "negative", and "mixed".
        :paramtype sentiment: str or ~azure.ai.textanalytics.v2023_04_01.models.DocumentSentimentValue
        :keyword confidence_scores: Document level sentiment confidence scores between 0 and 1 for each
         sentiment class. Required.
        :paramtype confidence_scores:
         ~azure.ai.textanalytics.v2023_04_01.models.SentimentConfidenceScorePerLabel
        :keyword sentences: Sentence level sentiment analysis. Required.
        :paramtype sentences: list[~azure.ai.textanalytics.v2023_04_01.models.SentenceSentiment]
        """
        super().__init__(id=id, warnings=warnings, statistics=statistics, sentiment=sentiment, confidence_scores=confidence_scores, sentences=sentences, **kwargs)


class SentimentTaskResult(AnalyzeTextTaskResult):
    """SentimentTaskResult.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Enumeration of supported Text Analysis task results. Required. Known values are:
     "SentimentAnalysisResults", "EntityRecognitionResults", "PiiEntityRecognitionResults",
     "KeyPhraseExtractionResults", "LanguageDetectionResults", and "EntityLinkingResults".
    :vartype kind: str or ~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextTaskResultsKind
    :ivar results: Required.
    :vartype results: ~azure.ai.textanalytics.v2023_04_01.models.SentimentResponse
    """

    _validation = {
        'kind': {'required': True},
        'results': {'required': True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "results": {"key": "results", "type": "SentimentResponse"},
    }

    def __init__(
        self,
        *,
        results: "_models.SentimentResponse",
        **kwargs
    ):
        """
        :keyword results: Required.
        :paramtype results: ~azure.ai.textanalytics.v2023_04_01.models.SentimentResponse
        """
        super().__init__(**kwargs)
        self.kind = 'SentimentAnalysisResults'  # type: str
        self.results = results


class SummaryContext(_serialization.Model):
    """The context of the summary.

    All required parameters must be populated in order to send to Azure.

    :ivar offset: Start position for the context. Use of different 'stringIndexType' values can
     affect the offset returned. Required.
    :vartype offset: int
    :ivar length: The length of the context. Use of different 'stringIndexType' values can affect
     the length returned. Required.
    :vartype length: int
    """

    _validation = {
        'offset': {'required': True},
        'length': {'required': True},
    }

    _attribute_map = {
        "offset": {"key": "offset", "type": "int"},
        "length": {"key": "length", "type": "int"},
    }

    def __init__(
        self,
        *,
        offset: int,
        length: int,
        **kwargs
    ):
        """
        :keyword offset: Start position for the context. Use of different 'stringIndexType' values can
         affect the offset returned. Required.
        :paramtype offset: int
        :keyword length: The length of the context. Use of different 'stringIndexType' values can
         affect the length returned. Required.
        :paramtype length: int
        """
        super().__init__(**kwargs)
        self.offset = offset
        self.length = length


class TargetConfidenceScoreLabel(_serialization.Model):
    """Represents the confidence scores across all sentiment classes: positive and negative.

    All required parameters must be populated in order to send to Azure.

    :ivar positive: Confidence score for positive sentiment. Required.
    :vartype positive: float
    :ivar negative: Confidence score for negative sentiment. Required.
    :vartype negative: float
    """

    _validation = {
        'positive': {'required': True},
        'negative': {'required': True},
    }

    _attribute_map = {
        "positive": {"key": "positive", "type": "float"},
        "negative": {"key": "negative", "type": "float"},
    }

    def __init__(
        self,
        *,
        positive: float,
        negative: float,
        **kwargs
    ):
        """
        :keyword positive: Confidence score for positive sentiment. Required.
        :paramtype positive: float
        :keyword negative: Confidence score for negative sentiment. Required.
        :paramtype negative: float
        """
        super().__init__(**kwargs)
        self.positive = positive
        self.negative = negative


class TargetRelation(_serialization.Model):
    """TargetRelation.

    All required parameters must be populated in order to send to Azure.

    :ivar relation_type: The type related to the target. Required. Known values are: "assessment"
     and "target".
    :vartype relation_type: str or ~azure.ai.textanalytics.v2023_04_01.models.TargetRelationType
    :ivar ref: The JSON pointer indicating the linked object. Required.
    :vartype ref: str
    """

    _validation = {
        'relation_type': {'required': True},
        'ref': {'required': True},
    }

    _attribute_map = {
        "relation_type": {"key": "relationType", "type": "str"},
        "ref": {"key": "ref", "type": "str"},
    }

    def __init__(
        self,
        *,
        relation_type: Union[str, "_models.TargetRelationType"],
        ref: str,
        **kwargs
    ):
        """
        :keyword relation_type: The type related to the target. Required. Known values are:
         "assessment" and "target".
        :paramtype relation_type: str or ~azure.ai.textanalytics.v2023_04_01.models.TargetRelationType
        :keyword ref: The JSON pointer indicating the linked object. Required.
        :paramtype ref: str
        """
        super().__init__(**kwargs)
        self.relation_type = relation_type
        self.ref = ref


class TasksStateTasks(_serialization.Model):
    """TasksStateTasks.

    All required parameters must be populated in order to send to Azure.

    :ivar completed: Required.
    :vartype completed: int
    :ivar failed: Required.
    :vartype failed: int
    :ivar in_progress: Required.
    :vartype in_progress: int
    :ivar total: Required.
    :vartype total: int
    :ivar items:
    :vartype items: list[~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResult]
    """

    _validation = {
        'completed': {'required': True},
        'failed': {'required': True},
        'in_progress': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        "completed": {"key": "completed", "type": "int"},
        "failed": {"key": "failed", "type": "int"},
        "in_progress": {"key": "inProgress", "type": "int"},
        "total": {"key": "total", "type": "int"},
        "items": {"key": "items", "type": "[AnalyzeTextLROResult]"},
    }

    def __init__(
        self,
        *,
        completed: int,
        failed: int,
        in_progress: int,
        total: int,
        items: Optional[List["_models.AnalyzeTextLROResult"]] = None,
        **kwargs
    ):
        """
        :keyword completed: Required.
        :paramtype completed: int
        :keyword failed: Required.
        :paramtype failed: int
        :keyword in_progress: Required.
        :paramtype in_progress: int
        :keyword total: Required.
        :paramtype total: int
        :keyword items:
        :paramtype items: list[~azure.ai.textanalytics.v2023_04_01.models.AnalyzeTextLROResult]
        """
        super().__init__(**kwargs)
        self.completed = completed
        self.failed = failed
        self.in_progress = in_progress
        self.total = total
        self.items = items
