# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class ResponseBase(Model):
    """Response base.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Identifiable

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        '_type': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Identifiable': 'Identifiable'}
    }

    def __init__(self, **kwargs):
        super(ResponseBase, self).__init__(**kwargs)
        self._type = None


class Identifiable(ResponseBase):
    """Defines the identity of a resource.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Response

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Response': 'Response'}
    }

    def __init__(self, **kwargs):
        super(Identifiable, self).__init__(**kwargs)
        self.id = None
        self._type = 'Identifiable'


class Response(Identifiable):
    """Defines a response. All schemas that could be returned at the root of a
    response should inherit from this.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Answer, Thing, ErrorResponse

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'Answer': 'Answer', 'Thing': 'Thing', 'ErrorResponse': 'ErrorResponse'}
    }

    def __init__(self, **kwargs):
        super(Response, self).__init__(**kwargs)
        self.read_link = None
        self.web_search_url = None
        self.potential_action = None
        self.immediate_action = None
        self.preferred_clickthrough_url = None
        self.adaptive_card = None
        self._type = 'Response'


class Thing(Response):
    """Defines a thing.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CreativeWork

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
        'url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'CreativeWork': 'CreativeWork'}
    }

    def __init__(self, **kwargs):
        super(Thing, self).__init__(**kwargs)
        self.url = None
        self._type = 'Thing'


class CreativeWork(Thing):
    """The most generic kind of creative work, including books, movies,
    photographs, software programs, etc.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Action

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar about: For internal use only.
    :vartype about:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar mentions: For internal use only.
    :vartype mentions:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar creator:
    :vartype creator: ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar text: Text content of this creative work
    :vartype text: str
    :ivar discussion_url:
    :vartype discussion_url: str
    :ivar comment_count:
    :vartype comment_count: int
    :ivar main_entity:
    :vartype main_entity:
     ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar head_line:
    :vartype head_line: str
    :ivar copyright_holder:
    :vartype copyright_holder:
     ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar copyright_year:
    :vartype copyright_year: int
    :ivar disclaimer:
    :vartype disclaimer: str
    :ivar is_accessible_for_free:
    :vartype is_accessible_for_free: bool
    :ivar genre:
    :vartype genre: list[str]
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
        'url': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'about': {'readonly': True},
        'mentions': {'readonly': True},
        'provider': {'readonly': True},
        'creator': {'readonly': True},
        'text': {'readonly': True},
        'discussion_url': {'readonly': True},
        'comment_count': {'readonly': True},
        'main_entity': {'readonly': True},
        'head_line': {'readonly': True},
        'copyright_holder': {'readonly': True},
        'copyright_year': {'readonly': True},
        'disclaimer': {'readonly': True},
        'is_accessible_for_free': {'readonly': True},
        'genre': {'readonly': True},
        'is_family_friendly': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'about': {'key': 'about', 'type': '[Thing]'},
        'mentions': {'key': 'mentions', 'type': '[Thing]'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'creator': {'key': 'creator', 'type': 'Thing'},
        'text': {'key': 'text', 'type': 'str'},
        'discussion_url': {'key': 'discussionUrl', 'type': 'str'},
        'comment_count': {'key': 'commentCount', 'type': 'int'},
        'main_entity': {'key': 'mainEntity', 'type': 'Thing'},
        'head_line': {'key': 'headLine', 'type': 'str'},
        'copyright_holder': {'key': 'copyrightHolder', 'type': 'Thing'},
        'copyright_year': {'key': 'copyrightYear', 'type': 'int'},
        'disclaimer': {'key': 'disclaimer', 'type': 'str'},
        'is_accessible_for_free': {'key': 'isAccessibleForFree', 'type': 'bool'},
        'genre': {'key': 'genre', 'type': '[str]'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
    }

    _subtype_map = {
        '_type': {'Action': 'Action'}
    }

    def __init__(self, **kwargs):
        super(CreativeWork, self).__init__(**kwargs)
        self.thumbnail_url = None
        self.about = None
        self.mentions = None
        self.provider = None
        self.creator = None
        self.text = None
        self.discussion_url = None
        self.comment_count = None
        self.main_entity = None
        self.head_line = None
        self.copyright_holder = None
        self.copyright_year = None
        self.disclaimer = None
        self.is_accessible_for_free = None
        self.genre = None
        self.is_family_friendly = None
        self._type = 'CreativeWork'


class Action(CreativeWork):
    """Action.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SearchAction

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar about: For internal use only.
    :vartype about:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar mentions: For internal use only.
    :vartype mentions:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar creator:
    :vartype creator: ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar text: Text content of this creative work
    :vartype text: str
    :ivar discussion_url:
    :vartype discussion_url: str
    :ivar comment_count:
    :vartype comment_count: int
    :ivar main_entity:
    :vartype main_entity:
     ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar head_line:
    :vartype head_line: str
    :ivar copyright_holder:
    :vartype copyright_holder:
     ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar copyright_year:
    :vartype copyright_year: int
    :ivar disclaimer:
    :vartype disclaimer: str
    :ivar is_accessible_for_free:
    :vartype is_accessible_for_free: bool
    :ivar genre:
    :vartype genre: list[str]
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :ivar result:
    :vartype result:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar display_name:
    :vartype display_name: str
    :ivar is_top_action:
    :vartype is_top_action: bool
    :ivar service_url:
    :vartype service_url: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
        'url': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'about': {'readonly': True},
        'mentions': {'readonly': True},
        'provider': {'readonly': True},
        'creator': {'readonly': True},
        'text': {'readonly': True},
        'discussion_url': {'readonly': True},
        'comment_count': {'readonly': True},
        'main_entity': {'readonly': True},
        'head_line': {'readonly': True},
        'copyright_holder': {'readonly': True},
        'copyright_year': {'readonly': True},
        'disclaimer': {'readonly': True},
        'is_accessible_for_free': {'readonly': True},
        'genre': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'about': {'key': 'about', 'type': '[Thing]'},
        'mentions': {'key': 'mentions', 'type': '[Thing]'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'creator': {'key': 'creator', 'type': 'Thing'},
        'text': {'key': 'text', 'type': 'str'},
        'discussion_url': {'key': 'discussionUrl', 'type': 'str'},
        'comment_count': {'key': 'commentCount', 'type': 'int'},
        'main_entity': {'key': 'mainEntity', 'type': 'Thing'},
        'head_line': {'key': 'headLine', 'type': 'str'},
        'copyright_holder': {'key': 'copyrightHolder', 'type': 'Thing'},
        'copyright_year': {'key': 'copyrightYear', 'type': 'int'},
        'disclaimer': {'key': 'disclaimer', 'type': 'str'},
        'is_accessible_for_free': {'key': 'isAccessibleForFree', 'type': 'bool'},
        'genre': {'key': 'genre', 'type': '[str]'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'SearchAction': 'SearchAction'}
    }

    def __init__(self, **kwargs):
        super(Action, self).__init__(**kwargs)
        self.result = None
        self.display_name = None
        self.is_top_action = None
        self.service_url = None
        self._type = 'Action'


class Answer(Response):
    """Defines an answer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SearchResultsAnswer

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
    }

    _subtype_map = {
        '_type': {'SearchResultsAnswer': 'SearchResultsAnswer'}
    }

    def __init__(self, **kwargs):
        super(Answer, self).__init__(**kwargs)
        self._type = 'Answer'


class Error(Model):
    """Defines the error that occurred.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code that identifies the category of
     error. Possible values include: 'None', 'ServerError', 'InvalidRequest',
     'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'.
     Default value: "None" .
    :type code: str or
     ~azure.cognitiveservices.search.autosuggest.models.ErrorCode
    :param message: Required. A description of the error.
    :type message: str
    :ivar more_details: A description that provides additional information
     about the error.
    :vartype more_details: str
    :ivar parameter: The parameter in the request that caused the error.
    :vartype parameter: str
    :ivar value: The parameter's value in the request that was not valid.
    :vartype value: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
        'more_details': {'readonly': True},
        'parameter': {'readonly': True},
        'value': {'readonly': True},
        '_type': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'more_details': {'key': 'moreDetails', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', "None")
        self.message = kwargs.get('message', None)
        self.more_details = None
        self.parameter = None
        self.value = None
        self._type = None


class ErrorResponse(Response):
    """The top-level response that represents a failed request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    :param errors: Required. A list of errors that describe the reasons why
     the request failed.
    :type errors:
     list[~azure.cognitiveservices.search.autosuggest.models.Error]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
        'errors': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Error]'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.errors = kwargs.get('errors', None)
        self._type = 'ErrorResponse'


class ErrorResponseException(HttpOperationError):
    """Server responded with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class QueryContext(Model):
    """Defines the query context that Bing used for the request.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param original_query: Required. The query string as specified in the
     request.
    :type original_query: str
    :ivar altered_query: The query string used by Bing to perform the query.
     Bing uses the altered query string if the original query string contained
     spelling mistakes. For example, if the query string is "saling downwind",
     the altered query string will be "sailing downwind". This field is
     included only if the original query string contains a spelling mistake.
    :vartype altered_query: str
    :ivar alteration_override_query: The query string to use to force Bing to
     use the original string. For example, if the query string is "saling
     downwind", the override query string will be "+saling downwind". Remember
     to encode the query string which results in "%2Bsaling+downwind". This
     field is included only if the original query string contains a spelling
     mistake.
    :vartype alteration_override_query: str
    :ivar adult_intent: A Boolean value that indicates whether the specified
     query has adult intent. The value is true if the query has adult intent;
     otherwise, false.
    :vartype adult_intent: bool
    :ivar ask_user_for_location: A Boolean value that indicates whether Bing
     requires the user's location to provide accurate results. If you specified
     the user's location by using the X-MSEdge-ClientIP and X-Search-Location
     headers, you can ignore this field. For location aware queries, such as
     "today's weather" or "restaurants near me" that need the user's location
     to provide accurate results, this field is set to true. For location aware
     queries that include the location (for example, "Seattle weather"), this
     field is set to false. This field is also set to false for queries that
     are not location aware, such as "best sellers".
    :vartype ask_user_for_location: bool
    :ivar is_transactional:
    :vartype is_transactional: bool
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        'original_query': {'required': True},
        'altered_query': {'readonly': True},
        'alteration_override_query': {'readonly': True},
        'adult_intent': {'readonly': True},
        'ask_user_for_location': {'readonly': True},
        'is_transactional': {'readonly': True},
        '_type': {'required': True},
    }

    _attribute_map = {
        'original_query': {'key': 'originalQuery', 'type': 'str'},
        'altered_query': {'key': 'alteredQuery', 'type': 'str'},
        'alteration_override_query': {'key': 'alterationOverrideQuery', 'type': 'str'},
        'adult_intent': {'key': 'adultIntent', 'type': 'bool'},
        'ask_user_for_location': {'key': 'askUserForLocation', 'type': 'bool'},
        'is_transactional': {'key': 'isTransactional', 'type': 'bool'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(QueryContext, self).__init__(**kwargs)
        self.original_query = kwargs.get('original_query', None)
        self.altered_query = None
        self.alteration_override_query = None
        self.adult_intent = None
        self.ask_user_for_location = None
        self.is_transactional = None
        self._type = None


class SearchAction(Action):
    """SearchAction.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    :ivar url: The URL to get more information about the thing represented by
     this object.
    :vartype url: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar about: For internal use only.
    :vartype about:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar mentions: For internal use only.
    :vartype mentions:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar provider: The source of the creative work.
    :vartype provider:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar creator:
    :vartype creator: ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar text: Text content of this creative work
    :vartype text: str
    :ivar discussion_url:
    :vartype discussion_url: str
    :ivar comment_count:
    :vartype comment_count: int
    :ivar main_entity:
    :vartype main_entity:
     ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar head_line:
    :vartype head_line: str
    :ivar copyright_holder:
    :vartype copyright_holder:
     ~azure.cognitiveservices.search.autosuggest.models.Thing
    :ivar copyright_year:
    :vartype copyright_year: int
    :ivar disclaimer:
    :vartype disclaimer: str
    :ivar is_accessible_for_free:
    :vartype is_accessible_for_free: bool
    :ivar genre:
    :vartype genre: list[str]
    :ivar is_family_friendly:
    :vartype is_family_friendly: bool
    :ivar result:
    :vartype result:
     list[~azure.cognitiveservices.search.autosuggest.models.Thing]
    :ivar display_name:
    :vartype display_name: str
    :ivar is_top_action:
    :vartype is_top_action: bool
    :ivar service_url:
    :vartype service_url: str
    :ivar display_text:
    :vartype display_text: str
    :ivar query:
    :vartype query: str
    :ivar search_kind: Possible values include: 'WebSearch', 'HistorySearch',
     'DocumentSearch', 'TagSearch', 'LocationSearch', 'CustomSearch'. Default
     value: "WebSearch" .
    :vartype search_kind: str or
     ~azure.cognitiveservices.search.autosuggest.models.SearchKind
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
        'url': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'about': {'readonly': True},
        'mentions': {'readonly': True},
        'provider': {'readonly': True},
        'creator': {'readonly': True},
        'text': {'readonly': True},
        'discussion_url': {'readonly': True},
        'comment_count': {'readonly': True},
        'main_entity': {'readonly': True},
        'head_line': {'readonly': True},
        'copyright_holder': {'readonly': True},
        'copyright_year': {'readonly': True},
        'disclaimer': {'readonly': True},
        'is_accessible_for_free': {'readonly': True},
        'genre': {'readonly': True},
        'is_family_friendly': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
        'display_text': {'readonly': True},
        'query': {'readonly': True},
        'search_kind': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'about': {'key': 'about', 'type': '[Thing]'},
        'mentions': {'key': 'mentions', 'type': '[Thing]'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'creator': {'key': 'creator', 'type': 'Thing'},
        'text': {'key': 'text', 'type': 'str'},
        'discussion_url': {'key': 'discussionUrl', 'type': 'str'},
        'comment_count': {'key': 'commentCount', 'type': 'int'},
        'main_entity': {'key': 'mainEntity', 'type': 'Thing'},
        'head_line': {'key': 'headLine', 'type': 'str'},
        'copyright_holder': {'key': 'copyrightHolder', 'type': 'Thing'},
        'copyright_year': {'key': 'copyrightYear', 'type': 'int'},
        'disclaimer': {'key': 'disclaimer', 'type': 'str'},
        'is_accessible_for_free': {'key': 'isAccessibleForFree', 'type': 'bool'},
        'genre': {'key': 'genre', 'type': '[str]'},
        'is_family_friendly': {'key': 'isFamilyFriendly', 'type': 'bool'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'display_text': {'key': 'displayText', 'type': 'str'},
        'query': {'key': 'query', 'type': 'str'},
        'search_kind': {'key': 'searchKind', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SearchAction, self).__init__(**kwargs)
        self.display_text = None
        self.query = None
        self.search_kind = None
        self._type = 'SearchAction'


class SearchResultsAnswer(Answer):
    """Defines a search result answer.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Suggestions

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.autosuggest.models.QueryContext
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
        'query_context': {'readonly': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
    }

    _subtype_map = {
        '_type': {'Suggestions': 'Suggestions'}
    }

    def __init__(self, **kwargs):
        super(SearchResultsAnswer, self).__init__(**kwargs)
        self.query_context = None
        self._type = 'SearchResultsAnswer'


class Suggestions(SearchResultsAnswer):
    """Suggestions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar potential_action:
    :vartype potential_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar immediate_action:
    :vartype immediate_action:
     list[~azure.cognitiveservices.search.autosuggest.models.Action]
    :ivar preferred_clickthrough_url:
    :vartype preferred_clickthrough_url: str
    :ivar adaptive_card:
    :vartype adaptive_card: str
    :ivar query_context:
    :vartype query_context:
     ~azure.cognitiveservices.search.autosuggest.models.QueryContext
    :param suggestion_groups: Required.
    :type suggestion_groups:
     list[~azure.cognitiveservices.search.autosuggest.models.SuggestionsSuggestionGroup]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'potential_action': {'readonly': True},
        'immediate_action': {'readonly': True},
        'preferred_clickthrough_url': {'readonly': True},
        'adaptive_card': {'readonly': True},
        'query_context': {'readonly': True},
        'suggestion_groups': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'potential_action': {'key': 'potentialAction', 'type': '[Action]'},
        'immediate_action': {'key': 'immediateAction', 'type': '[Action]'},
        'preferred_clickthrough_url': {'key': 'preferredClickthroughUrl', 'type': 'str'},
        'adaptive_card': {'key': 'adaptiveCard', 'type': 'str'},
        'query_context': {'key': 'queryContext', 'type': 'QueryContext'},
        'suggestion_groups': {'key': 'suggestionGroups', 'type': '[SuggestionsSuggestionGroup]'},
    }

    def __init__(self, **kwargs):
        super(Suggestions, self).__init__(**kwargs)
        self.suggestion_groups = kwargs.get('suggestion_groups', None)
        self._type = 'Suggestions'


class SuggestionsSuggestionGroup(Model):
    """SuggestionsSuggestionGroup.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Possible values include: 'Unknown', 'Web',
     'StoreApps', 'SearchHistory', 'PersonalSearchDocuments',
     'PersonalSearchTags', 'Custom'. Default value: "Unknown" .
    :type name: str or
     ~azure.cognitiveservices.search.autosuggest.models.ScenarioType
    :param search_suggestions: Required.
    :type search_suggestions:
     list[~azure.cognitiveservices.search.autosuggest.models.SearchAction]
    :param _type: Required. Constant filled by server.
    :type _type: str
    """

    _validation = {
        'name': {'required': True},
        'search_suggestions': {'required': True},
        '_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'search_suggestions': {'key': 'searchSuggestions', 'type': '[SearchAction]'},
        '_type': {'key': '_type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SuggestionsSuggestionGroup, self).__init__(**kwargs)
        self.name = kwargs.get('name', "Unknown")
        self.search_suggestions = kwargs.get('search_suggestions', None)
        self._type = None
