/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __POWERD_H__
#define __POWERD_H__

#ifdef __cplusplus
extern "C" {
#endif

enum SysPowerStates {
    //Note that callers will be notified of suspend state changes
    //but may not request this state.
    POWERD_SYS_STATE_SUSPEND = 0,

    //The Active state will prevent system suspend
    POWERD_SYS_STATE_ACTIVE,

    POWERD_NUM_POWER_STATES
};

enum powerd_display_state {
    POWERD_DISPLAY_STATE_DONT_CARE = 0,
    POWERD_DISPLAY_STATE_ON,

    /* Keep last */
    POWERD_NUM_DISPLAY_STATES
};

/* Use proximity sensor to override screen state */
#define POWERD_DISPLAY_FLAG_USE_PROXIMITY           (1 << 0)
/* Force autobrightness to be disabled */
#define POWERD_DISPLAY_FLAG_DISABLE_AUTOBRIGHTNESS  (1 << 1)
/* Request the screen to stay bright */
#define POWERD_DISPLAY_FLAG_BRIGHT                  (1 << 2)

/* Must be updated when new flags are added */
#define POWERD_NUM_DISPLAY_FLAGS 3

/*
 * Clients should treat this as an opaque type. Though this isn't really
 * possible until the client library is written.
 */
typedef char powerd_cookie_t[37];

#ifdef __cplusplus
}
#endif

#endif
