#############################################################################
#
#  Pidgin MSN SLP Message Integer Overflow Vulnerabilities (Linux)
#
#  Copyright: SecPod
#
#  Date Written: 2008/07/11
#
#  Revision: 1.4 
#
#  Log: schandan
#  Issue #0032 
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900009);
 script_bugtraq_id(29956);
 script_cve_id("CVE-2008-2927");
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("Revision: 1.4 ");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_name("Pidgin MSN SLP Message Integer Overflow Vulnerabilities (Linux)");
 script_summary("Check for vulnerable version of Pidgin");
 desc = " 
 Overview : The host is running Pidgin, which is prone to integer
 overflow vulnerability.
 
 Vulnerability Insight:

        The flaw is caused due to errors in the msn_slplink_process_msg
        function in libpurple/protocols/msnp9/slplink.c and
        libpurple/protocols/msn/slplink.c files, which fails to perform
        adequate boundary checks on user-supplied data.

        Impact : Remote attacker can execute arbitrary code by sending
        specially crafted SLP message with the privilege of a user.
 
 Impact Level : SYSTEM
 
 Affected Software/OS:
        Pidgin Version prior to 2.4.3 on Linux (All).
 
 Fix : Upgrade to Pidgin Version 2.4.3,
 http://www.pidgin.im/download/
 
 References : http://www.pidgin.im/news/security/?id=24

 CVSS Score Report :
        CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
        CVSS Temporal Score : 3.9
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/uname");
 exit(0);
}


 include("ssh_func.inc");

 if("Linux" >!< get_kb_item("ssh/login/uname")){
        exit(0);
 }

 foreach item (get_kb_list("ssh/*/rpms"))
 {
       if("pidgin~" >< item)
        {
		if(egrep(pattern:"^pidgin~([01]\..*|2\.([0-3](\..*)?|" +
                                 "4(\.[0-2])?))($|[^.0-9])", string:item))
		{
                        security_warning(0);
                	exit(0);
		}
        } 
 } 

 sock = ssh_login_or_reuse_connection();
 if(!sock){
	exit(0);
 }

 pidginVer = ssh_cmd(socket:sock, cmd:"pidgin --version", timeout:timeout);
 ssh_close_connection();

 if(!pidginVer){
	exit(0);
 }

 if(egrep(pattern:"Pidgin ([01]\..*|2\.([0-3](\..*)?|4(\.[0-2])?))($|[^.0-9])",
	  string:pidginVer)){
 	security_warning(0);
 }
