###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for hplip FEDORA-2007-2527
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861076);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.6");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-2527");
  script_cve_id("CVE-2007-5208");
  script_name( "Fedora Update for hplip FEDORA-2007-2527");
  desc = "

  Vulnerability Insight:
  The Hewlett-Packard Linux Imaging and Printing Project provides
  drivers for HP printers and multi-function peripherals.


  Affected Software/OS:
  hplip on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-October/msg00200.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of hplip");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-debuginfo", rpm:"hplip-debuginfo~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio", rpm:"libsane-hpaio~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hpijs", rpm:"hpijs~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-gui", rpm:"hplip-gui~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-gui", rpm:"hplip-gui~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip", rpm:"hplip~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libsane-hpaio", rpm:"libsane-hpaio~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hpijs", rpm:"hpijs~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hplip-debuginfo", rpm:"hplip-debuginfo~1.7.4a~6.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}