#
#VID 24ec781b-8c11-11dd-9923-0016d325a0ed
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 24ec781b-8c11-11dd-9923-0016d325a0ed
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61680);
 script_cve_id("CVE-2008-3920", "CVE-2008-3969");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: bitlbee";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: bitlbee

CVE-2008-3920
Unspecified vulnerability in BitlBee before 1.2.2 allows remote
attackers to 'recreate' and 'hijack' existing accounts via unspecified
vectors.
CVE-2008-3969
Multiple unspecified vulnerabilities in BitlBee before 1.2.3 allow
remote attackers to 'overwrite' and 'hijack' existing accounts via
unknown vectors.  NOTE: this issue exists because of an incomplete fix
for CVE-2008-3920.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/31633/
http://www.vuxml.org/freebsd/24ec781b-8c11-11dd-9923-0016d325a0ed.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: bitlbee";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bitlbee");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.3")<0) {
    security_note(0, data:"Package bitlbee version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
