# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-13366 (gnome-python2-extras)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66568);
 script_cve_id("CVE-2009-3979", "CVE-2009-3980", "CVE-2009-3982", "CVE-2009-3983", "CVE-2009-3984", "CVE-2009-3985", "CVE-2009-3986", "CVE-2009-3388", "CVE-2009-3389");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 12 FEDORA-2009-13366 (gnome-python2-extras)");

 desc = "The remote host is missing an update to gnome-python2-extras
announced via advisory FEDORA-2009-13366.

Update Information:

Update to new upstream Firefox version 3.5.6, fixing multiple security issues
detailed in the upstream advisories:
http://www.mozilla.org/security/known-vulnerabilities/firefox35.html#firefox3.5.6
Update also includes all packages depending on gecko-libs rebuilt against
new version of Firefox / XULRunner.

ChangeLog:

* Wed Dec 16 2009 Jan Horak  - 2.25.3-14
- Rebuild against newer gecko

References:

[ 1 ] Bug #546694 - CVE-2009-3979 Mozilla crash with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=546694
[ 2 ] Bug #546720 - CVE-2009-3983 Mozilla NTLM reflection vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=546720
[ 3 ] Bug #546722 - CVE-2009-3984 Mozilla SSL spoofing with document.location and empty SSL response page
https://bugzilla.redhat.com/show_bug.cgi?id=546722
[ 4 ] Bug #546726 - CVE-2009-3985 Mozilla URL spoofing via invalid document.location
https://bugzilla.redhat.com/show_bug.cgi?id=546726
[ 5 ] Bug #546724 - CVE-2009-3986 Mozilla Chrome privilege escalation via window.opener
https://bugzilla.redhat.com/show_bug.cgi?id=546724

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gnome-python2-extras' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-13366

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-13366 (gnome-python2-extras)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gnome-python2-extras", rpm:"gnome-python2-extras~2.25.3~14.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-gda", rpm:"gnome-python2-gda~2.25.3~14.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-gda", rpm:"gnome-python2-gda~devel~2.25.3", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-gdl", rpm:"gnome-python2-gdl~2.25.3~14.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-gtkhtml2", rpm:"gnome-python2-gtkhtml2~2.25.3~14.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-gtkmozembed", rpm:"gnome-python2-gtkmozembed~2.25.3~14.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-gtkspell", rpm:"gnome-python2-gtkspell~2.25.3~14.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-libegg", rpm:"gnome-python2-libegg~2.25.3~14.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-python2-extras", rpm:"gnome-python2-extras~debuginfo~2.25.3", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
