# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1955-1 (network-manager/network-manager-applet)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66593);
 script_cve_id("CVE-2009-0365");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1955-1 (network-manager/network-manager-applet)");

 desc = "The remote host is missing an update to network-manager/network-manager-applet
announced via advisory DSA 1955-1.

It was discovered that network-manager-applet, a network management
framework, lacks some dbus restriction rules, which allows local users
to obtain sensitive information.

If you have locally modified the /etc/dbus-1/system.d/nm-applet.conf
file, then please make sure that you merge the changes from this fix
when asked during upgrade.


For the stable distribution (lenny), this problem has been fixed in
version 0.6.6-4+lenny1 of network-manager-applet.

For the oldstable distribution (etch), this problem has been fixed in
version 0.6.4-6+etch1 of network-manager.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 0.7.0.99-1 of
network-manager-applet.


We recommend that you upgrade your network-manager and

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201955-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1955-1 (network-manager/network-manager-applet)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"network-manager-gnome", ver:"0.6.4-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"network-manager-dev", ver:"0.6.4-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"network-manager", ver:"0.6.4-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnm-glib0", ver:"0.6.4-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnm-util0", ver:"0.6.4-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnm-glib-dev", ver:"0.6.4-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnm-util-dev", ver:"0.6.4-6+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"network-manager-gnome", ver:"0.6.6-4+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
