//                                               -*- C++ -*-
/**
 *  @file  MaximumEntropyOrderStatisticsCopula.hxx
 *  @brief The maximum entropy order statistics copula
 *
 *  Copyright 2005-2015 Airbus-EDF-IMACS-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2009-10-27 17:42:46 +0100 (mar. 27 oct. 2009)
 */
#ifndef OPENTURNS_MAXIMUMENTROPYORDERSTATISTICSCOPULA_HXX
#define OPENTURNS_MAXIMUMENTROPYORDERSTATISTICSCOPULA_HXX

#include "OTprivate.hxx"
#include "SklarCopula.hxx"
#include "MaximumEntropyOrderStatisticsDistribution.hxx"

BEGIN_NAMESPACE_OPENTURNS

/**
 * @class MaximumEntropyOrderStatisticsCopula
 *
 * The maximum entropy order statistics copula
 */
class OT_API MaximumEntropyOrderStatisticsCopula
  : public SklarCopula
{
  CLASSNAME;
public:

  typedef MaximumEntropyOrderStatisticsDistribution::DistributionCollection DistributionCollection;

  /** Default constructor */
  MaximumEntropyOrderStatisticsCopula();

  /** Parameters constructor */
  explicit MaximumEntropyOrderStatisticsCopula(const DistributionCollection & coll);

  /** Comparison operator */
  Bool operator ==(const MaximumEntropyOrderStatisticsCopula & other) const;

  /** String converter */
  String __repr__() const;
  String __str__(const String & offset = "") const;

  /** Distribution collection accessor */
  void setDistributionCollection(const DistributionCollection & coll);
  DistributionCollection getDistributionCollection() const;

  /* Interface inherited from Distribution */

  /** Virtual constructor */
  virtual MaximumEntropyOrderStatisticsCopula * clone() const;

  /** Get the kth approximation */
  PiecewiseHermiteEvaluationImplementation getApproximation(const UnsignedInteger k = 0) const;

  /** Get the distribution of the marginal distribution corresponding to indices dimensions */
  using CopulaImplementation::getMarginal;
  Implementation getMarginal(const Indices & indices) const;

  /** Parameters value and description accessor */
  NumericalPointWithDescriptionCollection getParametersCollection() const;
  using CopulaImplementation::setParametersCollection;
  void setParametersCollection(const NumericalPointCollection & parametersCollection);

  /* Interface specific to MaximumEntropyOrderStatisticsCopula */

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

protected:


private:
  /** Constructor with no check of the parameters, to speed-up margina creations */
  MaximumEntropyOrderStatisticsCopula(const MaximumEntropyOrderStatisticsDistribution & distribution);

  /** The underlying order statistics distribution */
  MaximumEntropyOrderStatisticsDistribution distribution_;

}; /* class MaximumEntropyOrderStatisticsCopula */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_MAXIMUMENTROPYORDERSTATISTICSCOPULA_HXX */
