; 
; Setup script in order to create a windows auto-installer for OpenTURNS and its dependancies.
;
; To lauch the creation of the installer :
;   makensis  -DOPENTURNS_PREFIX=/absolute/path -DPRODUCT_VERSION=0.13.2  openturns_script.nsi
;

;SetCompressor lzma
SetCompressor /SOLID lzma

; Prefix where openturns is installed on Linux.
!ifndef OPENTURNS_PREFIX
  !error "OPENTURNS_PREFIX must be defined"
!endif

; Where win specific things reside : examples, dedendancies installers and headers... (relative path)
!define WINOT_PATH openturns
!define DEPS_PATH ${WINOT_PATH}\share\openturns\utils

!include "WordFunc.nsh" ; for ${WordAdd}, ${WordReplace}
!include "FileFunc.nsh" ; for ${DirState} , ${GetParent}, ${ConfigWrite}
!include "TextFunc.nsh" ; for ${ConfigRead}

; Script generated by the HM NIS Edit Script Wizard.
; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "OpenTURNS"
!ifndef PRODUCT_VERSION
  !error "PRODUCT_VERSION must be defined"
!endif
!define PRODUCT_WEB_SITE "http://www.openturns.org"
!define PRODUCT_DIR_REGKEY "Software\OpenTURNS"
!define PRODUCT_INST_ROOT_KEY "HKLM"

!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; deactivate some sections to speed up compilation
;!define DEBUG

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "openturns.ico"
!define MUI_UNICON "openturns.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "OpenTURNS.bmp"
!define MUI_HEADERIMAGE
!define MUI_HEADERIMAGE_BITMAP "OpenTURNS_header.bmp"
BrandingText "OpenTURNS ${PRODUCT_VERSION}"

; Language Selection Dialog Settings
!define MUI_LANGDLL_REGISTRY_ROOT "${PRODUCT_UNINST_ROOT_KEY}"
!define MUI_LANGDLL_REGISTRY_KEY "${PRODUCT_UNINST_KEY}"
!define MUI_LANGDLL_REGISTRY_VALUENAME "NSIS:Language"

; Welcome page
!define MUI_WELCOMEPAGE_TEXT "This wizard will guide you through the installation of ${PRODUCT_NAME} ${PRODUCT_VERSION}.\r\rThis installer has been tested on Windows 2000, XP and Vista. Although OpenTURNS may work on it, other operating systems are not supported."
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Components page
!insertmacro MUI_PAGE_COMPONENTS
; Directory page
!define MUI_DIRECTORYPAGE_TEXT_TOP "Setup will install ${PRODUCT_NAME} ${PRODUCT_VERSION} in the following folder. To install in a different folder, click Browse and select another folder.$\r$\rIt is recommended to install OpenTURNS in default path C:\OpenTURNS."
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_TEXT "${PRODUCT_NAME} ${PRODUCT_VERSION} has been installed on your computer.\r\n\r\n${PRODUCT_NAME} can be launched from the start menu."
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "openturns-setup-${PRODUCT_VERSION}-py${PYTHON_VERSION}.exe"
InstallDir "C:\OpenTURNS"
ShowInstDetails show
ShowUnInstDetails show


!macro PRINT MSG
  SetDetailsPrint both
  DetailPrint "${MSG}"
  SetDetailsPrint none
!macroend


Var UserInstall

; Check that current user has administrator privileges 
; if ok : set UserInstall to 0, if not : set UserInstall to 1
!macro CHECK_USER_INSTALL WARN_MSG
  StrCpy $UserInstall "0"

  ; avoid check if /userlevel option is present on command line
  ${GetParameters} $R1
  ClearErrors
  ${GetOptions} $R1 '/userlevel=' $R0
  IfErrors 0 setLevel

  ClearErrors
  WriteRegExpandStr HKLM "System\CurrentControlSet\Control\Session Manager\Environment" "test" "yo"
  IfErrors user_install admin_install
  user_install:
  StrCpy $UserInstall "1"
  MessageBox MB_OK|MB_ICONINFORMATION "You are not running Windows from an administrator account.$\r${WARN_MSG}" /SD IDOK
  admin_install:
  DeleteRegValue HKLM "System\CurrentControlSet\Control\Session Manager\Environment" "test"
  Goto endCheck

  setLevel:
  StrCpy $UserInstall $R0

  endCheck:
!macroend

; Set whether OpenTURNS shortcutes will be in every user menu or only in current user menu.
; CHECK_USER_INSTALL must have been called first
!macro SET_MENU_CONTEXT
  ${If} "$UserInstall" == "0"
    SetShellVarContext all
  ${Else}
    SetShellVarContext current
  ${EndIf}
!macroend


; Launch before the section are displayed
Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY

  !insertmacro CHECK_USER_INSTALL "Installation from a non-administrator account is not supported although it may works."

  ; if OT already installed, uninstall previous OT.
  ReadRegStr $0 ${PRODUCT_INST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}" "InstallPath"
  ${If} $0 != ""
    ReadRegStr $1 ${PRODUCT_INST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}" "Current Version"
    MessageBox MB_YESNO|MB_ICONEXCLAMATION "OpenTURNS $1 is already installed in directory $0.$\rDo you want to uninstall this installed version (recommended)?" /SD IDYES IDNO continue_anyway

    ; copy uninstaller to temp dir in order to erase the whole ot dir
    ; _? option permit to avoid uninstaller to copy itself to tempdir. it permit too to make ExecWait work
    CopyFiles "$0\uninst.exe" $TEMP
    IfSilent 0 +3
    ; silent uninstall
    ExecWait '"$TEMP\uninst.exe" /S _?=$0'
    Goto +2
    ExecWait '"$TEMP\uninst.exe" _?=$0'

    continue_anyway:
  ${EndIf}

  ; Avoid huge logs of File function
  SetDetailsPrint none
  SetAutoClose false
FunctionEnd


Section "!OpenTURNS" SEC01
  SetOverwrite on

  SetDetailsPrint both
  ClearErrors
  CreateDirectory "$INSTDIR"
  IfErrors permisssion_nok permission_ok
  permisssion_nok:
  MessageBox MB_OK|MB_ICONEXCLAMATION "Failed to create OpenTURNS directory $INSTDIR!$\rCheck directory permission.$\rInstallation aborted." /SD IDOK
  Abort
  permission_ok:
  SetDetailsPrint none

  SetOutPath "$INSTDIR"
  File "COPYING.txt"
  File "README.txt"

!ifndef DEBUG
  !insertmacro PRINT "Install binary files in $INSTDIR\bin."
  SetOutPath "$INSTDIR\bin"
  File /r "${WINOT_PATH}\bin\*.*"
;  File /r "${OPENTURNS_PREFIX}\bin\*.*"
  File /r "${OPENTURNS_PREFIX}\bin\*.*"
  File pyot.bat 
  File otprog.bat 
  File pyot.vbs
  File pyotgui.vbs
  ; Replace c:\openturns in openturns-config
  ${WordReplace} "$INSTDIR" "\" "/" "+" $0
  ${ConfigWrite} "$INSTDIR\bin\openturns-config" "  prefix=" "$\"$0$\"" $R0
  ; Set OpenTURNS Prefix
  ${ConfigWrite} "$INSTDIR\bin\pyot.bat" "set OPENTURNS_HOME=" "$INSTDIR" $R0
  ${ConfigWrite} "$INSTDIR\bin\otprog.bat" "set OPENTURNS_HOME=" "$INSTDIR" $R0
  ${ConfigWrite} "$INSTDIR\bin\pyot.vbs" "OPENTURNS_HOME = " "$\"$INSTDIR$\"" $R0
  ${ConfigWrite} "$INSTDIR\bin\pyotgui.vbs" "OPENTURNS_HOME = " "$\"$INSTDIR$\"" $R0

  !insertmacro PRINT "Install conf files in $INSTDIR\etc."
  SetOutPath "$INSTDIR\etc"
  File /r "${OPENTURNS_PREFIX}\etc\*.*"

  !insertmacro PRINT "Install headers files in $INSTDIR\include."
  SetOutPath "$INSTDIR\include"
  File /r "${OPENTURNS_PREFIX}\include\*.*"

  !insertmacro PRINT "Install library files in $INSTDIR\lib."
  SetOutPath "$INSTDIR\lib"
  ; exclude unused python dll produced by libtool
  File /r /x "_*-0.dll" "${OPENTURNS_PREFIX}\lib\*.*"

  !insertmacro PRINT "Install XML template and generic wrapper in $INSTDIR\lib\openturns\wrappers\wrapper.dtd."
  SetOutPath "$INSTDIR\lib\openturns\wrappers"
  File /r "${OPENTURNS_PREFIX}\lib\openturns\wrappers\wrapper.dtd"
  File /r "${OPENTURNS_PREFIX}\lib\openturns\wrappers\generic.*"
!endif

  !insertmacro PRINT "Install misc tools in $INSTDIR\share\openturns\tools"
  SetOutPath "$INSTDIR\share\openturns\tools"
  File "add-python27-toregistry.reg"

  SetOutPath "$INSTDIR\share\openturns\icons"
  File openturns.ico

  # create a version file
  ClearErrors
  FileOpen $0 $INSTDIR\share\openturns\VERSION.txt w
  IfErrors versionfile_fail
  FileWrite $0 "OpenTURNS ${PRODUCT_VERSION}"
  FileClose $0
  versionfile_fail:

  !insertmacro PRINT "Put OpenTURNS in windows registry."
  WriteRegStr ${PRODUCT_INST_ROOT_KEY} ${PRODUCT_DIR_REGKEY} "Current Version" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_INST_ROOT_KEY} ${PRODUCT_DIR_REGKEY} "InstallPath" "$INSTDIR"

  !insertmacro PRINT "Install uninstaller in $INSTDIR\uninst.exe."
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
SectionEnd


Section "OT dependencies" SEC02
!ifndef DEBUG
  SetOverwrite on
  !insertmacro PRINT "Install every OpenTURNS dependencies to $INSTDIR\opt."
  ; every other dependencies
  SetOutPath "$INSTDIR\opt"
  File /r /x "*.htm" /x "*.html" /x "*.chm" "${WINOT_PATH}\opt\*.*"
  ${ConfigWrite} "$INSTDIR\opt\Python${PYTHON_VERSION}\Scripts\ipython" "#!" "$INSTDIR\opt\Python${PYTHON_VERSION}\python.exe" $R0

  ; Visual studio DLL needed by python
  ${If} "$0" != "Microsoft Windows 2000"
    SetOutPath "$INSTDIR\opt\Python${PYTHON_VERSION}\Microsoft.VC90.CRT"
  ${Else}
    ; On Windows 2000, winsxs do not work (great!), put directly dll into Python directory
    ; (this method do not work on >= XP)
    SetOutPath "$INSTDIR\opt\Python${PYTHON_VERSION}"
  ${EndIf}
  File /r "${WINOT_PATH}\opt\Python${PYTHON_VERSION}\Microsoft.VC90.CRT\*.*"
!endif
SectionEnd


Section "OT python examples" SEC03
  SetOverwrite on
!ifndef DEBUG
  ;!insertmacro PRINT "Install wrapper example in $INSTDIR\lib\openturns\examples\python_example."
  ;SetOutPath "$INSTDIR\share\openturns\examples\python_example"
  ;File "examples\python_example\*.*"
  !insertmacro PRINT "Install wrapper example in $INSTDIR\share\openturns\WrapperTemplates\distributed_python_wrapper."
  SetOutPath "$INSTDIR\share\openturns\WrapperTemplates\*.*"
  File /r "${OPENTURNS_PREFIX}\share\openturns\WrapperTemplates\*.*"

  !insertmacro PRINT "Install Python examples in $INSTDIR\share\openturns\examples."
  SetOutPath "$INSTDIR\share\openturns\examples"
  File "${OPENTURNS_PREFIX}\share\openturns\examples\*.py"
  SetOutPath "$INSTDIR\lib\openturns\wrappers"
  File "${OPENTURNS_PREFIX}\lib\openturns\wrappers\*.xml"
  File "${OPENTURNS_PREFIX}\lib\openturns\wrappers\*.dll"
!endif
SectionEnd


Section -AdditionalIcons
  !insertmacro PRINT "Create OpenTURNS menu."
  ; install shortcuts on every accounts
  !insertmacro SET_MENU_CONTEXT
  CreateDirectory "$SMPROGRAMS\OpenTURNS"
  CreateShortCut "$SMPROGRAMS\OpenTURNS\OpenTURNS-IPython.lnk" "$INSTDIR\bin\pyotgui.vbs" "" "$INSTDIR\share\openturns\icons\openturns.ico" 0 SW_SHOWMINIMIZED
  CreateShortCut "$SMPROGRAMS\OpenTURNS\README.lnk"   "$INSTDIR\README.txt" "" "" 1
  CreateShortCut "$SMPROGRAMS\OpenTURNS\Uninstall.lnk" "$INSTDIR\uninst.exe" "" "" 2
SectionEnd


; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} "OpenTURNS DLL and headers."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC02} "OpenTURNS dependencies (Python, R, ...)."
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC03} "OpenTURNS python examples."
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onInit
  !insertmacro MUI_UNGETLANGUAGE
  !insertmacro CHECK_USER_INSTALL "Uninstall from a non-administrator account is not supported, although it may work if you installed ${PRODUCT_NAME} from a user account."
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Do you want to remove $(^Name) (directory $INSTDIR will be erased)?" /SD IDYES IDYES +2
  Abort
FunctionEnd


Section Uninstall
  ; nsis can't delete current directory
  SetOutPath $TEMP

  SetDetailsPrint textonly
  RMDir /r "$INSTDIR"

  !insertmacro SET_MENU_CONTEXT
  SetDetailsPrint both
  RMDir /r "$SMPROGRAMS\OpenTURNS"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey ${PRODUCT_INST_ROOT_KEY} "${PRODUCT_DIR_REGKEY}"

  SetAutoClose false
SectionEnd
