/*
 *  Copyright (c) 2010 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTL_CORE_TIME_MACHINE_
#define _GTL_CORE_TIME_MACHINE_

#include <vector>
#include <map>

#include <GTLCore/Macros.h>
#include <GTLCore/Export.h>

namespace GTLCore {
  class String;
  class Value;
  namespace Metadata {
    class ParameterEntry;
  }
  class TimeController;
  /**
    * @ingroup GTLCore_TimeMachine
    *
    * This class control the advancement of time.
    *
    * When a @p TimeController is passed to the @p TimeMachine the time machine will take
    * care of deleting it. But you can pass a @p TimeController multiple time to the same
    * @p TimeMachine.
    */
  class GTLCORE_EXPORT TimeMachine {
    GTL_NO_COPY(TimeMachine);
    public:
      TimeMachine();
      ~TimeMachine();
      /**
        * Start controlling a parameter entry with the given time controller.
        * @param _timeController the @p TimeMachine will take ownership of that controller.
        */
      void startControlling(const Metadata::ParameterEntry* _entry, const TimeController* _timeController);
      void startControlling(const Metadata::ParameterEntry* _entry, const std::vector<const TimeController*>& _timeController);
      void stopControlling(const String&  _name);
      std::map< GTLCore::String, GTLCore::Value> parametersAt(double t) const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
