/*
 *  This file is part of nzbget
 *
 *  Copyright (C) 2013-2015 Andrey Prygunkov <hugbug@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * $Revision$
 * $Date$
 *
 */


#ifndef CLEANUP_H
#define CLEANUP_H

#include "Log.h"
#include "Thread.h"
#include "DownloadInfo.h"
#include "Script.h"

class MoveController : public Thread, public ScriptController
{
private:
	PostInfo*			m_pPostInfo;
	char				m_szInterDir[1024];
	char				m_szDestDir[1024];

	bool				MoveFiles();

protected:
	virtual void		AddMessage(Message::EKind eKind, const char* szText);

public:
	virtual void		Run();
	static void			StartJob(PostInfo* pPostInfo);
};

class CleanupController : public Thread, public ScriptController
{
private:
	PostInfo*			m_pPostInfo;
	char				m_szDestDir[1024];
	char				m_szFinalDir[1024];

	bool				Cleanup(const char* szDestDir, bool *bDeleted);

protected:
	virtual void		AddMessage(Message::EKind eKind, const char* szText);

public:
	virtual void		Run();
	static void			StartJob(PostInfo* pPostInfo);
};

#endif
