include(CheckCCompilerFlag)
include(CheckCXXCompilerFlag)

macro(flagvar FLAG FLAGNAME PREFIX)
  string(REPLACE "-" "_" RESULT "${FLAG}")
  string(REPLACE "/" "_" RESULT "${RESULT}")
  string(REPLACE "," "_" RESULT "${RESULT}")
  string(TOUPPER "${PREFIX}_ACCEPTS${RESULT}" ${FLAGNAME})
endmacro(flagvar)

macro(try_add_c_flag FLAG)
  flagvar(${FLAG} FLAGNAME C)
  check_c_compiler_flag(${FLAG} ${FLAGNAME})
  if ("${ARGV1}" STREQUAL "")
    set(FLAGSNAME "CMAKE_C_FLAGS")
  else ()
    set(FLAGSNAME "CMAKE_C_FLAGS_${ARGV1}")
  endif ()
  if (${${FLAGNAME}})
    set(${FLAGSNAME} "${${FLAGSNAME}} ${FLAG}")
  endif ()
endmacro(try_add_c_flag)

macro(try_add_cxx_flag FLAG)
  flagvar(${FLAG} FLAGNAME CXX)
  check_cxx_compiler_flag(${FLAG} ${FLAGNAME})
  if ("${ARGV1}" STREQUAL "")
    set(FLAGSNAME "CMAKE_CXX_FLAGS")
  else ()
    set(FLAGSNAME "CMAKE_CXX_FLAGS_${ARGV1}")
  endif ()
  if (${${FLAGNAME}})
    set(${FLAGSNAME} "${${FLAGSNAME}} ${FLAG}")
  endif ()
endmacro(try_add_cxx_flag)

