#include "osl/misc/bitOp.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class BitOpTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE( BitOpTest );
  CPPUNIT_TEST( testBsr );
  CPPUNIT_TEST_SUITE_END();
public:
  void testBsr();
};

CPPUNIT_TEST_SUITE_REGISTRATION(BitOpTest);

void BitOpTest::testBsr()
{
    unsigned int w = (1 << 3) | (1 << 7);
    CPPUNIT_ASSERT_EQUAL(7, osl::misc::BitOp::bsr(w));
    CPPUNIT_ASSERT_EQUAL(3, osl::misc::BitOp::bsf(w));
    CPPUNIT_ASSERT_EQUAL(8, osl::misc::BitOp::bsr(w << 1));

    unsigned long long w64 = (1ull << 3) | (1ull << 37);
    CPPUNIT_ASSERT_EQUAL(37, osl::misc::BitOp::bsr(w64));
    CPPUNIT_ASSERT_EQUAL(3, osl::misc::BitOp::bsf(w64));
    CPPUNIT_ASSERT_EQUAL(38, osl::misc::BitOp::bsr(w64 << 1));
}
