#ifndef _COPY_IF_H
#define _COPY_IF_H

namespace osl
{
  namespace stl
  {
    /**
     * Copy the elements of a range that satisfy a predicate. The current
     * STL lacks this copy_if algorithm. This implementation comes from a
     * book: Effective STL, Scott Meyers, Addison-Wesley (Item 36).
     */
    template<class InputIterator, class OutputIterator, class Predicate>
    inline OutputIterator copy_if(InputIterator first, 
                                  InputIterator last, 
                                  OutputIterator result, 
                                  Predicate predicate)
    {
      while (first != last) {
        if (predicate(*first)) {
          *result++ = *first;
        }
        ++first;
      }
      return result;
    }
  } // stl
} // osl

#endif /* _COPY_IF_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
