/* bookInMemory.h
 */
#ifndef OSL_BOOKINMEMORY_H
#define OSL_BOOKINMEMORY_H
#include "osl/hash/hashKey.h"
#include "osl/container/moveVector.h"
#include "osl/stl/hash_map.h"
namespace osl
{
  namespace record
  {
    namespace opening
    {
      class WeightedBook;
      class BookInMemory
      {
	typedef CArray<Move,8> moves_t;
	typedef hash_map<HashKey,moves_t> table_t;
	table_t table;
      public:
	~BookInMemory();

	void find(const HashKey& key, MoveVector& out) const;
	size_t size() const { return table.size(); }
	static const BookInMemory& instance(const std::string& filename="");
      private:
	explicit BookInMemory(const std::string& filename);
	void readAll(const std::string& filename);
	int readRecursive(const HashKey& key, int index, WeightedBook& book, int, int);
      };
    }
  }
  using record::opening::BookInMemory;
}

#endif /* OSL_BOOKINMEMORY_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
