/* nonBlockDelete.h
 */
#ifndef OSL_NONBLOCKDELETE_H
#define OSL_NONBLOCKDELETE_H

#include <boost/shared_ptr.hpp>
#include <boost/utility.hpp>

#ifdef USE_BOOST_POOL_ALLOCATOR
#  define DISABLE_NON_BLOCK_DELETE
#endif

namespace osl
{
  namespace misc
  {
    class NonBlockDelete : boost::noncopyable
    {
    public:
      /** 別スレッドに消去を依頼する */
      template <class T>
      static void planDelete(T *ptr)
      {
	boost::shared_ptr<void> holder(ptr); // shared_ptr preserves T
	resetAny(holder);
      }

      /**
       * make ptr empty immediately
       */
      template <class T>
      static void reset(boost::shared_ptr<T>& ptr)
      {
#ifndef DISABLE_NON_BLOCK_DELETE
	boost::shared_ptr<void> holder;
	holder = ptr;
#endif
	ptr.reset();
#ifndef DISABLE_NON_BLOCK_DELETE
	resetAny(holder);
#endif
      }
      static void resetAny(boost::shared_ptr<void>&);

      /**
       * 空になるまで待つまたは自分で消去する 
       */
      static void deleteAll();
      static bool deleteOne();
      static int waiting();
    private:
      static NonBlockDelete& instance();

      NonBlockDelete();
      ~NonBlockDelete();
      void push_back(boost::shared_ptr<void>&);

      class Queue;
      boost::shared_ptr<Queue> queue;

      struct Runner;
      friend struct Runner;
    };
    
  }
  using misc::NonBlockDelete;
}

#endif /* OSL_NONBLOCKDELETE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
