/* ----- encode/1013x7177, derived from supercop/crypto_encode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *encode_1013x7177_checksums[] = {
  "6d839a50ec5e68cf79f8d99d8d86eb1b56b8e88d7e1b088313731657297d490b",
  "29b9c6f5b9891edd976092fe7d87049d3a788b2911274aba59241f0507a87fed",
} ;

static void (*crypto_encode)(unsigned char *,const void *);
#define crypto_encode_STRBYTES ntruprime_encode_1013x7177_STRBYTES
#define crypto_encode_ITEMS ntruprime_encode_1013x7177_ITEMS
#define crypto_encode_ITEMBYTES ntruprime_encode_1013x7177_ITEMBYTES

static void *storage_encode_1013x7177_s;
static unsigned char *test_encode_1013x7177_s;
static void *storage_encode_1013x7177_x;
static unsigned char *test_encode_1013x7177_x;
static void *storage_encode_1013x7177_s2;
static unsigned char *test_encode_1013x7177_s2;
static void *storage_encode_1013x7177_x2;
static unsigned char *test_encode_1013x7177_x2;

#define precomputed_encode_1013x7177_NUM 4

static const unsigned char precomputed_encode_1013x7177_s[precomputed_encode_1013x7177_NUM][crypto_encode_STRBYTES] = {
  {200,212,53,19,207,13,123,115,11,166,45,25,92,234,132,76,15,105,87,219,207,158,201,244,45,190,115,128,223,9,12,113,221,238,138,166,48,233,118,148,34,70,127,156,120,126,54,147,207,63,198,224,150,77,165,114,234,18,69,160,183,93,15,82,87,3,15,21,119,94,191,126,119,189,57,125,223,106,64,155,7,148,130,9,133,60,168,84,22,244,60,92,129,75,5,244,120,118,153,222,23,190,185,250,102,107,140,217,26,77,200,121,128,228,68,197,100,123,108,98,139,80,143,87,211,86,182,53,221,185,135,245,222,53,1,20,126,101,11,167,38,190,127,25,98,97,19,205,214,72,251,124,5,94,77,36,215,134,102,216,32,245,59,22,182,214,97,137,249,45,201,140,184,240,131,115,92,240,118,67,248,255,43,217,64,239,126,140,148,0,118,59,236,113,71,116,111,50,113,29,173,212,21,90,193,171,161,239,10,227,104,138,46,238,124,128,204,209,113,213,158,135,15,235,247,166,122,102,218,249,105,148,145,202,46,108,222,1,199,103,145,150,177,171,147,2,35,159,240,0,33,20,203,166,144,20,24,96,46,178,175,108,80,90,41,21,172,204,206,63,154,114,116,223,155,121,130,216,91,123,221,7,140,149,101,165,212,74,113,119,70,169,6,45,148,199,235,82,115,209,155,227,133,253,71,254,90,141,17,35,85,203,243,21,206,184,120,174,42,173,251,208,220,250,117,184,187,100,84,19,247,54,68,234,252,127,117,182,246,26,14,30,195,155,160,54,70,30,109,65,43,25,119,72,75,92,152,212,212,177,179,92,123,174,174,123,148,213,11,41,169,66,159,147,204,72,166,12,166,60,20,197,142,75,245,200,113,207,23,201,203,0,88,4,251,70,115,179,112,70,166,183,136,68,208,68,46,113,138,133,227,151,171,188,186,200,189,23,142,160,191,5,245,40,248,170,132,151,142,231,142,87,119,246,199,205,98,102,202,182,143,113,82,78,39,124,207,55,60,31,57,155,20,2,18,209,180,90,254,154,205,253,150,198,24,58,159,179,168,234,147,21,239,203,82,15,162,110,69,171,207,7,32,187,189,7,240,145,100,16,2,150,128,198,162,115,157,169,174,247,32,246,135,180,184,250,39,133,127,168,121,187,132,37,124,11,25,246,138,174,47,7,90,196,163,232,183,95,220,94,134,82,106,237,62,246,29,240,240,205,236,205,171,209,199,160,4,190,163,154,210,147,165,97,251,62,3,21,131,220,66,254,169,113,210,215,4,216,37,225,114,156,36,12,180,234,44,161,195,123,176,241,112,230,81,95,111,251,125,196,66,152,31,67,31,110,178,56,116,50,118,33,160,157,113,223,173,80,135,158,55,93,199,71,77,106,120,46,169,204,208,111,34,213,180,241,68,83,110,73,72,186,78,63,23,1,170,26,181,146,203,205,163,141,53,107,59,168,77,166,194,75,7,150,66,160,5,26,228,79,147,110,227,237,231,27,147,146,189,144,46,233,25,86,170,97,179,206,0,252,136,203,101,29,3,195,32,145,36,55,220,137,249,239,117,28,110,247,186,253,73,143,206,24,98,252,153,153,35,170,143,161,180,222,52,173,9,50,17,26,12,185,87,99,30,239,115,160,43,7,145,171,19,210,115,53,157,68,209,81,63,114,250,140,79,12,217,221,182,226,124,18,8,233,156,178,240,101,106,45,167,139,252,209,152,173,185,63,59,219,208,172,172,231,174,100,35,98,24,56,169,204,115,64,144,167,98,94,168,196,71,39,184,103,85,27,31,73,5,97,95,209,175,250,154,170,120,178,102,228,32,8,57,90,93,65,154,126,123,55,11,241,96,214,144,101,191,28,30,202,230,80,167,0,202,48,91,111,36,184,126,69,137,76,242,222,201,249,105,235,229,77,100,166,61,150,80,8,173,191,132,148,91,73,145,28,182,127,216,13,99,253,239,97,87,168,56,237,14,8,9,245,235,224,12,88,31,128,132,28,125,94,114,112,190,30,224,100,8,94,118,187,165,144,10,111,240,89,28,139,242,110,182,75,35,31,45,11,212,139,221,221,183,123,189,201,117,210,16,171,91,28,144,72,170,204,151,195,48,197,34,120,134,102,164,16,114,74,239,225,252,7,35,160,4,135,160,201,14,9,157,29,59,143,54,21,33,14,247,115,115,202,40,123,104,221,136,162,98,157,183,11,126,245,155,56,39,180,221,219,16,252,38,127,34,164,111,153,211,154,178,173,129,109,66,54,44,26,101,150,17,0,123,97,250,40,110,17,106,35,197,154,204,105,81,6,89,14,199,137,10,11,254,10,136,50,203,253,167,130,52,126,138,46,206,198,158,166,143,132,83,42,8,128,107,172,60,149,83,1,242,109,225,140,88,52,101,254,36,5,158,151,180,124,9,148,43,225,0,1,149,244,59,108,59,241,6,81,65,232,75,214,100,89,161,249,18,34,16,15,197,153,227,58,139,221,105,80,22,167,121,144,105,102,55,132,244,29,232,216,217,44,107,44,6,153,177,117,140,237,172,130,251,205,90,121,181,74,66,117,156,179,101,16,223,47,67,175,19,155,38,137,150,169,128,127,9,148,139,71,25,136,224,66,107,66,246,131,157,75,99,253,13,58,153,140,138,183,152,92,35,223,183,0,85,89,204,219,190,49,162,235,78,177,191,48,93,42,235,133,209,152,182,92,21,184,123,178,96,35,24,198,201,120,18,152,135,46,10,249,104,188,22,213,119,39,146,130,134,115,100,73,223,219,142,255,161,38,65,90,55,173,204,111,139,4,91,175,103,5,247,86,58,191,38,234,231,64,169,20,40,224,207,35,233,215,54,119,58,111,42,182,226,170,208,197,111,152,138,187,208,97,101,219,180,236,134,221,240,23,178,18,1,17,70,165,218,38,34,10,90,14,39,8,115,44,45,244,124,179,158,176,2,196,61,255,227,4,213,230,57,88,216,175,116,33,166,89,163,49,9,87,31,202,188,55,200,175,42,137,96,102,98,77,135,1,254,193,197,32,112,218,144,67,46,85,78,136,161,35,175,44,164,37,225,141,174,166,1,217,174,108,178,187,216,220,236,192,197,185,170,217,8,2,222,158,170,58,27,239,214,181,237,77,41,8,251,194,175,70,110,126,175,151,160,78,4,148,63,193,236,168,141,89,231,137,45,122,188,214,163,212,217,72,86,116,187,46,116,3,187,142,13,185,229,232,159,30,172,25,145,1,80,72,190,255,71,193,213,71,36,142,215,84,28,75,218,92,137,238,113,231,124,36,95,1,213,254,27,247,160,119,78,121,73,102,109,185,251,228,95,159,95,61,135,255,199,57,28,19,49,172,19,144,231,244,168,32,102,156,33,204,40,132,106,178,166,58,11,28,45,135,62,76,20,199,4,202,215,175,241,242,46,115,248,99,34,242,219,136,190,159,164,229,117,244,195,230,103,22,78,5,54,79,206,191,26,218,186,112,83,106,43,14,184,128,35,235,155,218,49,45,8,127,57,64,118,207,15,40,183,220,180,222,121,88,112,216,228,255,36,254,182,84,50,252,103,160,201,194,35,81,212,103,208,113,99,193,49,60,243,80,149,111,193,217,105,140,74,158,37,20,236,169,13,176,95,119,113,167,51,40,1},
  {75,67,163,217,159,154,157,250,20,1,95,156,123,95,141,79,111,99,36,185,46,42,214,229,28,94,202,106,98,242,117,202,77,107,244,162,225,70,105,147,85,178,82,190,243,209,61,109,207,104,222,132,204,4,150,132,161,115,10,132,112,144,144,174,238,154,20,12,31,92,102,121,154,96,161,41,127,104,6,94,16,224,176,114,122,188,53,55,184,237,126,122,242,72,227,114,78,123,17,39,205,248,61,60,157,95,170,147,187,160,1,179,184,42,187,7,128,93,29,96,197,195,216,111,54,235,92,156,124,171,227,13,32,60,26,22,191,185,71,237,79,99,15,8,21,63,117,169,77,64,170,178,16,2,226,149,0,133,201,17,148,237,180,42,163,62,17,47,71,132,108,186,237,241,129,184,221,47,233,29,55,254,5,170,46,136,55,241,219,32,36,128,108,254,233,129,182,249,95,209,26,238,106,151,219,49,104,168,243,243,190,43,90,75,73,88,200,246,189,165,224,217,203,84,97,142,212,30,86,243,61,255,45,252,123,10,234,44,169,145,16,146,174,16,137,14,115,4,128,38,32,129,223,8,57,47,20,128,110,191,85,75,244,196,29,214,255,212,93,181,29,178,145,180,211,187,150,217,179,160,21,93,33,15,30,202,23,5,219,177,239,197,211,53,37,103,156,221,89,194,161,79,90,19,95,80,87,45,231,54,190,116,125,235,182,188,50,254,195,89,85,237,169,12,130,46,45,139,83,99,61,187,209,24,117,186,219,209,191,66,71,225,221,200,43,193,74,105,161,15,189,212,194,27,178,69,131,135,243,78,36,134,74,161,249,198,66,207,2,75,201,214,238,79,154,82,226,252,18,250,1,31,214,219,85,225,14,63,204,44,227,172,122,6,34,132,161,45,99,58,16,210,40,49,44,221,254,8,33,241,125,52,113,144,42,143,155,246,181,129,64,138,8,14,21,46,118,32,146,197,99,194,110,132,195,67,125,148,129,59,77,54,211,227,138,142,247,17,190,36,129,34,213,217,208,251,251,41,150,80,91,124,84,135,99,89,48,44,61,56,7,189,70,70,110,93,37,215,32,134,110,56,175,124,82,111,236,41,208,178,16,48,2,128,131,127,39,23,7,230,254,243,88,237,249,226,56,176,55,242,67,241,40,239,134,54,25,209,199,170,21,104,239,30,39,234,188,214,162,60,38,23,145,130,255,183,143,210,18,36,118,176,149,36,237,64,138,170,43,72,255,18,218,64,150,207,130,183,243,181,19,215,2,30,10,39,31,135,148,132,72,65,61,174,36,11,130,27,164,241,229,1,40,31,126,109,164,200,81,31,216,61,80,51,106,173,202,56,148,234,119,93,158,226,103,6,164,205,179,80,252,35,185,144,233,237,155,128,52,1,22,76,223,28,6,115,10,161,16,101,111,163,31,105,235,91,115,180,55,247,175,150,0,107,66,231,151,155,149,247,44,85,111,197,181,50,101,99,36,252,28,162,82,218,26,148,128,71,139,72,51,29,60,82,14,153,172,13,93,40,73,207,173,8,141,230,144,143,19,255,6,169,108,56,221,66,111,148,219,45,198,129,66,199,189,181,254,124,44,150,125,63,90,139,98,80,82,235,19,255,233,55,238,232,41,249,180,217,131,20,132,147,167,3,157,81,20,145,36,172,158,99,123,202,191,144,242,76,91,116,90,55,124,109,182,214,133,127,170,103,197,137,151,75,214,171,82,162,6,129,61,249,219,51,209,90,36,93,86,148,8,218,77,57,132,246,152,60,213,180,28,241,219,73,133,137,141,60,199,19,187,129,225,125,118,254,77,49,208,141,58,231,144,143,233,89,142,73,213,13,179,176,195,91,185,233,190,49,71,101,143,157,239,60,109,78,153,33,97,108,189,154,50,179,213,81,240,206,7,17,133,189,13,82,200,160,90,144,158,90,168,133,91,91,131,180,61,244,84,67,0,191,185,71,185,153,160,86,43,45,8,68,2,14,81,221,144,171,16,164,126,225,31,220,168,116,88,163,49,163,168,246,56,86,177,121,33,47,30,73,20,66,112,10,54,143,177,158,192,29,209,2,39,1,149,181,84,82,130,195,14,253,110,149,23,46,9,51,27,42,125,74,185,103,152,6,14,110,146,123,234,77,33,62,250,166,121,237,1,93,192,217,220,204,55,176,171,196,109,125,39,214,235,240,74,208,129,183,220,110,154,236,170,162,215,242,152,144,47,153,63,49,96,119,68,42,2,196,168,29,233,212,4,130,2,4,149,66,4,26,101,153,99,221,54,117,233,70,160,19,20,122,207,245,58,220,44,64,208,49,29,224,77,195,136,86,92,29,77,133,111,21,122,135,174,14,0,114,197,234,9,128,252,179,223,186,36,90,138,1,145,226,180,202,235,103,64,202,95,234,255,123,26,37,165,83,215,235,1,91,209,121,249,147,5,225,43,213,166,184,81,247,89,120,34,118,12,24,1,5,197,58,212,118,0,27,50,140,233,232,130,253,244,167,5,196,184,199,74,4,98,144,51,43,148,173,210,188,204,208,99,131,195,218,194,176,41,44,103,78,30,123,54,78,45,247,4,133,23,175,12,243,184,190,115,65,196,102,96,7,157,191,250,92,243,147,194,206,133,197,245,101,155,118,108,8,155,208,6,233,79,137,169,65,64,5,106,127,61,182,193,171,106,92,141,197,211,79,46,15,236,215,245,216,114,86,65,139,48,65,41,57,158,5,84,203,16,66,236,104,197,126,100,225,61,219,67,180,110,2,108,27,161,206,87,23,82,42,91,188,132,144,155,114,223,156,133,21,249,58,22,79,185,155,255,117,174,238,46,7,167,135,101,97,6,47,231,193,167,165,27,53,137,180,59,70,216,8,57,26,246,15,79,157,38,84,0,11,37,227,161,102,68,131,58,147,142,22,123,28,21,108,254,79,67,64,31,155,173,84,45,25,5,203,121,88,82,39,129,101,235,78,134,218,45,215,143,67,127,181,81,145,223,183,52,116,253,63,208,230,124,113,130,83,108,234,105,60,159,206,6,140,63,13,154,68,69,115,251,83,152,245,91,91,23,41,23,160,255,3,109,248,129,2,198,40,146,186,110,172,192,197,15,143,92,195,62,150,69,76,220,146,44,137,163,77,133,107,9,182,54,101,110,90,232,92,121,5,168,228,106,71,137,124,77,169,17,180,197,98,76,184,86,249,57,193,22,252,32,98,161,196,125,141,92,248,124,189,29,29,88,82,108,26,190,147,142,169,177,180,187,130,213,238,246,81,235,14,254,177,217,222,227,97,65,74,27,222,171,30,208,216,23,79,169,3,224,218,5,189,200,197,141,170,241,185,174,179,136,241,143,123,124,35,28,176,185,253,200,221,96,208,222,238,170,92,19,115,17,51,56,54,170,188,60,241,8,3,56,253,199,231,58,76,73,97,52,235,249,220,230,32,38,7,16,171,200,137,116,9,253,227,83,225,19,203,177,82,52,198,122,255,83,73,122,52,206,137,203,103,19,254,129,102,227,84,142,30,200,201,127,140,202,6,85,111,212,161,135,47,114,20,21,64,35,148,4,26,143,35,145,27,205,10,195,9,130,61,247,37,33,154,159,240,81,201,252,162,254,132,122,106,157,148,45,152,246,173,146,50,28,205,1},
  {36,174,143,125,7,83,192,101,138,64,196,114,80,163,234,54,147,188,215,8,58,156,216,108,3,235,82,255,160,239,232,175,5,180,163,206,84,183,132,222,183,170,62,199,243,173,60,77,65,114,24,135,154,206,237,139,211,205,73,127,157,97,227,92,195,93,21,206,223,122,255,231,153,145,190,7,26,90,122,143,122,129,247,30,217,206,28,177,147,180,150,168,161,248,23,169,193,14,46,204,30,189,104,202,95,134,132,241,138,230,120,229,203,190,203,30,233,229,20,28,171,213,75,68,25,199,87,60,138,248,249,205,252,30,121,217,248,223,197,106,106,219,64,137,1,166,63,62,234,230,111,35,220,165,202,77,227,7,26,37,142,139,222,76,149,95,139,234,184,4,13,252,192,111,177,72,40,155,186,239,183,234,181,180,42,25,26,182,212,244,224,13,117,202,92,1,58,192,30,186,92,212,38,183,37,66,36,188,4,132,93,204,254,69,124,134,5,145,159,91,137,97,63,199,132,194,243,205,220,254,242,109,248,32,44,95,235,22,164,69,211,149,45,178,96,123,200,160,206,80,109,26,69,222,23,181,20,150,240,56,4,10,112,217,249,156,213,3,24,233,100,125,204,195,243,19,23,197,150,80,40,37,175,175,11,112,20,90,240,196,151,15,120,206,247,46,184,31,100,188,87,210,83,136,107,155,86,224,45,191,175,122,119,118,98,40,207,204,157,183,247,154,42,179,196,166,174,98,54,92,188,56,55,219,212,43,83,232,123,155,166,91,13,86,202,234,68,73,190,49,146,94,147,239,102,82,203,20,233,19,190,238,233,57,191,10,147,55,107,66,192,205,215,9,248,139,233,23,149,89,37,94,214,53,146,132,49,112,18,159,17,242,3,220,237,143,41,75,187,238,219,89,117,92,85,124,70,93,52,127,174,10,52,0,118,146,30,181,105,156,134,108,121,182,105,26,101,11,243,242,47,98,193,136,237,19,212,43,228,201,157,142,10,41,21,210,241,214,56,101,242,163,192,236,216,239,16,127,235,211,100,237,202,246,58,127,214,94,245,134,190,123,189,120,61,123,18,215,154,49,202,6,230,105,3,196,10,11,177,126,36,250,16,18,32,8,163,171,41,49,125,137,80,154,12,199,151,104,210,119,122,75,236,7,232,136,76,223,69,222,176,210,205,6,236,156,195,98,190,44,40,81,1,78,33,118,98,111,244,173,168,31,20,60,202,116,113,10,78,113,17,232,159,214,111,209,15,208,228,5,55,228,67,17,159,169,109,199,38,221,222,14,143,151,132,188,157,26,56,136,133,73,106,41,209,50,240,166,239,191,250,246,90,0,27,232,43,4,203,217,230,184,59,199,194,12,198,52,127,83,199,31,169,183,168,182,10,225,29,193,232,200,180,146,111,6,192,167,243,242,27,98,181,107,0,6,12,185,145,153,82,121,239,53,157,34,36,32,204,229,45,57,70,158,82,226,124,73,117,91,231,254,46,81,79,41,114,0,219,81,236,223,36,64,64,124,44,82,72,255,118,182,221,217,123,36,249,121,67,87,246,154,145,35,147,3,67,84,16,133,74,8,167,83,68,72,56,88,161,133,242,249,209,67,105,179,98,55,58,239,110,68,138,83,253,115,70,102,141,192,252,218,58,76,234,210,237,64,237,34,226,169,207,214,41,118,164,14,83,51,47,213,78,180,134,198,125,224,9,40,66,8,138,7,111,111,93,136,186,110,111,28,248,198,124,181,38,35,17,168,10,146,7,196,211,115,185,239,152,84,220,242,147,195,67,190,67,101,142,41,46,223,250,140,50,206,131,151,6,90,174,207,59,124,71,190,220,72,220,155,231,106,244,154,195,59,177,13,93,124,89,112,205,113,32,176,133,252,80,45,118,128,254,148,101,250,252,160,196,96,181,33,253,103,13,83,219,251,211,62,96,136,80,241,166,129,73,55,152,37,69,91,138,193,192,98,67,145,166,98,201,1,37,71,13,27,16,9,104,217,17,84,93,135,149,43,34,248,29,21,93,69,94,22,194,111,103,167,73,252,113,66,55,25,21,176,4,73,42,150,59,165,35,227,67,16,214,146,126,32,199,252,255,253,118,79,156,79,165,216,93,34,154,222,78,164,139,99,166,136,47,206,191,97,125,160,251,64,171,237,151,97,98,156,119,112,8,107,250,186,177,103,28,75,174,201,90,149,79,26,81,8,51,255,66,255,174,196,100,212,71,161,58,78,71,157,197,181,61,34,190,71,128,15,155,254,204,221,4,14,76,72,176,110,249,24,134,67,151,106,69,45,186,114,14,27,84,191,101,240,88,8,123,174,188,214,241,5,162,134,238,223,7,187,7,188,164,44,137,184,113,45,216,37,179,197,142,227,215,157,17,164,19,58,2,113,156,106,205,115,208,218,15,236,206,37,102,154,213,177,38,33,240,230,234,48,131,233,61,96,42,26,26,115,27,106,93,137,160,103,227,153,52,188,208,74,65,18,90,178,150,144,0,176,184,147,19,156,150,198,118,237,22,231,98,196,145,24,89,106,208,68,176,135,83,100,173,55,71,248,21,216,170,131,82,9,168,102,118,106,154,112,63,166,14,246,119,222,98,230,128,170,193,102,68,89,24,228,96,137,116,164,109,95,224,127,85,57,254,205,69,225,208,224,64,120,119,202,191,220,179,20,29,181,123,202,236,77,239,248,74,38,167,28,74,81,149,125,243,18,16,190,97,213,50,132,243,68,5,65,179,16,2,241,209,247,160,23,202,178,74,44,148,20,49,132,127,61,145,173,240,238,39,52,57,105,162,203,169,105,115,133,236,245,82,42,99,178,255,65,5,54,102,190,136,187,249,167,78,198,109,32,135,59,50,141,101,54,230,30,236,213,169,171,176,207,220,227,188,39,202,109,238,58,170,207,70,130,50,247,187,151,36,209,7,65,56,178,52,59,91,25,70,68,33,217,152,45,18,49,199,200,162,243,132,5,233,157,85,140,3,50,126,2,80,84,44,180,51,34,154,252,230,15,101,28,176,40,251,17,11,118,51,0,65,99,53,83,85,63,191,170,148,54,108,100,57,2,203,158,12,145,14,114,50,168,159,82,204,244,9,12,11,249,108,197,207,51,243,246,7,32,143,245,209,86,40,169,89,188,184,149,181,79,179,173,244,73,197,79,212,209,33,113,32,200,211,221,227,219,162,203,51,2,162,172,120,131,234,118,162,72,93,171,43,109,129,114,32,189,61,76,225,149,47,215,44,158,102,73,44,203,184,168,153,226,22,37,24,254,210,156,104,48,226,223,213,117,245,7,204,39,177,151,241,138,23,53,236,146,73,96,79,94,167,107,78,23,64,164,46,167,226,46,80,36,54,144,127,83,28,44,2,153,156,183,22,197,247,26,149,152,68,241,169,175,53,81,46,104,172,239,88,17,110,151,169,165,162,71,64,71,188,30,198,139,247,145,34,30,132,167,76,61,77,64,83,106,9,70,187,147,153,200,60,247,25,171,212,186,158,94,236,235,66,54,161,199,248,119,251,77,156,224,204,103,76,147,85,5,209,6,56,167,124,254,43,127,61,35,56,103,12,156,155,211,195,230,56,71,18,156,31,24,180,113,42,93,154,109,69,228,200,226,62,49,207,190,197,186,59,194,1},
  {85,156,56,191,88,245,96,44,39,20,28,75,98,138,32,161,32,176,95,33,23,110,109,70,139,233,139,187,244,221,130,233,27,133,242,97,52,164,56,202,242,70,227,82,230,199,255,37,150,47,169,91,230,96,201,25,209,198,81,95,151,11,195,248,129,134,139,172,228,63,191,132,205,102,0,122,56,2,110,57,63,167,186,59,95,136,13,38,7,65,240,180,230,59,186,31,210,215,247,118,105,166,166,240,157,229,137,217,59,181,245,224,234,79,128,136,211,228,81,229,26,89,70,250,255,158,92,15,172,169,15,167,176,229,68,180,149,159,168,20,18,96,199,150,186,153,192,28,91,171,21,0,155,147,199,101,169,43,97,121,132,105,47,207,122,208,224,91,202,22,237,180,252,249,252,136,196,237,5,191,114,87,1,110,171,21,20,140,170,110,60,44,207,46,215,154,146,176,129,64,209,247,20,72,236,171,174,114,110,63,248,20,51,73,21,161,243,168,148,123,230,107,225,39,228,133,63,71,211,124,39,27,237,253,155,237,145,65,110,36,134,3,32,13,116,148,98,6,136,173,93,58,127,201,231,165,154,119,162,110,240,111,26,224,225,243,125,31,232,170,128,130,219,146,216,135,170,135,87,197,102,255,52,91,254,37,76,103,140,18,181,232,74,228,221,150,70,4,178,58,163,11,0,169,116,109,122,128,240,60,184,157,8,195,0,185,92,121,188,117,191,101,111,97,169,243,233,22,31,17,204,43,146,233,98,185,92,64,158,37,255,92,183,80,245,171,190,125,88,208,235,226,243,126,241,188,74,55,200,201,237,37,188,86,142,202,191,81,28,95,183,248,234,55,79,33,62,22,77,210,94,248,202,42,234,169,105,102,154,179,188,9,165,222,211,164,145,236,197,182,126,80,16,72,220,137,82,199,84,220,94,188,226,199,16,173,64,37,12,174,175,124,235,231,77,26,168,140,114,214,203,216,30,6,208,25,194,156,217,47,52,149,227,236,174,238,211,59,241,247,17,129,29,147,203,77,186,79,71,54,209,145,32,176,65,176,94,224,1,185,55,26,31,200,219,240,32,7,240,225,211,30,212,37,159,172,136,44,5,76,151,83,240,181,128,193,194,210,166,203,106,121,22,14,163,224,47,95,162,172,75,173,112,233,49,153,20,247,110,202,118,19,55,120,59,44,34,188,152,111,123,10,246,47,38,82,11,39,138,24,109,76,87,42,101,17,25,134,11,221,254,55,246,183,113,73,14,250,48,70,124,52,214,232,0,69,14,101,225,48,181,172,7,112,190,221,168,166,253,172,130,115,160,90,147,99,171,112,206,25,251,98,102,74,205,47,210,116,164,121,120,18,162,68,161,109,95,180,40,184,220,14,66,30,118,81,222,10,224,52,186,149,206,142,66,253,218,242,210,147,27,116,73,63,88,242,224,140,25,195,186,81,250,118,185,94,119,48,155,40,139,52,115,174,174,79,105,65,203,144,200,40,5,40,47,194,20,228,224,53,96,227,188,152,34,36,231,233,211,180,155,117,28,41,250,160,70,151,49,102,134,222,186,193,19,70,24,249,182,195,144,76,113,34,18,164,35,243,9,26,223,55,59,206,150,234,217,78,93,217,236,239,30,248,211,208,125,13,104,214,180,67,0,4,171,207,72,170,98,11,70,248,63,176,48,140,248,160,153,34,251,193,177,213,102,255,133,17,97,8,21,89,78,31,169,7,89,131,76,37,3,128,124,71,222,55,169,90,206,70,19,117,85,130,193,110,239,38,10,194,214,254,164,151,56,79,254,4,2,101,105,77,220,231,200,11,62,28,134,102,203,223,121,138,179,11,137,6,131,19,73,24,194,53,221,2,47,66,13,117,28,227,142,126,43,197,86,127,74,178,6,105,108,198,96,152,199,189,167,219,220,142,24,235,125,104,43,161,236,104,63,94,156,133,185,224,190,71,147,207,111,32,222,213,187,43,5,133,23,191,226,74,134,232,29,37,144,209,221,234,50,12,212,227,123,4,114,90,153,119,15,131,206,78,135,226,173,84,114,113,138,208,169,60,144,46,108,144,17,178,175,98,82,97,144,58,118,121,19,128,78,83,70,204,37,139,6,59,71,152,62,119,254,105,71,236,40,185,255,183,121,186,20,21,137,70,34,150,7,151,192,217,255,99,110,247,186,231,105,47,67,13,149,236,191,171,147,209,138,238,31,28,93,80,164,19,170,197,33,148,160,86,54,75,11,50,103,71,85,160,220,243,143,33,239,83,238,47,56,103,184,180,153,14,179,116,111,174,254,19,42,189,187,138,140,156,180,35,239,132,41,140,72,33,27,128,132,216,174,152,163,244,32,168,32,83,22,150,134,219,123,119,151,47,241,36,230,179,229,6,190,147,48,8,166,200,150,199,25,43,68,132,55,206,27,240,50,200,250,24,106,169,211,16,33,22,77,149,188,117,231,104,61,0,240,19,63,61,154,99,170,50,49,90,113,130,19,242,174,70,60,244,175,78,109,9,15,133,203,109,185,27,71,235,167,235,190,208,103,140,196,108,112,101,175,225,156,52,207,123,5,53,41,216,17,95,132,157,116,73,210,186,184,92,150,58,216,233,212,52,56,225,127,89,129,184,36,123,66,72,34,198,139,247,44,99,184,50,94,242,68,39,43,246,254,225,175,176,196,154,187,253,167,165,181,164,219,0,250,10,191,245,1,56,230,163,105,175,94,143,153,173,94,56,44,143,211,79,42,60,88,80,201,4,20,136,214,63,204,164,190,195,68,96,175,238,67,225,41,93,210,33,80,19,113,148,228,180,250,199,100,94,180,20,182,247,43,99,224,204,66,27,187,17,41,60,151,188,140,190,131,211,182,154,158,133,250,167,114,79,208,178,195,126,122,142,120,76,207,91,112,222,218,220,212,58,151,84,162,43,226,114,244,138,225,145,78,234,154,91,93,34,235,247,34,222,159,69,79,108,246,202,232,95,154,74,86,24,216,150,238,22,169,105,171,225,45,253,29,169,168,114,21,59,131,195,30,191,220,65,79,235,49,116,1,72,62,154,116,24,176,3,222,184,46,14,255,253,243,41,253,65,253,29,191,127,51,122,138,212,223,89,68,129,106,171,122,57,210,12,147,25,148,12,28,25,48,88,146,59,157,77,4,169,138,140,199,231,143,116,195,183,70,244,69,102,117,185,88,159,10,6,53,74,108,227,130,133,195,102,174,64,80,111,215,150,229,58,131,20,52,121,121,93,71,49,243,165,243,49,223,81,170,192,87,153,13,202,119,202,211,7,57,197,48,86,27,226,59,10,80,217,29,27,2,199,98,98,155,74,0,252,82,30,152,147,230,175,231,15,225,150,137,6,111,228,8,7,242,222,39,25,191,180,218,232,0,98,184,72,46,204,156,88,137,45,143,58,124,200,206,218,233,151,126,182,106,29,20,41,53,59,17,236,105,63,76,159,252,99,36,187,69,226,172,208,219,244,30,163,103,127,190,94,115,222,112,39,46,87,103,49,101,70,42,63,63,210,10,223,130,241,20,30,17,135,213,75,162,169,42,165,214,147,151,243,117,229,159,155,90,223,7,149,133,141,219,13,145,47,53,109,156,217,179,34,226,200,91,81,94,195,189,67,59,135,209,33,232,125,195,237,0},
} ;

static const int16_t precomputed_encode_1013x7177_x[precomputed_encode_1013x7177_NUM][crypto_encode_ITEMS] = {
  {-1858,-17070,-14490,23087,-20919,-17426,4550,9829,4196,31559,-32466,-20257,-5577,3413,14793,15547,-20614,30533,-10324,-15829,19926,13449,-11680,30329,-30826,-3913,8936,17675,-78,22813,-10132,18104,27156,-25127,-4436,6022,22262,-20990,23092,-6198,-15527,27609,-17370,-7959,4224,-2224,11639,16543,2720,20623,4020,7194,12736,-13890,17789,-5888,18325,27397,-24051,21904,-30247,4998,19290,-23707,22036,-2813,27204,-18357,-14430,-1403,12930,-20819,-31324,28435,-11256,-30463,-19288,-25769,29297,20271,-31859,-30142,23360,-17462,-21067,-2200,13472,-800,-19460,9442,-29652,-16728,-785,19866,-16602,-24897,-30603,24515,-19568,8729,-28284,28115,-8351,-11856,28397,-23543,15914,-30742,-26773,11535,-22200,30616,30555,4693,-4353,14965,-26575,-10381,15247,-25523,-15319,28906,-29749,29116,1848,-30053,-12268,20522,-18135,6956,-13524,-16549,-23504,30422,-5151,-1480,6225,1053,-30779,-21074,-27529,271,10115,-23500,32675,-25441,-23240,-3877,26518,29272,-5365,27016,-12352,12917,-31371,-9936,21451,16580,23694,20016,25706,-28770,-18416,10411,-9578,28216,-5417,19410,28647,-7910,23803,-21514,26749,-22981,6868,30735,17992,-11892,4078,21600,30568,4904,-2994,27213,-4187,31387,18590,10232,3405,5095,32112,18030,-29040,25236,-2122,-9887,14569,-31250,-26296,14905,-3936,7165,-25182,-18765,29495,-10798,2705,-5208,11206,-24260,-17540,-2652,-11164,-17134,4260,25136,31736,3916,17320,-15655,19295,-15585,-8900,-27373,18981,14810,21923,-30473,15360,-7006,-19593,-6918,-5142,-17337,9828,18706,-10315,12345,2034,31621,14283,-11986,-3968,-13567,-10240,15315,20198,21165,28495,27121,5092,685,-26545,15540,27785,4775,19896,-23944,19333,-22343,-18732,-12581,6625,4559,32618,28831,-25136,-19948,27024,-9498,-12395,-28363,-7875,-7337,5231,-22044,-19771,-9171,-22093,2432,30259,-21006,21418,-26006,-20420,25401,-14172,26568,-14969,7218,14933,-28479,-21686,9716,29543,4893,-1548,6167,-13509,23952,-24990,5833,-16948,23881,2628,-2621,15278,4708,-25657,7826,-24659,-11392,12740,1935,-15363,-8287,7341,10059,-32479,6937,-9903,9202,3328,-1772,-27891,-20672,-8285,-8848,-1317,24585,30665,-10154,2367,7989,-28942,27218,-1114,-28369,-13621,-30037,19154,-29836,6171,11136,-30753,-23023,13113,-5379,-17960,-10939,17001,-16310,23644,8987,556,10751,23031,-13583,30005,-26497,-29034,-26227,27567,-32124,28870,-14144,-27363,-23657,9125,10958,25747,-13826,-32345,-1200,-20759,-23389,21166,-23728,-10722,28512,-22044,30920,21662,-22904,-2842,-3985,28873,-4480,14142,9833,20038,17589,25167,8473,-22549,21928,1531,-9520,13598,10842,-9307,-1711,-5783,-23809,-6220,32340,-27415,-12171,24415,-20309,2819,-5896,792,4819,-31835,-31035,18679,-16082,-26466,-4216,6798,-17663,-23833,-24522,13930,-1354,-1532,7320,-23515,3961,-14364,15346,-21304,-24305,-9005,6508,-19779,1237,12122,4872,20289,10870,-187,12029,2005,-19110,-22442,-8439,-28789,-9343,-30970,115,20051,17169,-18255,10929,-26405,5737,-17841,15,30502,9287,-16958,-5556,-3990,28374,-24785,-18424,21063,-21839,7949,-25874,-23674,3193,14694,1188,8045,-30747,-18955,-13848,24484,8875,11545,2215,3801,32220,17859,19229,26,-8302,-22350,-15896,2998,5650,20637,20789,15647,3878,-19029,21443,-12637,-19,-21775,-1666,12916,10812,32586,845,-30529,-25384,-10790,14719,-24082,-7298,28907,1889,-22753,-19262,29836,-12122,30086,31673,16135,-3949,-20169,14884,23872,5527,-16379,-22793,-16173,12787,7057,-6551,28087,-12505,21176,-28523,20358,9394,9975,-28251,21268,-18249,30370,10069,18693,9695,15829,-3850,24432,-26390,29035,-25598,-30153,-11588,15988,-273,-4795,-21530,14954,5680,-21858,-15733,30097,-8815,25451,-7383,-23749,2098,1519,9283,-29084,19160,8800,3532,-22587,-20217,21974,18141,-13029,19013,-31406,1734,-10532,-14555,-12303,22054,-3002,25943,-14820,-15986,-19616,23199,-2949,10396,-18141,-8209,-8035,16887,25460,15754,7311,6625,-3263,-32312,-24817,-3258,-29085,-21732,-6523,31930,-7663,-866,-26373,-21926,31146,-30474,-1552,22601,-324,-8052,-32498,27532,-1438,-8102,-26515,-7433,-13658,-27232,-31639,-10305,-29535,7581,15592,26511,7341,17005,4730,24123,-7798,-10351,659,-7768,25489,-14692,-2625,-16204,-14431,-2204,3659,-1897,19293,-24846,21606,-6380,29347,29674,11695,-15643,-29188,2743,17180,12135,10109,10930,-13926,-21367,18418,-6581,24865,8189,-10619,23308,-11679,-2983,-30526,-20543,-17862,-9170,-27523,12939,-16261,28466,3181,15998,-27907,14051,3407,13701,-14485,26689,3624,-23391,23623,4438,-30523,28857,25262,10436,19917,-26700,-6053,-13645,843,-16585,12601,-30600,17769,-29566,-18959,-25274,15990,5350,29683,-17263,1569,-24128,-29235,3644,28870,-12626,-10828,27235,-16271,31133,-6229,32672,32630,7269,-28336,5521,23043,-22872,19740,17527,-7214,32331,25758,-28301,3781,-15038,-31141,4735,31346,-20659,-17364,-11107,20712,-522,-32710,-16438,29702,-886,-14349,-13127,-29681,49,-8403,8365,-23910,-18179,9924,23184,11226,-13722,-16912,29401,-17886,-13399,-31004,-11100,5083,-31071,29238,-2096,17116,8167,-29693,-2619,-7808,10553,30524,5719,-23300,1548,-12902,-10336,21347,-17035,-5835,-24294,4165,-17997,-5635,30640,6811,28284,-21780,-1879,12459,15148,32207,-26376,-29852,18974,-22262,8342,30468,-13846,18270,-26038,1821,-15276,-5386,-6649,-11606,-3192,7097,-25270,-3999,25842,-18936,11952,6559,-31295,13548,7955,17851,6947,18478,11280,-13822,12245,-32344,11690,9086,-9907,-25718,15714,-16985,18423,-28962,11307,17852,13342,-17048,28337,2518,31443,4282,-12373,-26440,11876,-27639,28844,-7854,21926,-7089,32518,-1086,12874,6286,-19779,-24690,-18749,8227,-30509,-1375,4183,24243,-32696,-13231,30534,-4403,3794,13533,-8869,20347,-9773,31072,21945,-27656,25395,15573,-26537,21555,27300,-14345,26749,19180,-1951,-23703,-3047,-14376,20558,4655,18049,10539,-1459,32181,15633,13246,-26489,31502,22068,-4019,-22941,8351,-21779,-5440,15930,-9343,24805,-8851,-1890,-22898,-32641,10814,-28290,26438,-3913,15468,-14133,24034,-27429,-23426,-15081,-16291,-32013,-5740,14183,5465,28759,-25598,28800,-32411,3130,2351,22865,18527,17283,17194,-7532,5315,-28111,20680,5618,9440,-11921,10413,29103,31359,29852,25375,789,22695,-27511,-16885,-27453,1638,-2985,8591,-12700,19362,5388,-32474,-2821,-2600,-20993,-18171,-22378,-32477,12341,-22754,-27246,17127,2033,-22491,20397,-31889,13088,7795,-11637,10642,26137,22183,7320,7718,-14633,-5000,13296,-16508,23082,9808,4826,9011,-10636,-18012,-25457,9758,8972,-25655,27920,30403,-17313,-2108,1088,-27262,21411,22666,-2521,-12212},
  {-31909,-6264,-22628,-13145,23512,9063,-15057,-21354,-1345,3589,-30977,3448,-21573,20696,29859,-718,-5828,13939,-21145,21037,-7900,594,-28584,-20442,14989,25583,-5908,4486,-28353,16867,29765,7112,13687,5054,18468,-23704,2476,17893,-6020,-7203,-30692,-11319,-32419,30629,22333,-5730,-25034,423,-634,-20391,-11063,-26171,-25505,21853,15573,-2287,20977,27464,-21460,30598,-22828,18132,8782,27082,25187,18443,6370,13626,24599,30944,-29787,11537,12318,3764,-21479,3680,20493,122,-21967,28549,13907,-16339,19156,-7404,19905,-11191,-8852,2777,-18827,28419,-16849,9903,8652,-4466,-18322,26917,-1873,11903,530,5599,-32725,-13526,-4806,30915,-29399,-28948,7141,12277,-25014,26689,-28813,-3658,6802,-12402,23629,-19818,-15156,13100,-23689,30734,-5955,8160,17419,21949,-12297,-21985,9531,-15503,-21419,-1849,-2684,1599,13630,14186,30653,-2099,-23488,25183,13156,-15197,-11075,-29286,-435,23370,5633,-26484,-30950,-2213,9345,-27772,-13469,-22553,-20715,2811,32674,16216,-27092,24652,16732,32093,15119,-15179,3388,19152,8007,-364,8914,-11489,-30911,19822,-6507,13303,-8207,1076,8401,12616,8389,6000,-1207,16568,12914,-7179,4872,-11411,-5958,-19476,-5148,12435,-11995,5790,-28596,-7632,-863,22347,15866,22863,-5960,-20570,-14976,32191,-3364,-26650,-12411,-30955,29729,-8830,-3442,-25438,-30786,31973,4087,22631,-10739,29501,-29404,-32683,-24938,-19910,11503,-21258,-13416,18720,-8945,11252,28198,15931,3997,27735,23464,-29482,-9535,-23884,14079,-20906,-2771,-31370,22474,-200,2729,23064,25781,-5541,-10121,-29353,-22161,25058,-19471,-25590,-2026,21682,-3656,18752,-10734,9405,16087,-2838,7205,-1713,25860,-24398,32556,-15815,22040,12820,-27842,-833,-4216,8343,9071,-31466,-8946,26991,9876,-28051,-3125,9440,-220,12922,-17542,-18743,-22177,-25954,9842,2063,-29078,-16852,-12232,24255,-12085,-14424,-20414,-22371,5016,28731,5241,-29852,-20174,-7502,-10045,-9858,979,26614,24386,21616,25082,-26219,-3594,13745,-6642,-21143,-4221,31547,-26774,-1709,27351,21439,10629,-4195,-11531,2806,-1446,-5381,32003,13070,-19403,-28611,-30313,29054,30425,-31166,30650,-22205,-21451,29140,-19889,-14450,19236,-14377,-30912,22623,-11072,29479,22765,22408,-13528,-22589,28489,-6319,-19127,-10064,28945,-27548,4858,4000,-17367,27801,-8851,30206,22348,3399,-26474,-21578,-31681,-22389,15797,-7364,-7076,17486,-15206,18496,31030,-10541,4135,7271,-19323,22469,-30604,-19562,-21828,-16066,26044,-31371,-25562,22856,-12675,11568,-11624,15710,9429,-28905,-9499,-22362,-26084,18438,-40,-19566,17091,-3450,-13146,9261,-8219,23723,-3544,-11752,-20031,-9237,-5886,-24012,-27430,29927,3620,-2327,-29994,20635,18968,28698,-28174,-2375,6098,-2909,-2099,-9037,-7914,4346,19801,-13068,27278,7104,-13578,-12332,-26556,31231,2207,-30161,13168,25491,-1960,-30379,5369,-20640,24571,-30886,-19647,8090,-8271,23401,23924,-28093,-29183,-15059,-27294,17663,-4166,28955,-3381,18229,-27220,16047,19759,-5369,-23035,20542,19170,-15238,-2624,-12189,26697,1927,-14689,-19642,-22597,24836,-12804,-30830,15932,-32454,-16312,3149,-22242,-7030,-17184,2486,11392,-27761,17203,11263,13414,8686,15764,7540,-25358,26822,32018,21128,10867,23464,25955,26556,-1858,-7591,-25337,9751,-18607,-3929,23817,-17016,-16037,-23475,11227,28052,14063,-4148,10098,20126,-1874,-32720,20423,-26022,12768,-11129,-23892,-32391,17626,13253,-14255,-24642,-18797,30265,25580,22430,-11646,-25700,6272,31457,16587,-16980,-10141,22244,-13445,17079,29747,-29693,18847,22494,16046,-9953,-8004,-2570,-7813,18504,-12587,-5006,-5083,-32411,25230,25056,-300,-23082,10627,28680,30339,-21720,-7341,-30193,-5146,15900,-7377,-5240,32011,-1383,5217,26759,-888,-18843,-8705,-28075,20184,-12046,6972,22592,-4960,16757,4030,11698,15849,-699,6600,-19948,8104,31161,12769,13079,-24256,28840,4757,24197,-23231,9881,3768,14100,-20545,26896,-32288,12646,-4724,-9765,-2086,-26350,-9003,-19578,-21089,4045,19051,11894,14133,24876,7069,-7258,-8772,8400,21324,9234,20640,21279,22918,14488,-6771,29677,-18767,11327,-8055,-9138,491,-21076,17843,-4720,-26684,7183,4673,4574,-20348,12459,13024,19000,603,-8057,-8202,17393,-31900,-1023,-31465,-1595,30065,30374,26200,-18995,7089,-21972,16797,12583,30401,-1957,-12533,-5145,-9340,-3970,-8973,20093,32107,-15048,7429,-28330,-23466,12110,25288,-13138,12752,30484,-16914,27599,12189,28772,2924,-24431,5677,-20360,-19569,-1711,-26058,10829,3281,-21275,19282,-5662,-28359,-24420,-13709,15412,-9834,-14219,-24069,17739,-29219,3221,28283,-13110,21911,12039,-18138,28014,4804,-7607,4167,-22445,-2956,-234,-24004,-25346,-27765,-29600,-8341,-9434,6067,10043,-25257,16602,-4050,-18962,-30693,-8640,-27657,31613,-28668,-8093,-8418,5983,-13891,27511,-16989,-26671,11275,-24365,-10674,13085,27382,-18727,2260,4550,-31531,3054,-19035,18021,1970,-22254,-25339,30081,-10403,3072,3126,20460,-13784,-24819,4115,21372,-9859,-32023,8355,-26353,-25785,-16225,22671,19926,23471,1252,16481,3592,24757,-4657,23662,-29248,15136,31936,-26260,-27087,27713,-22013,15702,1226,-30460,7841,-1896,26748,29108,2503,-237,-23942,19677,2376,-3869,-10276,32102,-25595,-8127,-7240,-19898,-7736,-5614,27963,-6117,19045,-5696,-28862,342,2562,-29625,14378,-18025,5911,-15127,-8284,-19105,10444,25608,-17989,-21288,2865,-32732,-5534,30925,1602,4899,-19164,-25350,-15707,11478,-31817,8326,-16813,-20427,-14108,-22628,24433,-18929,-16925,-19500,-21679,-3150,-2074,30771,31308,13082,-15637,31176,27765,-27687,6735,1696,-13950,-11332,30570,-17523,-28389,16313,5674,16841,10882,12525,10216,29452,-1248,-27010,-3062,-22828,-10219,-6555,-24372,-23177,-199,-12222,15609,20002,-18610,7368,21762,-14859,30356,-12636,-11356,126,31386,22581,7769,-27110,23605,23718,-30838,-19475,-16405,-31087,-5448,-3775,-25337,18036,-10820,-6166,7783,-5874,-9389,1061,-30583,-364,-11624,-26600,28848,-18039,10397,21685,31796,5868,30796,11716,17661,13514,-18995,-7904,13093,-3662,13098,-12980,-5858,26660,-22734,26695,-18745,-8689,27872,-31544,-30319,19619,-13616,-21788,-2519,24097,-25104,30720,15088,4109,11089,-5405,12303,82,-32272,4752,4193,-27451,13029,-18976,3625,-592,-10719,16206,-19846,-28331,10791,-27391,26142,-31014,-8031,-22256,-563,9773,3522,32669,374,20129,27577,21910,-16789,26622,11910,-22315,-9227,-27689,-12781,-29944,-27089,-29537,3977,11042,-10755,-15057,15016,6414,3930,29120,-6020,19305,18217,-31808,-8256,5300,12517,-22723,8039,-5250,-14212,-8937,-32730,-3005,9489,8966,29759,8526},
  {9989,-4353,-9111,6286,-18097,-19184,-19635,-17229,10115,31655,24422,30470,-28874,-26398,20303,-7525,28794,24233,15063,-22248,-22181,11455,-29647,28231,-12144,25779,-23247,20081,-20205,637,4814,-26142,-6301,-16598,-29405,-8040,-8401,-23211,15071,13525,5789,-26398,3683,31195,29506,11905,13773,-3889,-2558,-15585,-24736,-27888,29051,5375,26040,-6427,-107,21222,-1277,10926,-32068,23857,-23170,-25963,26069,-1258,-5369,21814,11606,20633,21106,8573,20861,-13996,20430,-8312,26503,-15405,-23879,-3055,31655,-13037,6469,-27718,-11856,11065,-14896,18180,-12291,-17282,-17455,-17163,-30389,24894,22506,26653,27791,11322,-7135,-16387,-18673,-11665,15004,-22652,29549,1786,24033,99,24031,-8405,18905,16255,-3129,18172,-21291,30430,-18628,-1635,2891,-30247,-24164,20591,-22742,-1679,15253,-7300,-8889,5544,-7671,-16431,12776,-25375,-4079,9067,-4951,9576,27467,20381,18286,-6281,-15815,30977,-8386,18826,-5944,20169,-15287,-16674,13168,-27326,29187,-7132,-12750,-15374,-8311,2449,301,5534,-20074,-13444,23962,11884,10283,27891,17818,-26117,-5918,-5191,8155,-21939,31089,-26668,25994,7454,-20164,24101,-12692,6388,16204,3990,29500,-21637,-22657,18462,-11895,28657,19405,-16323,4246,30950,3950,30330,-5308,-12543,21391,1981,5556,12014,28124,27082,-19921,12573,-27288,10854,784,28869,-20668,-22280,14070,12086,32517,13232,-10694,-19012,11612,-23752,-30509,-24006,-961,1912,-22224,30953,26062,20289,-15690,-17418,32209,1706,32200,12428,15806,-20820,27077,-13453,-28207,19035,-9386,10565,-11249,-4283,13752,-18661,24807,-28754,23215,-7039,-11996,3740,-30086,23500,13754,11507,-30301,18218,-13689,9512,-11994,8214,3306,17518,-18132,31536,-11877,25477,12073,-8600,8790,-29089,11232,-25456,803,13713,-8649,17221,5194,31161,-15297,-21712,-3516,3930,31168,-31424,-1299,-20918,32600,6387,20202,15218,-11222,-11474,2870,-2383,-340,-22652,-19643,-9798,-14447,2503,9020,13568,8078,-25639,27519,-8628,29109,-8034,30829,28665,-11657,-13410,20026,19237,-3407,20014,765,-26475,-24429,-25484,-2776,28965,12257,12030,12703,-14069,-28240,-23412,-20366,12916,-24530,-1824,23552,-22284,-22198,29405,-32513,28293,-892,-17873,-23325,8944,-9228,-16966,19981,4888,-16590,-4112,-18609,-7003,-4175,2557,-17360,-10518,-18061,-26568,25703,-10529,914,-32055,-23996,21205,-18728,10574,32439,-710,-2142,30349,10955,-3168,26383,23188,30302,-7190,-8258,-29527,-25976,11528,-21565,19342,16940,17273,22033,16268,-6379,-14831,-1498,-2780,11680,-4255,-21192,-1886,27441,4856,-27571,3742,2723,-4974,-78,-26985,5447,24044,-21672,-17341,24638,12631,-14996,1785,18496,-23186,-15199,-13357,22472,3150,-23771,-3729,386,-18068,-31426,29688,32754,-24681,5313,-28683,30271,27650,13909,15244,29031,-3930,-30242,19141,28184,-24009,4160,4561,-18883,1864,-12438,21170,27188,14664,22319,24214,3624,-5270,12467,-8726,-13494,327,-22627,-14181,-7751,27593,27303,9385,-31904,-24112,-22530,-3558,16272,22875,-1364,-14832,21835,3679,-17227,5301,10117,-4575,14712,-2579,15266,2388,-19444,-22399,-3133,18754,22182,31524,18979,-11625,-20010,-8852,26566,-15304,11414,19549,-21532,9870,-32596,-11211,-22346,26774,-31202,-18438,21390,922,-14798,13121,-9727,768,11499,27546,2905,7703,-2713,-3371,28601,20614,25782,1108,-19516,-8546,8721,-16677,-29415,2607,-14475,22519,-7642,31743,21691,-20315,24604,-1407,-11633,17357,5097,-21086,-1248,13126,26267,-29059,-26689,-15414,-26857,10322,-3222,5456,-16764,15112,-22697,-22751,-12861,-21215,1068,31302,3769,18192,29844,-7038,530,-28961,10484,-25557,22197,29314,29644,-5117,-18979,-17753,11625,15094,-21488,2419,25533,-406,-21081,-19410,7925,-18943,16107,-29133,-7231,-12298,16235,18345,8928,7725,27849,-11057,-27537,26878,-28793,25763,5974,-4229,-21172,-5988,-7334,-32187,9882,28792,16688,3954,-19014,-2895,12362,10801,1198,-22387,-7887,27749,-21494,-5375,1696,-13142,-5581,23507,10171,20924,-4227,16274,-16747,-6004,9488,-23056,-6159,-23639,10718,17951,10205,-13173,1498,-17502,-881,-520,-5044,28652,-29564,-14385,6046,-13587,11792,16085,16482,10054,-29885,-295,21759,21402,24581,-2243,-25338,-9991,8346,-11325,-28179,-3241,-15574,-6870,27692,-23983,12692,-15686,-4092,-1418,-13256,-18628,-26558,30579,-19611,32522,-30550,30844,-30165,-32228,3116,-25938,-29801,-1988,12463,-18003,16549,-929,17532,-580,-25052,12512,17872,-31024,-18802,21952,-10509,25906,-18218,15573,22285,10660,-23906,-16939,5222,24872,-19054,-10529,3234,6337,-12883,3710,6885,-27477,5578,-30312,-6418,25161,-23153,-8347,-20363,-17533,-881,21530,-8101,-1097,22332,-28091,31420,-19555,24170,2640,18115,-13417,-30343,-31323,-26006,824,-31931,-27632,-3674,-32072,1628,20993,-16206,-26222,26499,-2601,-26082,-14204,18906,-31661,-2615,24604,-26239,-7503,-9043,-24406,10955,12038,1627,9561,-818,-22347,1303,20592,-3480,-7346,2632,-28442,-18544,29149,5783,-3718,18534,31508,20700,29654,-23815,7518,-10764,18041,-10425,14771,-22018,6209,-22585,20225,-25201,-5923,24908,2210,4188,11365,14373,-30443,18668,31259,-14019,4734,-12666,9587,-17687,-20209,541,13215,-23367,32162,-1425,19788,-25379,-27186,-17037,-23781,4361,-21675,14942,-22572,758,-31884,4645,22790,-3900,7882,9885,481,1076,-7513,10012,22955,30597,-6793,13100,-1464,-18337,-25760,-15548,-20152,-314,18797,21653,-17836,-4850,-7761,25591,28906,12041,-20292,-28734,7174,-4874,-4113,1996,11644,-8098,-24464,-567,4069,-14067,-2128,2192,-11484,-10335,-5661,-20505,7670,27381,12768,23271,14222,-14820,-28513,25223,12292,-4589,-20419,29160,-18112,11088,20542,-298,-11597,3477,31171,-28426,17583,1743,-6981,13272,3264,-27378,-29467,-27348,8002,8083,13598,26105,-31260,737,-31516,10725,8619,-31587,-28085,-31698,27299,-29953,6150,-21789,14010,-29634,-10020,19419,32458,25766,4567,27492,28866,11386,-27104,29533,21842,10661,14748,18285,-18692,-27251,20466,-7416,-771,2798,27134,-16732,13294,12199,24844,-31059,27998,22973,6894,13991,-113,24901,201,-1202,265,-25972,-6733,-6318,17180,28751,3389,19174,26783,1085,-32712,16596,-26578,-8897,-13457,9416,23171,29291,1083,-12021,28700,-20045,21956,-18667,-27840,-3853,27872,-31987,-7098,31734,7665,-20229,4871,-2664,-19265,31235,-20683,21891,8343,16321,-28792,-15792,22660,-3293,30219,29137,-18791,16436,8475,11222,-22405,18493,5086,-5910,-2896,-8474,-31584,-6833,-7995,19181,6434,-27387,-24091,-27478,24589,5306,19595,11002,-4349,-32233,-21689,-16576,-5800,5428,-7929,31214,9094,5586,21050,-87,3427,-24624},
  {22646,-19009,-1491,20619,-14580,-3580,-267,3563,29715,22412,-27104,20276,-15242,-19292,27971,16717,27203,845,11749,21826,9598,5929,1299,11298,12045,27942,-3758,-3127,-8544,-29492,1312,-14102,-22528,-29669,-17128,5026,10010,-17950,30627,2117,9746,7416,30921,28386,-20680,17878,4176,19727,-32096,23006,828,-31395,-28586,-25816,-4905,4346,-27625,27266,-32008,-17175,-31121,16640,23054,15205,32504,15001,-3382,22801,30355,28705,-23359,-14682,-27121,8550,-19753,-6855,-4378,7258,-18055,-23899,-11075,3594,30335,15163,-23685,-30244,-31010,27279,25757,-11598,6617,-11977,-26191,741,-23163,-9499,-20071,-4151,32068,-9741,-31832,-17903,-20367,-20251,20491,23706,-31059,30228,-9901,20928,-23955,1888,5619,-20201,9564,-23012,21870,-3435,-22906,-21429,5663,-17669,-27164,-14102,24199,5584,29187,30185,-11769,2261,20085,-26270,-5494,8846,-25191,32043,-5004,-8335,-10535,31791,9924,-30346,-15454,2133,8057,-19055,30999,-583,-22600,-3997,-8763,20200,-1570,28717,12628,11955,28830,-26997,18152,10761,-18565,12569,19709,-13254,-1003,3989,30725,3291,-30884,13974,30763,-2486,-13015,-1005,29611,-9183,4818,-28934,-22296,-7795,-24996,19710,-32097,-10262,1229,-6010,-892,-24024,-12399,-26199,17794,32386,-8255,8502,-28071,-29914,-19387,-32195,-12563,-756,-13805,-27034,20778,-18126,5028,-31968,-23534,17364,27412,10018,-28654,3662,-6250,-20211,-16007,19668,5521,-22,-7217,-12299,-18281,-6737,4495,-14502,13128,26580,-24020,-15789,-14274,-9659,7364,17699,320,-10339,18342,6309,-20051,7388,-25598,804,-3201,-1369,-23199,12959,13089,11411,13216,-25526,5689,-22097,15590,-1897,14873,25806,-4008,9711,1359,-23605,2137,-11431,23907,-18819,-21941,-19409,2101,7268,2816,17645,6368,-24864,31795,-963,-20802,-115,-7018,-14134,20729,-13695,18851,-468,-746,-20760,9748,7992,17934,18312,5535,17565,27121,23451,-8064,14565,-31609,13187,-11253,-20518,14475,28091,29286,-1020,5747,712,-7135,28351,32131,-30271,4187,-12289,7786,-32018,-19738,-10278,13845,25395,-8977,23777,-11057,14461,28627,-25095,31866,-2699,-12574,-2435,24740,-32459,620,-15123,-1499,-830,17569,-22101,-12298,14036,-30136,-25630,-24300,21024,-30901,403,-19466,28697,-9463,15062,-15058,19303,-22308,-27286,-24405,-19811,2760,227,19584,15539,-13937,-8214,-18286,-19952,9043,-19163,-20495,2100,-19213,-27943,-6420,7722,24109,-30054,-10208,4404,-27395,21378,15376,12962,18998,4521,1601,-31635,-12669,5906,13262,28456,-10813,-26713,-16448,8818,-15695,-4336,-11287,-5247,-11705,32293,-3764,-31255,1860,-29201,-15563,14484,-20569,31942,-13695,19053,25621,-27653,16484,-26928,8550,-27484,7006,19934,-19788,26098,-19720,10034,-17859,21011,6391,18777,11933,6351,9312,-7505,-859,-26194,-24776,-13115,-14559,-23513,-12770,19916,21160,-16669,14193,-9827,-6998,-13170,7359,-7741,-10415,-11936,23063,-24947,13754,21817,6015,-23921,-25298,-26667,-19426,-25837,-17169,6826,-6111,-10956,-3932,26311,-17414,-20264,-29567,-31698,7846,21931,-17682,-6342,5713,-20088,21834,10892,1719,-20078,-1634,-4311,-30808,9111,-3685,8280,-23808,5688,19876,26628,8442,-19863,-20709,7241,-8644,21795,-12620,22348,12738,31235,30633,-234,10737,1247,11897,-23129,-25138,15724,-3254,28564,-9046,12760,14011,-31653,7976,-6789,-10989,17236,-28369,-8781,-6882,-22755,-17613,173,-25659,20516,29332,-13416,17579,-22141,8311,13279,-24697,-5560,-30630,14897,-1542,22016,28737,9079,-31864,19763,14231,26175,16714,-15340,17132,9215,-12442,7196,-2267,22560,-27842,-28247,19502,-19881,263,-20454,-3884,-24233,3553,-10867,12218,-26508,10553,-22640,31873,2429,11545,-24777,-7587,25087,-14791,-22003,28890,29582,-26676,-7478,-3729,12154,15073,2892,6872,-20337,13695,-28897,3986,15102,20614,24471,23694,-28820,1139,17693,17714,177,-20746,18021,8461,24593,-9864,32579,11104,-24722,-31383,860,23877,4989,-1590,-26974,27968,-31600,8491,-20841,16980,14653,12691,644,18085,-6333,-11653,28337,-31679,1873,-9716,5554,-12206,-5052,-405,-31451,-32296,-25494,2279,-1657,-13125,-2265,-26990,-6368,26211,22223,15931,-30216,-19543,-24136,-9211,31123,-147,32691,4207,1778,14974,-4236,-26900,-5578,-9522,-12181,17378,4677,-29050,13253,-10533,18248,-18635,-19482,-29788,9554,-20274,17307,-17705,-27028,-14660,30660,14925,10512,23145,21038,31028,-26888,6278,10274,-14767,29039,21464,10716,17004,-10082,13785,-8650,12966,20765,-4959,24258,25940,-19808,-2505,26243,9911,2287,206,-19421,16347,17707,12776,5338,-13085,9928,26941,-10021,-1080,-29930,-21884,30660,-12669,30486,-4476,-3146,16532,15087,21407,-21326,28678,-5015,-27842,22381,-27841,15223,-18173,13246,16274,12107,17691,26017,-10609,12783,-22346,9101,986,1635,17959,23441,-10695,12667,-2034,-18438,24354,-9319,10047,-1511,-29874,30604,-8550,-26012,7817,2206,1787,-29211,-2721,8745,-4275,20228,-25774,26809,-23648,737,-27070,-996,12115,-5062,-19571,-10676,5622,-13569,32636,25818,30315,32230,-11278,-2297,21518,15846,17572,4415,26758,15326,-11425,31071,30006,6067,-24245,31555,8975,22012,20954,23675,-26782,19775,1653,-26046,-28088,-28342,-18344,22822,-27381,-16087,29845,-12445,-8393,4711,-14912,9418,29280,21017,-9729,2893,5442,23278,14796,31354,20477,20889,12491,536,27758,-7797,2817,14010,-443,27196,1106,16129,19140,18357,-9111,-11799,-6741,-28870,-29144,-16729,2439,-22546,8930,-5118,24519,871,-9665,29092,22710,-6984,10170,-31448,18798,-15376,-25885,32409,-29625,-8535,26880,-30361,-21811,32674,-26724,6232,4847,28217,13406,-3073,-20288,-18197,-31792,-14764,-7462,-16747,18612,10944,3284,13077,16354,788,-18215,-20862,25512,29031,-10374,-2212,-22124,-23609,19491,-9878,-2416,3879,18559,26915,-10619,-175,21155,15426,-24303,-23201,-26119,21980,-26624,28218,-16506,-9098,-31438,9305,-9587,-235,3265,-15056,21854,-13951,-23405,14395,25171,32428,-4234,21079,15948,-9586,20622,16948,26673,-30256,2679,-18775,20279,-22043,20135,-7758,-22094,9581,7822,-20292,3059,-10739,-468,-3438,17970,-8143,3225,-23707,-13870,32492,29593,-24252,-29046,-5452,-13414,-6243,-23610,20688,30266,-26180,32464,26775,6621,-22325,722,-21475,-5975,-7576,8209,11971,24318,-16629,23530,29072,1738,-27987,28668,8124,-15859,-8710,15062,-1808,-1882,11916,11260,6237,1687,-24732,17785,30804,17222,-4087,29324,-11865,-9502,-17536,31317,-31470,-32391,25564,31292,832,7367,-17501,-10861,29878,24206,2842,2596,-13286,-19869,18304,23852,-18373,20351,-26946,31026,-28942,30308,19883,-17758,30525,-25968,-22266,19640,29080,9120,18800,-30181},
} ;

static void test_encode_1013x7177_impl(long long impl)
{
  unsigned char *s = test_encode_1013x7177_s;
  unsigned char *x = test_encode_1013x7177_x;
  unsigned char *s2 = test_encode_1013x7177_s2;
  unsigned char *x2 = test_encode_1013x7177_x2;
  long long slen = crypto_encode_STRBYTES;
  long long xwords = crypto_encode_ITEMS;
  long long xlen;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_encode_1013x7177_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_encode = ntruprime_dispatch_encode_1013x7177(impl);
    printf("encode_1013x7177 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_encode_1013x7177_implementation(impl),ntruprime_dispatch_encode_1013x7177_compiler(impl));
  } else {
    crypto_encode = ntruprime_encode_1013x7177;
    printf("encode_1013x7177 selected implementation %s compiler %s\n",ntruprime_encode_1013x7177_implementation(),ntruprime_encode_1013x7177_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_encode_ITEMBYTES;

      output_prepare(s2,s,slen);
      input_prepare(x2,x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      secret(x,xlen);
      crypto_encode(s,x);
      public(x,xlen);
      endianness(x,xwords,crypto_encode_ITEMBYTES);
      public(s,slen);
      checksum(s,slen);
      output_compare(s2,s,slen,"crypto_encode");
      input_compare(x2,x,xlen,"crypto_encode");

      double_canary(s2,s,slen);
      double_canary(x2,x,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      secret(x2,xlen);
      crypto_encode(s2,x2);
      public(x2,xlen);
      endianness(x2,xwords,crypto_encode_ITEMBYTES);
      public(s2,slen);
      if (memcmp(s2,s,slen) != 0) fail("failure: crypto_encode is nondeterministic\n");
    }
    checksum_expected(encode_1013x7177_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_encode_1013x7177_NUM;++precomp) {
    output_prepare(s2,s,crypto_encode_STRBYTES);
    input_prepare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x,precomputed_encode_1013x7177_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    memcpy(x2,precomputed_encode_1013x7177_x[precomp],crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
    crypto_encode(s,x);
    if (memcmp(s,precomputed_encode_1013x7177_s[precomp],crypto_encode_STRBYTES)) {
      fail("failure: crypto_encode fails precomputed test vectors\n");
      printf("expected s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",((unsigned char *) precomputed_encode_1013x7177_s[precomp])[pos]);
      printf("\n");
      printf("received s: ");
      for (long long pos = 0;pos < crypto_encode_STRBYTES;++pos) printf("%02x",s[pos]);
      printf("\n");
    }
    output_compare(s2,s,crypto_encode_STRBYTES,"crypto_encode");
    input_compare(x2,x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES,"crypto_encode");
  }
}

void test_encode_1013x7177(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"encode")) return;
  if (targetp && strcmp(targetp,"1013x7177")) return;
  storage_encode_1013x7177_s = callocplus(crypto_encode_STRBYTES);
  test_encode_1013x7177_s = aligned(storage_encode_1013x7177_s,crypto_encode_STRBYTES);
  if (crypto_encode_STRBYTES > maxalloc) maxalloc = crypto_encode_STRBYTES;
  storage_encode_1013x7177_x = callocplus(crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  test_encode_1013x7177_x = aligned(storage_encode_1013x7177_x,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);
  if (crypto_encode_ITEMS*crypto_encode_ITEMBYTES > maxalloc) maxalloc = crypto_encode_ITEMS*crypto_encode_ITEMBYTES;
  storage_encode_1013x7177_s2 = callocplus(maxalloc);
  test_encode_1013x7177_s2 = aligned(storage_encode_1013x7177_s2,crypto_encode_STRBYTES);
  storage_encode_1013x7177_x2 = callocplus(maxalloc);
  test_encode_1013x7177_x2 = aligned(storage_encode_1013x7177_x2,crypto_encode_ITEMS*crypto_encode_ITEMBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("encode_1013x7177 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_encode_1013x7177();++impl)
      forked(test_encode_1013x7177_impl,impl);
    ++test_encode_1013x7177_s;
    ++test_encode_1013x7177_x;
    ++test_encode_1013x7177_s2;
    ++test_encode_1013x7177_x2;
  }
  free(storage_encode_1013x7177_x2);
  free(storage_encode_1013x7177_s2);
  free(storage_encode_1013x7177_x);
  free(storage_encode_1013x7177_s);
}
#undef crypto_encode_STRBYTES
#undef crypto_encode_ITEMS
#undef crypto_encode_ITEMBYTES

