/* ----- decode/857x1723, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_857x1723_checksums[] = {
  "3c44cbbf4970935594d86db45cb014095a1ca333e3ce7b2756b4fd46153c6014",
  "98b68e4fbc41894cfb6f07f41b15619290fe6c4ae47126151bc8bc91ec7a15e7",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_857x1723_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_857x1723_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_857x1723_ITEMBYTES

static void *storage_decode_857x1723_x;
static unsigned char *test_decode_857x1723_x;
static void *storage_decode_857x1723_s;
static unsigned char *test_decode_857x1723_s;
static void *storage_decode_857x1723_x2;
static unsigned char *test_decode_857x1723_x2;
static void *storage_decode_857x1723_s2;
static unsigned char *test_decode_857x1723_s2;

#define precomputed_decode_857x1723_NUM 4

static const int16_t precomputed_decode_857x1723_x[precomputed_decode_857x1723_NUM][crypto_decode_ITEMS] = {
  {303,807,1563,6,1758,-2202,1440,1275,-1983,-1368,1818,1197,-1146,-894,2169,-2472,2364,2043,-2112,549,294,1371,-831,-546,1965,-588,1797,990,-1995,-60,735,2142,2142,1677,-558,471,984,807,2454,1962,1011,-2370,2178,2373,-1272,-2211,-1845,1761,-1749,984,771,2184,291,1881,381,-942,2442,2040,-885,1257,-1929,309,-1590,-1149,-2133,2085,1731,-1347,459,-417,-1575,345,-1965,1863,573,2556,-717,1773,711,1812,-1389,1302,-1221,2436,-1452,1299,1416,-2136,960,-177,729,-837,2277,324,-687,282,-2478,-1431,-93,-2238,2055,1776,1320,-1530,-1035,1281,-744,1413,-1335,1521,1263,-180,-2559,252,1488,-1584,426,2253,705,120,-1047,-1620,-513,-2583,438,2412,1695,90,-2256,2172,2490,2544,-1872,240,-1719,2082,279,-1821,-567,942,2067,-399,456,-1386,-195,753,-894,1767,-645,1902,1920,738,771,-1104,-1182,375,-930,-1839,-126,-1434,-1002,1221,-2385,-1965,120,945,2187,981,-2439,597,1353,-63,1374,1920,1416,2058,90,81,-855,783,474,-900,1731,1911,984,1386,-2325,1503,639,2382,-66,-1875,-2571,1161,528,1245,2190,-1059,-1734,-1740,1398,-1227,-1686,-921,-2043,-1692,-1824,696,6,-1218,180,954,-690,-2277,414,1428,-2502,1254,-2565,-2487,-357,-1671,-873,-585,-1173,-1287,-30,-2562,-1695,1194,-1047,807,1746,-534,-1509,-153,414,-1425,-1197,1254,-1131,747,1626,-1218,-66,2199,-348,-1911,1950,2514,-2211,906,2055,54,1773,822,2037,-1833,2295,-690,-1719,-900,-2103,-1215,1182,-339,-618,-228,-2430,-60,1263,-1638,774,2109,-1230,-819,1440,243,1842,-978,-1605,-1695,-1962,891,1041,-486,1992,2433,2031,-24,1725,-1170,-1740,-597,-120,1686,2100,219,279,1992,813,1569,2460,462,-606,36,-1131,-315,-1440,-957,1896,849,-2337,192,1683,1650,-1971,1035,-1047,-1773,753,-195,1548,1953,1767,-2490,309,-582,-2253,1122,-1653,204,1608,1374,-2010,219,-1107,768,975,1785,-1563,-1245,-1527,2439,1581,-2280,-2460,366,2241,315,-2421,-2106,-654,1923,-2358,-1266,-39,285,-1365,438,246,546,726,2373,615,2547,-123,-378,-1305,1323,1671,-2283,2175,2508,2247,2226,1740,-582,1782,894,-300,444,-1725,228,-1791,-807,-369,1518,2406,-2067,273,-2460,2502,-1035,489,-573,-2007,1254,-213,777,732,-798,-870,-1980,-2391,-486,-2409,-2532,-2199,-579,1080,1824,-2094,1734,2352,1920,-2559,780,-621,2424,-1077,687,-1863,-894,-666,1791,-1977,-1137,-1425,1422,-2133,-1755,1857,-702,1125,-1692,-1377,1107,-681,-2496,1488,-2007,-1698,-1713,141,0,-1953,-1290,2547,-2478,249,2190,-996,-1041,624,321,318,-657,-1827,-2550,1410,-2565,-1242,-1887,-2142,-321,-2319,-516,2109,159,-885,-2370,633,-2424,-2085,2058,1767,420,2307,-15,495,-363,-1296,765,-1395,2385,1401,162,63,1677,1029,-2172,-429,-861,-1242,438,2382,-999,2376,1089,957,1620,2052,453,-2484,1437,330,-2436,-1503,-819,-822,-2508,-2061,-924,2415,270,1053,-966,1035,-1014,390,2127,-1947,-630,-1644,837,795,2397,-1257,243,-1734,2337,2475,-1461,-1866,300,-2484,585,-648,-1896,-837,93,-1260,-330,-540,2421,-963,-1980,1512,-651,-2481,-1494,2025,327,-1806,-1335,-1314,-1740,627,-279,-2514,450,-933,1608,-2328,-867,1809,690,1407,-987,-1518,2352,-2379,2052,-246,-669,75,2565,1644,-2406,1425,1797,-960,1053,1809,1398,183,-27,1485,-1677,-1698,1023,-2112,-507,1563,1395,-411,3,1386,-312,2349,-1227,1572,-1311,-1554,1914,2577,2139,-2094,1212,2118,1218,1803,-705,-69,1116,-1335,-753,-1596,1053,-2406,-2280,-1893,-2337,1620,-396,-660,-24,-1125,2013,-612,-2544,-630,1725,-918,-1038,2085,-153,-72,2466,-1767,-546,-2157,-1527,87,252,-249,849,2577,-1218,-1863,-2496,711,-120,-654,492,-1941,618,2538,1383,-2418,735,2097,1863,150,-1998,-585,-90,462,408,1242,-504,-1698,1383,-1548,2487,957,1122,39,-1770,-2523,1881,-2109,-639,-1899,-1161,2436,-2217,1968,-141,1197,2070,1116,-2283,1479,-654,906,1212,-2205,-2544,-1323,741,2058,-2025,1611,-1443,2478,-90,417,-2400,-42,1677,-573,210,-153,1503,-1281,1470,1305,-876,2310,-1188,-1305,939,2424,30,1224,-1896,1215,-1197,-813,-2061,1842,-561,-2169,-963,33,-480,1038,2139,2175,1326,699,789,-2565,144,570,-1221,-1665,129,-1236,855,2142,1803,1467,-1815,2334,369,2349,-1032,-1371,-2073,2418,1158,1944,-276,1146,513,-1815,324,-1698,-1623,-1194,-1533,-1860,672,408,-180,2430,-648,-1542,333,1980,630,-2427,-2088,2247,2430,-105,2463,1305,1734,1563,1710,474,-810,-1119,-2028,1698,-1092,-564,-306,-2370,1995,1197,1665,-1431,-1425,216,48,-1332,-363,114,861,1311,1719,495,1437,-1449,-1143,1995,924,1833,1851,-795,-2553,711,2397,1671,642,1563,309,1764,-501,1236,-1701,2145,-1509,720,-213,1779,2481,-1482,1215,1047,591,969,-999,-1686,-33,-1176,-117,-1401,1605,72,-1896,2508},
  {135,-1644,1038,87,-1524,300,951,1197,933,-708,2520,-171,-2289,-666,2550,-2538,210,-405,-273,-1125,2394,-2406,-927,2283,-549,693,-1737,-2454,-1815,-342,198,1527,27,447,174,-162,-1875,2169,855,2136,2052,-2565,237,-1815,-57,-624,1818,-897,-2133,-708,492,-294,1410,-972,411,2295,1002,1029,-1443,-1116,-1944,-1323,-1947,1317,-1095,-2322,-66,-1419,132,-1218,-186,-1872,-36,-564,-1383,-1797,1131,399,-132,-120,-1800,-2130,-300,-633,-1152,618,-1491,-807,1998,1794,1743,-555,-2106,-2475,2418,-2100,-543,-996,-1398,-441,-1086,-1482,-1878,-153,2238,-1905,186,690,1923,-462,1413,-1158,-1809,180,-324,-1755,-288,-1836,2322,669,-1665,708,6,1500,-768,2076,2334,306,-1689,222,-1698,-723,-894,756,2136,1317,-1389,-57,2058,-2319,-840,21,-1905,591,834,2244,-2274,-2487,1743,-210,-774,-2460,177,2301,-1239,231,1305,2283,-900,219,-639,-240,720,1401,105,1470,486,666,-1206,-1167,-1944,2118,-477,-2322,-132,-1485,1302,2256,-879,-144,-354,1719,-531,2196,168,1224,-1494,2505,1977,1866,2346,1275,1782,-2229,-1533,-1593,1269,-1689,-1314,2466,2091,-1686,-429,321,-183,1779,1641,537,-1590,-909,2328,-198,-498,-1602,1365,-225,2151,-2007,-990,-873,-1443,711,-1986,-156,-330,-1098,1017,1602,522,-798,-528,-666,-1926,2172,-2124,1287,1716,-1665,-1740,414,282,201,18,2463,-1683,-1539,-2082,-216,1068,-2421,-2466,-1380,-2181,627,-255,-1794,171,-390,-198,84,-2229,2208,216,2394,1326,1110,-1389,-498,1761,1659,1836,99,1929,2466,405,549,-1794,2358,1212,2043,-282,1278,1242,1983,1500,-834,1233,-918,1623,1899,2523,-744,894,-2529,-1995,1110,1788,2145,1680,1830,-1512,2373,-2112,897,498,1593,-2292,-741,-639,-1635,-1152,2367,1704,1980,-1896,1287,-1614,-1734,-1182,-2559,792,501,759,1932,90,1605,1161,-1368,-207,438,-465,-330,1233,2265,2532,2328,-480,-501,-819,291,1563,1689,1263,-2268,978,240,186,597,-1545,108,1542,174,-1962,2307,1836,2373,-1821,-681,252,-2298,-330,-30,2430,-15,834,1557,1062,-87,-855,1902,2292,1767,-1635,2262,1788,-858,693,1797,-192,-2052,-954,-1632,243,-1377,-1890,-945,-2298,-396,954,6,102,825,-171,-114,669,-60,141,-1488,1707,-192,582,1677,-1641,-906,-843,-1737,-2190,675,414,1575,2247,-2499,1179,-582,-1893,1506,-849,2058,-564,2139,846,-72,-2559,345,429,549,1809,381,717,-2259,-1494,2067,2046,606,-168,1530,2409,-2307,-1905,249,-507,1107,-1488,951,1527,-1347,1665,915,2394,-897,1068,-1767,-1371,1860,2061,1968,1641,1995,-1779,-1461,2370,-1713,-2550,261,1890,789,798,-426,441,-315,-240,1008,915,2532,-1653,-1125,1122,-1137,2475,-498,-957,177,939,-174,-1386,-2337,963,906,-1581,-1818,-1704,1779,1065,852,1257,2073,-816,-501,-132,-2157,-615,-33,-1125,-867,315,1596,1389,2532,-1500,-432,-603,-2406,987,1104,540,1854,-138,2337,132,-1104,1236,-774,1518,1722,-888,1848,-687,447,1602,-672,2490,384,-723,-642,2001,-1446,2088,-2442,-720,1380,-1860,2337,-1848,1155,2235,-930,-1602,-2355,-471,-2418,-1404,-1659,243,168,-987,-1530,-2535,528,-1650,-666,2427,2154,1827,432,363,2196,1506,2217,-2523,939,-444,-1302,2421,-603,-1929,-735,-2094,1671,1245,-369,-744,2190,744,-1533,-1569,2490,-1470,1905,-1887,1734,1797,-993,-324,1869,1182,1752,1557,-723,-1047,-1584,-1584,-318,-1329,453,495,1842,-1677,843,1179,1209,2109,1020,2211,-1755,-651,-1473,-45,594,1083,-9,1188,990,-618,2304,540,-1935,-1353,-1677,2430,1137,2184,765,2337,1287,-1935,417,-390,1707,-1974,261,-1482,921,-2571,-579,-1323,1902,225,-879,1920,213,1785,-1782,-705,2169,-1314,-1071,417,1113,1392,1341,-234,-2130,501,-120,-573,2067,693,33,1239,-1893,1884,-132,1044,-516,2442,543,2574,612,2292,2301,1758,-1251,-978,1023,-1332,258,-1806,369,1653,1278,-291,2325,-684,768,-135,-1008,-1359,2391,1437,2532,-819,1599,111,-1575,-1476,-1077,-864,-1806,57,-2067,-2433,1704,-2433,1173,1086,480,-2286,2241,-189,-27,621,-2484,2010,-1548,-1884,1305,-1485,-399,-2157,-744,2385,756,1854,-1458,-462,-360,1107,1995,-1233,747,1269,-123,2232,1251,-1233,-2418,2484,-1638,2295,-612,-1206,-900,1947,-1323,-1233,1674,1044,-603,-1800,-1317,1248,2469,-1248,714,-828,-1401,-1065,-1350,-2040,-1605,456,-1140,366,2241,1128,-456,1230,-552,951,2040,-1689,552,-1659,150,2271,1161,-843,-501,-1101,1125,-2439,1533,-432,1518,-1995,-1062,288,1518,-1008,225,1623,2478,-1983,714,399,462,-1209,330,-78,-159,-2202,2271,483,1806,102,-1233,-2370,-1506,-456,-123,828,-2475,-2379,-2160,-732,-453,2205,-1344,918,-1485,-2301,-2364,-60,705,-1545,-960,-1713,174,1470,2190,-558,-2133,1203,-936,-2085,1698,2016,-1851,-201,-2202,-894,492,-2244,-2034,-579,-621,-1320},
  {2340,753,-309,330,981,2013,1419,609,-1419,2124,-1113,219,1746,-1806,-2244,372,402,-1353,585,102,-390,1488,2346,1281,105,2316,-804,-1632,147,1941,-2358,78,-234,-2370,-504,-2235,-1536,1695,-1677,1542,-1077,1038,-492,-348,1842,-1458,1401,-1107,1860,1707,-390,-1578,-543,960,1365,1377,-1938,-2160,816,-2244,-2268,801,-714,-1128,-1638,1509,2421,129,-594,1614,-2553,1776,1719,1980,384,1404,-2292,828,-2451,501,-2199,24,-2442,726,549,-2319,1851,861,-2340,-1992,-1782,744,-1641,747,-36,-1818,414,-1713,1731,1344,1926,2013,-1578,2082,-1863,-1722,-2517,552,-648,1482,633,-921,597,1701,867,-2442,1563,1788,-351,1839,-111,-2316,-597,2217,2247,1425,-51,2058,1797,1758,1329,1188,-2262,1959,2157,-2259,2286,825,696,-177,2562,-1686,-1293,-801,1416,402,138,2190,-576,-768,-1599,-2562,486,-168,-1665,-2352,1623,-1146,-1677,-2352,-717,21,-2100,765,2523,381,615,-1479,60,1113,-330,489,-1356,-498,2169,-312,-2265,-2553,-2100,2034,1905,1368,-1785,-1059,1197,255,-1695,1299,-600,2376,-2259,210,165,-2127,-1941,822,-2517,-1047,-2457,-39,2409,-2349,81,-606,-1581,-720,-708,1599,2016,-2505,24,1479,2460,-477,2049,-705,2145,405,-2049,1734,465,-741,-204,1269,2421,-894,-117,363,-417,-1518,-564,285,615,-504,-1839,-642,414,45,-1362,-1158,378,-1410,2184,576,1899,1755,1587,-1143,468,303,1542,-762,-564,1344,-2559,-1446,1413,-1197,-1734,2169,981,-198,1218,1290,2409,132,1965,-2082,-2514,1650,-186,-2115,873,-1500,-2205,-1335,-1878,-147,-1380,-1323,2277,2067,969,-2472,1548,-36,591,-582,1605,-1350,-2058,-1512,-2007,822,-921,837,936,-528,-279,-1851,945,882,-2283,-78,-1629,-174,-66,-1926,-360,1464,-2472,1617,-903,2364,-369,-1191,-1179,60,1035,1494,-768,-1155,2208,-351,-1284,-1755,-228,606,987,-426,-270,1677,-1740,-1878,-1428,-177,402,-732,-1674,660,60,-2331,-1215,2574,2289,1830,-1680,2028,1806,2532,-924,384,-2151,-1395,-243,165,2016,2226,-90,-2469,-2091,-966,-717,-2220,2514,2157,-204,-966,-1731,-30,-657,585,-135,-2523,-924,-1821,-831,-1911,-2319,-1062,2349,-1524,-1308,-2055,-132,-9,-1776,2415,-60,-1797,1629,-1890,-1593,-606,1263,-2502,381,2268,-1500,780,2343,-12,267,-93,-2391,1371,2208,810,1776,-2511,564,2295,549,-1422,1056,-594,2112,120,2553,-2415,2037,-1029,618,1434,-258,-1917,2310,2358,1515,2181,-189,69,2568,141,-288,2328,789,1821,132,309,2007,330,-2313,-1278,-51,-1023,966,663,-2538,2166,-1899,-1956,2355,1089,-855,2151,-1425,1779,-711,-399,-252,1926,-1350,228,-501,-2292,285,-252,-207,-750,-1416,1833,-1668,-312,2400,-291,861,-1839,-801,732,-2088,-351,-36,-1626,-135,912,1920,18,297,-2520,-1647,729,579,1008,-1161,-270,-471,78,-1770,2172,-1563,1275,-1725,2568,-1461,408,-702,-21,-1059,-720,-558,-1062,168,2574,1431,-2313,-1800,2511,2178,-1752,150,831,1449,1962,-78,-39,750,129,2169,-288,1095,-2004,972,-1716,870,-2583,2235,-1686,-1401,-864,2073,-414,-2064,-429,2049,-732,813,2556,-2169,-2196,1071,1080,-1230,-1224,-930,-2271,-2436,-1446,-1143,294,-669,-114,1443,2523,132,-1380,315,-1704,1275,-2133,648,-1437,2475,1248,819,45,-2514,2214,1689,2175,-927,-1341,-1200,-1203,2250,-297,2166,-453,1917,-1251,1752,2349,-2313,2253,-1005,1128,-1083,873,-249,-759,-1389,-6,990,1623,438,-1401,762,2346,-54,-1596,-1446,1011,1164,-1299,2484,-1908,702,-561,2361,-546,480,33,-2583,-1764,-1242,-2484,2307,2556,-1401,249,-834,-249,-1944,2376,-2055,1779,-1905,-1245,807,-342,-1758,-492,-729,1332,-492,312,-690,1530,-747,-1644,1449,-2064,-936,702,924,-333,-1260,435,2328,-1275,453,-2070,-354,-735,2505,-12,-2427,-2379,2262,1485,240,876,2040,546,-429,-459,-1455,-1542,330,411,-1722,-1482,1878,-312,-1878,609,-2064,1053,873,-1440,-1290,-1230,2034,-1449,-240,1443,1584,-2229,-1287,-732,-1632,-114,1644,-183,-348,999,2154,1908,-1995,660,507,480,-1179,495,2553,-2298,930,-1197,-1266,1824,-402,84,-1023,651,525,1992,-1527,2418,-1494,-2328,192,2085,420,1083,-1950,-234,-1668,-1563,-786,-1728,1869,-729,-888,2163,282,408,-2406,261,-735,1557,-510,-1698,1395,-1455,-2082,672,1713,210,1860,-2133,-1611,-2370,243,2325,21,-453,-609,903,1647,-1269,1521,-1170,-1005,-1572,657,1791,2271,-1143,-816,1200,-150,1278,2514,1467,576,2196,-714,222,-1014,2247,-951,-1389,-1374,-2046,-1212,-2109,1902,-417,816,2289,-153,1644,-297,-951,-2457,2118,-684,1269,-1038,-2424,-429,-2124,-723,447,-3,612,-1812,-2457,-1977,-1068,2265,-1971,2376,966,399,-681,-447,-537,2103,-2532,2250,-1488,-2391,-1734,-1563,927,1545,-1437,456,-681,-2193,531,1524,-1857,-1836,282,2163,-2457,-1116,-954,1743,1998,-2361,126,270,-1311,-1074},
  {-24,-1695,-1032,252,378,1845,-1854,-738,-1494,186,-75,-792,-450,252,1941,1845,-1251,930,417,1464,2517,2043,645,2124,390,2394,-2061,-174,603,-1308,-3,1440,-1716,-1830,-1965,-2496,303,666,-1956,1065,-84,-1821,-2574,1773,939,-1845,-1680,654,-2493,-633,1893,-960,1878,-2562,2385,177,-2445,282,-1002,-591,-2226,-1692,-918,1539,-204,1365,-1158,-2256,-2166,135,1368,-462,768,978,-582,1128,192,-1644,-87,-2319,1182,-1314,729,-816,294,-177,1101,-420,-345,-2100,1086,339,1002,-786,315,-1083,-1779,-1995,2058,927,-2364,-1449,2103,1644,2238,2391,-15,-1560,48,-2124,-723,999,-2043,564,3,2379,-2133,-1491,-1488,-1791,1542,1977,33,-276,-183,-2286,2307,1818,-1737,-1965,1074,696,693,-975,-918,609,1221,1182,54,-2559,1530,-2115,-1182,-2580,1209,1179,96,-1029,-2313,342,822,-1734,510,888,-840,-567,-1857,1200,138,1974,1941,135,-1584,933,-2382,519,-2202,-1650,-1227,2544,2301,-1749,-1824,2193,-726,-921,-1983,2427,-1839,-1809,-1974,-639,-843,-1515,1578,534,2226,615,-1593,-1689,-66,2088,-462,-2553,678,-1287,-1140,1833,-1434,-480,675,-2139,60,1140,-2127,-1044,-1593,-276,-720,1260,-2508,1638,705,135,-2424,2205,-1836,663,1443,-2169,2445,1659,-984,2067,-2298,-1371,-183,-270,-2247,153,-906,-6,1404,1848,486,573,-2475,2358,2487,-2544,-1527,-2136,-1722,402,-2070,1173,1806,2076,-30,1314,1911,-78,-2049,-2343,933,936,-93,2271,-318,-2094,789,2451,-2472,465,-2124,972,1389,-2454,-867,1827,-648,594,531,-747,-1209,-1839,-1938,-1110,-453,-1869,1383,-2013,-1530,-2562,387,-969,-1644,1515,1635,1341,2316,-1677,-54,-1089,1314,1974,-90,-2163,612,2577,1983,1005,-1143,-864,-1890,741,-516,462,408,-2019,246,2526,2478,-2256,1002,-831,1266,309,-1317,-2193,-2151,771,-471,1728,810,-165,2517,-534,438,111,-2376,-153,-1440,54,705,1242,-822,-696,-1914,51,-672,-498,1074,-2037,-126,237,-2529,-1875,54,1623,1224,-2193,-732,-1191,354,-2568,2499,1866,1695,-1515,-1500,2247,-1200,1131,-2406,1212,-1401,921,-1566,693,762,-69,1500,-657,426,-1977,-321,1551,855,-2103,1656,1767,-174,-1101,-2109,1476,1845,-414,891,-387,789,-915,-1005,1494,531,-2355,-1656,-690,2535,-810,1815,498,-2250,-843,798,2292,540,-1320,234,1554,1515,-495,291,-915,-30,-1680,-1923,-1509,1398,-618,-1392,-669,-1557,-1506,1152,1218,141,-2136,-1722,183,1020,2238,-87,-2058,843,-1719,-1425,-1758,1944,2343,-1032,408,-2244,2106,-480,1821,27,900,795,-2559,-825,-1014,534,201,-102,-1200,1167,591,72,-1392,-855,-1881,-2517,1908,2556,-1701,-2220,1740,2322,1836,-1917,-576,-1032,1146,1596,-180,-2334,501,1476,-1905,2391,-6,-6,1992,1797,-1626,-2265,198,-255,-2292,165,-972,1986,528,2508,24,2358,-225,927,1017,-2406,-243,-2163,-837,1725,-930,1977,672,813,-2502,-1311,-1032,2025,153,-168,372,2076,-1482,-822,1950,666,-717,-858,819,-1422,-2499,-1068,249,495,2367,-588,-255,2262,-2034,978,1659,-1167,516,-1176,765,1341,621,-2262,1233,960,-1503,1509,2193,-1440,1542,105,-891,-2373,-2556,-1629,-2046,-2145,1425,228,-2262,2031,2466,-2322,-1656,1863,-1734,492,-1023,-2412,-2193,-1044,-1077,1602,2067,1389,1758,198,2454,-1896,-2256,2265,444,-2412,1020,993,-2079,-75,786,-645,153,-2550,309,2187,-369,1416,1512,-507,-693,-114,-2280,915,195,2061,645,-2253,336,-177,-1701,2253,-1356,-2433,-1833,213,2559,15,-1335,1710,-678,2412,-708,-996,-891,-789,-1758,-1956,-2109,-96,-2331,1248,2352,-1419,915,2178,2451,1380,-1260,-1287,-2340,-1392,1602,2328,804,-1350,2487,1566,2208,1284,2391,894,-1683,1497,2565,1008,-1599,81,993,-918,2067,330,-6,1095,771,-1194,-1656,-1995,-1704,270,2037,-933,411,-873,2205,-213,408,-372,432,2019,-2217,1845,750,1929,-291,-21,261,-1200,1224,2541,-666,-195,-1992,-300,-684,1971,2460,1101,2496,1626,-741,1710,-2445,1038,1626,1473,-2133,-2331,-2325,657,-1182,2580,2568,1083,615,159,-2340,-897,1380,-2349,258,-1341,114,2358,-408,-504,1944,993,-570,-1347,2478,-705,2223,180,-993,-1551,306,2550,-768,-1422,2175,-1029,-2241,1212,39,1281,-702,-1092,1860,-366,-1461,1797,2415,-2151,750,597,-1713,-1005,-1413,-2274,-657,-1905,2157,2409,-489,-2412,-1173,1959,1518,-204,-2406,825,-711,-102,-2583,-2175,2418,225,-486,1104,888,717,1824,-165,1824,-2538,1575,2274,330,714,-2385,-2514,-1326,-609,-693,-1587,-90,1047,-1203,477,315,-2265,-1245,-2460,324,-2502,-1902,-714,-921,-93,-252,2370,345,-1635,531,-1023,1905,1770,1896,1656,-1728,-1101,-2481,-618,96,-1740,-2157,-2304,-843,1767,-1848,-1278,-1926,522,393,-705,1032,-354,-1545,6,-1479,720,-1419,1095,-690,-270,-792,-2193,-1218,-2229,2124,-975,-678,183,-768,1941,-2103,540,2373,2343},
} ;

static const unsigned char precomputed_decode_857x1723_s[precomputed_decode_857x1723_NUM][crypto_decode_STRBYTES] = {
  {48,203,108,159,159,31,32,55,211,57,129,69,175,177,23,207,107,65,19,56,139,239,73,174,157,21,174,109,50,54,6,117,50,146,92,64,92,103,18,109,131,217,179,12,115,114,39,17,163,63,105,122,220,97,232,29,83,140,111,111,123,178,42,107,56,250,76,1,68,237,214,106,100,97,147,126,125,17,79,248,75,188,141,2,124,184,150,62,35,214,198,220,14,60,31,171,164,33,75,94,91,217,167,100,188,210,249,138,96,102,246,184,102,112,209,110,140,20,221,19,182,216,165,137,248,5,31,193,162,71,235,184,75,250,134,27,211,71,87,144,126,177,81,77,25,169,171,170,91,177,100,254,70,32,103,125,1,63,190,58,204,217,79,253,143,209,242,1,219,50,30,46,51,54,234,91,173,248,164,43,144,11,68,25,188,150,205,59,218,76,4,145,120,111,35,171,139,106,5,54,242,14,217,165,116,212,200,220,227,181,44,49,133,224,175,50,201,199,12,169,141,253,123,167,63,221,135,69,189,5,149,55,89,163,194,19,231,175,221,166,142,225,52,145,182,199,24,84,39,141,255,69,245,150,236,142,161,47,117,191,181,93,245,250,212,19,200,234,129,204,218,78,21,239,193,75,142,227,234,46,152,157,41,169,206,2,215,21,242,154,180,113,13,246,230,45,25,0,126,34,152,33,80,122,174,160,252,241,54,157,2,204,252,152,250,16,127,92,194,166,13,174,197,178,21,31,1,62,63,89,29,166,0,159,62,50,213,215,189,95,4,246,34,167,135,225,221,251,150,253,0,233,10,156,119,147,175,16,143,179,10,60,194,60,108,104,25,254,119,121,255,82,5,189,138,223,25,70,47,19,194,104,160,179,211,231,121,128,0,174,95,70,187,231,224,53,179,176,11,158,14,249,68,118,68,45,23,144,214,26,225,98,162,222,203,146,155,187,170,95,182,53,144,80,17,71,70,188,42,195,32,116,20,177,130,46,39,161,214,45,18,111,153,135,233,0,153,153,198,119,174,160,82,96,131,60,95,253,67,139,123,190,33,173,224,252,23,165,38,214,54,129,119,237,134,237,205,136,44,1,249,229,252,254,102,138,137,239,12,99,20,67,16,147,5,76,223,191,246,232,44,98,240,137,144,175,139,146,58,100,200,31,176,83,184,129,41,164,190,3,16,75,18,181,31,137,117,218,132,234,168,229,147,185,82,248,75,45,180,128,103,228,37,60,35,3,227,161,175,214,25,94,52,99,78,190,209,158,217,34,80,74,69,30,237,186,103,51,19,58,228,107,110,236,228,78,179,231,216,253,240,203,198,128,88,136,212,1,50,172,242,227,65,162,181,168,59,254,239,252,165,192,65,113,1,226,36,175,6,100,215,27,42,28,146,106,116,99,145,42,168,150,119,99,4,168,210,142,55,214,170,62,151,87,33,210,191,55,160,198,19,50,244,235,248,129,153,252,49,112,55,112,157,97,80,161,115,86,76,149,140,159,109,8,36,121,241,155,240,94,66,192,222,1,25,165,140,225,70,116,99,16,152,36,165,208,36,166,80,149,129,199,24,132,79,151,222,38,53,200,31,197,194,94,182,147,85,108,32,51,46,85,142,125,19,138,10,80,122,239,126,85,148,200,44,74,168,144,215,246,178,227,211,24,67,250,209,171,176,176,146,85,90,21,223,212,43,255,104,71,121,3,241,186,75,66,54,186,224,34,3,23,147,79,37,3,3,109,212,219,54,100,123,9,161,149,113,134,56,140,22,209,22,181,166,200,184,150,83,136,238,169,251,157,200,32,31,116,228,131,253,102,255,33,54,238,107,248,188,69,171,236,92,67,208,88,146,79,101,169,186,32,205,224,13,156,125,210,253,106,250,13,144,175,138,206,94,15,110,93,205,169,65,22,183,249,228,158,168,49,3,184,224,92,29,93,240,1,190,110,168,92,47,202,254,143,92,9,33,116,17,217,157,104,13,178,66,155,234,160,184,32,212,232,130,158,190,68,32,12,190,230,130,88,126,77,157,92,232,191,21,240,211,211,118,124,252,195,148,228,163,215,82,42,132,185,85,95,209,95,139,5,255,202,50,255,75,108,76,27,181,230,35,182,219,28,139,230,10,218,179,117,67,240,117,145,204,120,198,213,49,251,81,143,44,205,108,241,194,9,218,4,166,72,12,18,94,19,236,37,113,165,221,172,30,251,123,42,15,144,64,205,209,240,152,136,164,241,249,221,135,2,95,137,206,171,228,191,127,214,118,52,234,215,202,71,152,190,146,2,136,15,72,132,137,201,66,180,251,63,165,88,0,228,44,38,221,149,46,6,101,244,229,252,148,67,203,146,94,37,122,249,198,196,57,77,207,133,185,122,237,251,65,185,80,142,21,112,205,132,161,44,42,6,191,123,45,186,40,145,233,196,168,211,148,194,10,236,112,255,82,100,32,251,196,203,143,45,11,78,166,189,251,93,78,226,212,48,31,141,10,44,108,79,166,168,252,47,229,175,207,96,88,172,177,165,88,12,129,86,226,94,116,158,188,223,178,23,241,202,97,164,249,39,38,244,136,65,151,251,144,92,4,56,222,76,88,51,78,194,104,156},
  {45,213,92,254,31,241,39,164,245,4,148,250,82,131,169,93,44,20,252,129,107,172,73,65,33,90,118,164,39,175,161,112,125,179,230,62,236,242,236,232,82,199,70,220,184,110,235,30,19,25,8,153,93,140,79,45,197,141,224,55,133,138,200,216,39,11,54,193,156,83,81,184,198,199,111,78,204,238,226,115,7,93,93,24,147,122,75,139,78,23,101,79,140,75,57,205,225,108,178,8,127,230,58,48,229,30,148,74,106,113,138,186,132,177,172,114,166,231,31,214,155,9,96,254,51,18,32,37,143,126,5,126,76,59,138,203,65,128,28,83,28,193,46,97,204,109,173,249,233,18,33,245,211,227,92,35,160,51,252,171,81,181,55,183,173,87,104,112,175,22,150,181,2,231,149,172,121,125,28,22,144,207,127,127,77,135,241,182,192,104,174,84,189,226,0,79,81,143,43,197,99,143,66,205,85,190,31,135,75,99,222,248,136,108,48,165,132,158,180,114,46,235,78,66,1,113,103,43,50,62,73,135,223,156,44,108,1,56,233,67,38,39,117,39,147,63,35,176,63,235,118,186,81,159,40,173,101,110,39,168,114,144,28,62,194,10,9,209,106,96,233,31,195,203,237,133,133,121,143,252,239,221,121,19,166,178,160,210,113,18,146,255,139,59,13,218,245,110,72,63,206,222,115,96,54,103,218,202,223,132,230,126,217,52,79,105,182,80,109,71,159,248,177,144,169,185,130,207,216,161,92,187,216,60,252,156,4,177,170,141,251,29,98,203,161,8,104,175,182,175,146,242,35,110,20,9,190,150,251,122,71,254,153,54,85,123,180,10,128,148,0,207,239,178,69,150,178,75,213,71,25,134,23,51,215,80,111,188,126,65,129,169,242,54,202,100,90,29,74,197,199,145,79,19,123,101,171,53,132,193,189,67,11,235,233,177,225,137,111,116,53,245,7,57,223,238,30,86,32,181,25,101,200,162,252,255,219,109,129,3,242,109,12,82,80,220,56,78,84,109,138,96,38,113,202,49,216,169,225,104,137,146,159,210,72,56,222,80,126,141,172,71,112,47,204,226,198,174,132,205,129,241,182,175,171,59,220,40,231,143,1,19,12,182,156,93,2,232,177,49,252,53,111,70,242,119,249,221,33,108,33,174,193,103,6,98,231,210,74,211,24,67,20,197,117,53,103,196,19,65,54,186,245,2,62,4,120,45,160,163,67,51,235,128,14,127,133,226,117,242,77,172,63,156,107,218,181,85,106,150,189,26,128,198,195,44,81,129,65,148,69,224,32,86,118,21,254,22,163,170,112,83,24,124,177,170,252,194,220,51,217,59,137,248,81,238,75,112,80,246,111,8,108,115,191,160,19,217,253,151,224,205,113,33,253,222,136,111,40,104,253,51,98,160,70,93,129,29,48,8,213,102,206,120,236,118,194,47,141,85,41,192,232,49,46,106,155,99,62,54,227,173,188,197,185,239,130,187,162,2,65,29,227,42,0,45,140,233,31,64,225,237,116,229,73,79,103,152,170,139,155,153,222,173,130,65,6,215,82,253,39,116,223,31,209,93,27,173,197,76,130,168,70,3,43,107,236,49,134,250,131,176,233,11,106,186,196,248,97,154,84,31,58,60,160,239,249,249,198,128,230,105,69,135,211,0,17,189,178,159,123,243,153,78,127,57,228,77,185,137,25,48,136,248,52,147,175,193,0,104,63,108,144,253,81,32,125,20,157,249,250,19,169,32,240,212,144,160,160,197,17,215,115,251,22,225,219,92,205,199,52,101,19,180,199,12,147,95,103,37,233,54,89,110,32,84,227,204,121,75,238,218,103,140,210,78,185,42,222,51,98,11,234,35,132,23,45,36,64,30,232,221,195,34,114,174,13,3,103,239,90,229,82,236,69,150,111,211,139,147,53,197,189,2,116,85,117,9,49,228,255,135,19,32,91,184,71,254,98,177,130,128,80,215,82,164,203,24,230,6,38,54,33,192,133,122,193,252,35,137,5,121,27,137,21,218,96,111,206,175,213,112,208,5,173,200,180,212,1,94,118,45,91,221,57,69,42,114,250,207,187,234,9,96,189,144,254,187,125,239,210,73,60,145,45,78,112,40,148,25,230,238,82,82,229,145,87,15,33,124,46,2,209,101,120,198,219,131,213,215,5,110,167,216,85,60,156,136,143,156,202,95,51,175,111,242,202,102,224,242,246,85,77,57,89,106,44,182,111,45,33,131,133,127,127,216,231,185,78,248,148,19,78,211,117,110,69,159,52,214,226,201,97,171,180,98,84,56,246,204,48,169,16,127,190,202,123,188,210,155,191,143,109,74,147,208,138,42,109,174,233,186,132,238,104,192,170,86,190,122,93,4,37,51,35,240,177,59,255,209,20,63,154,179,135,95,61,32,252,107,253,30,165,186,7,66,151,250,66,58,148,96,245,31,159,226,158,107,132,213,249,177,186,198,61,97,33,171,128,32,162,187,202,51,179,51,4,150,202,85,94,99,170,255,139,10,234,33,216,17,204,59,184,238,118,255,26,22,138,206,234,4,33,149,226,161,25,19,194,147,42,195,162,69,85,245,221,203,135,248,142,198},
  {177,63,184,110,159,44,212,244,97,229,26,67,91,224,26,56,236,113,3,147,163,236,176,148,91,144,87,92,214,248,97,182,151,220,132,105,165,168,236,24,71,228,92,90,56,34,12,150,189,205,243,48,149,109,78,222,64,211,177,158,59,86,50,85,177,75,89,16,39,27,28,148,6,184,140,101,6,113,95,109,122,213,90,250,97,239,70,39,184,210,223,30,242,98,12,125,156,235,22,154,122,217,237,183,251,115,91,78,180,215,122,5,197,136,35,245,97,149,203,144,120,100,24,14,175,196,208,225,174,43,93,252,147,233,200,19,51,94,15,93,142,167,140,91,173,118,213,230,244,60,73,85,207,64,76,205,187,210,95,107,17,181,77,142,219,71,194,87,150,210,205,117,221,232,42,152,212,40,238,1,93,209,199,210,189,226,204,179,232,177,71,57,239,3,171,57,171,187,7,68,109,0,2,102,53,215,197,10,68,152,102,68,49,116,82,218,249,196,184,181,67,27,36,253,100,143,134,238,156,56,238,14,145,79,105,197,40,145,164,125,29,86,47,46,23,168,125,11,173,218,182,85,189,69,155,252,66,248,91,138,213,233,179,175,255,197,188,127,175,25,49,39,187,183,197,169,170,31,10,101,171,128,116,205,152,63,101,82,28,22,146,209,233,209,48,137,222,165,116,42,7,197,189,132,158,149,133,244,157,109,245,107,218,169,26,149,76,202,172,19,54,173,160,240,7,159,2,107,147,225,221,223,163,224,211,232,230,250,241,205,52,198,35,1,207,32,33,87,159,99,106,225,23,174,103,213,74,21,13,198,58,122,3,17,130,57,139,200,141,134,58,207,2,183,116,48,214,54,169,91,33,186,6,96,116,101,57,62,242,108,72,197,192,108,25,218,84,51,61,181,101,90,207,101,186,145,50,79,175,173,84,154,0,246,133,234,249,250,106,19,188,31,146,220,142,15,231,111,196,13,177,57,145,220,181,17,154,142,247,59,29,248,83,149,99,144,58,224,117,188,69,211,123,137,180,21,129,53,2,14,159,205,33,153,102,143,255,121,140,162,248,59,131,255,59,77,6,230,147,91,241,143,38,138,207,197,250,21,17,1,201,34,45,21,71,221,182,8,182,173,217,122,90,142,73,236,184,227,255,52,240,243,253,15,144,185,193,233,81,83,177,98,42,250,173,200,5,241,241,86,220,158,160,34,122,166,70,236,105,217,151,23,44,237,35,183,241,254,188,48,94,199,128,217,106,95,24,193,156,92,102,224,209,122,178,131,246,131,223,237,192,38,154,68,9,20,207,41,198,156,94,114,112,107,77,40,158,106,87,33,244,128,99,198,25,105,184,152,143,145,71,195,115,89,161,129,17,255,156,115,102,131,161,17,44,198,41,204,8,232,135,121,30,20,70,251,57,122,236,69,1,48,78,36,199,128,233,221,124,125,208,164,5,104,129,38,251,197,61,58,45,91,209,35,26,193,169,150,218,100,140,5,55,88,84,12,12,103,62,136,129,184,172,246,215,179,16,220,241,54,181,153,51,49,175,30,27,21,51,63,118,101,13,167,250,229,76,186,181,77,39,230,106,242,16,69,207,119,153,0,153,135,121,173,53,44,98,14,105,19,254,162,88,243,252,173,254,192,247,141,157,135,41,2,117,4,28,210,121,40,98,49,81,254,232,220,66,125,177,161,74,58,218,228,88,24,192,90,38,8,3,245,163,217,68,168,96,46,163,131,192,183,129,116,133,214,145,22,141,179,148,4,75,175,73,107,74,202,39,67,45,200,57,205,66,175,113,202,74,120,54,21,62,238,130,89,202,180,173,0,177,102,132,225,163,54,249,58,141,4,80,26,110,104,11,122,191,233,30,131,38,197,206,159,119,14,118,122,3,2,223,165,254,170,23,143,179,209,196,64,188,15,55,178,18,168,73,189,65,195,37,26,25,22,131,72,233,94,72,72,209,27,255,53,23,94,217,223,24,139,67,10,192,177,132,2,113,195,95,16,139,41,143,71,34,218,191,189,98,70,249,250,169,187,252,160,125,3,223,100,142,236,204,170,11,182,19,240,162,35,104,53,105,212,179,171,179,231,47,140,141,36,148,57,200,185,49,172,66,241,2,37,40,238,36,109,26,29,208,122,112,142,36,173,51,210,49,62,255,198,106,247,59,4,10,254,51,99,172,221,47,249,219,237,67,61,169,93,16,199,80,23,197,239,227,94,22,196,250,72,93,203,94,148,202,198,189,246,43,182,22,50,140,89,229,179,191,84,212,114,130,49,15,10,37,232,247,45,68,2,94,0,33,3,132,66,181,55,79,17,124,221,184,30,155,202,201,51,113,57,31,6,68,3,139,160,165,98,30,108,75,109,156,221,130,150,101,232,127,193,227,45,171,163,48,172,32,154,248,216,198,92,106,8,155,207,117,254,107,28,103,221,169,89,124,147,199,28,139,239,231,232,2,36,190,179,81,93,232,251,82,14,149,69,28,58,198,161,24,138,5,81,179,161,202,247,146,246,133,50,97,15,90,87,187,58,135,177,121,68,160,238,87,164,241,113,197,155,116,174,132,219,132,253,22,95,70,67,150,70,40,46},
  {141,80,7,48,164,91,18,16,29,79,6,79,184,63,153,235,122,253,219,17,203,167,72,90,236,3,236,128,199,23,106,213,101,122,89,150,110,50,64,136,228,143,149,119,133,65,56,2,56,177,103,85,101,111,48,154,247,144,122,69,175,35,113,247,148,42,204,99,177,71,79,142,242,223,143,40,46,37,17,32,178,105,145,172,35,110,229,25,170,110,35,80,96,241,248,158,17,207,33,142,90,244,83,5,40,222,22,9,87,12,110,79,123,81,160,168,24,115,57,25,55,240,55,34,52,203,34,107,36,4,30,77,52,149,6,22,26,242,128,160,244,124,220,11,242,251,17,168,131,145,150,111,67,30,57,172,54,67,47,156,58,111,45,141,229,243,146,161,194,57,42,181,215,118,141,235,89,122,231,158,119,31,70,186,255,125,71,121,136,90,179,253,241,229,58,136,195,146,34,95,235,27,106,152,252,190,226,50,94,164,151,147,94,99,157,142,21,214,99,83,76,42,17,121,62,83,239,250,184,116,46,153,115,20,94,141,254,140,63,95,243,82,185,143,227,215,114,104,149,34,255,174,25,127,37,79,48,168,38,8,149,153,247,137,72,113,252,133,107,9,64,147,149,60,226,124,217,255,122,210,99,14,131,217,47,179,173,41,20,132,91,132,96,149,182,55,76,76,230,254,248,8,45,228,15,208,170,66,112,12,13,55,59,153,156,62,237,76,219,142,24,25,246,39,171,204,69,48,101,68,116,134,203,163,40,14,93,0,28,81,244,210,196,113,3,92,217,123,253,49,144,218,38,89,240,116,189,37,15,79,6,252,205,233,168,191,201,158,9,76,95,9,196,21,170,29,250,240,93,6,94,139,119,50,64,59,57,65,244,91,53,125,156,129,40,196,81,190,158,52,252,236,29,209,99,118,208,66,180,196,222,211,9,161,172,171,169,165,47,185,183,26,223,145,241,137,196,205,93,211,14,192,182,162,159,10,202,105,5,134,90,158,164,154,65,136,97,127,236,61,15,66,9,109,114,198,230,68,188,178,175,50,113,239,33,208,53,82,163,52,254,142,94,217,25,58,80,111,13,45,207,208,183,99,199,131,92,170,186,156,8,41,120,152,154,151,40,55,135,110,105,135,211,232,120,216,63,220,180,25,184,121,129,82,18,99,93,139,80,104,242,166,160,226,217,30,24,53,239,123,162,39,201,186,212,244,97,99,141,129,71,204,101,110,150,181,147,205,65,23,125,188,15,131,250,200,105,209,224,50,150,37,58,217,105,148,93,227,115,131,215,42,102,197,127,245,189,42,225,209,172,110,106,210,119,85,217,28,39,253,180,156,46,174,82,66,41,224,241,140,93,26,66,176,86,152,48,6,11,235,0,92,82,218,221,65,98,110,215,225,173,23,253,243,163,69,232,14,69,241,14,49,161,227,234,25,195,241,196,196,234,37,178,194,187,170,249,161,112,174,208,106,148,61,86,139,108,119,136,219,8,84,43,252,179,251,5,36,186,229,251,15,124,15,92,47,77,16,170,55,158,64,191,252,200,170,56,9,136,242,52,143,250,195,146,209,239,147,22,8,219,1,210,101,173,59,151,19,229,61,25,232,15,32,149,107,238,14,196,112,164,251,116,47,53,168,180,191,108,172,110,166,177,174,42,47,232,148,47,245,0,135,25,25,92,67,120,160,101,43,237,179,33,149,182,72,199,217,86,92,52,182,215,81,156,144,250,44,254,150,213,71,108,98,210,75,232,205,229,147,210,227,121,139,253,173,58,9,108,152,7,104,234,229,232,185,1,62,204,186,233,20,16,115,125,183,176,254,191,200,70,236,124,193,232,71,118,100,82,204,77,96,238,176,70,166,91,82,196,79,67,228,62,126,100,69,177,186,8,67,190,190,251,22,207,155,59,199,12,155,54,180,98,41,132,31,177,242,34,29,200,146,237,10,106,92,218,71,237,87,11,67,244,96,206,79,133,235,44,176,61,158,92,141,212,221,184,197,213,181,15,8,254,144,117,174,174,156,48,174,123,73,44,25,82,42,170,183,167,139,179,212,145,15,53,133,195,248,44,199,100,232,213,128,174,222,207,247,189,172,83,101,85,140,191,221,149,134,111,153,82,208,32,220,83,80,237,152,155,144,59,108,76,192,32,22,128,188,64,66,99,99,20,246,139,71,72,90,40,53,167,212,64,246,0,121,168,156,188,118,31,187,16,73,189,103,58,59,128,196,200,122,137,20,85,3,135,101,2,4,112,204,165,251,178,200,216,251,217,138,76,65,133,131,127,10,112,230,184,131,47,139,75,148,137,126,75,227,87,50,182,155,250,202,16,147,66,246,140,152,31,103,149,115,141,238,141,51,73,32,16,183,245,126,131,164,31,251,147,191,117,75,58,8,162,122,67,135,65,169,39,249,80,234,241,137,27,159,232,105,79,102,231,234,175,68,221,198,19,80,216,18,50,17,236,132,21,48,46,40,32,42,1,190,86,98,131,28,34,120,175,111,253,132,9,92,56,60,41,180,148,125,108,233,28,79,14,25,38,12,103,132,219,198,160,44,143,202,148,86,220,218,239,101,83,55,79,37,219,167,224,151},
} ;

static void test_decode_857x1723_impl(long long impl)
{
  unsigned char *x = test_decode_857x1723_x;
  unsigned char *s = test_decode_857x1723_s;
  unsigned char *x2 = test_decode_857x1723_x2;
  unsigned char *s2 = test_decode_857x1723_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_857x1723_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_857x1723(impl);
    printf("decode_857x1723 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_857x1723_implementation(impl),ntruprime_dispatch_decode_857x1723_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_857x1723;
    printf("decode_857x1723 selected implementation %s compiler %s\n",ntruprime_decode_857x1723_implementation(),ntruprime_decode_857x1723_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_857x1723_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_857x1723_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_857x1723_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_857x1723_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_857x1723_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_857x1723_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_857x1723(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"857x1723")) return;
  storage_decode_857x1723_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_857x1723_x = aligned(storage_decode_857x1723_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_857x1723_s = callocplus(crypto_decode_STRBYTES);
  test_decode_857x1723_s = aligned(storage_decode_857x1723_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_857x1723_x2 = callocplus(maxalloc);
  test_decode_857x1723_x2 = aligned(storage_decode_857x1723_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_857x1723_s2 = callocplus(maxalloc);
  test_decode_857x1723_s2 = aligned(storage_decode_857x1723_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_857x1723 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_857x1723();++impl)
      forked(test_decode_857x1723_impl,impl);
    ++test_decode_857x1723_x;
    ++test_decode_857x1723_s;
    ++test_decode_857x1723_x2;
    ++test_decode_857x1723_s2;
  }
  free(storage_decode_857x1723_s2);
  free(storage_decode_857x1723_x2);
  free(storage_decode_857x1723_s);
  free(storage_decode_857x1723_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

