<?xml version="1.0" encoding="ISO-8859-1"?>


<!--
Site-wide style for each sub-project
version $Date: 2004/03/16 22:26:38 $


Creates an HTML-viewable document for a code-coverage report.

 @author Matt Albrecht (mailto:groboclown@users.sourceforge.net)
-->

<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0' >

    <xsl:output method="html" indent="no"
        doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
        doctype-system="http://www.w3.org/TR/html4/loose.dtd"
    />

    <xsl:param name="perfectP" select="'100'" />
    <xsl:param name="goodP" select="'80'" />
    <xsl:param name="warnP" select="'60'" />
    
    <!-- not used
    <xsl:param name="do-weight" select="false" />
    -->
    <xsl:param name="title" select="'Code Coverage Report'" />
    <xsl:param name="footerText" select="'Generated with GroboUtils Code Coverage'" />
    <xsl:param name="footerLink" select="'http://groboutils.sourceforge.net/codecoverage'" />
    
    <xsl:param name="TSTAMP" select="'(unknown)'" />
    
    <xsl:param name="DoBarGraph" select="'true'" />
    <xsl:param name="BarWidth" select="'50'" />
    
    
    <!-- base document: contains all coverage reports -->
    <xsl:template match="/coveragereport">
<!--
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
-->
<html>
<head>
    <title>Overview (<xsl:value-of select="$title" />)</title>
    <link REL ="stylesheet" TYPE="text/css" HREF="stylesheet.css" TITLE="Style" />
</head>

<body BGCOLOR="white">
<table BORDER="0" WIDTH="100%" SUMMARY="">
<tr>
<td CLASS="FrameTitleFont"><xsl:value-of select="$title" /></td>
</tr>
</table>

<table BORDER="0" WIDTH="100%" SUMMARY="">
<tr>
<td CLASS="FrameItemFont" NOWRAP="true">
    <xsl:if test="$DoBarGraph = 'true'">
        <xsl:attribute name="COLSPAN">2</xsl:attribute>
    </xsl:if>
   
    <a HREF="overview-summary.html" target="classFrame">Overview</a>
    <br />
    <a HREF="allclasses-frame.html" target="packageFrame">All Classes</a>

<p CLASS="FrameHeadingFont">Packages</p>
</td>
</tr>
    <xsl:for-each select="package">
        <!-- we'll ignore the '.' to '/' conversion - it isn't necessary
        for sort purposes -->
        <xsl:sort data-type="text" order="ascending"
            select="@name"/>
        <xsl:variable name="path" select="translate(@name, '.', '/')" />
<tr>
<td CLASS="FrameItemFont"><a target="packageFrame">
    <xsl:attribute name="HREF">
        <xsl:value-of select="concat($path, '/package-classes.html')" />
    </xsl:attribute><xsl:value-of select="@name" /></a>
    <i>(<xsl:value-of select="cover/@display-percentcovered" />%)</i>
      <xsl:if test="$DoBarGraph = 'true'">
        <xsl:for-each select="cover">
            <xsl:call-template name="func-cover-barline">
                <xsl:with-param name="reldir" select="''" />
            </xsl:call-template>
        </xsl:for-each>
      </xsl:if>
</td>
</tr>
    </xsl:for-each>
</table>
</body>
</html>
    </xsl:template>
    
    
    <xsl:template match="/package">
        <xsl:variable name="reldir" select="@updir" />
        <xsl:variable name="pname" select="@name" />
<!--
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
-->
<html>
<head>
    <title>Overview (<xsl:value-of select="$title" />)</title>
    <link REL ="stylesheet" TYPE="text/css" TITLE="Style">
        <xsl:attribute name="HREF">
            <xsl:value-of select="concat($reldir, 'stylesheet.css')" />
        </xsl:attribute>
    </link>
</head>

<body BGCOLOR="white">
<table BORDER="0" WIDTH="100%" SUMMARY="">
<tr>
<td CLASS="FrameTitleFont"><xsl:value-of select="$title" /></td>
</tr>
</table>

<table BORDER="0" WIDTH="100%" SUMMARY="">
<tr>
<td CLASS="FrameItemFont" NOWRAP="true">
    <xsl:if test="$DoBarGraph = 'true'">
        <xsl:attribute name="COLSPAN">2</xsl:attribute>
    </xsl:if>
   
    <a HREF="package-frame.html" target="classFrame">Package Overview</a>
    <br />


<p CLASS="FrameHeadingFont">Classes</p>
</td>
</tr>
    <xsl:for-each select="classcoverage[@package = $pname]">
        <!-- since, for this select, all the package names are the same,
        we can simply sort on the classsignature -->
        <xsl:sort data-type="text" order="ascending"
            select="@classsignature"/>
        
        <xsl:variable name="sf" select="@sourcefile" />
        <xsl:variable name="classset"
            select="../classcoverage[@package = $pname and @sourcefile = $sf]" />
        <xsl:if test="$classset[1]/@classsignature = @classsignature">
<tr><td CLASS="FrameItemFont"><a target="classFrame">
    <xsl:attribute name="HREF">
        <xsl:value-of select="concat($sf, '.html')" />
    </xsl:attribute><xsl:value-of select="$sf" /></a>
    <i>(<xsl:value-of select="cover/@display-percentcovered" />%)</i>
</td>
      <xsl:if test="$DoBarGraph = 'true'">
        <xsl:for-each select="cover">
            <xsl:call-template name="func-cover-barline">
                <xsl:with-param name="reldir" select="$reldir" />
            </xsl:call-template>
        </xsl:for-each>
      </xsl:if>
</tr>    
        </xsl:if>
    </xsl:for-each>
</table>
</body>
</html>
    </xsl:template>
    
    <!-- cut-n-paste! -->
    <xsl:template name="func-cover-barline">
        <xsl:param name="reldir" select="''" />
        
        <td COLSPAN="3" CLASS="bcell">
            <table CLASS="bar"><tr><xsl:if test="@percentcovered &gt; 0">
            <td>
                <xsl:choose>
                    <xsl:when test="@percentcovered &gt;= 100">
                        <xsl:attribute name="CLASS">bpassall</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="CLASS">bpass</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                
                <img CLASS="bimg">
                <xsl:attribute name="src"><xsl:value-of
                    select="concat( $reldir, '1x1.png' )"
                /></xsl:attribute
                ><xsl:attribute name="width"><xsl:value-of
                    select="ceiling((@percentcovered * $BarWidth) div 100)"
                /></xsl:attribute></img>
            </td></xsl:if><xsl:if test="@percentcovered &lt; 100">
            <td>
                <xsl:choose>
                    <xsl:when test="@percentcovered &lt;= 0">
                        <xsl:attribute name="CLASS">bfailall</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="CLASS">bfail</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
                <img CLASS="bimg">
                <xsl:attribute name="src"><xsl:value-of
                    select="concat( $reldir, '1x1.png' )"
                /></xsl:attribute
                ><xsl:attribute name="width"><xsl:value-of
                    select="$BarWidth - ceiling((@percentcovered * $BarWidth) div 100)"
                /></xsl:attribute></img>
            </td></xsl:if></tr></table>
        </td>
    </xsl:template>
</xsl:stylesheet>
