#ifndef __LONGLINENOTE_H__
#define __LONGLINENOTE_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 *
 * October 1993
 *
 * Goes along with my indexing routines.
 *
 * Due to complications with the way the text file is kept in memory,
 * the length of some longer lines needs to be remembered.
 * This is just a list of structs giving a line->length mapping.
 */
#define longlinenote_version 100 /* 1.00 */
#include "xmalloc.h"

#if !defined(__GNUC__)
#  if !defined(__volatile__)
#    define __volatile__ /*nothing; for use with volatile functions */
#  endif
#  if !defined(__inline__)
#    define __inline__ /*nothing; for use with volatile functions */
#  endif
#endif

struct long_line_note
{
    struct long_line_note *next;  /* info about the next line */
    const unsigned char *line;    /* the line in question */
    unsigned len;                 /* the length of the line */
};

/*
 * Record that LINE has length LEN. Simple stuff.
 */
static __inline__ void
note_long_line(struct long_line_note **listptr,
	       const unsigned char *line,
	       unsigned len)
{
    struct long_line_note *oldnext;
    oldnext = (*listptr);
    (*listptr) = xmalloc(sizeof(struct long_line_note));
    (*listptr)->next = oldnext;
    (*listptr)->line = line;
    (*listptr)->len  = len;
}

/*
 * Return the length of LINE, as per our line notes.
 * It's a fatal error to not have the line in our list.
 */
static __inline__ unsigned
get_long_line_note(struct long_line_note *list, const unsigned char *line)
{
   /*
     * We assume that the lines are in larger-address-first order,
     * so if we skip only records for lines with a larger address than
     * us, either finding our line exactly then, or dying if not.
     */
    while (list && list->line > line)
	list = list->next;

    if (list && list->line == line)
	return list->len;
    assert(0);
    return 0; /* to quite "no return from non-void" warnings */
}

#undef __inline__
#endif /* file wrapper */
