#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/soundcard.h>
#include "wav_lib.h"


void init_head(wav_sig *info){
	strcpy(info->head, "RIFF    WAVEfmt                     data    ");
	*(long  *)&info->head[4]  = (info->sofar + 32);
	*(long  *)&info->head[16] = 16;
	*(short *)&info->head[20] = 1;
	*(short *)&info->head[22] = info->chans;
	*(long  *)&info->head[24] = info->srate;
	*(long  *)&info->head[28] = info->bps;
	*(short *)&info->head[32] = info->blkalign;
	*(short *)&info->head[34] = info->depth;
	*(long  *)&info->head[40] = info->sofar;
}

int open_wav_rec(wav_sig *info){
	info->handle = open(info->name, O_CREAT | O_RDWR, 0644);
	init_head(info);
	write(info->handle, info->head, 44);
	return(info->handle);
}

int rewrite_head(wav_sig *info){
	lseek(info->handle, 0, SEEK_SET);
	init_head(info);
	write(info->handle, info->head, 44);
}