/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.format;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.format.Formatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatter
implements Formatter<Date> {
    protected static final Map<String, Integer> namedPatterns = new HashMap<String, Integer>();
    private String formatType;
    private String formatPattern;
    private Locale locale;
    private DateFormat format;

    @Override
    public void setFormatType(String formatType) {
        this.formatType = formatType;
    }

    public String getFormatType() {
        return this.formatType;
    }

    @Override
    public void setFormatPattern(String formatPattern) {
        this.formatPattern = formatPattern;
    }

    public String getFormatPattern() {
        return this.formatPattern;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init() {
        if (this.formatPattern == null) {
            this.formatPattern = "short";
        }
        if (this.formatType == null) {
            this.formatType = "date";
        }
        String lcFormatString = this.formatPattern.toLowerCase();
        String lcFormatType = this.formatType.toLowerCase();
        if (namedPatterns.containsKey(lcFormatString)) {
            if (lcFormatType.equals("date")) {
                this.format = DateFormat.getDateInstance(namedPatterns.get(lcFormatString), this.locale);
                return;
            } else if (lcFormatType.equals("datetime")) {
                this.format = DateFormat.getDateTimeInstance(namedPatterns.get(lcFormatString), namedPatterns.get(lcFormatString), this.locale);
                return;
            } else {
                if (!lcFormatType.equals("time")) throw new StripesRuntimeException("Invalid formatType for Date: " + this.formatType + ". Allowed types are 'date', 'time' and 'datetime'.");
                this.format = DateFormat.getTimeInstance(namedPatterns.get(lcFormatString), this.locale);
            }
            return;
        } else {
            this.format = new SimpleDateFormat(this.formatPattern, this.locale);
        }
    }

    @Override
    public String format(Date input) {
        return this.format.format(input);
    }

    static {
        namedPatterns.put("short", 3);
        namedPatterns.put("medium", 2);
        namedPatterns.put("long", 1);
        namedPatterns.put("full", 0);
    }
}

