/***************************************************************************
 *   Copyright (C) 2003-2007 by Spiros Georgaras <sng@hellug.gr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef DIRSDATA_H
#define DIRSDATA_H
#include <qdir.h>
#include <qregexp.h>
#include <filesdata.h>

/**
  *@author Spiros Georgaras
  */

class dirsData : public filesData  {
	public:
		struct filePart{
			QString pref;
			QString suf;
			int digitNum;
			QString ext;
			int partType;	//0: number only, 1: pref + number, 2: number +suffix, 3: all
		}fPart;

		struct newFile{
			QString oldFileName;
			QString oldName;
			QString oldExtension;
			QString newFileName;
			QString newTmpFileName;
			QString newName;
			QString newTmpName;
			QString Counter;
			QString newExtension;
			QString Suffix;
			QString newSuffix;
			QString Prefix;
			int iconID;
			int inc;
			int randomNum;
			bool selected;
			bool isDir;
		};
  
		dirsData();
		~dirsData();
// 		void setPath(QString path,const QString &nameFilter,int filterSpec);
		void setPath(QString path,const QString &nameFilter,QDir::Filters filterSpec);
		QString path(void);
// 		void setFilter(int filterSpec);
		void setFilter(QDir::Filters filterSpec);
		int filter(void);
		newFile * ren;
		int setLink(filesData * b);
		int setFilesInDir(bool select);
		void resetFileName(int k);
		int numOfDigits;
		int getSorted(int i);
		int setSortValue(bool state);
		void resetHasbeenSorted();
		int numOfSlectedItems();
	private:
		QString mPath;
		int mFilter;
		QString mNameFilter;
		int * sort;
		bool sortID;
		bool hasBeenSorted;
};

#endif
