/* soapC.cpp
   Generated by gSOAP 2.8.8 from GeoIPService.h

Copyright(C) 2000-2012, Robert van Engelen, Genivia Inc. All Rights Reserved.
The generated code is released under one of the following licenses:
1) GPL or 2) Genivia's license for commercial use.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.8 2012-05-24 21:00:32 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap, -1)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if (soap->error || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_std__string:
		return soap_in_std__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ns1__GeoIP:
		return soap_in_ns1__GeoIP(soap, NULL, NULL, "ns1:GeoIP");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPContextResponse:
		return soap_in_PointerTo_ns1__GetGeoIPContextResponse(soap, NULL, NULL, "ns1:GetGeoIPContextResponse");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPContext:
		return soap_in_PointerTo_ns1__GetGeoIPContext(soap, NULL, NULL, "ns1:GetGeoIPContext");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPResponse:
		return soap_in_PointerTo_ns1__GetGeoIPResponse(soap, NULL, NULL, "ns1:GetGeoIPResponse");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIP:
		return soap_in_PointerTo_ns1__GetGeoIP(soap, NULL, NULL, "ns1:GetGeoIP");
	case SOAP_TYPE_PointerTons1__GeoIP:
		return soap_in_PointerTons1__GeoIP(soap, NULL, NULL, "ns1:GeoIP");
	case SOAP_TYPE_PointerTostd__string:
		return soap_in_PointerTostd__string(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	*type = SOAP_TYPE_std__string;
			return soap_in_std__string(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:GeoIP"))
		{	*type = SOAP_TYPE_ns1__GeoIP;
			return soap_in_ns1__GeoIP(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "ns1:GetGeoIPContextResponse"))
		{	*type = SOAP_TYPE__ns1__GetGeoIPContextResponse;
			return soap_in__ns1__GetGeoIPContextResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:GetGeoIPContext"))
		{	*type = SOAP_TYPE__ns1__GetGeoIPContext;
			return soap_in__ns1__GetGeoIPContext(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:GetGeoIPResponse"))
		{	*type = SOAP_TYPE__ns1__GetGeoIPResponse;
			return soap_in__ns1__GetGeoIPResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:GetGeoIP"))
		{	*type = SOAP_TYPE__ns1__GetGeoIP;
			return soap_in__ns1__GetGeoIP(soap, NULL, NULL, NULL);
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_std__string:
		return soap_out_std__string(soap, tag, id, (const std::string *)ptr, "xsd:string");
	case SOAP_TYPE__ns1__GetGeoIPContextResponse:
		return ((_ns1__GetGeoIPContextResponse *)ptr)->soap_out(soap, "ns1:GetGeoIPContextResponse", id, NULL);
	case SOAP_TYPE__ns1__GetGeoIPContext:
		return ((_ns1__GetGeoIPContext *)ptr)->soap_out(soap, "ns1:GetGeoIPContext", id, NULL);
	case SOAP_TYPE__ns1__GetGeoIPResponse:
		return ((_ns1__GetGeoIPResponse *)ptr)->soap_out(soap, "ns1:GetGeoIPResponse", id, NULL);
	case SOAP_TYPE__ns1__GetGeoIP:
		return ((_ns1__GetGeoIP *)ptr)->soap_out(soap, "ns1:GetGeoIP", id, NULL);
	case SOAP_TYPE_ns1__GeoIP:
		return ((ns1__GeoIP *)ptr)->soap_out(soap, tag, id, "ns1:GeoIP");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPContextResponse:
		return soap_out_PointerTo_ns1__GetGeoIPContextResponse(soap, tag, id, (_ns1__GetGeoIPContextResponse *const*)ptr, "ns1:GetGeoIPContextResponse");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPContext:
		return soap_out_PointerTo_ns1__GetGeoIPContext(soap, tag, id, (_ns1__GetGeoIPContext *const*)ptr, "ns1:GetGeoIPContext");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPResponse:
		return soap_out_PointerTo_ns1__GetGeoIPResponse(soap, tag, id, (_ns1__GetGeoIPResponse *const*)ptr, "ns1:GetGeoIPResponse");
	case SOAP_TYPE_PointerTo_ns1__GetGeoIP:
		return soap_out_PointerTo_ns1__GetGeoIP(soap, tag, id, (_ns1__GetGeoIP *const*)ptr, "ns1:GetGeoIP");
	case SOAP_TYPE_PointerTons1__GeoIP:
		return soap_out_PointerTons1__GeoIP(soap, tag, id, (ns1__GeoIP *const*)ptr, "ns1:GeoIP");
	case SOAP_TYPE_PointerTostd__string:
		return soap_out_PointerTostd__string(soap, tag, id, (std::string *const*)ptr, "xsd:string");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE_std__string:
		soap_serialize_std__string(soap, (const std::string *)ptr);
		break;
	case SOAP_TYPE__ns1__GetGeoIPContextResponse:
		((_ns1__GetGeoIPContextResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__GetGeoIPContext:
		((_ns1__GetGeoIPContext *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__GetGeoIPResponse:
		((_ns1__GetGeoIPResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__GetGeoIP:
		((_ns1__GetGeoIP *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns1__GeoIP:
		((ns1__GeoIP *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___ns3__GetGeoIPContext:
		soap_serialize___ns3__GetGeoIPContext(soap, (const struct __ns3__GetGeoIPContext *)ptr);
		break;
	case SOAP_TYPE___ns3__GetGeoIP:
		soap_serialize___ns3__GetGeoIP(soap, (const struct __ns3__GetGeoIP *)ptr);
		break;
	case SOAP_TYPE___ns2__GetGeoIPContext:
		soap_serialize___ns2__GetGeoIPContext(soap, (const struct __ns2__GetGeoIPContext *)ptr);
		break;
	case SOAP_TYPE___ns2__GetGeoIP:
		soap_serialize___ns2__GetGeoIP(soap, (const struct __ns2__GetGeoIP *)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPContextResponse:
		soap_serialize_PointerTo_ns1__GetGeoIPContextResponse(soap, (_ns1__GetGeoIPContextResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPContext:
		soap_serialize_PointerTo_ns1__GetGeoIPContext(soap, (_ns1__GetGeoIPContext *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__GetGeoIPResponse:
		soap_serialize_PointerTo_ns1__GetGeoIPResponse(soap, (_ns1__GetGeoIPResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__GetGeoIP:
		soap_serialize_PointerTo_ns1__GetGeoIP(soap, (_ns1__GetGeoIP *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__GeoIP:
		soap_serialize_PointerTons1__GeoIP(soap, (ns1__GeoIP *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostd__string:
		soap_serialize_PointerTostd__string(soap, (std::string *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{	(void)type;
	switch (t)
	{
	case SOAP_TYPE_std__string:
		return (void*)soap_instantiate_std__string(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns1__GeoIP:
		return (void*)soap_instantiate_ns1__GeoIP(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__GetGeoIP:
		return (void*)soap_instantiate__ns1__GetGeoIP(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__GetGeoIPResponse:
		return (void*)soap_instantiate__ns1__GetGeoIPResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__GetGeoIPContext:
		return (void*)soap_instantiate__ns1__GetGeoIPContext(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__GetGeoIPContextResponse:
		return (void*)soap_instantiate__ns1__GetGeoIPContextResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns2__GetGeoIP:
		return (void*)soap_instantiate___ns2__GetGeoIP(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns2__GetGeoIPContext:
		return (void*)soap_instantiate___ns2__GetGeoIPContext(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns3__GetGeoIP:
		return (void*)soap_instantiate___ns3__GetGeoIP(soap, -1, type, arrayType, n);
	case SOAP_TYPE___ns3__GetGeoIPContext:
		return (void*)soap_instantiate___ns3__GetGeoIPContext(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_std__string:
		if (p->size < 0)
			SOAP_DELETE((std::string*)p->ptr);
		else
			SOAP_DELETE_ARRAY((std::string*)p->ptr);
		break;
	case SOAP_TYPE_ns1__GeoIP:
		if (p->size < 0)
			SOAP_DELETE((ns1__GeoIP*)p->ptr);
		else
			SOAP_DELETE_ARRAY((ns1__GeoIP*)p->ptr);
		break;
	case SOAP_TYPE__ns1__GetGeoIP:
		if (p->size < 0)
			SOAP_DELETE((_ns1__GetGeoIP*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__GetGeoIP*)p->ptr);
		break;
	case SOAP_TYPE__ns1__GetGeoIPResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__GetGeoIPResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__GetGeoIPResponse*)p->ptr);
		break;
	case SOAP_TYPE__ns1__GetGeoIPContext:
		if (p->size < 0)
			SOAP_DELETE((_ns1__GetGeoIPContext*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__GetGeoIPContext*)p->ptr);
		break;
	case SOAP_TYPE__ns1__GetGeoIPContextResponse:
		if (p->size < 0)
			SOAP_DELETE((_ns1__GetGeoIPContextResponse*)p->ptr);
		else
			SOAP_DELETE_ARRAY((_ns1__GetGeoIPContextResponse*)p->ptr);
		break;
	case SOAP_TYPE___ns2__GetGeoIP:
		if (p->size < 0)
			SOAP_DELETE((struct __ns2__GetGeoIP*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns2__GetGeoIP*)p->ptr);
		break;
	case SOAP_TYPE___ns2__GetGeoIPContext:
		if (p->size < 0)
			SOAP_DELETE((struct __ns2__GetGeoIPContext*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns2__GetGeoIPContext*)p->ptr);
		break;
	case SOAP_TYPE___ns3__GetGeoIP:
		if (p->size < 0)
			SOAP_DELETE((struct __ns3__GetGeoIP*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns3__GetGeoIP*)p->ptr);
		break;
	case SOAP_TYPE___ns3__GetGeoIPContext:
		if (p->size < 0)
			SOAP_DELETE((struct __ns3__GetGeoIPContext*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct __ns3__GetGeoIPContext*)p->ptr);
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Header*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Header*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Code*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Code*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Detail*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Detail*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Reason*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Reason*)p->ptr);
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE((struct SOAP_ENV__Fault*)p->ptr);
		else
			SOAP_DELETE_ARRAY((struct SOAP_ENV__Fault*)p->ptr);
		break;
#endif
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_container_id_forward(struct soap *soap, const char *href, void *p, size_t len, int st, int tt, size_t n, unsigned int k)
{	return soap_id_forward(soap, href, p, len, st, tt, n, k, soap_container_insert);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_container_insert(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
#ifdef WIN32
#pragma warning(push)
#pragma warning(disable:4065)
#endif
{
	(void)soap; (void)st; (void)p; (void)len; (void)q; (void)n; /* appease -Wall -Werror */
	switch (tt)
	{
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type=%d in %d\n", st, tt));
	}
#ifdef WIN32
#pragma warning(pop)
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{	(void)soap; (void)type; (void)tag; (void)id;
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_std__string(struct soap *soap, std::string *p)
{
	(void)soap; /* appease -Wall -Werror */
	p->erase();
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_std__string(struct soap *soap, const std::string *a)
{	(void)soap; (void)a; /* appease -Wall -Werror */
}
SOAP_FMAC3 int SOAP_FMAC4 soap_out_std__string(struct soap *soap, const char *tag, int id, const std::string *s, const char *type)
{
	if ((soap->mode & SOAP_C_NILSTRING) && s->empty())
		return soap_element_null(soap, tag, id, type);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, s, SOAP_TYPE_std__string), type) || soap_string_out(soap, s->c_str(), 0) || soap_element_end_out(soap, tag))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_in_std__string(struct soap *soap, const char *tag, std::string *s, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!s)
		s = soap_new_std__string(soap, -1);
	if (soap->null)
		if (s)
			s->erase();
	if (soap->body && !*soap->href)
	{	char *t;
		s = (std::string*)soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType);
		if (s)
		{	if (!(t = soap_string_in(soap, 1, 0, -1)))
				return NULL;
			s->assign(t);
		}
	}
	else
		s = (std::string*)soap_id_forward(soap, soap->href, soap_class_id_enter(soap, soap->id, s, SOAP_TYPE_std__string, sizeof(std::string), soap->type, soap->arrayType), 0, SOAP_TYPE_std__string, 0, sizeof(std::string), 0, soap_copy_std__string);
	if (soap->body && soap_element_end_in(soap, tag))
		return NULL;
	return s;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_std__string(struct soap *soap, const std::string *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_std__string);
	if (soap_out_std__string(soap, tag?tag:"string", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 std::string * SOAP_FMAC4 soap_get_std__string(struct soap *soap, std::string *p, const char *tag, const char *type)
{
	if ((p = soap_in_std__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 std::string * SOAP_FMAC2 soap_instantiate_std__string(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_std__string(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_std__string, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(std::string);
		if (size)
			*size = sizeof(std::string);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(std::string[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(std::string);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (std::string*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_std__string(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying std::string %p -> %p\n", q, p));
	*(std::string*)p = *(std::string*)q;
}

void _ns1__GetGeoIPContextResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__GetGeoIPContextResponse::GetGeoIPContextResult = NULL;
	/* transient soap skipped */
}

void _ns1__GetGeoIPContextResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__GeoIP(soap, &this->_ns1__GetGeoIPContextResponse::GetGeoIPContextResult);
	/* transient soap skipped */
}

int _ns1__GetGeoIPContextResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__GetGeoIPContextResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__GetGeoIPContextResponse(struct soap *soap, const char *tag, int id, const _ns1__GetGeoIPContextResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__GetGeoIPContextResponse), type))
		return soap->error;
	if (a->GetGeoIPContextResult)
		soap_element_result(soap, "ns1:GetGeoIPContextResult");
	if (soap_out_PointerTons1__GeoIP(soap, "ns1:GetGeoIPContextResult", -1, &(a->_ns1__GetGeoIPContextResponse::GetGeoIPContextResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__GetGeoIPContextResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__GetGeoIPContextResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__GetGeoIPContextResponse * SOAP_FMAC4 soap_in__ns1__GetGeoIPContextResponse(struct soap *soap, const char *tag, _ns1__GetGeoIPContextResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__GetGeoIPContextResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__GetGeoIPContextResponse, sizeof(_ns1__GetGeoIPContextResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__GetGeoIPContextResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__GetGeoIPContextResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_GetGeoIPContextResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetGeoIPContextResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__GeoIP(soap, "ns1:GetGeoIPContextResult", &(a->_ns1__GetGeoIPContextResponse::GetGeoIPContextResult), "ns1:GeoIP"))
				{	soap_flag_GetGeoIPContextResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "ns1:GetGeoIPContextResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__GetGeoIPContextResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__GetGeoIPContextResponse, 0, sizeof(_ns1__GetGeoIPContextResponse), 0, soap_copy__ns1__GetGeoIPContextResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__GetGeoIPContextResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__GetGeoIPContextResponse);
	if (this->soap_out(soap, tag?tag:"ns1:GetGeoIPContextResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__GetGeoIPContextResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__GetGeoIPContextResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__GetGeoIPContextResponse * SOAP_FMAC4 soap_get__ns1__GetGeoIPContextResponse(struct soap *soap, _ns1__GetGeoIPContextResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__GetGeoIPContextResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__GetGeoIPContextResponse * SOAP_FMAC2 soap_instantiate__ns1__GetGeoIPContextResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__GetGeoIPContextResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__GetGeoIPContextResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIPContextResponse);
		if (size)
			*size = sizeof(_ns1__GetGeoIPContextResponse);
		((_ns1__GetGeoIPContextResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIPContextResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__GetGeoIPContextResponse);
		for (int i = 0; i < n; i++)
			((_ns1__GetGeoIPContextResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__GetGeoIPContextResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__GetGeoIPContextResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__GetGeoIPContextResponse %p -> %p\n", q, p));
	*(_ns1__GetGeoIPContextResponse*)p = *(_ns1__GetGeoIPContextResponse*)q;
}

void _ns1__GetGeoIPContext::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void _ns1__GetGeoIPContext::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int _ns1__GetGeoIPContext::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__GetGeoIPContext(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__GetGeoIPContext(struct soap *soap, const char *tag, int id, const _ns1__GetGeoIPContext *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__GetGeoIPContext), type))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__GetGeoIPContext::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__GetGeoIPContext(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__GetGeoIPContext * SOAP_FMAC4 soap_in__ns1__GetGeoIPContext(struct soap *soap, const char *tag, _ns1__GetGeoIPContext *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__GetGeoIPContext *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__GetGeoIPContext, sizeof(_ns1__GetGeoIPContext), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__GetGeoIPContext)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__GetGeoIPContext *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__GetGeoIPContext *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__GetGeoIPContext, 0, sizeof(_ns1__GetGeoIPContext), 0, soap_copy__ns1__GetGeoIPContext);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__GetGeoIPContext::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__GetGeoIPContext);
	if (this->soap_out(soap, tag?tag:"ns1:GetGeoIPContext", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__GetGeoIPContext::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__GetGeoIPContext(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__GetGeoIPContext * SOAP_FMAC4 soap_get__ns1__GetGeoIPContext(struct soap *soap, _ns1__GetGeoIPContext *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__GetGeoIPContext(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__GetGeoIPContext * SOAP_FMAC2 soap_instantiate__ns1__GetGeoIPContext(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__GetGeoIPContext(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__GetGeoIPContext, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIPContext);
		if (size)
			*size = sizeof(_ns1__GetGeoIPContext);
		((_ns1__GetGeoIPContext*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIPContext[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__GetGeoIPContext);
		for (int i = 0; i < n; i++)
			((_ns1__GetGeoIPContext*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__GetGeoIPContext*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__GetGeoIPContext(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__GetGeoIPContext %p -> %p\n", q, p));
	*(_ns1__GetGeoIPContext*)p = *(_ns1__GetGeoIPContext*)q;
}

void _ns1__GetGeoIPResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__GetGeoIPResponse::GetGeoIPResult = NULL;
	/* transient soap skipped */
}

void _ns1__GetGeoIPResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__GeoIP(soap, &this->_ns1__GetGeoIPResponse::GetGeoIPResult);
	/* transient soap skipped */
}

int _ns1__GetGeoIPResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__GetGeoIPResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__GetGeoIPResponse(struct soap *soap, const char *tag, int id, const _ns1__GetGeoIPResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__GetGeoIPResponse), type))
		return soap->error;
	if (a->GetGeoIPResult)
		soap_element_result(soap, "ns1:GetGeoIPResult");
	if (soap_out_PointerTons1__GeoIP(soap, "ns1:GetGeoIPResult", -1, &(a->_ns1__GetGeoIPResponse::GetGeoIPResult), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__GetGeoIPResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__GetGeoIPResponse(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__GetGeoIPResponse * SOAP_FMAC4 soap_in__ns1__GetGeoIPResponse(struct soap *soap, const char *tag, _ns1__GetGeoIPResponse *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__GetGeoIPResponse *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__GetGeoIPResponse, sizeof(_ns1__GetGeoIPResponse), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__GetGeoIPResponse)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__GetGeoIPResponse *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_GetGeoIPResult1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_GetGeoIPResult1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__GeoIP(soap, "ns1:GetGeoIPResult", &(a->_ns1__GetGeoIPResponse::GetGeoIPResult), "ns1:GeoIP"))
				{	soap_flag_GetGeoIPResult1--;
					continue;
				}
			/* transient soap skipped */
			soap_check_result(soap, "ns1:GetGeoIPResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__GetGeoIPResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__GetGeoIPResponse, 0, sizeof(_ns1__GetGeoIPResponse), 0, soap_copy__ns1__GetGeoIPResponse);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__GetGeoIPResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__GetGeoIPResponse);
	if (this->soap_out(soap, tag?tag:"ns1:GetGeoIPResponse", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__GetGeoIPResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__GetGeoIPResponse(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__GetGeoIPResponse * SOAP_FMAC4 soap_get__ns1__GetGeoIPResponse(struct soap *soap, _ns1__GetGeoIPResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__GetGeoIPResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__GetGeoIPResponse * SOAP_FMAC2 soap_instantiate__ns1__GetGeoIPResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__GetGeoIPResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__GetGeoIPResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIPResponse);
		if (size)
			*size = sizeof(_ns1__GetGeoIPResponse);
		((_ns1__GetGeoIPResponse*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIPResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__GetGeoIPResponse);
		for (int i = 0; i < n; i++)
			((_ns1__GetGeoIPResponse*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__GetGeoIPResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__GetGeoIPResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__GetGeoIPResponse %p -> %p\n", q, p));
	*(_ns1__GetGeoIPResponse*)p = *(_ns1__GetGeoIPResponse*)q;
}

void _ns1__GetGeoIP::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__GetGeoIP::IPAddress = NULL;
	/* transient soap skipped */
}

void _ns1__GetGeoIP::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &this->_ns1__GetGeoIP::IPAddress);
	/* transient soap skipped */
}

int _ns1__GetGeoIP::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__GetGeoIP(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__GetGeoIP(struct soap *soap, const char *tag, int id, const _ns1__GetGeoIP *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__GetGeoIP), type))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns1:IPAddress", -1, &(a->_ns1__GetGeoIP::IPAddress), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__GetGeoIP::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__GetGeoIP(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__GetGeoIP * SOAP_FMAC4 soap_in__ns1__GetGeoIP(struct soap *soap, const char *tag, _ns1__GetGeoIP *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__GetGeoIP *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__GetGeoIP, sizeof(_ns1__GetGeoIP), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__GetGeoIP)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__GetGeoIP *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_IPAddress1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_IPAddress1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns1:IPAddress", &(a->_ns1__GetGeoIP::IPAddress), "xsd:string"))
				{	soap_flag_IPAddress1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__GetGeoIP *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__GetGeoIP, 0, sizeof(_ns1__GetGeoIP), 0, soap_copy__ns1__GetGeoIP);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__GetGeoIP::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__GetGeoIP);
	if (this->soap_out(soap, tag?tag:"ns1:GetGeoIP", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__GetGeoIP::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__GetGeoIP(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__GetGeoIP * SOAP_FMAC4 soap_get__ns1__GetGeoIP(struct soap *soap, _ns1__GetGeoIP *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__GetGeoIP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__GetGeoIP * SOAP_FMAC2 soap_instantiate__ns1__GetGeoIP(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__GetGeoIP(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__GetGeoIP, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIP);
		if (size)
			*size = sizeof(_ns1__GetGeoIP);
		((_ns1__GetGeoIP*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(_ns1__GetGeoIP[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__GetGeoIP);
		for (int i = 0; i < n; i++)
			((_ns1__GetGeoIP*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__GetGeoIP*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__GetGeoIP(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__GetGeoIP %p -> %p\n", q, p));
	*(_ns1__GetGeoIP*)p = *(_ns1__GetGeoIP*)q;
}

void ns1__GeoIP::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_int(soap, &this->ns1__GeoIP::ReturnCode);
	this->ns1__GeoIP::IP = NULL;
	this->ns1__GeoIP::ReturnCodeDetails = NULL;
	this->ns1__GeoIP::CountryName = NULL;
	this->ns1__GeoIP::CountryCode = NULL;
	/* transient soap skipped */
}

void ns1__GeoIP::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTostd__string(soap, &this->ns1__GeoIP::IP);
	soap_serialize_PointerTostd__string(soap, &this->ns1__GeoIP::ReturnCodeDetails);
	soap_serialize_PointerTostd__string(soap, &this->ns1__GeoIP::CountryName);
	soap_serialize_PointerTostd__string(soap, &this->ns1__GeoIP::CountryCode);
	/* transient soap skipped */
}

int ns1__GeoIP::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns1__GeoIP(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__GeoIP(struct soap *soap, const char *tag, int id, const ns1__GeoIP *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__GeoIP), type))
		return soap->error;
	if (soap_out_int(soap, "ns1:ReturnCode", -1, &(a->ns1__GeoIP::ReturnCode), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns1:IP", -1, &(a->ns1__GeoIP::IP), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns1:ReturnCodeDetails", -1, &(a->ns1__GeoIP::ReturnCodeDetails), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns1:CountryName", -1, &(a->ns1__GeoIP::CountryName), ""))
		return soap->error;
	if (soap_out_PointerTostd__string(soap, "ns1:CountryCode", -1, &(a->ns1__GeoIP::CountryCode), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns1__GeoIP::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns1__GeoIP(soap, tag, this, type);
}

SOAP_FMAC3 ns1__GeoIP * SOAP_FMAC4 soap_in_ns1__GeoIP(struct soap *soap, const char *tag, ns1__GeoIP *a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns1__GeoIP *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__GeoIP, sizeof(ns1__GeoIP), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns1__GeoIP)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns1__GeoIP *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_ReturnCode1 = 1;
	size_t soap_flag_IP1 = 1;
	size_t soap_flag_ReturnCodeDetails1 = 1;
	size_t soap_flag_CountryName1 = 1;
	size_t soap_flag_CountryCode1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ReturnCode1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:ReturnCode", &(a->ns1__GeoIP::ReturnCode), "xsd:int"))
				{	soap_flag_ReturnCode1--;
					continue;
				}
			if (soap_flag_IP1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns1:IP", &(a->ns1__GeoIP::IP), "xsd:string"))
				{	soap_flag_IP1--;
					continue;
				}
			if (soap_flag_ReturnCodeDetails1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns1:ReturnCodeDetails", &(a->ns1__GeoIP::ReturnCodeDetails), "xsd:string"))
				{	soap_flag_ReturnCodeDetails1--;
					continue;
				}
			if (soap_flag_CountryName1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns1:CountryName", &(a->ns1__GeoIP::CountryName), "xsd:string"))
				{	soap_flag_CountryName1--;
					continue;
				}
			if (soap_flag_CountryCode1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_PointerTostd__string(soap, "ns1:CountryCode", &(a->ns1__GeoIP::CountryCode), "xsd:string"))
				{	soap_flag_CountryCode1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns1__GeoIP *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__GeoIP, 0, sizeof(ns1__GeoIP), 0, soap_copy_ns1__GeoIP);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_ReturnCode1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns1__GeoIP::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns1__GeoIP);
	if (this->soap_out(soap, tag?tag:"ns1:GeoIP", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns1__GeoIP::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns1__GeoIP(soap, this, tag, type);
}

SOAP_FMAC3 ns1__GeoIP * SOAP_FMAC4 soap_get_ns1__GeoIP(struct soap *soap, ns1__GeoIP *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__GeoIP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns1__GeoIP * SOAP_FMAC2 soap_instantiate_ns1__GeoIP(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns1__GeoIP(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns1__GeoIP, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(ns1__GeoIP);
		if (size)
			*size = sizeof(ns1__GeoIP);
		((ns1__GeoIP*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(ns1__GeoIP[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns1__GeoIP);
		for (int i = 0; i < n; i++)
			((ns1__GeoIP*)cp->ptr)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns1__GeoIP*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns1__GeoIP(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns1__GeoIP %p -> %p\n", q, p));
	*(ns1__GeoIP*)p = *(ns1__GeoIP*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault);
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Fault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason);
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Reason[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", &a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail);
		if (size)
			*size = sizeof(struct SOAP_ENV__Detail);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Detail[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Detail);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Detail*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Detail(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Detail %p -> %p\n", q, p));
	*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code);
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Code[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header);
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct SOAP_ENV__Header[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns3__GetGeoIPContext(struct soap *soap, struct __ns3__GetGeoIPContext *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__GetGeoIPContext = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns3__GetGeoIPContext(struct soap *soap, const struct __ns3__GetGeoIPContext *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__GetGeoIPContext(soap, &a->ns1__GetGeoIPContext);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns3__GetGeoIPContext(struct soap *soap, const char *tag, int id, const struct __ns3__GetGeoIPContext *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__GetGeoIPContext(soap, "ns1:GetGeoIPContext", -1, &a->ns1__GetGeoIPContext, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__GetGeoIPContext * SOAP_FMAC4 soap_in___ns3__GetGeoIPContext(struct soap *soap, const char *tag, struct __ns3__GetGeoIPContext *a, const char *type)
{
	size_t soap_flag_ns1__GetGeoIPContext = 1;
	short soap_flag;
	a = (struct __ns3__GetGeoIPContext *)soap_id_enter(soap, "", a, SOAP_TYPE___ns3__GetGeoIPContext, sizeof(struct __ns3__GetGeoIPContext), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns3__GetGeoIPContext(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__GetGeoIPContext && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__GetGeoIPContext(soap, "ns1:GetGeoIPContext", &a->ns1__GetGeoIPContext, ""))
				{	soap_flag_ns1__GetGeoIPContext--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns3__GetGeoIPContext(struct soap *soap, const struct __ns3__GetGeoIPContext *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns3__GetGeoIPContext(soap, tag?tag:"-ns3:GetGeoIPContext", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__GetGeoIPContext * SOAP_FMAC4 soap_get___ns3__GetGeoIPContext(struct soap *soap, struct __ns3__GetGeoIPContext *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns3__GetGeoIPContext(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns3__GetGeoIPContext * SOAP_FMAC2 soap_instantiate___ns3__GetGeoIPContext(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns3__GetGeoIPContext(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns3__GetGeoIPContext, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns3__GetGeoIPContext);
		if (size)
			*size = sizeof(struct __ns3__GetGeoIPContext);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns3__GetGeoIPContext[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns3__GetGeoIPContext);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns3__GetGeoIPContext*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns3__GetGeoIPContext(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns3__GetGeoIPContext %p -> %p\n", q, p));
	*(struct __ns3__GetGeoIPContext*)p = *(struct __ns3__GetGeoIPContext*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns3__GetGeoIP(struct soap *soap, struct __ns3__GetGeoIP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__GetGeoIP = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns3__GetGeoIP(struct soap *soap, const struct __ns3__GetGeoIP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__GetGeoIP(soap, &a->ns1__GetGeoIP);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns3__GetGeoIP(struct soap *soap, const char *tag, int id, const struct __ns3__GetGeoIP *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__GetGeoIP(soap, "ns1:GetGeoIP", -1, &a->ns1__GetGeoIP, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__GetGeoIP * SOAP_FMAC4 soap_in___ns3__GetGeoIP(struct soap *soap, const char *tag, struct __ns3__GetGeoIP *a, const char *type)
{
	size_t soap_flag_ns1__GetGeoIP = 1;
	short soap_flag;
	a = (struct __ns3__GetGeoIP *)soap_id_enter(soap, "", a, SOAP_TYPE___ns3__GetGeoIP, sizeof(struct __ns3__GetGeoIP), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns3__GetGeoIP(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__GetGeoIP && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__GetGeoIP(soap, "ns1:GetGeoIP", &a->ns1__GetGeoIP, ""))
				{	soap_flag_ns1__GetGeoIP--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns3__GetGeoIP(struct soap *soap, const struct __ns3__GetGeoIP *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns3__GetGeoIP(soap, tag?tag:"-ns3:GetGeoIP", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns3__GetGeoIP * SOAP_FMAC4 soap_get___ns3__GetGeoIP(struct soap *soap, struct __ns3__GetGeoIP *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns3__GetGeoIP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns3__GetGeoIP * SOAP_FMAC2 soap_instantiate___ns3__GetGeoIP(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns3__GetGeoIP(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns3__GetGeoIP, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns3__GetGeoIP);
		if (size)
			*size = sizeof(struct __ns3__GetGeoIP);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns3__GetGeoIP[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns3__GetGeoIP);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns3__GetGeoIP*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns3__GetGeoIP(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns3__GetGeoIP %p -> %p\n", q, p));
	*(struct __ns3__GetGeoIP*)p = *(struct __ns3__GetGeoIP*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns2__GetGeoIPContext(struct soap *soap, struct __ns2__GetGeoIPContext *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__GetGeoIPContext = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns2__GetGeoIPContext(struct soap *soap, const struct __ns2__GetGeoIPContext *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__GetGeoIPContext(soap, &a->ns1__GetGeoIPContext);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns2__GetGeoIPContext(struct soap *soap, const char *tag, int id, const struct __ns2__GetGeoIPContext *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__GetGeoIPContext(soap, "ns1:GetGeoIPContext", -1, &a->ns1__GetGeoIPContext, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns2__GetGeoIPContext * SOAP_FMAC4 soap_in___ns2__GetGeoIPContext(struct soap *soap, const char *tag, struct __ns2__GetGeoIPContext *a, const char *type)
{
	size_t soap_flag_ns1__GetGeoIPContext = 1;
	short soap_flag;
	a = (struct __ns2__GetGeoIPContext *)soap_id_enter(soap, "", a, SOAP_TYPE___ns2__GetGeoIPContext, sizeof(struct __ns2__GetGeoIPContext), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns2__GetGeoIPContext(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__GetGeoIPContext && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__GetGeoIPContext(soap, "ns1:GetGeoIPContext", &a->ns1__GetGeoIPContext, ""))
				{	soap_flag_ns1__GetGeoIPContext--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns2__GetGeoIPContext(struct soap *soap, const struct __ns2__GetGeoIPContext *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns2__GetGeoIPContext(soap, tag?tag:"-ns2:GetGeoIPContext", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns2__GetGeoIPContext * SOAP_FMAC4 soap_get___ns2__GetGeoIPContext(struct soap *soap, struct __ns2__GetGeoIPContext *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns2__GetGeoIPContext(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns2__GetGeoIPContext * SOAP_FMAC2 soap_instantiate___ns2__GetGeoIPContext(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns2__GetGeoIPContext(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns2__GetGeoIPContext, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns2__GetGeoIPContext);
		if (size)
			*size = sizeof(struct __ns2__GetGeoIPContext);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns2__GetGeoIPContext[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns2__GetGeoIPContext);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns2__GetGeoIPContext*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns2__GetGeoIPContext(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns2__GetGeoIPContext %p -> %p\n", q, p));
	*(struct __ns2__GetGeoIPContext*)p = *(struct __ns2__GetGeoIPContext*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns2__GetGeoIP(struct soap *soap, struct __ns2__GetGeoIP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__GetGeoIP = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns2__GetGeoIP(struct soap *soap, const struct __ns2__GetGeoIP *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__GetGeoIP(soap, &a->ns1__GetGeoIP);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns2__GetGeoIP(struct soap *soap, const char *tag, int id, const struct __ns2__GetGeoIP *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)type;
	if (soap_out_PointerTo_ns1__GetGeoIP(soap, "ns1:GetGeoIP", -1, &a->ns1__GetGeoIP, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns2__GetGeoIP * SOAP_FMAC4 soap_in___ns2__GetGeoIP(struct soap *soap, const char *tag, struct __ns2__GetGeoIP *a, const char *type)
{
	size_t soap_flag_ns1__GetGeoIP = 1;
	short soap_flag;
	a = (struct __ns2__GetGeoIP *)soap_id_enter(soap, "", a, SOAP_TYPE___ns2__GetGeoIP, sizeof(struct __ns2__GetGeoIP), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns2__GetGeoIP(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__GetGeoIP && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__GetGeoIP(soap, "ns1:GetGeoIP", &a->ns1__GetGeoIP, ""))
				{	soap_flag_ns1__GetGeoIP--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns2__GetGeoIP(struct soap *soap, const struct __ns2__GetGeoIP *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns2__GetGeoIP(soap, tag?tag:"-ns2:GetGeoIP", id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns2__GetGeoIP * SOAP_FMAC4 soap_get___ns2__GetGeoIP(struct soap *soap, struct __ns2__GetGeoIP *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns2__GetGeoIP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct __ns2__GetGeoIP * SOAP_FMAC2 soap_instantiate___ns2__GetGeoIP(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___ns2__GetGeoIP(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE___ns2__GetGeoIP, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)SOAP_NEW(struct __ns2__GetGeoIP);
		if (size)
			*size = sizeof(struct __ns2__GetGeoIP);
	}
	else
	{	cp->ptr = (void*)SOAP_NEW(struct __ns2__GetGeoIP[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct __ns2__GetGeoIP);
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct __ns2__GetGeoIP*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy___ns2__GetGeoIP(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	(void)soap; (void)tt; (void)st; (void)len; (void)n; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct __ns2__GetGeoIP %p -> %p\n", q, p));
	*(struct __ns2__GetGeoIP*)p = *(struct __ns2__GetGeoIP*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag?tag:"SOAP-ENV:Detail", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__GetGeoIPContextResponse(struct soap *soap, _ns1__GetGeoIPContextResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__GetGeoIPContextResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__GetGeoIPContextResponse(struct soap *soap, const char *tag, int id, _ns1__GetGeoIPContextResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__GetGeoIPContextResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__GetGeoIPContextResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__GetGeoIPContextResponse(struct soap *soap, const char *tag, _ns1__GetGeoIPContextResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__GetGeoIPContextResponse **)soap_malloc(soap, sizeof(_ns1__GetGeoIPContextResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__GetGeoIPContextResponse *)soap_instantiate__ns1__GetGeoIPContextResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__GetGeoIPContextResponse ** p = (_ns1__GetGeoIPContextResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__GetGeoIPContextResponse, sizeof(_ns1__GetGeoIPContextResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__GetGeoIPContextResponse(struct soap *soap, _ns1__GetGeoIPContextResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__GetGeoIPContextResponse);
	if (soap_out_PointerTo_ns1__GetGeoIPContextResponse(soap, tag?tag:"ns1:GetGeoIPContextResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__GetGeoIPContextResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__GetGeoIPContextResponse(struct soap *soap, _ns1__GetGeoIPContextResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__GetGeoIPContextResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__GetGeoIPContext(struct soap *soap, _ns1__GetGeoIPContext *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__GetGeoIPContext))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__GetGeoIPContext(struct soap *soap, const char *tag, int id, _ns1__GetGeoIPContext *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__GetGeoIPContext);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__GetGeoIPContext ** SOAP_FMAC4 soap_in_PointerTo_ns1__GetGeoIPContext(struct soap *soap, const char *tag, _ns1__GetGeoIPContext **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__GetGeoIPContext **)soap_malloc(soap, sizeof(_ns1__GetGeoIPContext *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__GetGeoIPContext *)soap_instantiate__ns1__GetGeoIPContext(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__GetGeoIPContext ** p = (_ns1__GetGeoIPContext **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__GetGeoIPContext, sizeof(_ns1__GetGeoIPContext), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__GetGeoIPContext(struct soap *soap, _ns1__GetGeoIPContext *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__GetGeoIPContext);
	if (soap_out_PointerTo_ns1__GetGeoIPContext(soap, tag?tag:"ns1:GetGeoIPContext", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__GetGeoIPContext ** SOAP_FMAC4 soap_get_PointerTo_ns1__GetGeoIPContext(struct soap *soap, _ns1__GetGeoIPContext **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__GetGeoIPContext(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__GetGeoIPResponse(struct soap *soap, _ns1__GetGeoIPResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__GetGeoIPResponse))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__GetGeoIPResponse(struct soap *soap, const char *tag, int id, _ns1__GetGeoIPResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__GetGeoIPResponse);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__GetGeoIPResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__GetGeoIPResponse(struct soap *soap, const char *tag, _ns1__GetGeoIPResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__GetGeoIPResponse **)soap_malloc(soap, sizeof(_ns1__GetGeoIPResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__GetGeoIPResponse *)soap_instantiate__ns1__GetGeoIPResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__GetGeoIPResponse ** p = (_ns1__GetGeoIPResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__GetGeoIPResponse, sizeof(_ns1__GetGeoIPResponse), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__GetGeoIPResponse(struct soap *soap, _ns1__GetGeoIPResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__GetGeoIPResponse);
	if (soap_out_PointerTo_ns1__GetGeoIPResponse(soap, tag?tag:"ns1:GetGeoIPResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__GetGeoIPResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__GetGeoIPResponse(struct soap *soap, _ns1__GetGeoIPResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__GetGeoIPResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__GetGeoIP(struct soap *soap, _ns1__GetGeoIP *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__GetGeoIP))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__GetGeoIP(struct soap *soap, const char *tag, int id, _ns1__GetGeoIP *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__GetGeoIP);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 _ns1__GetGeoIP ** SOAP_FMAC4 soap_in_PointerTo_ns1__GetGeoIP(struct soap *soap, const char *tag, _ns1__GetGeoIP **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_ns1__GetGeoIP **)soap_malloc(soap, sizeof(_ns1__GetGeoIP *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_ns1__GetGeoIP *)soap_instantiate__ns1__GetGeoIP(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	_ns1__GetGeoIP ** p = (_ns1__GetGeoIP **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__GetGeoIP, sizeof(_ns1__GetGeoIP), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__GetGeoIP(struct soap *soap, _ns1__GetGeoIP *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__GetGeoIP);
	if (soap_out_PointerTo_ns1__GetGeoIP(soap, tag?tag:"ns1:GetGeoIP", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _ns1__GetGeoIP ** SOAP_FMAC4 soap_get_PointerTo_ns1__GetGeoIP(struct soap *soap, _ns1__GetGeoIP **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__GetGeoIP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTons1__GeoIP(struct soap *soap, ns1__GeoIP *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_ns1__GeoIP))
		(*a)->soap_serialize(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTons1__GeoIP(struct soap *soap, const char *tag, int id, ns1__GeoIP *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_ns1__GeoIP);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, type);
}

SOAP_FMAC3 ns1__GeoIP ** SOAP_FMAC4 soap_in_PointerTons1__GeoIP(struct soap *soap, const char *tag, ns1__GeoIP **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (ns1__GeoIP **)soap_malloc(soap, sizeof(ns1__GeoIP *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (ns1__GeoIP *)soap_instantiate_ns1__GeoIP(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
			return NULL;
	}
	else
	{	ns1__GeoIP ** p = (ns1__GeoIP **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_ns1__GeoIP, sizeof(ns1__GeoIP), 0);
		a = p;
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTons1__GeoIP(struct soap *soap, ns1__GeoIP *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTons1__GeoIP);
	if (soap_out_PointerTons1__GeoIP(soap, tag?tag:"ns1:GeoIP", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 ns1__GeoIP ** SOAP_FMAC4 soap_get_PointerTons1__GeoIP(struct soap *soap, ns1__GeoIP **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTons1__GeoIP(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTostd__string(struct soap *soap, std::string *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_std__string))
		soap_serialize_std__string(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTostd__string(struct soap *soap, const char *tag, int id, std::string *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_std__string);
	if (id < 0)
		return soap->error;
	return soap_out_std__string(soap, tag, id, *a, type);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_in_PointerTostd__string(struct soap *soap, const char *tag, std::string **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (std::string **)soap_malloc(soap, sizeof(std::string *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_std__string(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (std::string **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_std__string, sizeof(std::string), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTostd__string(struct soap *soap, std::string *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTostd__string);
	if (soap_out_PointerTostd__string(soap, tag?tag:"string", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 std::string ** SOAP_FMAC4 soap_get_PointerTostd__string(struct soap *soap, std::string **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTostd__string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__QName);
	if (soap_out__QName(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_string(struct soap *soap, char **a)
{
	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_string
	*a = SOAP_DEFAULT_string;
#else
	*a = (char *)0;
#endif
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	soap_reference(soap, *a, SOAP_TYPE_string);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{	char **p;
	p = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_string);
	if (soap_out_string(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
