/*
 * Copyright 2009 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.external.javadoc.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ArrayList;

/**
 * @author Tom Eyckmans
 */
public class PathJavadocOptionFileOption extends AbstractListJavadocOptionFileOption<List<File>> {

    public PathJavadocOptionFileOption(String option, String joinBy) {
        super(option, new ArrayList<File>(), joinBy);
    }

    public PathJavadocOptionFileOption(String option, List<File> value, String joinBy) {
        super(option, value, joinBy);
    }

    public void writeCollectionValue(JavadocOptionFileWriterContext writerContext) throws IOException {
        writerContext.writePathOption(option, value, joinBy);
    }
}
